import java.awt.Point;
import java.awt.Rectangle;

public class TitleData{
	String title;
	boolean visible;
	boolean hidable;
	Rectangle rect;
	CutCond cond;
	
	TitleData(String _title){
		title = _title;
		visible = true;
		hidable = true;
		cond = null;
	}
	public void setHidable(boolean _flag){hidable = _flag;}
	public void setVisible(boolean _flag){
		if((hidable == false)&&(_flag == false)) return;
		else visible = _flag;
	}
	public boolean getVisible(){return visible;}
	public void setTitle(String _title){title = _title;}
	public String getTitle(){return title;}
	public void setRect(int x, int y, int width, int height){
		rect = new Rectangle(x,y,width,height);
	}
	public Rectangle getRect(){return rect;}
	public int getWidth(){
		if(rect == null) return 0;
		else return(rect.width);
	}
	public boolean contains(Point pt){
		if(rect == null) return false;
		return (rect.contains(pt));
	}
	public void setCutCond(CutCond _cond){cond = _cond;}
	public CutCond getCutCond(){return cond;}
	public boolean applyCond(double val){
		if(cond == null) return true;
		return cond.applyVal(val);
	}
	public boolean hasCutCond(){
		if(cond == null) return false;
		else{
			return(cond.getState());
		}
	}
	public void setCutCondState(boolean flag){
		if(cond == null) return;
		cond.setState(flag);			
	}
}//end of class title Data