
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class TView extends Frame
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	

	TDCanvas maincanvas;

	java.awt.MenuBar mainMenuBar;
	java.awt.Menu menu1;
	java.awt.MenuItem miExit;
	java.awt.MenuItem miSwitch;
	java.awt.Scrollbar miVAScroll;
	Point morigin;
	double originra;
	double originde;
	int initva = 60;

	public TView()
	{
		initLayout();	

		Vector ptvect = new Vector();	
		KFileAnalyzer.readPTData(ptvect);
		for(int i =0;i<ptvect.size();i++){
			StarData pt = (StarData)(ptvect.elementAt(i));
			maincanvas.addStar(pt);
		}
		
		Vector linevect = new Vector();
		KFileAnalyzer.readLineData(linevect);
		for(int i =0;i<linevect.size();i++){
			TLine ln = (TLine)(linevect.elementAt(i));
			maincanvas.addLine(ln);
		}

		Vector namevect = new Vector();
		KFileAnalyzer.readStNameData(namevect);
		for(int i =0;i<namevect.size();i++){
			StarData st = (StarData)(namevect.elementAt(i));
			maincanvas.addStName(st);
		}


		maincanvas.setVra(0.0);
		maincanvas.setVde(0.0);

		maincanvas.start();
		maincanvas.repaint();
	}
	
	
	public void initLayout()
	{
		int wwidth = 600;
		int wheight = 400;
	
		
		setLayout(new BorderLayout(0,0));
		setVisible(false);
		setSize(wwidth,wheight);	
	
		
		maincanvas = new TDCanvas(this);
		add("Center", maincanvas);
	
		miVAScroll = new Scrollbar(Scrollbar.VERTICAL);
		add("West",miVAScroll);

		setTitle("SETI@Support 3D");
				
		// init menues
		mainMenuBar = new java.awt.MenuBar();
		menu1 = new java.awt.Menu("File");

		miExit = new java.awt.MenuItem("Quit");
		menu1.add(miExit);

		java.awt.Menu menu2 = new java.awt.Menu("Setting");
		miSwitch = new java.awt.MenuItem("Switch");
		menu2.add(miSwitch);

		mainMenuBar.add(menu1);
		mainMenuBar.add(menu2);

		setMenuBar(mainMenuBar);		
		SymAction lSymAction = new SymAction();

		miExit.addActionListener(lSymAction);
		miSwitch.addActionListener(lSymAction);

		SymAdjust lSymAdjust = new SymAdjust();
		miVAScroll.addAdjustmentListener(lSymAdjust);

		setVAScrollValue();


		SymMouseMotion  lSymMot = new SymMouseMotion();
		maincanvas.addMouseMotionListener(lSymMot);

		SymMouse lSymMouse = new SymMouse();
		maincanvas.addMouseListener(lSymMouse);
	}
	private void setVAScrollValue(){
		int mode = maincanvas.getDrawMode();
		int initva = 0;
		if(mode == XLB.SPHERE){
			initva = 60;
			miVAScroll.setValues(initva,1,10,120);
		}
		else if(mode == XLB.SQUARE){
			initva = 180;
			miVAScroll.setValues(initva,1,1,180);
		}
		maincanvas.setVangle(initva);		
	}
	
    public void setVisible(boolean b)
	{
		if(b)
		{
			//setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	static public void main(String args[])
	{
		(new TView()).setVisible(true);
	}
	
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
						
			Object object = event.getSource();
			if (object == miExit)
				miExit_Action(event);	
			else if(object == miSwitch)
				miSwitch_Action(event);
		}
	}
	
	private void miSwitch_Action(java.awt.event.ActionEvent event)
	{
		maincanvas.switchMode();
		setVAScrollValue();
	}
		
	void miExit_Action(java.awt.event.ActionEvent event)
	{
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
		setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		System.exit(0);	

	}
	
	class SymAdjust implements java.awt.event.AdjustmentListener
	{
		public void adjustmentValueChanged(AdjustmentEvent event) 
		{
						
			Object object = event.getSource();
			if (object == miVAScroll)
				miVAAdjust_Action(event);	
		}
	}

	public void miVAAdjust_Action(AdjustmentEvent event){
		int val = miVAScroll.getValue();
		maincanvas.setVangle(val);
		maincanvas.repaint();
	}

	class SymMouseMotion implements java.awt.event.MouseMotionListener
	{
		public void mouseDragged(MouseEvent event)  
		{
						
			Object object = event.getSource();
			if (object == maincanvas)
				miDrag_Action(event);	
		}

		public void mouseMoved(MouseEvent event){
		}
	}

	public void miDrag_Action(MouseEvent event){
		Point pt = event.getPoint();
		Dimension d = maincanvas.getSize();
		int deltax = morigin.x - pt.x;
		int deltay = morigin.y - pt.y;

		double newra = originra - ((double)deltax/d.width) * 2 * Math.PI;
		double newde = originde - ((double)deltay/d.height)*Math.PI;
		
		if(newra > 2*Math.PI) newra -= 2*Math.PI;
		if(newra < 0) newra = 2*Math.PI + newra;

		if(newde < -1 * Math.PI/2){
			newde = -1 * Math.PI/2;
			//newde = -1 * Math.PI - newde;
			//newra = newra + Math.PI;
			//if(newra > 2*Math.PI) newra -= 2*Math.PI;
		}
		if(newde > Math.PI/2){
			newde = Math.PI/2;
			//newde = Math.PI - newde;
			//newra = newra + Math.PI;
			//if(newra > 2*Math.PI) newra -= 2*Math.PI;
		}
		maincanvas.setVra(newra);
		maincanvas.setVde(newde);
		maincanvas.repaint();
	}

	class SymMouse implements java.awt.event.MouseListener
	{
		public void mousePressed(MouseEvent event)  
		{
						
			Object object = event.getSource();
			if (object == maincanvas)
				miMousePress_Action(event);	
		}
		public void mouseClicked(MouseEvent event)  
		{
		}
		public void mouseEntered(MouseEvent event)  
		{
		}
		public void mouseExited(MouseEvent event)  
		{
		}
		public void mouseReleased(MouseEvent event)  
		{
		}
	}

	public void miMousePress_Action(MouseEvent event){
		morigin = event.getPoint();
		originra = maincanvas.getRa();
		originde = maincanvas.getDe();
	}
}// end of class 3View

