import java.awt.Point;

class TDPoint{
	double ra; // in radian
	double de; // in radian

	double x;
	double y;
	double z;


	TDPoint(){
		ra = 0.0;
		de = 0.0;
		setXYZ();
	}
	/*TDPoint(String rastr, String destr){// input is ra and de value
		ra = (Double.valueOf(rastr)).doubleValue()*Math.PI/12.0;
		de = (Double.valueOf(destr)).doubleValue()*Math.PI/180.0;
		setXYZ();
	}*/
	TDPoint(double ravalue, double devalue){ // input is rad
		ra = ravalue ;
		de = devalue;
		setXYZ();
	}
	TDPoint(int radeg, int dedeg){ // input is deg
		ra = radeg * Math.PI / 180.0;
		de = dedeg * Math.PI / 180.0;
		setXYZ();
	}

	TDPoint(double _x, double _y, double _z){
		x = _x; y = _y; z = _z;
		setRaDe();
	}
	TDPoint(TDPoint ps){
		x = ps.getX(); y= ps.getY(); z = ps.getZ();
		setRaDe();
	}
	private void setXYZ(){
		x = Math.cos(de) * Math.cos(ra);
		y = Math.cos(de) * Math.sin(ra);
		z = Math.sin(de);
	}
	private void setRaDe(){
		double len = length();
		de = Math.asin(z/len);
		ra = Math.atan2(y,x);
	}
	boolean isNull(){
		if((ra == 0.0)&&(de == 0.0)) return true;
		else return false;
	}
	//////////////////////////////
	////// set get functions
	//////////////////////////////
	double getRa(){
		return ra;
	}
	double getDe(){
		return de;
	}
	public void setRa(double val){
		ra = val;
		setXYZ();
	}
	public void setDe(double val){
		de = val;
		setXYZ();
	}
	double getX(){ return x;}
	double getY(){return y;}
	double getZ(){return z;}
	

	
	/////// used for 3D conversion...
	public Point getConv(double vra, double vde, double dist){

		TDouble tr = getConvedTD(vra,vde);
		if(tr.getZ() > 0.0001){// I look only forward
			int px = (int)(dist * (tr.getX()/tr.getZ()));
			int py = (int)(dist * (tr.getY()/tr.getZ()));
//System.out.println("px, py = " + px + " " + py);		
			return new Point(px,py);			
		}
		else return null;			
	}
	
	////// used for sphere conversion
	public Point getPtConv(double vra, double vde, double length){
		TDouble tr = getConvedTD(vra,vde);
		if(tr.getZ() > 0.0001){// I look only forward
			int px = (int)(length * (tr.getX()));
			int py = (int)(length * (tr.getY()));
//System.out.println("px, py = " + px + " " + py);		
			return new Point(px,py);			
		}
		else return null;		
	}
	
	private TDouble getConvedTD(double vra, double vde){
		double sinra = Math.sin(vra);
		double cosra = Math.cos(vra);
		double sinde = Math.sin(vde);
		double cosde = Math.cos(vde);
		double dx = cosra*y - sinra*x;
		double dy = cosde * z - cosra*sinde*x - sinra*sinde*y;
		double dz = cosra*cosde*x + sinra * cosde * y + sinde * z;
//System.out.println("x,y,x " + x + " " + y + " " + z +"dx, dy, dz "+dx + " " + dy + " " + dz);
		return  new TDouble(dx,dy,dz);
	}

	// return angle of point from vra, vde ponit.
	public double getAngle(double vra, double vde){
		TDouble tr = getConvedTD(vra,vde);
		double length = Math.sqrt(((tr.getX())*(tr.getX())) + ((tr.getY())*(tr.getY())));
		double val = Math.atan(length/(tr.getZ()));
		if(val < 0.0){
			val = Math.PI + val;
		}
		return val;
	}
	
	public double length(){
		return Math.sqrt(x*x +y*y + z*z);
	}
	public TDPoint cross(TDPoint A){
		double cx = (y*A.getZ()) - (A.getY() * z);
		double cy = (A.getX() * z) - (x*A.getZ());
		double cz = (x*A.getY()) - (A.getX() * y);

		TDPoint retp = new TDPoint(cx,cy,cz);
		retp.setRaDe();
		return retp;
	}
	
	public TDPoint subtract(TDPoint A){
		double cx = x - A.getX();
		double cy = y - A.getY();
		double cz = z - A.getZ();
		TDPoint retp = new TDPoint(cx,cy,cz);
		retp.setRaDe();
		return retp;
	}
	
	public TDPoint add(TDPoint A){
		double cx = x + A.getX();
		double cy = y + A.getY();
		double cz = z + A.getZ();
		TDPoint retp = new TDPoint(cx,cy,cz);
		retp.setRaDe();
		return retp;
	}
	public void changeLength(double len){
		double ratio = len/(length());
		x *= ratio; y *= ratio; z *= ratio;
	}
}