import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import java.net.*;

public class TDCanvas extends Canvas  implements Runnable{

	Vector pointVect = new Vector();
	Vector lineVect = new Vector();
	Vector gridVect = new Vector();
	Vector stNameVect = new Vector();
	Image offscreen = null;
	Dimension offscreensize;
	Graphics offgraphics;   
	Thread relaxer;
	TView boss;
	Font font;
	double vra,prev_vra;
	double vde,prev_vde;
	double vangle,prev_vangle;
	int movelesscount  = 0;
	final int movelessValue = 3;
	boolean moveflag = false;
	
	boolean gridflag = true;
	boolean stnameflag = true;
	int drawmode = XLB.SPHERE;
	boolean jumpflag = false;
	double brlimit = 8.0;
	
	public TDCanvas(TView _boss){
		super();

		boss = _boss;
	      	String[] fontNames = getToolkit().getFontList();
	      	font = new Font(fontNames[0], Font.PLAIN, 10);
//pointVect.addElement(new TDPoint(0.0,0.0));	      	
		setGrid();
	
		//{{REGISTER_LISTENERS
		SymMouse aSymMouse = new SymMouse();
		this.addMouseListener(aSymMouse);
		//}}
	}
	
	////////////////////////
	//// Basic Function for canvas
	////////////////////////
	
	 public void start() {
		relaxer = new Thread(this);
			relaxer.start();
    	}
    	
	 public void stop() {
		if(relaxer != null)
			relaxer.stop();
	}
	public void suspend(){
		if(relaxer != null)
			relaxer.suspend();
	}	
	public void resume(){
		if(relaxer != null)
			relaxer.resume();
	}
	public void run() {
		while (true) {
			//setSize(mySize);
			repaint();
			try {
				relaxer.sleep(200);
			} catch (InterruptedException e) {
				break;
			} // end of catch
		}// end of while(true)
	}// end of run()	

	public void update(Graphics g)
	{
		Dimension d = getSize();
		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());
		}
		offgraphics.setColor(Color.black);
		offgraphics.fillRect(0,0,d.width, d.height);

		paintData(offgraphics);

		g.drawImage(offscreen, 0, 0, null);

		setMoveFlag();
	}	
	
	private void setMoveFlag(){
		if((vra == prev_vra)&&(vde == prev_vde)&&(vangle == prev_vangle)){
			movelesscount ++;
		}
		else{
			movelesscount = 0;
			moveflag = true;
		}
		if(movelesscount >= movelessValue){
			movelesscount = movelessValue;
			moveflag = false;
		}
		prev_vra = vra; 
		prev_vde = vde;
		 prev_vangle = vangle;		
	}
	//////////////////////////////////////////////
	//// set get functions
	//////////////////////////////////////////////
	public void switchMode(){
		if(drawmode == XLB.SPHERE) drawmode = XLB.SQUARE;
		else if(drawmode == XLB.SQUARE) drawmode = XLB.SPHERE;
		movelesscount  = movelessValue;
		repaint();
	}
	
	public int getDrawMode(){
		return drawmode;
	}
	public void setVra(double val){
		vra = val;}
	public void setVde(double val){
		vde = val;}
	public void setVangle(double val){// input is degree
		vangle = val * Math.PI / 180.0;}
	public double getRa(){return vra;}
	public double getDe(){return vde;}
	
	
	///////////////////////////////////
	/////// add data functions...
	////////////////////////////////////
	
	void addStar(StarData pt){
		pointVect.addElement(pt);
	}
	
	public void addLine(TLine ln){
		lineVect.addElement(ln);
	}		
	
	public void addStName(StarData st){
		stNameVect.addElement(st);	
	}
	
	private void setGrid(){
	      	for(int d=-90;d<=90;d+=30){
			for(int r = 0; r<=330;r+=30){
				String str = "";
				if((r != 0)|| (d == 0))
					str = Integer.toString(r/15) + "hr";
				if(d != 0){
					if(d >= 0) str = str + "+";
					else str = str + "-";
					str = str + Integer.toString(d) + "deg";
				}
				StarData tp = new StarData(r,d,str);
				gridVect.addElement(tp);
			}
		}
	}



//////////////////////////////////////////////////
/////// pait related fucntions..
//////////////////////////////////////////////////

private void paintData(Graphics offgraphics){
  	
	Dimension d = getSize();
	int mind = Math.min(d.width, d.height)/2;

	double dist = mind / (Math.tan(vangle/2));

  	for(int i = 0;i<pointVect.size();i++){
		StarData pt = (StarData)pointVect.elementAt(i);
		Point vp =mapToCanvas(pt.getPt(),dist);
		if(vp == null) continue;
		offgraphics.setColor(Color.white);
		double br = pt.getBr();
		if(br > brlimit) continue;
		int x = vp.x;
		int y = vp.y;
		if(br < 1.0){
			int dt =4;
			offgraphics.fillOval(x-dt/2, y-dt/2,dt,dt);
		}
		else if(br < 2.0){
			offgraphics.drawLine(vp.x-2,y,x+2,y);
			offgraphics.drawLine(x,y-2,x,y+2);
			offgraphics.drawLine(x-1,y-1,x+1,y+1);
			offgraphics.drawLine(x-1,y+1,x+1,y-1);
		}
		else if(br < 3.0){
			offgraphics.drawLine(x,y-1,x,y+1);
			offgraphics.drawLine(x-1,y,x+1,y);
		}
		else {
			if(moveflag == false){
				offgraphics.drawLine(x,y,x,y);
			}
		}
	}//end of for
	if(gridflag) paintGrid(offgraphics,dist);
	if(moveflag== false){
		for(int i = 0;i<lineVect.size();i++){
			TLine ln = (TLine)(lineVect.elementAt(i));
			drawLine(offgraphics,Color.blue,dist,ln);
		}

		if(stnameflag) paintStName(offgraphics,dist);
	}
	//System.out.println("vra, vde = "+(Double.toString(vra*180/Math.PI)) + " " + (Double.toString(vde*180/Math.PI)));
 }//end of paintPoints

	private void paintGrid(Graphics g, double dist){
		for(int i =0;i<gridVect.size();i++){
			StarData spt = (StarData)(gridVect.elementAt(i));
			TDPoint pt = spt.getPt();
			if((pt.getDe() == 0.0)||(pt.getRa() == 0)){
				drawString(g,pt,spt.getStr(),dist,Color.lightGray);
			}
			double delta = vangle / 80;
			TDPoint p[] = {null,null,null,null};
			 p[0] = new TDPoint(pt.getRa()+delta,pt.getDe());
			 p[1] = new TDPoint(pt.getRa()-delta,pt.getDe());
			 p[2] = new TDPoint(pt.getRa(),pt.getDe()+delta);
			 p[3] = new TDPoint(pt.getRa(),pt.getDe()-delta);		
			for(int j = 0;j<4;j++){
				drawLine(g,Color.lightGray,dist,(new TLine(pt,p[j])));
			}				
		}		
	}
	
	private void paintStName(Graphics g, double dist){
		for(int i =0;i<stNameVect.size();i++){
			StarData spt = (StarData)(stNameVect.elementAt(i));
			TDPoint pt = spt.getPt();
			drawString(g,pt,spt.getSStr(),dist,Color.cyan);
		}		
	}	
	
	////////////////////////////////////////////
	////// paint related basic functions
	////////////////////////////////////////////
			
	private void drawString(Graphics g, TDPoint pt, String str,double dist,Color cl){
		Point vp = mapToCanvas(pt,dist);
		if(vp == null) return;
		g.setColor(cl);
		g.drawString(str,vp.x, vp.y);		
	}
	private void drawLine(Graphics g, Color cl, double dist, TLine ln){
		jumpflag = false;
		Point p1 =mapToCanvas(ln.getP1(),dist);
		boolean jumpflag1 = jumpflag;
		jumpflag = false;
		Point p2 = mapToCanvas(ln.getP2(),dist);
		boolean jumpflag2 = jumpflag;
		if((p1 == null)||(p2== null)) return ;
		if((jumpflag1 != jumpflag2)&&(drawmode == XLB.SQUARE)) return;
		g.setColor(cl);
		g.drawLine(p1.x, p1.y, p2.x, p2.y);
	}

	private Point mapToCanvas(TDPoint pt, double dist){
		Dimension d = getSize();
		Point vp = new Point();

		if(drawmode == XLB.SPHERE){
			vp = pt.getConv(vra,vde,dist);			
		}
		else if(drawmode == XLB.SQUARE){

			vp = get2DConv(pt,d.height/vangle);
		}
		if(vp == null) return null;
		int x = d.width/2- vp.x ;
		int y = d.height/2 - vp.y;
		
		if((x < 0)||(x > d.width)||(y<0)||(y>d.height)){
			return null;
		}
		else{
			return new Point(x,y);	
		}	
	}
	private Point get2DConv(TDPoint pt, double vol){
	//	double t_vde = vde;
//System.out.println("vde"+vde + " " +(vde+ vangle/2)*180/Math.PI);			
		if(vde + (vangle/2) > Math.PI/2){
			vde = Math.PI/2 - (vangle/2);
		}
		else if(vde - (vangle/2) < -1*Math.PI/2){
			vde = -1*Math.PI/2+(vangle/2);
		}
		
		double raddiff =pt.getRa() - vra;
		if(raddiff > Math.PI){
			raddiff -= (2*Math.PI);
			jumpflag = true;
		}
		else if(raddiff < -1*Math.PI){
			raddiff += (2*Math.PI);
			jumpflag = true;
		}
		int px = (int)(raddiff * vol);		
		int py = (int)((pt.getDe() - vde) * vol);
		
		return new Point(px,py);
	}

	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mouseClicked(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == TDCanvas.this)
				TDCanvas_MouseClicked(event);
		}
	}

	void TDCanvas_MouseClicked(java.awt.event.MouseEvent event)
	{
		if(drawmode == XLB.SQUARE){
			Point vp = event.getPoint();
			Dimension d = getSize();
			int dx = vp.x - d.width/2;
			int dy = vp.y - d.height/2;
			double vol = vangle / d.height;
			double ravalue = vra - dx*vol;
			if(ravalue < 0) ravalue += 2*Math.PI;
			double devalue = vde - dy * vol;
			//System.out.println(ravalue*180/Math.PI+ " " + devalue*180/Math.PI);
			System.out.println(ravalue+ " " + devalue);			
		}
	}
}// end of SkyCanvas
