import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Polygon;
import java.awt.Rectangle;
//import java.awt.event.*;
//import java.awt.image.*;
import java.util.Vector;
import java.util.Calendar;
//import java.net.*;

public class SkyPainter{
	static double bbtable[] = {0.0 ,0.0 ,0.2 ,0.4 ,0.6 ,0.8 ,1.0 ,1.0 ,1.0, 1.0,1.0};
	static double brtable[] = {1.0,0.9,0.8,0.8,0.7,0.6,0.5,0.4,0.2,0.0};
		
	double sybVolume = 1.0;        // volume for each symbol	
	static final int smallRadius= 6; // used for finished data display	
	 							// diameter of analyzed node is sybVolume * smallRadius
	final int ingSizeFactor = 3; //diameter of analyzing node is sybVolume * ingSizeFactor *maxCircleLevel
	
	final int particleNo = 50;
	final int particleRad = 100;	
	
	 
	SkyCanvas boss;	 
	
	//boolean blinkFlag = true;	 
	int paintmode  = GLB.CONV;	
	int pre_paintmode = paintmode;
	boolean gridFlag = true; // flag indicates if grid is displayed or not
	boolean topFlag = true;// flag which indicates to hightligt top data
	int cstmode = GLB.MINIMUM;// value indicates number of constellations displayed
	int cstnamemode = GLB.MINIMUM;// value indicates length of constellation name displayed

	int calccount = 0;
	int gpcount = 0;

	
	////////////////////// 3d graphics
	//boolean jumpflag = false;
	double vra,prev_vra;
	double vde,prev_vde;
	double vangle,prev_vangle;
	Dimension pre_dimension;
	int movelesscount  = 0;
	final int movelessValue = 3;
	boolean moveflag = false;
	boolean pre_moveflag = moveflag;
	double starBrVal = 5.0;  // upper limit the magnitude of star
	boolean tailflag = true; // if true tail is on
	double tailbr = 1.0; // brightness of tail
	MyClipper mycp;
	//Rectangle cliprect; 
	
	///////////////////////////////////////////////////////
	/// Constructo type functions
	///////////////////////////////////////////////////////
	
		
	 SkyPainter(SkyCanvas _boss){
	 	boss = _boss;
	 	mycp = new MyClipper();
	 }
	 
	 Dimension getSize(){
	 	return boss.getSize();
	 }
	 
	 Dimension getSkyMapSize(){
	 	return boss.getSkyMapSize();
	 }	 
	
	////////////////////////////////////////////////////////
	/////Analyzing node painting
	////////////////////////////////////////////////////////
			
	public void paintIngNode(PointData pt, Graphics g,int cpaintmode){
		pt.resetDPoints();
		DPos tpt = pt.getPoint();
		//tpt.resetDPoint();
	
		Point ppt = mapToCanvasWithClip(tpt);

		if(ppt == null){
			pt.resetDPoints();
			return;
		}
		
		if((moveflag)&&(paintmode != GLB.CONV)){
			paintSimpleINode(pt,ppt,g);
		}
		else{
			if(cpaintmode == GLB.NORMAL) paintNNode(pt,ppt,g);
			else if(cpaintmode == GLB.WRD) paintWNode(pt,ppt,g);
			else if(cpaintmode == GLB.BWH) paintBWNode(pt,ppt,g);	
			else if(cpaintmode == GLB.LINE) paintLineNode(pt,ppt,g);
			
			if(pt.getTop()&&topFlag){
				paintTopRing(pt,g,ppt,(int)(SkyCanvas.maxCircleLevel * ingSizeFactor *sybVolume)+4);				
			}
		}
	}
	
	int x_line[][] = {{1, 0,-3, -2},{ 1,-2,-3, 0},{-1, 0, 3, 2},{-1, 2, 3, 0}};
	int y_line[][] = {{1,-2,-3,  0},{-1, 0, 3, 2},{-1,-2, 3, 0},{ 1, 0,-3,-2}};
	int x_vect[] = {1,1,-1,-1};
	int y_vect[] = {1,-1,-1,1};
	int phase_no = 0;
	
	private void paintTopRing(PointData pt, Graphics g, Point ppt, int i_rad){
	


		for(int i = 0;i<3;i++){
			double cratio = 1.0 - ((float)pt.getLevel())/SkyCanvas.maxCircleLevel;
			if(i%2 == 1) cratio = 1.0 - cratio;
			Color orcolor = Color.pink;
			float cl[] = {(float)0.0,(float)0.0,(float)0.0};
			cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(),cl);
			Color nwcolor = Color.getHSBColor(cl[0],cl[1],(float)(cratio));
			g.setColor(nwcolor);		
			int length = (int)(i_rad / Math.sqrt(2.0)) + (i)+1 ;
			g.drawLine(ppt.x , ppt.y + length, ppt.x + length, ppt.y);
			g.drawLine(ppt.x + length, ppt.y , ppt.x ,ppt.y - length);
			g.drawLine(ppt.x , ppt.y - length, ppt.x - length, ppt.y);
			g.drawLine(ppt.x - length, ppt.y, ppt.x , ppt.y + length);
		}
/*
		int phase2_no = phase_no + 1;
		if(phase2_no >= 4) phase2_no = 0;
		for(int i = 0;i<4;i++){
			int x0 = x_line[i][phase_no]*i_rad;
			int y0 = y_line[i][phase_no]*i_rad;
			int x1 = x_line[i][phase2_no]*i_rad;
			int y1 = y_line[i][phase2_no]*i_rad;
			double alpha = pt.getLevel() / SkyCanvas.maxCircleLevel;
			
			int x= (int)(x0 * (1-alpha) + x1 * alpha) + ppt.x;
			int y= (int)(y0 * (1-alpha) + y1 * alpha) + ppt.y; 			
			g.drawLine(x,y,x+x_vect[i]*i_rad,y+y_vect[i]*i_rad);
		}
		phase_no ++;
		if(phase_no >= 4) phase_no = 0;
		int no = 3-  pt.getLevel();
		if(no < 1) no = 0;
		for(int i = no;(i > no-2)&&(i>=0);i--){
			int rad = i_rad + i*4;
			int x = ppt.x - (int)(rad*0.5);
			int y = ppt.y - (int)(rad*0.5);
			g.drawOval(x,y,rad,rad);
		}*/
	}
	
	private void paintSimpleINode(PointData pt, Point ppt , Graphics offgraphics){
			int level = 3;
		 	double bb = bbtable[level];
			double br = brtable[level]+0.2;
			if(br > 1.0) br = 1.0;
			double ph = (1-(pt.getProgValue()))/2;
			offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)br));	
			int rad =(int)(smallRadius * ingSizeFactor * sybVolume);
			int x = ppt.x - (int)(rad * 0.5);
			int y = ppt.y - (int)(rad * 0.5);
	
			offgraphics.fillOval(x,y,rad,rad);				
	}
	 private void paintNNode(PointData pt, Point ppt , Graphics offgraphics){

		int ptlevel = pt.getLevel();
		for(int rad  = (int)(ptlevel * ingSizeFactor *sybVolume); rad >=0; rad-=2){
		//for(int level = 0;level < pt.getLevel();level ++){	
			//int rad = (int)(level * sybVolume * ingSizeFactor) ;	
			int level = (int)(rad / (ingSizeFactor*sybVolume));
		 	double bb = bbtable[level];
			double br = brtable[level]+0.2;
			if(br > 1.0) br = 1.0;
			double ph = (1-(pt.getProgValue()))/2;
			offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)br));

			int x = ppt.x - (int)(rad * 0.5);
			int y = ppt.y - (int)(rad * 0.5);
	
			offgraphics.drawOval(x,y,rad,rad);
		}	
	}


	private void paintWNode(PointData pt , Point ppt ,Graphics offgraphics){	


		int offset =(Calendar.getInstance()).get(Calendar.SECOND);
		if(offset > 30) offset = 60 - offset;
		double mvalue = 0.75 + ((double)offset/120);
		
		 for(int i = 0 ;i<SkyCanvas.maxCircleLevel;i+=1){ 
			int rad=(int)(i*ingSizeFactor * sybVolume);
			int modrad = (int)(rad * mvalue);
			
			for(int k=0;k<SkyCanvas.maxCircleLevel;k+=1){
				int index  = ((pt.getLevel() + k+i) % SkyCanvas.maxCircleLevel);
				int da = 36;
				double bb = bbtable[index];
				double br = brtable[index];
				double ph = (1-(pt.getProgValue()))/2;
				offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)br));

				int x = ppt.x;
				int y = ppt.y;
	
				offgraphics.drawArc(x-(modrad/2), y-(rad/2),modrad,rad,k*da+(offset),da);
				offgraphics.drawArc(x-(rad/2), y-(modrad/2),rad,modrad,(SkyCanvas.maxCircleLevel - 1 - k)*da,da);
	   		}// end of k
	   	}// end of i 
	}// end of function
	
	private   void paintBWNode(PointData pt , Point ppt ,Graphics offgraphics){

		if(pt.hasLingP() == false) pt.initRings();
		Vector rings = pt.getRings();

		pt.rotate();
		for(int i = 0; i < rings.size(); i++){
		 	double bb = bbtable[i];
			double br = brtable[i]+0.2;
			if(br > 1.0) br = 1.0;
			double ph = (1-(pt.getProgValue()))/2;
			offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)br));
			
			SRing sr = (SRing)(rings.elementAt(i));
			int rad = (int)((SkyCanvas.maxCircleLevel + i*(ingSizeFactor-1)) *sybVolume) ;//sr.getRad();
	//System.out.println("rad = "+rad+ " " + i);
			int x =ppt.x - (int)(rad * 0.5);
			int y =ppt.y - (int)(rad * 0.5);
			Vector infovect = sr.getInfoVect();
			for(int  j= 0;j<infovect.size();j++){
				Point npt = (Point)(infovect.elementAt(j));
				offgraphics.drawArc(x,y,rad,rad,npt.x,npt.y);
			}
		}	
	}

	 private void paintLineNode(PointData pt, Point ppt , Graphics offgraphics){

		int level = pt.getLevel();
		double bb = bbtable[level];
		double br = brtable[level]+0.2;
		if(br > 1.0) br = 1.0;
		double ph = (1-(pt.getProgValue()))/2;
		offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)br));
		
		paintLineANode(pt,ppt,offgraphics,true,true);
		
	}	
	////////////////////////////////////////////////////////
	/////Analayzed node painting
	////////////////////////////////////////////////////////
	public void paintEdNode(PointData pt, Graphics g,int apaintmode,int ablinkmode,boolean oflag){

		if((ablinkmode == GLB.BLINK_OF)||(ablinkmode == GLB.BLINK_WAVE)){
			Color orcolor = pt.getColor();
			float cl[] = {(float)0.0,(float)0.0,(float)0.0};
			cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(),cl);
			Color nwcolor = Color.getHSBColor(cl[0],cl[1],(float)(1.0 - ((float)pt.getLevel())/SkyCanvas.maxCircleLevel));
			g.setColor(nwcolor);
		}
		else{
			g.setColor(pt.getColor());
		}
		Point ppt = mapToCanvasWithClip(pt.getPoint());	
		if(ppt == null){
			pt.resetDPoints();
			return;
		}

		if(moveflag){
			pt.resetDPoints();
			if(paintmode != GLB.CONV){
				paintSimpleANode(ppt,g);
			}
		}
		else{
			if(apaintmode == GLB.CIRCLE){
				paintCircleANode(pt,ppt,g,oflag);
			}
			else if(apaintmode == GLB.SQUARE){
				paintSquareANode(pt,ppt,g,oflag);				
			}
			else if(apaintmode == GLB.DIAMOND){
				paintDiaANode(pt,ppt,g,oflag);				
			}
			else if(apaintmode == GLB.ALINE){
				paintLineANode(pt,ppt,g,oflag,false);				
			}	
			
			if(pt.getTop()&&topFlag){
				paintTopRing(pt,g,ppt,(int)(smallRadius *sybVolume)+4);		
//System.out.println("yes it top");						
			}			
					
		}
	}

	private void paintSimpleANode(Point ppt, Graphics g){
		int x = ppt.x;
		int y = ppt.y;

		int delta = (int)(smallRadius*0.4*sybVolume);
		int ddelta = (int)(smallRadius*0.3*sybVolume);
		
		g.drawLine(x,y-delta,x,y+delta);
		g.drawLine(x-delta,y,x+delta,y);
		g.drawLine(x-ddelta,y-ddelta,x+ddelta,y+ddelta);
		g.drawLine(x-ddelta,y+ddelta,x+ddelta,y-ddelta);	
	}
	
	private void paintCircleANode(PointData pt, Point ppt,Graphics offgraphics,boolean flag){

		int rad = (int)(smallRadius*sybVolume);
		int x = ppt.x;
		int y = ppt.y;
		//if(blinkFlag == false) flag = true;
//System.out.println("x = "+x);
		x -= (rad/2);
		y -= (rad /2);
		if(flag) offgraphics.fillOval(x,y,rad,rad);
		else offgraphics.drawOval(x,y,rad,rad);	
	}

	
	private void paintSquareANode(PointData pt, Point ppt,Graphics offgraphics,boolean flag){

		int rad = (int)(smallRadius*sybVolume);
		int x = ppt.x;
		int y = ppt.y;
		//if(blinkFlag == false) flag = true;

		x -= (rad/2);
		y -= (rad /2);
	     	if(flag) offgraphics.fill3DRect(x,y,rad,rad,true);	
	     	else offgraphics.draw3DRect(x,y,rad,rad,false);	
	 }			
	 
	private void paintDiaANode(PointData pt, Point ppt,Graphics offgraphics,boolean flag){

		int x = ppt.x;
		int y = ppt.y;
		//if(blinkFlag == false) flag = true;
			int delta = (int)((smallRadius*0.4)*sybVolume);
			int ll = (int)((smallRadius*1.0)*sybVolume);
			if(flag){
				ll = (int)(ll*0.7);
				offgraphics.drawLine(x,y-ll,x,y+ll);
				offgraphics.drawLine(x-ll,y,x+ll,y);
				offgraphics.drawLine(x-delta,y-delta,x+delta,y+delta);
				offgraphics.drawLine(x-delta,y+delta,x+delta,y-delta);
			}
			else{
				delta = delta/2;
				Polygon rect = new Polygon();	
				rect.addPoint(x+ll,y);
				rect.addPoint(x+delta,y+delta);
				rect.addPoint(x,y+ll);
				rect.addPoint(x-delta,y+delta);
				rect.addPoint(x-ll,y);
				rect.addPoint(x-delta,y-delta);
				rect.addPoint(x,y-ll);
				rect.addPoint(x+delta,y-delta);
				offgraphics.drawPolygon(rect);				
			}
	}	

	private void paintLineANode(PointData pt, Point ppt, Graphics offgraphics,boolean flag,boolean fillflag){
		Vector bg = new Vector();
		pt.getAreaData(bg);
//bg.addElement(pt.getPoint());		
//TDPoint ttt = (pt.getPoint()).getPoint();		
//System.out.println("ept " + ttt.getX() + " " + ttt.getY() + " " + ttt.getZ());	
		if(bg.size() == 0) return ;
		Polygon pol = new Polygon();
		TDPoint spt = ((DPos)(bg.elementAt(0))).getPoint();
		for(int i = 1;i<=bg.size();i++){
			DPos pos ;
			if(i == bg.size()) pos = (DPos)(bg.elementAt(0));
			else pos = (DPos)(bg.elementAt(i));
			//pos.resetDPoint();
			TLine tl = new TLine(spt, pos.getPoint());
			if(flag){
				drawLine(offgraphics, (offgraphics.getColor()),tl);
			}
			spt = pos.getPoint();
		}
	}
		/*
			TDPoint tpt = pos.getPoint();
//System.out.println("i = " + i + " " + tpt.getX() + " " + tpt.getY() + " " + tpt.getZ());			
			Point ept= mapToCanvas(pos);	
//System.out.println("ept = "+ ept);			
			if(ept == null) continue;
			pol.addPoint(ept.x, ept.y);
		}
		
		pol.addPoint(pol.xpoints[0], pol.ypoints[0]);
		
		for(int i = 0;i<pol.npoints-1;i++){
			Point startpt = new Point(pol.xpoints[i], pol.ypoints[i]);
			Point endpt = new Point(pol.xpoints[i+1], pol.ypoints[i+1]);
//System.out.println(pol.xpoints[i]+ " " + pol.ypoints[i] + " " + pol.xpoints[i+1] + " " + pol.ypoints[i+1]);			
			if(flag){
				if(fillflag){
//System.out.println(pol.xpoints[i]+ " " + pol.ypoints[i] + " " + pol.xpoints[i+1] + " " + pol.ypoints[i+1]);	
					if(pol.npoints > 2){			
						offgraphics.fillPolygon(pol);
					}
					else{
						Rectangle lr = mycp.lineclip(startpt,endpt);
						offgraphics.drawLine(lr.x, lr.y, lr.width, lr.height);						}
				}
				else{
					Rectangle lr = mycp.lineclip(startpt,endpt);
					offgraphics.drawLine(lr.x, lr.y, lr.width, lr.height);	
				}	
			}			
		}

		TDPoint tpt = pt.getEndPoint();
		
		Point ept = null;
		if(tpt == null) {
			ept = ppt;
		}
		else{
			pt.resetDPoint();		
			ept = mapToCanvas(tpt);
			
		}
		if(ept == null) return;
		if(flag){
			Rectangle lr = mycp.lineclip(ppt,ept);
			offgraphics.drawLine(lr.x, lr.y, lr.width, lr.height);		
			//offgraphics.drawLine(ppt.x, ppt.y, ept.x, ept.y);	
		}
*/

	////////////////////////////////////////////////////////
	/////Analayzed Terminal particle, prog value, corss line...
	////////////////////////////////////////////////////////
		
	public   void paintTermParticle(PointData pt , Graphics offgraphics)
	{
		double prog = pt.getProgValue();
		Point ppt = mapToCanvasWithClip(pt.getPoint());			
		if(ppt == null) return;		
		int ptlevel = pt.getLevel();
		if((prog > 0.96)&&(ptlevel == SkyCanvas.maxCircleLevel -1)){
			pt.addParticle(ppt,particleNo,particleRad,(ptlevel*ingSizeFactor));
		}


		double bb = bbtable[ptlevel];
		double ph = (1-prog)/2;
					
		Vector ptvect = pt.getPtVect();
		for(int j = 0;j<ptvect.size();j++){
			ParticleData prt = (ParticleData)(ptvect.elementAt(j));
			offgraphics.setColor(Color.getHSBColor((float)ph,(float)bb,(float)(prt.getLifeValue())));
			offgraphics.drawLine(prt.getX(), prt.getY(),prt.getTX(),prt.getTY());
		}		
	}
	
	public void paintProgValue(PointData pt, Graphics offgraphics){
		if(moveflag&&(paintmode != GLB.CONV)) return;
		
		FontMetrics fm = offgraphics.getFontMetrics();	
		boolean clearflag = pt.getSelected();
		String cpustr = pt.getCpuString();
		String progstr = pt.getProgString();
		String remainstr = pt.getRemainCpuString();
		if(remainstr != null){
			remainstr = "(+"+remainstr+")";
		}
		int strw = Math.max(fm.stringWidth(cpustr), fm.stringWidth(progstr));
		int strh = fm.getLeading() + fm.getAscent();
		int rstrh = strh + fm.getDescent();
		int margin = 3;
		int xoffset = (SkyCanvas.maxCircleLevel * ingSizeFactor/2)+margin;
		
		Dimension d = getSkyMapSize();			
		Point ppt = mapToCanvasWithClip(pt.getPoint());
		if(ppt == null) return;		
		boolean rflag = false;
		
		if(ppt.x + strw + xoffset  < d.width) rflag  = true;
		
		int x = 0; int y = 0;
		
		if(rflag) x = ppt.x+xoffset;
		else  x =ppt.x-xoffset-fm.stringWidth(progstr);
		
		y = ppt.y - margin;
		
		offgraphics.setColor(Color.black);
		if(clearflag) offgraphics.fillRect(x,y-strh,fm.stringWidth(progstr),rstrh);
		offgraphics.setColor(Color.pink);
		offgraphics.drawString(progstr,x,y);
		
		if(rflag) x =  ppt.x+xoffset;
		else  x =   ppt.x-xoffset-fm.stringWidth(cpustr);
		y = ppt.y + strh ; 
		offgraphics.setColor(Color.black);			
		if(clearflag) offgraphics.fillRect(x,y-strh,fm.stringWidth(cpustr),rstrh);
		offgraphics.setColor(Color.pink);
		offgraphics.drawString(cpustr, x,y);
		
		if(remainstr != null){
			if(rflag) x =ppt.x+xoffset;
			else  x = ppt.x-xoffset-fm.stringWidth(remainstr);
			y = ppt.y + strh*2;
			offgraphics.setColor(Color.black);	
			if(clearflag) offgraphics.fillRect(x,y - strh,fm.stringWidth(remainstr),rstrh);
			offgraphics.setColor(Color.pink);
			offgraphics.drawString(remainstr,x,y);
		}
	}
	
	public void paintGPattern(PointData pt, Graphics offgraphics){
		Vector bgpot = pt.getBgpot();
		if(bgpot == null) return;
		Point ppt = mapToCanvasWithClip(pt.getPoint());
		if(ppt == null) return;
		double maxval = 0.0;
		for(int i = 0;i<bgpot.size();i++){
			Double  ddt = ((Double)(bgpot.elementAt(i)));
			double mval = 0.0;
			if(ddt != null) mval = ddt.doubleValue();
			if(mval > maxval) maxval = mval;
		}
		int rheight = 40;
		int rwidth = 6;
		Dimension d = getSkyMapSize();			
		if(maxval > 0.0){
			//offgraphics.setColor(Color.red);
			
			FontMetrics fm = offgraphics.getFontMetrics();
			int y = ppt.y + rheight+(SkyCanvas.maxCircleLevel * ingSizeFactor/2)+(fm.getHeight());
			int x = ppt.x - ((bgpot.size())*rwidth)/2;
			if(x < 0) x = 0;

			else if((x+((bgpot.size())*rwidth)) > d.width) x = d.width - ((bgpot.size())*rwidth);
			int org_x = x;
			int dy = y;
			int o_dy = y;
			for(int i =0;i<bgpot.size();i++){
				double br = 0.5;
				if(i < gpcount){
					br = 1.0;
				}
				offgraphics.setColor(Color.getHSBColor((float)0.0,(float)0.9,(float)br));
								
				Double  ddt = ((Double)(bgpot.elementAt(i)));
				double mval = 0.0;
				if(ddt != null) mval = ddt.doubleValue();	
				o_dy = dy;
				dy = y - (int)((mval/maxval)*rheight);
				offgraphics.drawLine(x,o_dy,x,dy);
				offgraphics.drawLine(x,dy,x+6,dy);
				x+=6;				
			}
			
			if((gpcount >= bgpot.size())&&(pt.getBgTrueMean() > 0.0)){
				offgraphics.setColor(Color.lightGray);
				dy = y - (int)(((pt.getBgTrueMean())/maxval)*rheight);
				//offgraphics.drawLine(org_x,dy,x,dy);
				dy = y - (int)(((pt.getBgPower())/maxval)*rheight);
				//offgraphics.drawLine(org_x,dy,x,dy);				
			}
			gpcount += 2;
			if(gpcount > (bgpot.size()*2)) gpcount = 0;
		}
	}		
	
	 public Point paintCrossLine(Graphics g, PointData pt,int tracx, int tracy){
			Point ppt = mapToCanvasWithClip(pt.getPoint());	
			if(ppt == null) return new Point();
			Dimension d = getSkyMapSize();
			g.setColor(Color.yellow);
		    	int len = SkyCanvas.maxCircleLevel * ingSizeFactor;
		    	double alpha = 0.7;
	    	
		    	tracx =(int)(ppt.x*alpha + (tracx * (1-alpha)));
		    	tracy = (int)(ppt.y*alpha + (tracy * (1-alpha))); 	
		    	g.drawRect(tracx-(int)(len*0.5),tracy-(int)(len*0.5),len,len);
		
		   	g.drawLine(tracx,0,           tracx,tracy  - (int)(len*0.5));
		    	g.drawLine(tracx,d.height, tracx,tracy  + (int)(len*0.5));
		   	g.drawLine(0,tracy,         tracx - (int)(len*0.5), tracy);
		    	g.drawLine(d.width,tracy, tracx+(int)(len*0.5),tracy);		
		    	
		    	return new Point(tracx,tracy);
	}

/////////////////////////////////////////////////////////////
////// Backgroudn paint functions
/////////////////////////////////////////////////////////////

	public void paintStarData(Graphics offgraphics,Vector starVect){
	  	
	  	for(int i = 0;i<starVect.size();i++){
//System.out.println("trying");	  		
			StarData pt = (StarData)starVect.elementAt(i);
			Point npt = pt.getDPoint();
			
			Point vp =mapToCanvasWithClip(pt.getPoint());
			if(vp == null) continue;
			offgraphics.setColor(Color.white);
			double br = pt.getBr();
			if(br > starBrVal) continue;
			int x = vp.x;
			int y = vp.y;
			if((moveflag)&&(tailflag)&&
			   ((paintmode == GLB.SPHERE)||(paintmode == GLB.PLTVIEW))){
				if((npt != null)&&(br < 4.5)){
					offgraphics.setColor(Color.getHSBColor((float)0.0,(float)0.0,(float)tailbr));
					offgraphics.drawLine(x,y,npt.x, npt.y);
				}
			}
			else{
				if(br < 1.0){
					int dt =4;
					offgraphics.fillOval(x-dt/2, y-dt/2,dt,dt);
				}
				else if(br < 2.0){
					offgraphics.drawLine(vp.x-2,y,x+2,y);
					offgraphics.drawLine(x,y-2,x,y+2);
					offgraphics.drawLine(x-1,y-1,x+1,y+1);
					offgraphics.drawLine(x-1,y+1,x+1,y-1);
				}
				else if(br < 3.0){
					offgraphics.drawLine(x,y-1,x,y+1);
					offgraphics.drawLine(x-1,y,x+1,y);
				}
				else {
					if(moveflag == false){
						offgraphics.drawLine(x,y,x,y);
					}
				}
			}
		}//end of for
	}
	
	public void paintCst(Graphics g, Vector cstVect){
		

		
		for(int i =0;i<cstVect.size();i++){
			CstData cst = (CstData)(cstVect.elementAt(i));
			if(moveflag == true){
				cst.resetDPoint();
				continue; // dont write constellation while moving
			}			
			///////first take care of name
			
			DPos pt = cst.getNamePos();
			if(cstnamemode == GLB.MINIMUM){
				drawString(g,pt,cst.getShortName(),Color.cyan);			
			}
			else if(cstnamemode == GLB.FULL){
				drawString(g,pt,cst.getName(),Color.cyan);				
			}	
			
			////// then take care of lines

			if((cstmode == GLB.NONE)||
				((cstmode == GLB.MINIMUM)&&((cst.getRank()) > 0))) continue;
			Vector lineVect = cst.getLineVect();
			for(int j = 0;j<lineVect.size();j++){
				TLine ln = (TLine)(lineVect.elementAt(j));
				drawLine(g,Color.blue,ln);
			}			
		}
	}	
	
	
	public void paintGrid(Graphics g,Vector gridVect){
		//if(moveflag == true) return;
		if(gridFlag == false) return;
		for(int i =0;i<gridVect.size();i++){
			StarData spt = (StarData)(gridVect.elementAt(i));
			DPos pt = spt.getPoint();
			if(moveflag){
				//int deltadot = 5;
				spt.resetDPoint();
				/*Point ppt = mapToCanvasWithClip(pt);	
				if(ppt == null) return;		
				g.drawLine(ppt.x-deltadot, ppt.y, ppt.x + deltadot, ppt.y);
				g.drawLine(ppt.x,          ppt.y-deltadot, ppt.x, ppt.y + deltadot);	*/	
			}
			else{
				double delta = vangle / 80;
				TDPoint p[] = {null,null,null,null,null};
				 p[0] = new TDPoint(pt.getRa()+delta,pt.getDe());
				 p[1] = new TDPoint(pt.getRa()-delta,pt.getDe());
				 p[2] = new TDPoint(pt.getRa(),pt.getDe()+delta);
				 p[3] = new TDPoint(pt.getRa(),pt.getDe()-delta);
				// p[4] = new TDPoint(pt.getRa(),pt.getDe());	
				 
				drawLine(g,Color.lightGray,(new TLine(p[0],p[1])));
				drawLine(g,Color.lightGray,(new TLine(p[2],p[3]))); 	
				/*for(int j = 0;j<4;j++){
					if(moveflag)pt.resetDPoint();			
					drawLine(g,Color.lightGray,(new TLine(p[4],p[j])));
				}*/
					

			}	
			if((pt.getDe() == 0.0)||(pt.getRa() == 0)){
				drawString(g,pt,spt.getStr(),Color.lightGray);
			}								
		}		
	}
	
	
	/////////////////////////////////////
	//set & get functions...
	/////////////////////////////////////
	public void setVra(double val){
		vra = val;
	}
	public void setVde(double val){
		vde = val;
//System.out.println("vde = " + (vde*180/Math.PI)+ " vangle = "+(vangle*180/Math.PI));		
		adjustVde();
	}
	public void setVangle(double val){// input is degree
		vangle = val * Math.PI / 180.0;
//System.out.println("vangle = "+vangle);	
		adjustVde();
	}

	public double getVangle(){return vangle;}
	public double getRa(){return vra;}
	public double getDe(){return vde;}
	public void setPaintMode(int mode){
		pre_paintmode = paintmode;
		paintmode = mode;	
		movelesscount  = movelessValue;		
		checkMovement();
	}
	public void setGridMode(boolean flag){
		gridFlag = flag;
	}
/*	public void setBlinkFlag(boolean val){
		blinkFlag = val;
	}*/
	
	public void setTopMode(boolean flag){
		topFlag = flag;
	}
	public void checkMovement(){

		pre_moveflag = moveflag;
		/*if(paintmode == GLB.CONV){
			moveflag = false;
			return;
		}*/
		Dimension dim = getSize();
		if((vra == prev_vra)&&(vde == prev_vde)&&(vangle == prev_vangle)
			&&(boss.getMouseDownFlag() == false)&&(dim.equals(pre_dimension)&&
			(paintmode == pre_paintmode))){
			movelesscount ++;

		}
		else{
			movelesscount = 0;
			moveflag = true;
//System.out.println("move flag is true");			
		}
		if(movelesscount >= movelessValue){
			movelesscount = movelessValue;		
			moveflag = false;
		}
//System.out.println("moveflag = " + moveflag);			
		prev_vra = vra; 
		prev_vde = vde;
		pre_dimension = dim;
		prev_vangle = vangle;		
		pre_paintmode = paintmode;

	}
	public void setCstMode(int val){
		cstmode = val;
	}
	public void setCstNameMode(int val){
		cstnamemode = val;
	}
	public void setStarBr(double val){
		starBrVal = val;
	}
	public void setSybSize(String str){
		if((str.equals("Standard"))||(str.equals("Normal"))){
			sybVolume = 1.0;
		}
		else if(str.equals("Small")){
			sybVolume = 0.8;
		}
		else if(str.equals("VerySmall")){
			sybVolume = 0.5;
		}
		else if(str.equals("Normal")){
		
		}
		else{
			System.out.println("Wao, we are in trouble for setSybSize with "+str);
		}
	}	
	
	public void setTailBr(int n){
		switch(n){
			case 1: tailbr = 1.0;
				break;
			case 2: tailbr = 0.9;
				break;
			case 3: tailbr = 0.7;
				break;
			case 4: tailbr = 0.5;
				break;
			default:
				System.out.println("outrange in setTailBr " + n);
		}
//System.out.println("tailbr = " + tailbr);
	}
	
	public void setStarTrace(boolean flag){
		tailflag = flag;
	}
	////////////////////////////////////////
	//// COmmonly used functions
	////////////////////////////////////////
	
	private void drawString(Graphics g, DPos pt, String str,Color cl){
		Point vp = mapToCanvasWithClip(pt);
		if(vp == null) return;
		g.setColor(cl);
		g.drawString(str,vp.x, vp.y);		
	}
	
	private void drawLine(Graphics g, Color cl,TLine ln){
		if(leapP(ln) == true) return;
		Point p1 =mapToCanvas(ln.getP1());
		//boolean jumpflag1 = jumpflag;
		//jumpflag = false;
		Point p2 = mapToCanvas(ln.getP2());
		//boolean jumpflag2 = jumpflag;
//System.out.println((ln.getP1()) + " "  + (ln.getP2()));		
		if((p1 == null)||(p2== null)) return ;
		//if((jumpflag1 != jumpflag2)&&(paintmode ==GLB.RECT_VIEW)) return;
		Rectangle lr = null;
		if(moveflag){
			if((mycp.clipPoint(p1) == false)||(mycp.clipPoint(p2) == false)) return;
			lr = new Rectangle(p1.x, p1.y, p2.x, p2.y);
		}
		else{
			lr = mycp.lineclip(p1,p2);
		}
		g.setColor(cl);
		g.drawLine(lr.x, lr.y, lr.width, lr.height);	
		//g.drawLine(p1.x, p1.y, p2.x, p2.y);		
			
	}
	private boolean leapP(TLine ln){
		if((paintmode != GLB.RECT_VIEW)&&(paintmode != GLB.CONV)) return false;
		double r_vra = vra + Math.PI;
		if(paintmode == GLB.CONV) r_vra = Math.PI;
		
		if(r_vra > 2*Math.PI) r_vra -= 2*Math.PI;
		//else if(r_vra < 0) r_vra += 2*Math.PI;
		
		double ra1 = (ln.getP1()).getRa();
		if(ra1 < 0) ra1 += (2*Math.PI);
		//else if(ra1 > (2*Math.PI)) ra1 -= (2*Math.PI);
		double ra2 = (ln.getP2()).getRa();
		if(ra2 < 0) ra2 += (2*Math.PI);
		//else if(ra2 > (2*Math.PI)) ra2 -= (2*Math.PI);
				
		double minRa = Math.min(ra1,ra2);
		double maxRa = Math.max(ra1,ra2);
//System.out.println(r_vra + " " + minRa + " " + maxRa);		
		if((maxRa - minRa) < Math.PI){
			if((maxRa >= r_vra) &&( minRa <= r_vra)) return true;	
			else return false;	
		}
		else{
			if((r_vra >= maxRa)||(r_vra <= minRa)) return true;
			else return false;
		}
	}
	
	private boolean leapP2(TLine ln){
		if(paintmode != GLB.RECT_VIEW) return false;
		double r_vra = vra + Math.PI;
		if(r_vra > 2*Math.PI) r_vra -= 2*Math.PI;

		double ra1 = (ln.getP1()).getRa();
		double ra2 = (ln.getP2()).getRa();
		double radiff1 = ra1 - r_vra;
		if(Math.abs(radiff1) > Math.PI){
			if(radiff1 > 0)
				radiff1 =  Math.abs(radiff1)-(2*Math.PI);
			else
				radiff1 = 2*Math.PI - Math.abs(radiff1);
		}
		double raddif2 = ra2 - r_vra;
		if(Math.abs(raddif2) > Math.PI){
			if(raddif2 > 0)
				raddif2 =  Math.abs(raddif2)-(2*Math.PI);
			else
				raddif2 = 2*Math.PI - Math.abs(raddif2);
		}		

		if(radiff1 * raddif2 <= 0) return true;
		else return false;
	}	
	
	public void setClipRange(Dimension d){
		mycp.setClipRange(d);
	}
	

	public Point mapToCanvasWithClip(DPos pt){
		Point ppt = mapToCanvas(pt);
		//Dimension d = getSkyMapSize();
		if( clipPoint(ppt)){
			return ppt;
		}
		else {
			pt.resetDPoint();
			return null;
		}		
	}
	private boolean clipPoint(Point pt){
		Dimension d = getSize();
		if(pt == null) return false;
		if((pt.x < 0)||(pt.x > d.width)||
			(pt.y<0)||(pt.y>d.height)){
			return false;
		}
		else{
			return true;
		}
	}	
	private Point mapToCanvas(DPos pt){
//System.out.println("moveflag = "+moveflag + " pt = " + pt.getDPoint());	
		if((moveflag == true)||(pt.isDPointSet() == false)){
			Point npt = calcMapToCanvas(pt.getPoint());
			pt.setDPoint(npt);
			return npt;
		}
		else{
			return pt.getDPoint();			
		}
	}

	
	private Point calcMapToCanvas(TDPoint pt){
//System.out.println("-called for " + pt);
//System.out.println("."+calccount);
//calccount ++;
		Dimension d = getSkyMapSize();
		Point vp = new Point();

		if(paintmode == GLB.CONV){
//System.out.println("called for " + pt);		
			vp = get2DConv(pt,d.width/(2*Math.PI));
			vp.x = vp.x -1; // this is silly.. but needed
		}
		else if(paintmode == GLB.SPHERE){
			int mind = Math.min(d.width, d.height)/2;
		
			double dist = mind / (Math.tan(vangle/2));	
//System.out.println("dist = "+dist);					
			vp = pt.getConv(vra,vde,dist);				
		}
		else if(paintmode == GLB.RECT_VIEW){
			//int length = Math.max(d.height,(d.width/2));
			vp = get2DConv(pt,getVolume());
		}
		else if(paintmode == GLB.PLTVIEW){
			int length = Math.min((d.height/2),(d.width/2));
			vp = pt.getPtConv(vra,vde,length);
		}
		if(vp == null) return null;
		int x = d.width/2- vp.x ;
		int y = d.height/2 - vp.y;
//System.out.println("px : py " +x);		
		return new Point(x,y);	

	}
	private double getVolume(){
		Dimension d = getSkyMapSize();
		int length = Math.max(d.height,(d.width/2));
		return (length/vangle);	
	}
	
	private Point get2DConv(TDPoint pt, double vol){
	//	double t_vde = vde;

		double raddiff =pt.getRa() - vra;		
		
		if(Math.abs(raddiff) > Math.PI){
			if(raddiff > 0){
				raddiff = -1 * (Math.PI*2 - Math.abs(raddiff));
			}
			else{
				raddiff = Math.PI*2 - Math.abs(raddiff);
			}
			//jumpflag = true;
		}
		int px = (int)(raddiff * vol);		
		int py = (int)((pt.getDe() - vde) * vol);
//System.out.println("raddiff = "+raddiff*12/Math.PI + " px = "+px);
		return new Point(px,py);
	}	
	
	private void adjustVde(){
		if(paintmode != GLB.RECT_VIEW) return;
		double vol = getVolume();
		Dimension d = getSkyMapSize();
		double vdelta = (d.height/2)/vol;
		
		if(vde + vdelta > Math.PI/2) vde = Math.PI/2 - vdelta;
		else if(vde - vdelta < -1*Math.PI/2) vde = -1*Math.PI/2 + vdelta;
	
	}	
}// end of class SkyPainter