/*
	I learend a couple of ideas and could get use the data from Chris Dolan's site.
	Thanks.
	
   PLEASE READ THIS:

   You may use this code for your own uses, including scavenging
   functions from it.  However, I insist that I remain permanently
   acknowledged in your source code and, if possible, in the final
   product (executable, web page, what have you).  In addition, please
   email me if you plan to use part of this code.

   I wrote this program in my spare time for fun.  It is neither
   elegant nor polished.  You have been warned.

   Chris Dolan (dolan@astro.wisc.edu)  Nov 25, 1998

*/

import java.awt.Image;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.ScrollPane;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;

import java.util.Vector;
import java.util.Random;


public class SkyCanvas extends Canvas  implements Runnable{
	// Used for addNotify check.

	static int maxCircleLevel = 10;

	Vector pointVect = new Vector(); // data of analyzing and analyzed data
	SkyPainter sptr ;                // take care of all the painting
	SETISupport boss;
	Random dice  = new Random(0);
	final Dimension mySize = new Dimension(964,482);
	ScrollPane parentSp;
	
	
	Image skyImage;                  // Image of SkyMap

	int tracx; // center of tracking line
	int tracy; // center of tracking ine

	Image offscreen = null;         // these are related to animation
	Dimension offscreensize;        // same as above
	Graphics offgraphics;   	    // ditto
	Thread relaxer;                 // me too
	
	Font font	;

	boolean progDisplayFlag = false;
	boolean gpDisplayFlag = false;
	boolean clDisplayFlag  = true;
	String msgString;
	int msgcount = 0;
	int animetime = 100;

	boolean alwaysCenterFlag = false;

	
	//////////// Current node related variables..

	int cpaintmode = GLB.NORMAL;
	
	//////////// Analyzed node related variables..
	int apaintmode = GLB.CIRCLE;
	int ablinkmode = GLB.BLINK_WAVE; // paint moade for analyzed node.	

	///////////////// // bakcgroudn paint mode
	int bpaintmode = GLB.CONV;

////////////////////////////////// 3D view related variables
	Vector starVect = new Vector();
	Vector cstVect = new Vector(); // vector which has constellatioin data
	Vector gridVect = new Vector();
	Vector bringVect = new Vector();// contains BlinkRing

	Point morigin;
	double originra;
	double originde;
	
	//boolean gridflag = true;
	//boolean stnameflag = true;
	boolean mouseDownFlag = false;
	Vector vptvect = new Vector();
	boolean autoAngleFlag = true; // adjust VAngle according to progress
	//Rectangle cliprect;
		
/////////////////////////////////////////////////
///////////Constructor
/////////////////////////////////////////////////

	public SkyCanvas(SETISupport _boss){
		super();


		try {
    		skyImage = (Toolkit.getDefaultToolkit()).createImage(
    			(java.awt.image.ImageProducer) 
    			(getClass().getResource("SKYMAP.GIF")).getContent());

		}

		catch (java.io.IOException ex) {

    		System.out.println(ex);

		}
		//skyImage = getToolkit().getImage("skymap.gif");

		
		setSize(mySize);
		Dimension d = getSize();
		tracx = d.width/2;
		tracy = d.height/2;
		boss = _boss;
	      String[] fontNames = getToolkit().getFontList();
	      font = new Font(fontNames[0], Font.PLAIN, 10);
	      sptr = new SkyPainter(this);
	      setPaintMode(GLB.CONV);
	      
	      readTData();
	      setGrid();
	      
		SymMouse aSymMouse = new SymMouse();
		this.addMouseListener(aSymMouse);
		
		SymMouseMotion  lSymMot = new SymMouseMotion();
		this.addMouseMotionListener(lSymMot);	
	
	}

///////////////////////////////////
/////  Basic thread functions
///////////////////////////////////

	 public void start() {
		relaxer = new Thread(this);
			relaxer.start();
			relaxer.setPriority(Thread.MIN_PRIORITY);
    	}
    	
	 public void stop() {
		if(relaxer != null)
			relaxer.stop();
	}
	public void suspend(){
		if(relaxer != null)
			relaxer.suspend();
	}	
	public void resume(){
		if(relaxer != null)
			relaxer.resume();
	}
	public void run() {
		while (true) {
			//setSize(mySize);
			repaint();
			try {
				relaxer.sleep(animetime);
			} catch (InterruptedException e) {
				break;
			} // end of catch
		}// end of while(true)
	}// end of run()	
	
/////////////////////////////////////////////////////	
///////set and get functions
/////////////////////////////////////////////////////

	public void setAnimeTime(int val){
//System.out.println("set to "+val);		
		animetime = val;
		if(val == SETISupport.LOW_SPEED){
			//relaxer.setPriority(Thread.MIN_PRIORITY);		
		}
		else if(val == SETISupport.HIGH_SPEED){
			//relaxer.setPriority(Thread.NORM_PRIORITY);		
		}
	}
	public void setParentSp(ScrollPane sp){
		parentSp = sp;
	}
	public void setMessage(String str){
		msgString = new String(str);
		msgcount = 3*1000/animetime;
	}
	public void setBounds(int x, int y, int w, int h){
		if(bpaintmode == GLB.CONV){
			super.setBounds(x,y,mySize.width, mySize.height);	
		}
		else if((bpaintmode == GLB.SPHERE)||(bpaintmode == GLB.RECT_VIEW)
				||(bpaintmode == GLB.PLTVIEW)){
			super.setBounds(x,y,w,h);				
		}
	}
	public Dimension getMinimumSize(){
		if(bpaintmode == GLB.CONV){
			return mySize;
		}
		else{
			return super.getMinimumSize();
		}
	}
	public Dimension getPreferredSize(){
		if(bpaintmode == GLB.CONV){
			return mySize;
		}
		else{
			return super.getMinimumSize();
		}	
	}
	public void setPMode(int mode){
		cpaintmode = mode;
	}
	public void setAPMode(int mode){
		apaintmode = mode;
	}	
	public void setABMode(int mode){
		ablinkmode = mode;
		if(ablinkmode != GLB.BLINK_WAVE){
		  	for(int i = 0;i<pointVect.size();i++){
				PointData pt = (PointData)pointVect.elementAt(i);
				pt.setLevel((int)(dice.nextDouble()*maxCircleLevel));
			}
			bringVect.removeAllElements();
		}
	}
	public int getABMode(){ return ablinkmode;}
	
	public void setProgDisplay(boolean _val){progDisplayFlag = _val;}
	public void setGpDisplay(boolean _val){gpDisplayFlag = _val;}
	public void setCLDisplay(boolean _val){clDisplayFlag = _val;}
	//public void setBlink(int val){
	//	ablinkmode = val;
	//}
	public void setCenterFlag(boolean _val){
		alwaysCenterFlag = _val;
		setScrollPos();
	}
	public void setPaintMode(int mode){
		vptvect.removeAllElements();
		bpaintmode = mode;
		sptr.setPaintMode(mode);
		sptr.setVra(0.0);
		sptr.setVde(0.0);
		if(mode == GLB.CONV){
			setSize(mySize);		
		}	
		repaint();
	}	
	/*public void resetViewPoint(){
		sptr.setVra(0.0);
		sptr.setVde(0.0);	
	}*/
	public void setVangle(int val){
		sptr.setVangle(val);
		setScrollPos();
	}
	public void setGridMode(boolean flag){
//System.out.println("grid " + flag);	
		sptr.setGridMode(flag);
	}
	public void setTopMode(boolean flag){
		sptr.setTopMode(flag);
	}
	public void setCstMode(int val){
		sptr.setCstMode(val);
	}
	
	public void setCstNameMode(int val){
		sptr.setCstNameMode(val);
	}
	
	public boolean getMouseDownFlag(){
		return mouseDownFlag;
	}
	
	public void setStarBr(double val){
		sptr.setStarBr(val);
	}
	
/*	public ResultData getNthRd(int no){
		for(int i =0;i<pointVect.size();i++){
			PointData pt = (PointData)(pointVect.elementAt(i));
			if(i == no){
				return pt.getOrgData();
			}
		}
		return null;
	}*/
	
	public void setSybSize(String str){
		sptr.setSybSize(str);
	}
	
	public Dimension getSkyMapSize(){
		if(bpaintmode == GLB.CONV){
			return mySize;
		}
		else{
			return getSize();
		}
	}
	
	public void setStarTrace(boolean flag){
		sptr.setStarTrace(flag);
	}
	
	public void setAutoVangle(boolean flag){
		autoAngleFlag = flag;
	}
	
	/*public void setClipRect(Rectangle d){
		cliprect = d;
	}*/
/////////////////////////////////////////////////////	
///////update and paint functions
/////////////////////////////////////////////////////
		
	public void update(Graphics g)
	{
		//Rectangle cliprect = new Rectangle(0,0,(getSize().width), (getSize().height));
		//g.setClip(cliprect);
		sptr.setClipRange(getSize());
		if(vptvect.size() > 0){
			sptr.setTailBr(vptvect.size());
			Point pt = (Point)vptvect.elementAt(0);
			sptr.setVra(pt.x/1000.0);
			sptr.setVde(pt.y/1000.0);	
//System.out.println("ra,de " + (pt.x/1000.0) + " " + (pt.y / 1000.0));			
			vptvect.removeElementAt(0);			
		}

		if(autoAngleFlag) autoAngleAdjust();
		
		Dimension d = getSize();
//System.out.println(d);		
		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());
			//offgraphics.setClip(cliprect);
		}
		paintBackground(offgraphics);
		
		paintPoints(offgraphics);
		sptr.checkMovement();
		g.drawImage(offscreen, 0, 0, null);

		if(ablinkmode == GLB.BLINK_WAVE){
			Vector deadVect = new Vector();
			for(int i = 0;i<bringVect.size();i++){
				BlinkRing br = (BlinkRing)(bringVect.elementAt(i));
				br.expand();
				if(br.liveP() == false){
					deadVect.addElement(br);
				}
			}
			for(int i = 0;i<deadVect.size();i++){
				bringVect.removeElement(deadVect.elementAt(i));
			}
		}
	}

	private void paintBackground(Graphics g){
		Dimension d = getSize();
		g.setColor(Color.black);
		g.fillRect(0,0,d.width,d.height);
				
		switch(bpaintmode){
			case GLB.CONV:
				g.drawImage(skyImage,0,0,this);		
//sptr.paintGrid(offgraphics,gridVect);					
				break;
			case GLB.RECT_VIEW:
			case GLB.SPHERE:
			case GLB.PLTVIEW:		
				sptr.paintStarData(g,starVect);
				sptr.paintGrid(offgraphics,gridVect);		
				sptr.paintCst(offgraphics,cstVect);	
						
				break;
		}
	}

	
void paintPoints(Graphics offgraphics){
  
 	
  	Vector pveg = new Vector();	
  	for(int i = 0;i<pointVect.size();i++){
		PointData pt = (PointData)pointVect.elementAt(i);
		pt.addLevel();
		if(pt.getVisible() == false) continue;
		if(pt.getSelected()) pveg.addElement(pt);
		else pveg.insertElementAt(pt,0);
	}
	
	for(int i=0;i<pveg.size();i++){
		PointData pt = (PointData)pveg.elementAt(i);		
		if(pt.getFinished() == false){ // in progress	
			sptr.paintIngNode(pt,offgraphics,cpaintmode);		
			sptr.paintTermParticle(pt,offgraphics);

			if(pt.getLevel() == maxCircleLevel -1){
				bringVect.addElement(new BlinkRing( pt.getPoint()));
			}
			if(progDisplayFlag){				
				sptr.paintProgValue(pt,offgraphics);		
			}				
		}
		else{                                   // already done
			boolean oflag = true;
			if(ablinkmode == GLB.BLINK_WAVE){
				int n_level = maxCircleLevel;
				
				for(int  j = 0;j<bringVect.size();j++){
					BlinkRing br = (BlinkRing)(bringVect.elementAt(j));
					int temp_level = br.getLevel(pt.getPoint());
					if(temp_level < n_level) n_level = temp_level;
				}
				pt.setLevel(n_level);
			}

			else if(ablinkmode == GLB.BLINK_RANDOM){
				if(pt.getLevel() < (maxCircleLevel /2)){
					oflag = false;
				}
			}
			sptr.paintEdNode(pt,offgraphics,apaintmode,ablinkmode,oflag);
			

  		 }// end of else..
		
		if(pt.getSelected() == true){// selected
			if(clDisplayFlag == true){ 
				Point npt = sptr.paintCrossLine(offgraphics,pt,tracx, tracy);
				tracx = npt.x;
				tracy = npt.y;
			}
			if(gpDisplayFlag==true){
				sptr.paintGPattern(pt,offgraphics);
			}				
		}
	
	}//end of for

	if(msgcount > 0){// drawMessage
		FontMetrics fm = offgraphics.getFontMetrics();	
		offgraphics.setColor(Color.red);
		Point ofp = new Point();
		if(bpaintmode == GLB.CONV){
			ofp = parentSp.getScrollPosition();
		}
		offgraphics.drawString(msgString,ofp.x + 10,ofp.y + (fm.getHeight()*2));
		msgcount --;
	}

 }//end of paintPoints


/////////////////////////////////////////////////////////////
///////////Data manipulation functions
/////////////////////////////////////////////////////////////

	public void addPoint(double rd, double dec, ResultData rdata, boolean finished){
		int firstLevel = (int)(dice.nextDouble()*maxCircleLevel);		
		PointData pt = new PointData(firstLevel,maxCircleLevel,rdata);
		pt.setColor(rdata.getColorName());
		pointVect.addElement(pt);
	}// end of addPoint
	

	
	public void selectPt(PointData spt){
		if(spt == null) return;
		for(int i = 0;i<pointVect.size();i++){
			PointData pt = (PointData)pointVect.elementAt(i);	
			pt.setSelected(false);
		}
		spt.setSelected(true);
		setScrollPos();
	}
	
	public void setScrollPos()
	{
		if(alwaysCenterFlag == true){

			PointData spt = null;
			for(int i = 0;i<pointVect.size();i++){
				PointData pt = (PointData)pointVect.elementAt(i);	
				if(pt.getSelected()== true){
					spt = pt;
					break;
				}
			}
	//System.out.println("spt = "+spt);			
			if(spt == null) return;
			DPos tpt = spt.getPoint();
			if(tpt == null) return;
			
			if(bpaintmode == GLB.CONV){
				if(parentSp == null) return;
				Dimension parentd = parentSp.getViewportSize();
//System.out.println("parentd = "+ parentd);
				Point dpt = sptr.mapToCanvasWithClip(tpt);
				if(dpt == null) return;
				parentSp.setScrollPosition((dpt.x - (parentd.width/2)),(dpt.y - ( parentd.height/2)));				
			}				
			else if((bpaintmode == GLB.SPHERE)||(bpaintmode == GLB.RECT_VIEW)||
					 (bpaintmode == GLB.PLTVIEW)){
				int divno = 10;
				double startra = sptr.getRa();
				double startde = sptr.getDe();
				double endra = tpt.getRa();
				double endde = tpt.getDe();
//System.out.println("sra,sde, endra , endde" + startra + " " + startde + " " + endra + " " + endde);				
				double deltade = (endde - startde)/divno;
				double deltara = endra - startra;
				if(Math.abs(deltara) > Math.PI){
					if(deltara > 0){
						deltara = -1 * (Math.PI*2 - Math.abs(deltara));
					}
					else{
						deltara = Math.PI*2 - Math.abs(deltara);
					}
				}
				deltara = deltara / divno;
				vptvect.removeAllElements();
				
				int seq[] = {4,7,9};
				
				for(int i = 0;i<seq.length;i++){
					double newde = startde + (deltade*seq[i]);
					double newra = startra + (deltara*seq[i]);
					if(newra > Math.PI*2) newra -= Math.PI*2;
					else if(newra < 0) newra += Math.PI*2;
					
					Point pt = new Point((int)(newra * 1000),
										 (int)(newde * 1000));
					vptvect.addElement(pt);
				}
				vptvect.addElement(new Point((int)(endra*1000),(int)(endde*1000)));
				//sptr.setVra(tpt.getRa());
				//sptr.setVde(tpt.getDe());
			}
		}
	}

	public void removeAllPoints(){
		pointVect.removeAllElements();
	}
	
	public void readTData(){
		KFileAnalyzer.readPTData(starVect,this);
		KFileAnalyzer.readCstData(cstVect,this);						
	}
	private void setGrid(){
		for(int d=-90;d<=90;d+=30){
			for(int r = 0; r<=330;r+=30){
		//for(int d=30;d<=30;d+=30){
		//	for(int r = 30; r<=30;r+=30){		
				String str = "";
				if((r != 0)|| (d == 0))
					str = Integer.toString(r/15) + "hr";
				if(d != 0){
					if(d >= 0) str = str + "+";
					else str = str + "-";
					str = str + Integer.toString(d) + "deg";
				}
				StarData tp = new StarData(r,d,str);
				gridVect.addElement(tp);
			}
		}
	}	
	
	private void autoAngleAdjust(){
		if(autoAngleFlag == false) return;
		ResultData srd = boss.getSelectedData();
		if(srd == null) return;
		if(srd.getFinishedFlag() == true) return;
		double val = srd.getProgValue();
		int nvangle =(int)((GLB.MAX_SH_VANGLE-GLB.INI_SH_VANGLE)*val) + GLB.INI_SH_VANGLE;
		setVangle(nvangle);
	}
/////////////////////////////////////////////////////////////
/////////// Call back functions
/////////////////////////////////////////////////////////////
	
	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mousePressed(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == SkyCanvas.this)
				SkyCanvas_MousePressed(event);
		}
		public void mouseReleased(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == SkyCanvas.this)
				SkyCanvas_MouseReleased(event);
		}

		//public void mousePressed(java.awt.event.MouseEvent event)
		public void mouseClicked(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == SkyCanvas.this)
				GraphPanel_MouseClicked(event);
		}
	}

	void GraphPanel_MouseClicked(java.awt.event.MouseEvent event)
	{
//System.out.println("who");
		boss.resetSleepThread();
		int cl = (int)(SkyPainter.smallRadius*2);
		Point ept = event.getPoint();		
		Rectangle checkRect = new Rectangle(ept.x - cl, ept.y - cl, cl*2, cl*2);

		Vector candvect = new Vector();
  		for(int i = 0;i<pointVect.size();i++){
			PointData pt = (PointData)pointVect.elementAt(i);
			Point dpt = sptr.mapToCanvasWithClip(pt.getPoint());
			if(dpt == null) continue;
			if(checkRect.contains(dpt.x, dpt.y) == true){
				candvect.addElement(pt);
			}
		}		
		
		PointData selpt = null;
		if(candvect.size() == 1){
			selpt = (PointData)(candvect.elementAt(0));
		}
		else{// more than one candidate
			int mind = (cl * 2)*(cl*2);
			for(int i = 0;i<candvect.size();i++){
				PointData pt = (PointData)candvect.elementAt(i);
				if(pt.getSelected() == true) continue; // don't want to select again
				Point dpt = sptr.mapToCanvasWithClip(pt.getPoint());			
				int dx = ept.x -dpt.x;
				int dy = ept.y -dpt.y;
				int d = 	dx*dx + dy*dy;
//System.out.println(d + " : " + mind);				
				if(d < mind){
					mind = d;
					selpt = pt;
				}
			}
		}
		if(selpt != null){
			boss.selectData(selpt.getOrgData());
		}
	}
	void SkyCanvas_MousePressed(java.awt.event.MouseEvent event)
	{
		morigin = event.getPoint();
		originra = sptr.getRa();
		originde = sptr.getDe();
		mouseDownFlag = true;
		
		boss.resetSleepThread();
	}
	void SkyCanvas_MouseReleased(java.awt.event.MouseEvent event){
		mouseDownFlag = false;
	}
	class SymMouseMotion extends java.awt.event.MouseMotionAdapter
	{
		public void mouseDragged(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == SkyCanvas.this)
				SkyCanvas_MouseDragged(event);
		}
	}

	void SkyCanvas_MouseDragged(java.awt.event.MouseEvent event)
	{
		if((bpaintmode != GLB.SPHERE)&&(bpaintmode != GLB.RECT_VIEW)
		 &&(bpaintmode != GLB.PLTVIEW)) return;
		
		Point pt = event.getPoint();
		Dimension d = getSkyMapSize();
		int deltax = morigin.x - pt.x;
		int deltay = morigin.y - pt.y;

		double vol = (double)(sptr.getVangle())/(Math.max(d.width/2, d.height));
		//double xvol = (double)(sptr.getVangle())*2/d.width;
		//double yvol = (double)(sptr.getVangle())*2/d.height;
		double newra = originra - (deltax * vol);
		double newde = originde - (deltay * vol);
		
		if(newra > 2*Math.PI) newra -= 2*Math.PI;
		if(newra < 0) newra = 2*Math.PI + newra;

		if(newde < -1 * Math.PI/2){
			newde = -1 * Math.PI/2;
		}
		if(newde > Math.PI/2){
			newde = Math.PI/2;
		}
		sptr.setVra(newra);
		sptr.setVde(newde);
		repaint();		
	}


}// end of SkyCanvas