import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Container;
import java.awt.List;
import java.awt.TextArea;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.BorderLayout;
import java.awt.Scrollbar;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.MenuShortcut;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;

import java.awt.event.WindowEvent;
import java.awt.event.ComponentEvent;

import java.io.File;
import java.util.Vector;
import java.util.TimeZone;
import java.util.StringTokenizer;
import java.util.Date;


public class SETISupport extends Frame implements ScrollBoss
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	
	java.awt.ScrollPane gScrollPane;
	java.awt.ScrollPane sScrollPane;	
	java.awt.Panel tPane;
	java.awt.Container currentPane;
	java.awt.Panel lowerPanel;
	java.awt.List datalist;
	java.awt.TextArea dataText;
	SkyCanvas maincanvas;

	java.awt.MenuBar mainMenuBar;
	
	java.awt.Menu menu1;
	java.awt.MenuItem miSave;
	java.awt.MenuItem miOpen;
	java.awt.MenuItem miExportCSV;
	java.awt.MenuItem miExportTAB;
	java.awt.MenuItem miAutoCruise;
	java.awt.MenuItem miExit;
	
	java.awt.Menu menu2;
	java.awt.Menu update_sub;
	java.awt.CheckboxMenuItem mi_update[];//={null,null,null,null,null};
	String updatestr[] = {"5  min","15 min", "30 min", "60 min", "Never"};
	java.awt.CheckboxMenuItem miShowList;
	java.awt.CheckboxMenuItem miShowGraph;
	java.awt.CheckboxMenuItem miShowAll;	
	
	java.awt.CheckboxMenuItem miLogData;
	
	java.awt.CheckboxMenuItem miShowProg;
	java.awt.CheckboxMenuItem miAutoScroll;
	java.awt.CheckboxMenuItem miCrossLine;	
	
	java.awt.CheckboxMenuItem miBlinkNone;
	java.awt.CheckboxMenuItem miBlinkNorm;
	java.awt.CheckboxMenuItem miBlinkOF;
	java.awt.CheckboxMenuItem miBlinkWave;
				
	java.awt.CheckboxMenuItem miPaintNorm;
	java.awt.CheckboxMenuItem miPaintWrd;
	java.awt.CheckboxMenuItem miPaintBwh;
	java.awt.CheckboxMenuItem miPaintLine;
		
	java.awt.CheckboxMenuItem miACircle;
	java.awt.CheckboxMenuItem miASquare;
	java.awt.CheckboxMenuItem miADaiya;	
	java.awt.CheckboxMenuItem miALine;	
			
	java.awt.CheckboxMenuItem mi_tzone[];
	java.awt.CheckboxMenuItem miAmHigh;
	java.awt.CheckboxMenuItem miAmLow;
	java.awt.CheckboxMenuItem miAmAuto;
	java.awt.MenuItem miDataset; 	
	java.awt.MenuItem miPastset;

	java.awt.Menu menu20;
	
	java.awt.Menu menu21;
	java.awt.CheckboxMenuItem miSkConv;
	java.awt.CheckboxMenuItem miSkSphere;
	java.awt.CheckboxMenuItem miSkRect;
	java.awt.CheckboxMenuItem miSkPlt;	

	java.awt.Menu miSybSize;
	java.awt.CheckboxMenuItem miSybNormal;
	java.awt.CheckboxMenuItem miSybSmall;
	java.awt.CheckboxMenuItem miSybVerySmall;
		
	java.awt.Menu miStarMenu;
	java.awt.CheckboxMenuItem miStar3;
	java.awt.CheckboxMenuItem miStar4;	
	java.awt.CheckboxMenuItem miStar5;
	
	java.awt.CheckboxMenuItem miStarTrace;
	java.awt.CheckboxMenuItem miAutoVangle;
			
	java.awt.Menu miConstMenu;
	java.awt.CheckboxMenuItem miConstFull;
	java.awt.CheckboxMenuItem miConstMin;
	java.awt.CheckboxMenuItem miConstNone;

	java.awt.Menu miConstNameMenu;
	java.awt.CheckboxMenuItem miConstNameFull;
	java.awt.CheckboxMenuItem miConstNameMin;
	java.awt.CheckboxMenuItem miConstNameNone;	
	
	java.awt.CheckboxMenuItem miShowGrid;

	java.awt.CheckboxMenuItem miShowGp;
	java.awt.CheckboxMenuItem miTop;
				
	java.awt.MenuItem miUserInfo;
	java.awt.MenuItem miTable;
	java.awt.MenuItem miGDGraph;	
	
				
	java.awt.Menu menu3;
	java.awt.MenuItem miAbout;

	java.awt.PopupMenu pmenu;
	java.awt.FileDialog openFileDialog1;
	java.awt.FileDialog exportFileDialog;
	//PasswordDialog inputDialog;
	MatrixViewer mx;
	GDViewer gdx;
	
	//java.awt.Scrollbar miVAScroll;
	GScroll miVAScroll;
	
	Vector pastData = new Vector();
	ResultData selectedData;
	GrSaveThread saveThread;
	GrSleepThread sleepThread;
	GrAutoCruiseThread acThread;
	
	Dimension orgsize = new Dimension();
   	//String timeZoneIDs[];
   	PrefValue pref;
	Vector dirVect = new Vector();
	Vector pastDataDirVect = new Vector();
	SSLogic lgc;

	
	//////////// Display Mode related enums
	final int SHOW_LIST = 2;
	final int SHOW_GRAPH = 1;
	final int SHOW_ALL = 0;
	
	/////////// Animation speed control related enums
	public static final int LOW_SPEED = 2000;
	public static final int HIGH_SPEED = 100;
	
	boolean startUpFlag = true;
	boolean datalistflag = true;

	//boolean openedGdFlag = false;
	
	public SETISupport()
	{
//System.out.println("going");		

		lgc = new SSLogic(this);
		pref = FileAnalyzer.readPrefs();
		FileAnalyzer.readDirData(dirVect);
		
		initLayout();	
		setMenu();
//System.out.println("menum finished");		
		if(dirVect.size() == 0){
			handleDirInput(miOpen_Action(null,dirVect));
		}
		miBlinkAction();// need to update wave menu...
		
		FileAnalyzer.readPastDataDir(pastDataDirVect);
		
		boolean foundflag = false;
		for(int i = 0;i<pastDataDirVect.size();i++){
			DirData dr = (DirData)(pastDataDirVect.elementAt(i));
			if((dr.getDir()).equals(FileAnalyzer.pastDataFileName)){
				foundflag = true;
				break;
			}
		}
				
		if(foundflag == false){
			pastDataDirVect.addElement(new DirData("Default",FileAnalyzer.pastDataFileName));	
		}					
		updateData(true);

		if(dirVect.size() > 0){
			selectedData = ((DirData)(dirVect.elementAt(0))).getProg();
		}
		maincanvas.start();
		saveThread =new GrSaveThread(this);
		resetSleepThread();
	
		handleDataSelection();
		
		if(pref.getDatatablePref() == 1){
			miTable_Action(null);
		}
		if(pref.getGsdPref() == 1){
			miGD_Action(null);
		}
		//{{REGISTER_LISTENERS
		SymComponent aSymComponent = new SymComponent();
		this.addComponentListener(aSymComponent);
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		//}}
	}
	
	public Vector getDirVect(){return dirVect;}
	
	
	public void initLayout()
	{
		int wwidth = 600;
		int wheight = 400;
		int listWidth = wwidth/2;
		int listHeight = 160;
		
		Rectangle dm = pref.getBound();
		if((dm.width != 0)&&(dm.height != 0)){
			wwidth = dm.width;
			wheight = dm.height;
			setLocation(dm.x, dm.y);
		}
		else{
			setLocation(50,50);	
		}
		
		setLayout(new BorderLayout(0,0));
		setVisible(false);
		setSize(wwidth,wheight);	
		//setBackground(Color.black);
		
		gScrollPane = new java.awt.ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
		//gScrollPane = new java.awt.ScrollPane(ScrollPane.SCROLLBARS_NEVER);		
		gScrollPane.setSize(wwidth,wheight - listHeight);
		gScrollPane.setBackground(Color.black);
		add("Center", gScrollPane);
		currentPane = gScrollPane;

		sScrollPane = new java.awt.ScrollPane(ScrollPane.SCROLLBARS_NEVER);		
		sScrollPane.setSize(wwidth,wheight - listHeight);
		sScrollPane.setBackground(Color.black);
		//add("Center", sScrollPane);
		//sScrollPane.setVisible(false);
		
		tPane = new java.awt.Panel(new BorderLayout(0,0));
		tPane.setBackground(Color.black);
		
		maincanvas = new SkyCanvas(this);
		gScrollPane.add(maincanvas);
		maincanvas.setParentSp(gScrollPane);
		gScrollPane.doLayout();

		
		lowerPanel = new java.awt.Panel();
		lowerPanel.setLayout(new BorderLayout(0,0));
		lowerPanel.setSize(wwidth,listHeight);
		add("South", lowerPanel);
		
		datalist = new java.awt.List(4,false);
		datalist.setBackground(Color.black);
		datalist.setForeground(Color.cyan);
		datalist.setSize(listWidth,listHeight);
		lowerPanel.add("West", datalist);

		
		dataText = new java.awt.TextArea();
		dataText.setBackground(Color.black);
		dataText.setForeground(Color.pink);
		dataText.setSize(wwidth - listWidth,listHeight);
		//dataText.setRows(12);
		lowerPanel.add("Center", dataText);
		setTitle("SETI@Support");

		//miVAScroll = new Scrollbar(Scrollbar.VERTICAL);
		miVAScroll = new GScroll(this, Scrollbar.VERTICAL,GScroll.SLIDER);
		miVAScroll.setUnitIncrement(1);		
		tPane.add("West",miVAScroll);				
		// init menues

		
		pmenu = new java.awt.PopupMenu();	
		maincanvas.add(pmenu);
			
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		

		SymComponent lSymAdjust = new SymComponent();
		sScrollPane.addComponentListener(lSymAdjust);
		
		SymItem lSymItem = new SymItem();
		datalist.addItemListener(lSymItem);
		
		//SymAdjust lSymVAdjust = new SymAdjust();
		//miVAScroll.addAdjustmentListener(lSymVAdjust);
			
		(SETISupport.this).addComponentListener(lSymAdjust);
		openFileDialog1 = new java.awt.FileDialog(this, " ",FileDialog.LOAD);
		exportFileDialog = new java.awt.FileDialog(this,"Please specify file name",FileDialog.SAVE);
//System.out.println("after" + (getSize()));

	}

	private void setMenu(){
		mainMenuBar = new java.awt.MenuBar();
		
		//////////////////////////////////////////////////
		//////// menu 1 series
		//////////////////////////////////////////////////
				
		menu1 = new java.awt.Menu("File");
		
		miOpen = new java.awt.MenuItem("Open...");
		miOpen.setShortcut(new MenuShortcut(java.awt.event.KeyEvent.VK_O,false));

		miSave = new java.awt.MenuItem("Update");
		miAutoCruise = new java.awt.MenuItem("Start AutoCruise");
		Menu export_sub = new java.awt.Menu("Export  File..",true);
		
		miExportCSV = new java.awt.MenuItem("CSV");
		export_sub.add(miExportCSV);
		miExportTAB = new java.awt.MenuItem("Tab separator");
		export_sub.add(miExportTAB);		
		miExit = new java.awt.MenuItem("Quit");		

		//menu1.add(miOpen);
		menu1.add(miSave);
		menu1.addSeparator();		
		menu1.add(miAutoCruise);
		menu1.addSeparator();
		menu1.add(export_sub);
		menu1.addSeparator();
		menu1.add(miExit);
		
		mainMenuBar.add(menu1);

		//////////////////////////////////////////////////
		//////// menu 2 series
		//////////////////////////////////////////////////

		menu2 = new java.awt.Menu("Setting");
		Menu update_sub = new java.awt.Menu("Auto Update",true);
				
		mi_update = new java.awt.CheckboxMenuItem[updatestr.length];
		String str = null;
		for(int i = 0;i<updatestr.length;i++){
			mi_update[i] = new java.awt.CheckboxMenuItem(updatestr[i]);
			update_sub.add(mi_update[i]);
			if(pref.getUpdatePref() == i) str  =  updatestr[i];
		}
		setUpdateInt(str);
		
		Menu display_sub = new java.awt.Menu("Display..",true);

		miShowAll = new java.awt.CheckboxMenuItem("SkyMap+Data");
		miShowGraph = new java.awt.CheckboxMenuItem("SkyMap");
		miShowList = new java.awt.CheckboxMenuItem("Selected Data");
		miSetDisplay_Action()	;	
		display_sub.add(miShowAll);
		display_sub.add(miShowGraph);
		display_sub.add(miShowList);
		
		Menu tzone_sub = new java.awt.Menu("Time Zone",true);

		String timeZoneIDs[] = TimeZone.getAvailableIDs();
		mi_tzone = new java.awt.CheckboxMenuItem[timeZoneIDs.length];
		//currentTimeZoneID = TimeZone.getDefault().getID();

//System.out.println(currentTimeZoneID);
		for (int i = 0; i < timeZoneIDs.length; i++) {
	   		 if (timeZoneIDs[i] != null) {
	   		 	if(timeZoneIDs[i].length() > 3) continue;
	   		 	boolean flag = (pref.getCurrentTimeZoneID()).equals(timeZoneIDs[i]);
	   		 	mi_tzone[i] = new java.awt.CheckboxMenuItem(timeZoneIDs[i],flag);
				tzone_sub.add(mi_tzone[i]);
	   	 	}
		}	
		miTimeZone_Action(null);
		
		miLogData =  new java.awt.CheckboxMenuItem("Log Data");
		boolean flag;
		if(pref.getLogDataPref() == 0) flag = false; else flag = true;			
		miLogDataAction(flag);
		
		miDataset = new java.awt.MenuItem("Add Work Unit..");
		
		miPastset = new java.awt.MenuItem("Add Analyzed Data..");

		menu2.add(update_sub);

		menu2.add(display_sub);
		menu2.add(tzone_sub);
		menu2.add(miDataset);
		menu2.add(miPastset);
		menu2.add(miLogData);
				
		mainMenuBar.add(menu2);				
						
		//////////////////////////////////////////////////
		//////// menu 20 series
		//////////////////////////////////////////////////
		
		menu20 = new java.awt.Menu("SkyMap");
				
		Menu sktype_sub = new java.awt.Menu("Type",true);
		miSkConv = new java.awt.CheckboxMenuItem("BitMap");
		miSkSphere = new java.awt.CheckboxMenuItem("Vector-3D");
		miSkRect = new java.awt.CheckboxMenuItem("Vector-2D");
		miSkPlt = new java.awt.CheckboxMenuItem("Vector-Sphere");
		sktype_sub.add(miSkConv);
		sktype_sub.add(miSkSphere);
		sktype_sub.add(miSkRect);
		sktype_sub.add(miSkPlt);		
		//if((new File("goro")).exists())  
		//miSkyAction();

		miStarMenu = new java.awt.Menu("Star",true);
		miStar3 = new java.awt.CheckboxMenuItem("Brighter_than_Magnitude 3.5");
		miStar4 = new java.awt.CheckboxMenuItem("Brighter_than_Magnitude 4.5");		
		miStar5 = new java.awt.CheckboxMenuItem("Brighter_than_Magnitude 5.5");	
	
		miStarMenu.add(miStar3);
		miStarMenu.add(miStar4);		
		miStarMenu.add(miStar5);
		
		miStarBrAction();

		miSybSize = new java.awt.Menu("Mark Size",true);
		miSybNormal = new java.awt.CheckboxMenuItem("Standard");
		miSybSmall = new java.awt.CheckboxMenuItem("Small");	
		miSybVerySmall = new java.awt.CheckboxMenuItem("VerySmall");
			
		miSybSize.add(miSybNormal);
		miSybSize.add(miSybSmall);
		miSybSize.add(miSybVerySmall);		
		miSSize_Action();
				
		miConstMenu = new java.awt.Menu("Constellation",true);
		miConstFull = new java.awt.CheckboxMenuItem("Full");
		miConstMin = new java.awt.CheckboxMenuItem("Min.");	
		miConstNone = new java.awt.CheckboxMenuItem("None");	
		miConstMenu.add(miConstFull);
		miConstMenu.add(miConstMin);
		miConstMenu.add(miConstNone);
		
		miCstAction();
				
		miConstNameMenu = new java.awt.Menu("Constellation name",true);
		miConstNameFull = new java.awt.CheckboxMenuItem("Full");
		miConstNameMin = new java.awt.CheckboxMenuItem("Min.");	
		miConstNameNone = new java.awt.CheckboxMenuItem("None");	
		miConstNameMenu.add(miConstNameFull);
		miConstNameMenu.add(miConstNameMin);
		miConstNameMenu.add(miConstNameNone);	
		
		miCstNameAction();
						
		//boolean flag;
		
		if(pref.getGridPref() == 0) flag = false; else flag = true;		
		miShowGrid = new java.awt.CheckboxMenuItem("Grid ",flag);
		maincanvas.setGridMode(flag);		

		if(pref.getGpPref() == 0) flag = false; else flag = true;		
		miShowGp = new java.awt.CheckboxMenuItem("Gaussian Pattern",flag);	
//System.out.println("flag = "+flag);			
		maincanvas.setGpDisplay(flag);

		if(pref.getTopPref() == 0) flag = false; else flag = true;		
		miTop = new java.awt.CheckboxMenuItem("Highlight Top Gaussian ",flag);
		maincanvas.setTopMode(flag);	
						
		if(pref.getProgPref() == 0) flag = false; else flag = true;		
		miShowProg = new java.awt.CheckboxMenuItem("Progress Data ",flag);
		maincanvas.setProgDisplay(flag);
		
		if(pref.getScrollPref() == 0) flag = false; else flag = true;
		miAutoScroll =  new java.awt.CheckboxMenuItem("Auto Scroll",flag);
		maincanvas.setCenterFlag(flag);
		
		if(pref.getCLPref() == 0) flag = false; else flag = true;
		miCrossLine =   new java.awt.CheckboxMenuItem("Cross Line",flag);
		maincanvas.setCLDisplay(flag);

		//if(pref.getBlinkPref() == 0) flag = false; else flag = true;
		//miBlink =   new java.awt.CheckboxMenuItem("Blink of analyzed data",flag);
		//maincanvas.setBlink(flag);
		
		Menu miBlinkMenu = new java.awt.Menu("Blink of analyzed data",true);		
		miBlinkNone = new java.awt.CheckboxMenuItem("None",true);
		miBlinkNorm = new java.awt.CheckboxMenuItem("ON_OFF");
		miBlinkOF = new java.awt.CheckboxMenuItem("Cont.");	
		miBlinkWave = new java.awt.CheckboxMenuItem("Wave");	
		
		miBlinkMenu.add(miBlinkNone);
		miBlinkMenu.add(miBlinkNorm);
		miBlinkMenu.add(miBlinkOF);	
		miBlinkMenu.add(miBlinkWave);
		
		miBlinkAction();
		
		if(pref.getStarTracePref() == 0) flag = false; else flag = true;
		miStarTrace =   new java.awt.CheckboxMenuItem("Trace of Star",flag);
		maincanvas.setStarTrace(flag);

		if(pref.getAutoVanglePref() == 0) flag = false; else flag = true;
		miAutoVangle =   new java.awt.CheckboxMenuItem("Auto View Angle",flag);
		maincanvas.setAutoVangle(flag);
								
		Menu paint_sub = new java.awt.Menu("Analying Node",true);

		miPaintNorm =  new java.awt.CheckboxMenuItem("Standard");
		miPaintWrd  = new java.awt.CheckboxMenuItem("Strings"); 
		miPaintBwh  = new java.awt.CheckboxMenuItem("Hole"); 
		miPaintLine  = new java.awt.CheckboxMenuItem("Area"); 				
		miPaint_Action(null);
		paint_sub.add(miPaintNorm);
		paint_sub.add(miPaintWrd);
		paint_sub.add(miPaintBwh);
		paint_sub.add(miPaintLine);

		Menu paint_asub = new java.awt.Menu("Analyzed Node",true);

		miACircle =  new java.awt.CheckboxMenuItem("Circle");
		miASquare  = new java.awt.CheckboxMenuItem("Square"); 
		miADaiya  = new java.awt.CheckboxMenuItem("Star"); 
		miALine  = new java.awt.CheckboxMenuItem("Area"); 		
				
		miAPaint_Action(null);
		paint_asub.add(miACircle);
		paint_asub.add(miASquare);
		paint_asub.add(miADaiya);
		paint_asub.add(miALine);

		Menu anime_sub = new java.awt.Menu("Animation Speed",true);
		
		miAmHigh = new java.awt.CheckboxMenuItem("High");
		miAmLow = new java.awt.CheckboxMenuItem("Low");
		miAmAuto = new java.awt.CheckboxMenuItem("Auto");
		
		anime_sub.add(miAmHigh);
		anime_sub.add(miAmLow);
		anime_sub.add(miAmAuto);		
		miAm_Action(null);


		menu20.add(miShowProg);
		menu20.add(miAutoScroll);
		menu20.add(miCrossLine);		
		menu20.add(miBlinkMenu);
		//if((new File("goro")).exists()) 
		menu20.add(sktype_sub);		
		menu20.add(paint_sub);
		menu20.add(paint_asub);		
		menu20.add(anime_sub);
		menu20.add(miSybSize);
		menu20.add(miStarTrace);
		menu20.add(miAutoVangle);
		menu20.add(miShowGp);
		menu20.add(miTop);
		
		adjustSkyMapMenu();

		mainMenuBar.add(menu20);
		
		//////////////////////////////////////////////////
		//////// menu 21 series
		//////////////////////////////////////////////////		
				
		menu21 = new java.awt.Menu("Info");
		
		miUserInfo = new java.awt.MenuItem("User Info..");
		miTable = new java.awt.MenuItem("Data Table..");
		miGDGraph = new java.awt.MenuItem("Gaussian Distribution..");		
		
		menu21.add(miUserInfo);
		menu21.add(miTable);
		//if((new File("goro")).exists())  
			menu21.add(miGDGraph);
		mainMenuBar.add(menu21);

		//////////////////////////////////////////////////
		//////// menu3 series
		//////////////////////////////////////////////////	
						
		menu3 = new java.awt.Menu("Help");
		mainMenuBar.setHelpMenu(menu3);
		miAbout = new java.awt.MenuItem("About SETI@Support..");
		menu3.add(miAbout);
		mainMenuBar.add(menu3);
		
		setMenuBar(mainMenuBar);		


		///////////////////////////////////////////////	
		///////// SEt listners
		///////////////////////////////////////////////
					
		SymAction lSymAction = new SymAction();
		miOpen.addActionListener(lSymAction);
		miAbout.addActionListener(lSymAction);
		miSave.addActionListener(lSymAction);
		miAutoCruise.addActionListener(lSymAction);
		miExit.addActionListener(lSymAction);
		miDataset.addActionListener(lSymAction);
		miPastset.addActionListener(lSymAction);
		miUserInfo.addActionListener(lSymAction);
		miTable.addActionListener(lSymAction);		
		miGDGraph.addActionListener(lSymAction);				
		miExportCSV.addActionListener(lSymAction);		
		miExportTAB.addActionListener(lSymAction);	
								
		SymItem lSymItem = new SymItem();	
		miShowList.addItemListener(lSymItem);
		miShowGraph.addItemListener(lSymItem);
		miShowAll.addItemListener(lSymItem);
		
		miLogData.addItemListener(lSymItem);
				
		miShowProg.addItemListener(lSymItem);
		miAutoScroll.addItemListener(lSymItem);
		miCrossLine.addItemListener(lSymItem);		
		
		miBlinkNone.addItemListener(lSymItem);		
		miBlinkNorm.addItemListener(lSymItem);	
		miBlinkOF.addItemListener(lSymItem);	
		miBlinkWave.addItemListener(lSymItem);							
			
		miPaintNorm.addItemListener(lSymItem);
		miPaintWrd.addItemListener(lSymItem);
		miPaintBwh.addItemListener(lSymItem);
		miPaintLine.addItemListener(lSymItem);	
			
		miACircle.addItemListener(lSymItem);	
		miASquare.addItemListener(lSymItem);	
		miADaiya.addItemListener(lSymItem);	
		miALine.addItemListener(lSymItem);					
						
		miAmHigh.addItemListener(lSymItem);
		miAmLow.addItemListener(lSymItem);	
		miAmAuto.addItemListener(lSymItem);	
		miSkConv.addItemListener(lSymItem);	
		miSkSphere.addItemListener(lSymItem);	
		miSkRect.addItemListener(lSymItem);	
		miSkPlt.addItemListener(lSymItem);			
		miStar3.addItemListener(lSymItem);	
		miStar4.addItemListener(lSymItem);			
		miStar5.addItemListener(lSymItem);	
		miConstFull.addItemListener(lSymItem);
		miConstMin.addItemListener(lSymItem);
		miConstNone.addItemListener(lSymItem);
		miConstNameFull.addItemListener(lSymItem);
		miConstNameMin.addItemListener(lSymItem);
		miConstNameNone.addItemListener(lSymItem);
		miShowGrid.addItemListener(lSymItem);
		miShowGp.addItemListener(lSymItem);	
		miTop.addItemListener(lSymItem);				
		miSybNormal.addItemListener(lSymItem);
		miSybSmall.addItemListener(lSymItem);
		miSybVerySmall.addItemListener(lSymItem);		
		miStarTrace.addItemListener(lSymItem);		
		miAutoVangle.addItemListener(lSymItem);
		
		for(int i = 0;i<updatestr.length;i++) mi_update[i].addItemListener(lSymItem);	
		for(int i =0;i<mi_tzone.length;i++){
			if(mi_tzone[i] == null) continue;		
			mi_tzone[i].addItemListener(lSymItem);	
		}		
	}
	
	////////////////////////////////////////////////////////////
	////////// some basic functions...
	////////////////////////////////////////////////////////////
	
	
    public void setVisible(boolean b)
	{
		if(b)
		{
			//setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	static public void main(String args[])
	{
	//System.out.println("stqrtup");
		(new SETISupport()).setVisible(true);
	}
	
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
//////////////////////////////////////////////////////
// call back related functions
/////////////////////////////////////////////////////

///////////////////////////////////////////////////
////////////////// Window Adapter relted
///////////////////////////////////////////////////
	
	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowActivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == SETISupport.this)
				SETISupport_WindowActivated(event);
		}
		public void windowDeactivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == SETISupport.this)
				SETISupport_WindowDeactivated(event);
		}		

		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == SETISupport.this)
				SETISupport_WindowClosing(event);
		}
	}// end of class SymWindow
	
	void SETISupport_WindowActivated(java.awt.event.WindowEvent event)
	{
		resetSleepThread();	
	}
	
	void SETISupport_WindowDeactivated(java.awt.event.WindowEvent event)
	{
		if(miAmAuto.getState() == false) return;		
		if(sleepThread == null) return;
		//if(openedGdFlag == true){
		//	openedGdFlag = false;
		//	return;
		//}
//System.out.println("deactivate called");		
		sleepThread.forceStop();
		slowerAm();
	}		
	void SETISupport_WindowClosing(java.awt.event.WindowEvent event)
	{
		pref.setBound(getBounds());
		FileAnalyzer.fileOutPrefs(pref);		
		setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		System.exit(0);		// close the application
	}


///////////////////////////////////////////////////
////////////////// Action Listner relted
///////////////////////////////////////////////////
	
	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			//resetSleepThread();	/// time to wakeup
						
			Object object = event.getSource();
			if (object == miAbout)
				miAbout_Action(event);
			else  if (object == miOpen)
				handleDirInput(miOpen_Action(event,dirVect));
			else if (object == miSave)
				miSave_Action(event);
			else if (object == miExit)
				miExit_Action(event);	
			else if (object == miDataset)
				miDataset_Action(event);	
			else if(object == miPastset)
				miPastset_Action(event);
			else if (object == miUserInfo)
				miUserInfo_Action(event);	
			else if (object == miTable)
				miTable_Action(event);	
			else if (object == miGDGraph)
				miGD_Action(event);									
			else if(object == miExportCSV)
				miExport_Action(GLB.CSV);
			else if(object == miExportTAB)
				miExport_Action(GLB.TAB);
			else if(object == miAutoCruise)
				miAutoCruise_Action(event);
		}
	}
	
	void miAbout_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from About Create and show as modal
		AboutDialog adg = new AboutDialog(this, true);
		Dimension d = getSize();
		adg.setLocation(d.width/3,d.height/3);
		adg.show();
		//}}
	}

	DirData miOpen_Action(java.awt.event.ActionEvent event, Vector cvect)
	{
		return miOpen_Action(event,cvect,true);	
	}
	
	DirData miOpen_Action(java.awt.event.ActionEvent event, Vector cvect, boolean flag)
	{

		int		defMode			= openFileDialog1.getMode();
		String	defTitle		= openFileDialog1.getTitle();
		String defDirectory	= openFileDialog1.getDirectory();
		String defFile			= openFileDialog1.getFile();
//System.out.println("here");
		openFileDialog1 = new java.awt.FileDialog(this, defTitle, defMode);
		openFileDialog1.setDirectory(defDirectory);
		openFileDialog1.setFile(defFile);
		if(flag){
			openFileDialog1.setTitle("Please select state.txt or state.sah for SETI@Home");
		}
		else{
			openFileDialog1.setTitle("Please select analyzed data file");			
		}
		openFileDialog1.show();
//System.out.println("htere");		
		String dirName= null;

		dirName =  (openFileDialog1.getDirectory());
		if(dirName == null) return null;

		if(flag == false){
			dirName =dirName + (openFileDialog1.getFile());	
		}


		
		for(int i = 0;i<cvect.size();i++){
			DirData ndata = (DirData)(cvect.elementAt(i));
			if(dirName.equals(ndata.getDir()) == true){
				return null;// no redundant..
			}
		}
		String shortName =lgc.getUniqueDirName(cvect);
		DirData ndata = new DirData(shortName,dirName);
		return ndata;
	}
	

	void handleDirInput(DirData ndata)
	{
		if(ndata == null) return;
		dirVect.addElement(ndata);
		FileAnalyzer.FileoutDirData(dirVect);
		updateData(true);	
	}
	
	public void updateDirData(Vector cvect){
		dirVect.removeAllElements();
		for(int i = 0;i<cvect.size();i++){
			DirData ddata = (DirData)(cvect.elementAt(i));
//System.out.println("name = "+(ddata.getShortName()));
			dirVect.addElement(ddata);
			ddata.informChange();
		}
		FileAnalyzer.FileoutDirData(dirVect);
		updateData(true);	
		miBlinkAction();// need to update wave menu according to the result of this			
	}
	public void updatePastDirData(Vector cvect){
		
		boolean updateflag = false;

		if(cvect.size() != pastDataDirVect.size()) updateflag = true;
		else{
			for(int i = 0;i<cvect.size();i++){
				DirData ddata = (DirData)(cvect.elementAt(i));
				boolean matchedflag = false;
				for(int j = 0;j<pastDataDirVect.size();j++){
					DirData jdata = (DirData)(pastDataDirVect.elementAt(j));
					if((ddata.getDir()).equals(jdata.getDir())){
						matchedflag = true;
						jdata.setShortName(ddata.getShortName());
						jdata.setColorName(ddata.getColorName());
						//jdata.setColor();
						break;
					}
				}			
				if(matchedflag == false) updateflag = true;
			}
		}
		if(updateflag){
		
			pastDataDirVect.removeAllElements();
			for(int i = 0;i<cvect.size();i++){
				DirData ddata = (DirData)(cvect.elementAt(i));
	//System.out.println("name = "+(ddata.getShortName()));
				pastDataDirVect.addElement(ddata);
			}
			updateData(true);		
		}		
		FileAnalyzer.FileoutPastDataDir(pastDataDirVect);	
	}	
	
	void miSave_Action(java.awt.event.ActionEvent event){
		updateData(false);			
		setViewItems();
	}
			
	void miExit_Action(java.awt.event.ActionEvent event)
	{
//System.out.println("before exit" + (getSize()));
		pref.setBound(getBounds());
		FileAnalyzer.fileOutPrefs(pref);
		if(mx != null){
			mx.MatrixViewer_WindowClosing(null);
			pref.setDatatablePref(1);
			FileAnalyzer.fileOutPrefs(pref);			
		}
		if(gdx != null){
			gdx.GDViewer_WindowClosing(null);
			pref.setGsdPref(1);
			FileAnalyzer.fileOutPrefs(pref);					
		}
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
	}		
	void miTable_Action(java.awt.event.ActionEvent event){
		if(mx != null){// already opend
			mx.show();	
		}
		else{
			mx = new MatrixViewer(this);
			mx.setVisible(true);	
			mx.show();
		}	
		pref.setDatatablePref(1);
		FileAnalyzer.fileOutPrefs(pref);				
	}	
	void miGD_Action(java.awt.event.ActionEvent event){
		if(gdx != null){// already opend
			gdx.show();	
		}
		else{
			gdx = new GDViewer(this);
			gdx.setVisible(true);	
			gdx.show();
		}		
		pref.setGsdPref(1);
		FileAnalyzer.fileOutPrefs(pref);			
		//openedGdFlag = true;
	}	
	
	void miDataset_Action(java.awt.event.ActionEvent event){
		ListDialog ldg = new ListDialog(this,dirVect,"Data set",GLB.EDITOR);
		ldg.setLocation(100,100);		
		ldg.show();	
	}

	void miPastset_Action(java.awt.event.ActionEvent event){
		ListDialog ldg = new ListDialog(this,pastDataDirVect,"Analyzed Data",GLB.PAST_DATA);
		ldg.setLocation(100,100);		
		ldg.show();	
	}
	void miUserInfo_Action(java.awt.event.ActionEvent event){
		ListDialog ldg = new ListDialog(this,dirVect,"User Info",GLB.USER_INFO);
		ldg.setLocation(100,100);		
		ldg.show();		
	}	
	
	void miExport_Action(int mode)
	{

		int		defMode			= exportFileDialog.getMode();
		String	defTitle		= exportFileDialog.getTitle();
		String defDirectory	= exportFileDialog.getDirectory();
		String defFile			="";
		if(mode == GLB.CSV) defFile = "st_data.csv";
		else if(mode == GLB.TAB) defFile = "st_data.txt";

		exportFileDialog = new java.awt.FileDialog(this, defTitle, defMode);
		exportFileDialog.setDirectory(defDirectory);
		exportFileDialog.setFile(defFile);
		exportFileDialog.show();
//System.out.println("htere");		
		String dirName =  (exportFileDialog.getDirectory());
		String fileName = (exportFileDialog.getFile());
		
		if((dirName == null)||(fileName == null)) return;
		else{
			Vector cvect = new Vector();
			String title[] = {"Unit Name","Progress","CPU Time(sec)","CPU Time(hr:min:sec)","Analysis started","Peak Power","Peak Score","Drift Rate-Peak","Gaussian Power","Gaussian Fit","Gaussian Score","Drift Rate-Gaussian","From(RA)","From(DEC)","To(RA)","To(DEC)","Recorded Time (GMT)","Base Freq"};
			Vector svect = new Vector();
			for(int i =0;i<title.length;i++){
				svect.addElement(title[i]);
			} 	
			cvect.addElement(svect);		
					
			for(int i = pastData.size() - 1 ;i >= 0;i--){
				ResultData rd = (ResultData)pastData.elementAt(i);
				svect = new Vector();
				rd.getCSVStr(svect);
				cvect.addElement(svect);
			}	
			for(int i =dirVect.size() -1 ; i >= 0;i--){
				ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
				svect = new Vector();
				rd.getCSVStr(svect);
				cvect.addElement(svect);
			}
			FileAnalyzer.exportCSVFile(dirName+fileName,cvect,mode);
		}
	}		

	private void miAutoCruise_Action(java.awt.event.ActionEvent event){
		String str = miAutoCruise.getLabel();
		if(str.indexOf("Start")!= -1){
			miAutoCruise.setLabel("Stop AutoCruise");
			acThread =new GrAutoCruiseThread(this);
			acThread.setSleepTime(pref.getAcPref());
			acThread.start();	
			cruiseNextData(0);		
			acThread.setN(1);		
		}
		else{
			miAutoCruise.setLabel("Start AutoCruise");
			if(acThread != null){
				acThread.stop();
			}
		}

	}

////////////////////////////////////////////////////////////////////////////
/////////// ItemListner related 
////////////////////////////////////////////////////////////////////////////

	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
	//System.out.println("called ");
			//resetSleepThread();	// wake up	
	
			Object object = event.getSource();
			if (object == datalist){
				resetSleepThread();
				ptChoice_ItemStateChanged(event);
			}
			else if(object == miShowList){
				pref.setDispPref (SHOW_LIST);
				miSetDisplay_Action();
			}
			else if(object == miShowGraph){
				pref.setDispPref (SHOW_GRAPH);
				miSetDisplay_Action();
			}
			else if(object == miShowAll){
				pref.setDispPref (SHOW_ALL);
				miSetDisplay_Action();
			}
			else if(object == miShowProg){			
				miShowProg_Action(event);
				if(miShowProg.getState())  pref.setProgPref(1);
				else pref.setProgPref(0);					
			}
			else if(object == miAutoScroll){
				miAutoScroll_Action(event);
				if(miAutoScroll.getState())  pref.setScrollPref(1);
				else pref.setScrollPref(0);
			}
			else if(object == miCrossLine){
				miCrossLine_Action(event);
				if(miCrossLine.getState())  pref.setCLPref(1);
				else pref.setCLPref(0);
			}	
			else if(object == miBlinkNone){
				pref.setBlinkPref(GLB.BLINK_NONE);
				miBlinkAction();
			}
			else if(object == miBlinkNorm){
				pref.setBlinkPref(GLB.BLINK_RANDOM);
				miBlinkAction();			
			}
			else if(object == miBlinkOF){
				pref.setBlinkPref(GLB.BLINK_OF);
				miBlinkAction();			
			}
			else if(object == miBlinkWave){
				pref.setBlinkPref(GLB.BLINK_WAVE);
				miBlinkAction();			
			}							
			else if((object == miPaintNorm)||(object == miPaintWrd)||
					(object == miPaintBwh)||(object == miPaintLine)){
				pref.setPaintPref(((java.awt.CheckboxMenuItem)object).getLabel());
				miPaint_Action(event);
			}
			else if((object == miACircle)||(object == miASquare)||
					(object == miADaiya)||(object == miALine)){
				pref.setAPaintPref(((java.awt.CheckboxMenuItem)object).getLabel());
				miAPaint_Action(event);
			}			
			else if((object == miAmHigh)||(object == miAmLow)||(object == miAmAuto)){
				pref.setAmPref(((java.awt.CheckboxMenuItem)object).getLabel());
				miAm_Action(event);				
			}
			else if((object == miStar3)||(object == miStar5)||(object == miStar4)){
				StringTokenizer st = new StringTokenizer(((java.awt.CheckboxMenuItem)object).getLabel());
				st.nextToken();
				pref.setStarBrPref((Double.valueOf(st.nextToken())).doubleValue());
				miStarBrAction();
			}
			else if(object == miSkConv){
				pref.setSkyPref(GLB.CONV);
				miSkyAction();
			}
			else if(object == miSkSphere){
				pref.setSkyPref(GLB.SPHERE);	
				miSkyAction();		
			}
			else if(object == miSkRect){
				pref.setSkyPref(GLB.RECT_VIEW);			
				miSkyAction();		
			}	
			else if(object == miSkPlt){
				pref.setSkyPref(GLB.PLTVIEW);			
				miSkyAction();		
			}				
			else if(object == miConstFull){
				pref.setCstPref(GLB.FULL);			
				miCstAction();		
			}		
			else if(object == miConstMin){
				pref.setCstPref(GLB.MINIMUM);			
				miCstAction();		
			}	
			else if(object == miConstNone){
				pref.setCstPref(GLB.NONE);			
				miCstAction();		
			}	
			else if(object == miConstNameFull){
				pref.setCstNamePref(GLB.FULL);			
				miCstNameAction();		
			}		
			else if(object == miConstNameMin){
				pref.setCstNamePref(GLB.MINIMUM);			
				miCstNameAction();		
			}	
			else if(object == miConstNameNone){
				pref.setCstNamePref(GLB.NONE);			
				miCstNameAction();		
			}		
			else if(object == miShowGrid){
				miGrid_Action();
				if(miShowGrid.getState())  pref.setGridPref(1);
				else pref.setGridPref(0);
			}	
			else if(object == miShowGp){
				miGp_Action();
				if(miShowGp.getState())  pref.setGpPref(1);
				else pref.setGpPref(0);
			}	
			else if(object == miTop){
				miTop_Action();
				if(miTop.getState())  pref.setTopPref(1);
				else pref.setTopPref(0);
			}								
			else if(object == miStarTrace){
				miStarTrace_Action();
				if(miStarTrace.getState())  pref.setStarTracePref(1);
				else pref.setStarTracePref(0);
			}	
			else if(object == miAutoVangle){
				miAutoVangle_Action();
				if(miAutoVangle.getState())  pref.setAutoVanglePref(1);
				else pref.setAutoVanglePref(0);
			}	
			else if(object == miLogData){
//System.out.println((pref.getLogDataPref()));			
				if(pref.getLogDataPref() == 1){
					popUpConfirm();			
				}
				else{
					miLogDataAction(true);
				}

			}									
			else if((object == miSybNormal)||(object == miSybSmall)||
					(object == miSybVerySmall)){
				pref.setSSizePref(((java.awt.CheckboxMenuItem)object).getLabel());
				miSSize_Action();
			}												
			for(int i = 0;i<updatestr.length;i++){
				if(object == mi_update[i]){
					pref.setUpdatePref(i);
					miUpdateInt_Action(event);
				}
			}
			for(int i =0;i<mi_tzone.length;i++){
				if(object == mi_tzone[i]){
					pref.setCurrentTimeZoneID(mi_tzone[i].getLabel());
					miTimeZone_Action(event);
				}
			}			
			FileAnalyzer.fileOutPrefs(pref);
		}// end of itemStateChanged
	}

	void popUpConfirm(){
		ConfirmDialog cdg = new ConfirmDialog(this, true);
		Dimension d = getSize();
		cdg.setLocation(d.width/3,d.height/3);
		cdg.show();	
	}	
		
	void ptChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		//resetSleepThread();
		if(datalistflag == false) return;
		int selindex = datalist.getSelectedIndex();
		
		selectedData = null;
		if(selindex < dirVect.size()){
			for(int i = 0;i<dirVect.size();i++){
				if(i == selindex){
					selectedData = ((DirData)(dirVect.elementAt(i))).getProg();
					break;
				}
			}
		}
		else{
			selindex -= (dirVect.size());
			for(int i = 0;i<pastData.size();i++){
				if(i == selindex){
					selectedData = (ResultData)pastData.elementAt(i);
					break;
				}
			}// end of for..
		}//end of else
		handleDataSelection();
	}
	
	private void handleDataSelection(){	
		if(selectedData != null){
			handleDataSelectionExceptTable();
			if(mx == null) return;
			mx.updateWithScroll();			
		}		
	}	
	private void handleDataSelectionExceptTable()
	{
		if(selectedData != null){
			setTimeZoneData();
			dataText.setText(selectedData.getDataStr());
			maincanvas.selectPt(selectedData.getPointData());	
			int index = datalist.getSelectedIndex();
			datalist.deselect(index);
			index = getDataIndex(selectedData);
	//System.out.println("index = "+index);		
			datalist.select(index);			
		}				
	}
	public void selectData(ResultData srd){// called from skycanvas
		if(srd == null) return;
		selectedData = srd;
		handleDataSelection();
	}
		
	private int getDataIndex(ResultData srd){
		int selindex = 0;
		
		for(int i = 0;i<dirVect.size();i++,selindex ++){
			ResultData  rd = ((DirData)(dirVect.elementAt(i))).getProg();
			if(rd == srd){
				return selindex;
			}
		}
		for(int i = 0;i<pastData.size();i++,selindex ++){
			ResultData rd = (ResultData)pastData.elementAt(i);
			if(rd == srd){
				return selindex;
			}
		}		
		return selindex;
	}
	
	void miSetDisplay_Action(){
		if(pref.getDispPref() == SHOW_ALL){
			if(orgsize.equals(new Dimension()) == false){
				setSize(orgsize);
			}
			lowerPanel.setVisible(true);
			datalist.setVisible(true);
			currentPane.setVisible(true);
			maincanvas.resume();
			orgsize = new Dimension();
			
			miShowAll.setState(true); miShowGraph.setState(false); miShowList.setState(false);
		}
		else if(pref.getDispPref() == SHOW_GRAPH){
			if(orgsize.equals(new Dimension()) == false){
				setSize(orgsize);
			}
			lowerPanel.setVisible(false);
			currentPane.setVisible(true);
			maincanvas.resume();
			orgsize = new Dimension();
			
			miShowAll.setState(false); miShowGraph.setState(true); miShowList.setState(false); 
		}
		else if(pref.getDispPref() == SHOW_LIST){
			orgsize = getSize();
			setSize(datalist.getSize());
			
			lowerPanel.setVisible(true);
			currentPane.setVisible(false);
			datalist.setVisible(false);
			maincanvas.suspend();
			//datalist.select(0);
			//ptChoice_ItemStateChanged(null);		
			miShowAll.setState(false); miShowGraph.setState(false); miShowList.setState(true);
		}
		validate();
		doLayout();
	}
	void miShowProg_Action(java.awt.event.ItemEvent event){
		CheckboxMenuItem item = (CheckboxMenuItem)(event.getSource());
		maincanvas.setProgDisplay(item.getState());
	}		
	
	void miAutoScroll_Action(java.awt.event.ItemEvent event){

//System.out.println("removed " + currentPane);		
		if(pref.getSkyPref() == GLB.CONV){
			remove(currentPane);
			currentPane.remove(maincanvas);
			if(miAutoScroll.getState() == false){
				add("Center", gScrollPane);
				//remove(sScrollPane);
				//sScrollPane.remove(maincanvas);
				gScrollPane.add(maincanvas);
				maincanvas.setParentSp(gScrollPane);
				currentPane = gScrollPane;	
			}
			else{
				add("Center", sScrollPane);
				//remove(gScrollPane);
				//gScrollPane.remove(maincanvas);
				sScrollPane.add(maincanvas);
				maincanvas.setParentSp(sScrollPane);
				currentPane = sScrollPane;	
				
			}
		}
		
		maincanvas.setCenterFlag(miAutoScroll.getState());
		validate();
		doLayout();
		
		maincanvas.setScrollPos();		
	}	
		
	void miCrossLine_Action(java.awt.event.ItemEvent event){
		CheckboxMenuItem item = (CheckboxMenuItem)(event.getSource());
		maincanvas.setCLDisplay(item.getState());
	}

	private void miStarTrace_Action(){
		//CheckboxMenuItem item = (CheckboxMenuItem)(event.getSource());
		maincanvas.setStarTrace(miStarTrace.getState());
	}
	
	private void miAutoVangle_Action(){
		maincanvas.setAutoVangle(miAutoVangle.getState());
		if(miAutoVangle.getState()){
			miVAScroll.setVisible(false);
		}
		else{
			miVAScroll.setVisible(true);
		}
	}

	public void miLogDataAction(boolean flag){
		if(flag)  pref.setLogDataPref(1);
		else pref.setLogDataPref(0);
		miLogData.setState(flag);
		FileAnalyzer.fileOutPrefs(pref);			
		
	}
	
	public boolean getLogDataPref(){
		if(pref.getLogDataPref() == 1) return true;
		else return false;
	}	
	
	void miBlinkAction(){
		int mode = pref.getBlinkPref();
		if(mode == GLB.BLINK_NONE){
			miBlinkNone.setState(true); 	miBlinkNorm.setState(false);
			miBlinkOF.setState(false);		miBlinkWave.setState(false);
		}
		else if(mode == GLB.BLINK_RANDOM){
			miBlinkNone.setState(false); 	miBlinkNorm.setState(true);
			miBlinkOF.setState(false);		miBlinkWave.setState(false);		
		}
		else if(mode == GLB.BLINK_OF){
			miBlinkNone.setState(false); 	miBlinkNorm.setState(false);
			miBlinkOF.setState(true);		miBlinkWave.setState(false);		
		}
		else if(mode == GLB.BLINK_WAVE){
			miBlinkNone.setState(false); 	miBlinkNorm.setState(false);
			miBlinkOF.setState(false);		miBlinkWave.setState(true);		
		}
		maincanvas.setABMode(mode);
		if(dirVect.size() == 0){
			miBlinkWave.setEnabled(false);
		}
		else{
			miBlinkWave.setEnabled(true);
		}
	}

	void miPaint_Action(java.awt.event.ItemEvent event){
		//if(pref.getPaintPref() == null) pref.setPaintPref("Standard");
//System.out.println(pref.getPaintPref());	
		int mode = GLB.NORMAL;	
		if((pref.getPaintPref()).equals("Standard") == true){
			miPaintNorm.setState(true);
			miPaintWrd.setState(false);
			miPaintBwh.setState(false);
			miPaintLine.setState(false);
			mode = GLB.NORMAL;
		}
		else if((pref.getPaintPref()).equals("Strings") == true){
			miPaintNorm.setState(false);
			miPaintWrd.setState(true);
			miPaintBwh.setState(false);		
			miPaintLine.setState(false);
	
			mode = GLB.WRD;
		}
		else if(((pref.getPaintPref()).equals("Whole") == true)||((pref.getPaintPref()).equals("Hole") == true)){
			miPaintNorm.setState(false);
			miPaintWrd.setState(false);
			miPaintBwh.setState(true);
			miPaintLine.setState(false);
			
			mode = GLB.BWH;			
		}	
		else if((pref.getPaintPref()).equals("Area") == true){
			miPaintNorm.setState(false);
			miPaintWrd.setState(false);
			miPaintBwh.setState(false);		
			miPaintLine.setState(true);
				
			mode = GLB.LINE;
		}			
		maincanvas.setPMode(mode);
	}	
	
	void miAPaint_Action(java.awt.event.ItemEvent event){
		int mode = GLB.CIRCLE;	
		if((pref.getAPaintPref()).equals("Circle") == true){
			miACircle.setState(true);
			miASquare.setState(false);
			miADaiya.setState(false);
			miALine.setState(false);
			mode = GLB.CIRCLE;
		}
		else if((pref.getAPaintPref()).equals("Square") == true){
			miACircle.setState(false);
			miASquare.setState(true);
			miADaiya.setState(false);			
			miALine.setState(false);
			mode = GLB.SQUARE;
		}
		else if((pref.getAPaintPref()).equals("Star") == true){
			miACircle.setState(false);
			miASquare.setState(false);
			miADaiya.setState(true);	
			miALine.setState(false);				
			mode = GLB.DIAMOND;	
		}	
		else if((pref.getAPaintPref()).equals("Area") == true){
			miACircle.setState(false);
			miASquare.setState(false);
			miADaiya.setState(false);	
			miALine.setState(true);				
			mode = GLB.ALINE;	
		}				
		maincanvas.setAPMode(mode);
	}		
	
	void miAm_Action(java.awt.event.ItemEvent event){
		
		if(sleepThread != null) sleepThread .stop();		
		if(pref.getAmPref().equals("High") == true){
//System.out.println("high");			
			miAmHigh.setState(true);
			miAmLow.setState(false);	
			miAmAuto.setState(false);
//System.out.println(maincanvas);			
			maincanvas.setAnimeTime(HIGH_SPEED);

		}
		else if(pref.getAmPref().equals("Low") == true){
			miAmHigh.setState(false);
			miAmLow.setState(true);	
			miAmAuto.setState(false);				
			maincanvas.setAnimeTime(LOW_SPEED);
			if(sleepThread != null) sleepThread .stop();		
		}	
		else if(pref.getAmPref().equals("Auto") == true){
			miAmHigh.setState(false);
			miAmLow.setState(false);	
			miAmAuto.setState(true);	
			sleepThread = new GrSleepThread(this);
			sleepThread.resetSleepTime();
			sleepThread.start();
		}			
	}
	
	private void miStarBrAction(){
		double brvalue = pref.getStarBrPref();
		maincanvas.setStarBr(brvalue);
		if(brvalue == 3.5){
			miStar3.setState(true);
			miStar4.setState(false);
			miStar5.setState(false);
		}
		else if(brvalue == 4.5){
			miStar3.setState(false);
			miStar4.setState(true);			
			miStar5.setState(false);
		}		
		else if(brvalue == 5.5){
			miStar3.setState(false);
			miStar4.setState(false);			
			miStar5.setState(true);
		}
	}

	void miSkyAction(){
		int mode = pref.getSkyPref();
		maincanvas.setPaintMode(mode);	
	
		adjustSkyMapMenu();
		
		if(mode == GLB.CONV){
			miSkSphere.setState(false); miSkRect.setState(false);		
			miSkPlt.setState(false);	miSkConv.setState(true); 
			miAutoScroll_Action(null);
			maincanvas.setVangle(GLB.INI_CONV_VANGLE);			
		}
		else if((mode == GLB.SPHERE)||(mode == GLB.RECT_VIEW)||(mode == GLB.PLTVIEW)){
			remove(currentPane);
			currentPane.remove(maincanvas);	
			tPane.add("Center",maincanvas);
			tPane.setVisible(true);	

			add("Center", tPane);						
			currentPane = tPane;			
			
			if(mode == GLB.SPHERE){
				miSkConv.setState(false); miSkSphere.setState(true); miSkRect.setState(false);
				miSkPlt.setState(false);		
				miVAScroll.setValues(GLB.INI_SH_VANGLE,1,GLB.MIN_SH_VANGLE,GLB.MAX_SH_VANGLE);					
				maincanvas.setVangle(GLB.INI_SH_VANGLE);	
				miVAScroll.setVisible(true);
				
			}
			else if(mode == GLB.RECT_VIEW){
				miSkConv.setState(false); miSkSphere.setState(false); miSkRect.setState(true);
				miSkPlt.setState(false);
				miVAScroll.setValues(GLB.INI_RC_VANGLE,1,GLB.MIN_RC_VANGLE,GLB.MAX_RC_VANGLE);							
				maincanvas.setVangle(GLB.INI_RC_VANGLE);	
				miVAScroll.setVisible(true);				
			}
			else if(mode == GLB.PLTVIEW){
				miSkConv.setState(false); miSkSphere.setState(false); miSkRect.setState(false);
				miSkPlt.setState(true);
				maincanvas.setVangle(GLB.INI_SPH_VANGLE);					
				miVAScroll.setVisible(false);
			}	
					
			validate();
			doLayout();			
				
		}
		
	}
	private void adjustSkyMapMenu(){
		int pval = pref.getSkyPref();

		menu20.remove(miStarMenu);
		menu20.remove(miStarTrace);			
		menu20.remove(miConstMenu);
		menu20.remove(miConstNameMenu);
		menu20.remove(miShowGrid);
		menu20.remove(miAutoVangle);
		menu20.remove(miShowGp);
		menu20.remove(miTop);
		
		if((pval == GLB.SPHERE)||(pval == GLB.RECT_VIEW)||(pval == GLB.PLTVIEW)){
			menu20.add(miStarMenu);	
	
			menu20.add(miConstMenu);
			menu20.add(miConstNameMenu);
			menu20.add(miShowGrid);		
			if(pref.getGridPref() == 1) miShowGrid.setState(true); else miShowGrid.setState(false);
			if(pval == GLB.SPHERE){
				menu20.add(miStarTrace);
				if(pref.getStarTracePref() == 1) miStarTrace.setState(true);
				else miStarTrace.setState(false);	
				
				if((new File("goro")).exists()) menu20.add(miAutoVangle);
				if(pref.getAutoVanglePref() == 1) miAutoVangle.setState(true);
				else miAutoVangle.setState(false);
			}
		}

		menu20.add(miShowGp);
		menu20.add(miTop);
		if(pref.getGpPref() == 1) miShowGp.setState(true); else miShowGp.setState(false);	
		if(pref.getTopPref() == 1) miTop.setState(true); else miTop.setState(false);				
	}		
	void miCstAction()
	{
		int mode = pref.getCstPref();
		maincanvas.setCstMode(mode);	
		if(mode == GLB.FULL){
			miConstFull.setState(true); miConstMin.setState(false); miConstNone.setState(false);
		}
		else if(mode == GLB.MINIMUM){
			miConstFull.setState(false); miConstMin.setState(true); miConstNone.setState(false);		
		}
		else if(mode == GLB.NONE){
			miConstFull.setState(false); miConstMin.setState(false); miConstNone.setState(true);		
		}	
	}
	
	void miCstNameAction()
	{
		int mode = pref.getCstNamePref();
		maincanvas.setCstNameMode(mode);	
		if(mode == GLB.FULL){
			miConstNameFull.setState(true); miConstNameMin.setState(false); miConstNameNone.setState(false);
		}
		else if(mode == GLB.MINIMUM){
			miConstNameFull.setState(false); miConstNameMin.setState(true); miConstNameNone.setState(false);		
		}
		else if(mode == GLB.NONE){
			miConstNameFull.setState(false); miConstNameMin.setState(false); miConstNameNone.setState(true);		
		}				
	}
					
	void miGrid_Action(){
		//CheckboxMenuItem item = (CheckboxMenuItem)(event.getSource());
		maincanvas.setGridMode(miShowGrid.getState());
	}	
	
	void miGp_Action(){
		maincanvas.setGpDisplay(miShowGp.getState());
	}
	
	void miTop_Action(){
		maincanvas.setTopMode(miTop.getState());
	}
	
	private void miSSize_Action(){
		String str = pref.getSSizePref();
		if(str.equals(miSybNormal.getLabel())){
			miSybNormal.setState(true);
			miSybSmall.setState(false);
			miSybVerySmall.setState(false);
		}
		else if(str.equals(miSybSmall.getLabel())){
			miSybNormal.setState(false);
			miSybSmall.setState(true);		
			miSybVerySmall.setState(false);
			
		}
		else if(str.equals(miSybVerySmall.getLabel())){
			miSybNormal.setState(false);
			miSybSmall.setState(false);		
			miSybVerySmall.setState(true);			
		}
		maincanvas.setSybSize(str);
	}	
	
	void miUpdateInt_Action(java.awt.event.ItemEvent event)
	{
		CheckboxMenuItem item = (CheckboxMenuItem)(event.getSource());
		setUpdateInt(item.getLabel());
	}
	
	private void setUpdateInt(String str)
	{
		StringTokenizer st = new StringTokenizer(str);
		String fstr = st.nextToken();
//System.out.println("fsr = "+fstr);

		if(fstr.equals("Never") == true){
			if(saveThread != null){
				saveThread.stop();
			}
		}
		else{
			int interval = (Integer.valueOf(fstr)).intValue();
			saveThread =new GrSaveThread(this);
			saveThread.setSleepTime(interval*60);
			saveThread.start();
//System.out.println("started "+(interval));
		}
//System.out.println("anyway");
		for(int i = 0;i<updatestr.length;i++){
			if(i == pref.getUpdatePref()) mi_update[i].setState(true);
			else mi_update[i].setState(false);
		}
	}
	
	private void miTimeZone_Action(java.awt.event.ItemEvent event){
		
		setTimeZoneData();
		
		for(int i =0;i<mi_tzone.length;i++) {
			if(mi_tzone[i] == null) continue;
			if((mi_tzone[i].getLabel()).equals(pref.getCurrentTimeZoneID()))  mi_tzone[i].setState(true);
			else mi_tzone[i].setState(false);
		}	
		
		handleDataSelection();	
		if(mx != null) mx.update(false);
	}
	
	private void setTimeZoneData(){
		for(int i = 0;i<dirVect.size();i++){
			ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
			if(rd != null) rd.setTimeZone(pref.getCurrentTimeZoneID());
		}		
		for(int i = 0;i<pastData.size();i++){
			((ResultData)(pastData.elementAt(i))).setTimeZone(pref.getCurrentTimeZoneID());
		}		
	}
	
	//public String getTimeZoneID(){
	//	return (pref.getCurrentTimeZoneID());
	//}
	public void popupmenu(Point pos){
		pmenu.show(maincanvas,pos.x, pos.y);
	}	
	
////////////////////////////////////////////////////////////////////////
/////////////// Component Adapter related
////////////////////////////////////////////////////////////////////////
	
	class SymComponent extends java.awt.event.ComponentAdapter
	{
		public void componentShown(java.awt.event.ComponentEvent event)
		{
			//resetSleepThread();
			Object object = event.getSource();
			if (object == SETISupport.this)
				SETISupport_ComponentShown(event);
		}

		public void componentMoved(java.awt.event.ComponentEvent event)
		{
			//resetSleepThread();	
						
			Object object = event.getSource();
			if (object == SETISupport.this)
				SETISupport_ComponentMoved(event);
		}

		public void componentResized(java.awt.event.ComponentEvent event)
		{
	//System.out.println("called ");
			//resetSleepThread();	
						
			Object object = event.getSource();
			if ((object == sScrollPane)||(object == tPane))
				scroll_SizeChanged(event);
			else if (object == SETISupport.this)
				SETISupport_ComponentResized(event);
		}// end of itemStateChanged
	}

	
	void SETISupport_ComponentShown(java.awt.event.ComponentEvent event)
	{
		if(startUpFlag){
			//miAutoScroll_Action(null);		
			miSkyAction();
			startUpFlag = false;
			
			Rectangle dm = pref.getBound();
			if((dm.width != 0)&&(dm.height != 0)){
				setSize(new Dimension(dm.width,dm.height));

				setLocation(dm.x, dm.y);			
			}
			else{
				setLocation(50,50);	
			}
			//maincanvas.setClipRect(maincanvas.getSize());						
		}
	}	
	

	void SETISupport_ComponentMoved(java.awt.event.ComponentEvent event)
	{
		//pref.setBound(getBounds());
		//FileAnalyzer.fileOutPrefs(pref);
	}
		
	public void scroll_SizeChanged(ComponentEvent event){
		maincanvas.setScrollPos();
	}
	
	void SETISupport_ComponentResized(java.awt.event.ComponentEvent event)
	{
		//maincanvas.setClipRect(maincanvas.getSize());
		//System.out.println("called");
		//pref.setBound(getBounds());
		//FileAnalyzer.fileOutPrefs(pref);
	}	

////////////////////////////////////////////////////////////////////////
/////////////// Adjustment Listner related
////////////////////////////////////////////////////////////////////////
/*
	class SymAdjust implements java.awt.event.AdjustmentListener
	{
		public void adjustmentValueChanged(AdjustmentEvent event) 
		{
						
			Object object = event.getSource();
			if (object == miVAScroll)
				miVAAdjust_Action(event);	
		}
	}	
	public void miVAAdjust_Action(AdjustmentEvent event){
		int val = miVAScroll.getValue();
		maincanvas.setVangle(val);
		maincanvas.repaint();
	}
*/	

	public void changeScroll(int val, int mode){ 
		if(mode == Scrollbar.VERTICAL){
			maincanvas.setVangle(val);
			maincanvas.repaint();
		}
	}
////////////////////////////////////////////////////////
/////////////////my functions...
////////////////////////////////////////////////////////
	
	public void slowerAm(){
		maincanvas.setAnimeTime(LOW_SPEED);
		if(gdx != null) gdx.setAnimeTime(LOW_SPEED);
//System.out.println("slower called");		
		//sleepThread.stop();	
	}
	
	public void resetSleepThread(){
		if(miAmAuto.getState() == false) return;
		if(sleepThread != null){
			sleepThread.resetSleepTime();
			
			maincanvas.setAnimeTime(HIGH_SPEED);
			if(gdx != null) gdx.setAnimeTime(HIGH_SPEED);
//System.out.println("wake up caleed " +(sleepThread.getName())+ " " + (new Date()));			
		}
	}
			
	private void setViewItems(){
		
		// first, clear everything
		datalistflag = false;
		datalist.removeAll();
		datalistflag = true;
		maincanvas.removeAllPoints();
		
		for(int i = 0;i<dirVect.size();i++){
			ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
//System.out.println("rd = "+rd);
			datalist.add("* "+rd.getTitle());
			maincanvas.addPoint(rd.getRaValue(),rd.getDecValue(),rd,false);
		}

		for(int i = 0 ;i < pastData.size();i++){
			ResultData rd = (ResultData)pastData.elementAt(i);
//System.out.println("rd = "+rd);
			maincanvas.addPoint(rd.getRaValue(),rd.getDecValue(),rd,true);
			datalist.add(rd.getTitle());
		}
		if(datalist.getItemCount() > 0){
			selectLatestData();
			//selectedData = maincanvas.getNthRd(0);
		}
		else{
			datalist.add("-------No date yet------");					
		}
		handleDataSelection();
	}// end of readfile		
	
	private void selectLatestData(){
		int index = 0;
		double minval = (double)((new Date()).getTime()); // should be smaller than current time
		for(int i = 0 ;i<dirVect.size();i++){
			ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
			StrDbl sb = rd.getMxVal(GLBX.TITLE[4]);// analysis started
			if(sb.getVal() < minval){
				index = i;
				minval = sb.getVal();
				selectedData = rd;
			}
		}		
		if(selectedData == null){ // need to pick from past data
			if(pastData.size() == 0){
				System.out.println("we are in trouble");
			}
			selectedData = (ResultData)(pastData.elementAt(0));
			index = 0;
		}
		datalist.select(index);
	}

	private void updatePastData(){
		
		pastData.removeAllElements();	
		for(int i = 0;i<pastDataDirVect.size();i++){
			DirData ddt = (DirData)(pastDataDirVect.elementAt(i));
			ddt.clearPastData();
	//System.out.println("dir = "+(ddt.getDir()));		
			if(FileAnalyzer.checkFile(ddt.getDir()) == false){
				continue ;
			}
			
			Vector temp = new Vector();
			FileAnalyzer.readPastFile((ddt.getDir()),temp,(pref.getCurrentTimeZoneID()));
			String colorStr = ddt.getColorName();
			for(int j = temp.size()-1;j >= 0;j--){
				ResultData rdt = (ResultData)(temp.elementAt(j));
				rdt.setFinishedFlag(true);
				rdt.setColorName(colorStr);
				pastData.addElement(rdt);
				ddt.addPastData(rdt);
			}
		}
	}
	
	public void addLatestPastData(ResultData rd){
		rd.setFinishedFlag(true);
		pastData.insertElementAt(rd,0);	
	}
	public void updateData(boolean virginflag){

		boolean pastReadRequiredFlag = lgc.updateCurrentData(dirVect);	
		//if(pastReadRequiredFlag == true) // changed for Ver0.72
		maincanvas.setMessage("Information updated");
		if(mx != null) mx.update(true);// tell maxtrixViewer to update
                                        // dont need to update gdx, since it will be repaint 
                                        // automatically
                                        
		//ptChoice_ItemStateChanged(null);
		handleDataSelection();

			
		if(virginflag){
			updatePastData();	
		}
		
		if(pastReadRequiredFlag || virginflag){
			setViewItems();
			if(mx != null) mx.setData();// matrix viewer also need data change
			if(gdx != null) gdx.setData();//gaussian destributter need to be updated
		}
	}
	

	/////////////
	///// Matrix Viewer - Data table ////////
	/////////////
	public void setMxData(Vector pvect){

		for(int i = pastData.size() -1;i>=0;i--){
			ResultData rd = (ResultData)(pastData.elementAt(i));
			pvect.addElement(rd);	
		}	
		for(int i = 0;i<dirVect.size();i++){
			ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
			pvect.addElement(rd);
		}
	}
	public void clearMx(){
		mx = null;
		pref.setDatatablePref(0);
		FileAnalyzer.fileOutPrefs(pref);			
	}

	public void selectFromOutside(ResultData  rd,boolean flag){// this is sent from MastrixViewer - MxCanvas and
												  // GDViewer
		if(rd == null) return;
		selectedData = rd;
		resetSleepThread();		
		if(flag) 
			handleDataSelection();
		else handleDataSelectionExceptTable();		
	}
	
	////////////////
	/////// GDViewer ///////
	////////////////
	
	
	public void clearGdx(){
		gdx = null;
		pref.setGsdPref(0);
		FileAnalyzer.fileOutPrefs(pref);			
	}

	///////////
	/////////// Cruising 
	///////////
	
	public void cruiseNextData(int n){
//System.out.println("n = "+n);	

		selectedData = null;
		for(int i = 0;i<dirVect.size();i++){
			ResultData rd = ((DirData)(dirVect.elementAt(i))).getProg();
			if(n == i){
				selectedData = rd;
				break;
			}
		}		
		
		if(selectedData == null){
			for(int i = pastData.size() -1;i>=0;i--){
				ResultData rd = (ResultData)(pastData.elementAt(i));
				if(n == i+dirVect.size()){
					selectedData = rd;		
					break;
				}
			}	
		}	
		
		
		if(selectedData == null){
			if(dirVect.size() > 0){
				selectedData = ((DirData)(dirVect.elementAt(0))).getProg();
			}
			else if(pastData.size() > 0){
				selectedData = (ResultData)(pastData.elementAt(0));
			}
			if(acThread != null)
				acThread.setN(0);
		}
		else{
			acThread.setN(n+1);
		}
		
		if(selectedData != null){
			handleDataSelection();
		}
	}
	///////////////////////////////////////////////////////
	/////////
	///////////////////////////////////////////////////////
	
	public ResultData getSelectedData(){
		return selectedData;
	}

}// end of class SETISupport

