//import java.lang.*;
//import java.io.*;
import java.util.Vector;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Locale;
import java.util.TimeZone;
//import java.math.*;
import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.text.DateFormatSymbols;


public class ResultData implements Cloneable{
	String name;
	
	int ra[] = {0,0,0};
	int dec[] = {0,0,0};
	TDPoint tpoint;
	
	int end_ra[] = {0,0,0};
	int end_dec[] = {0,0,0};
	TDPoint end_tpoint;
	
	//double ravalue, decvalue;
	double subband_base=-1.0;
	String bs_power, bs_score;
	String bs_bin,bs_fft_ind, bs_chirp_rate, bs_fft_len;
	String bg_power,bg_score,bg_chisq;
	String bg_sigma, bg_bin, bg_fft_ind, bg_chirp_rate, bg_fft_len;
	String bg_true_mean;

	double bs_power_val, bs_score_val;
	double bs_bin_val,bs_fft_ind_val, bs_chirp_rate_val, bs_fft_len_val;
	double bg_power_val, bg_score_val, bg_chisq_val;
	double bg_sigma_val, bg_bin_val, bg_fft_ind_val, bg_chirp_rate_val, bg_fft_len_val;	
	double bg_true_mean_val;
	double cpu = -1.0;
	double prog = -1.0;

	String time_recorded;         //Tue Apr 06 05:36:30 1999 format
	String time_recorded_yms; // 1999/04/06 05:36:30 format
	Date recordedTime;	

	Date startedTime;
	String startedTimeStr;
	
	Date infoUpdatedTime;

	String dirname;
	String shortname;

	boolean finishedFlag = false;
	boolean selected;
	
	PointData pt;
	PlotData plt;
	String colorname;
			
	String timeZoneID;
	
	MxData md;
	
	Vector bgpot;
	Vector areaData;
	
	////************ start definig functions***************//
	ResultData(){
		tpoint = new TDPoint();
	}
	
	// don't have to care about Date datas.. since they are clonable
	// don't care about String, they cant be overwritten..
	public Object clone(){
	        try
	        {
	            ResultData other = (ResultData) super.clone();
	            
	            ////////// clone which may not be cloed by simlple call
	            
	            if(tpoint != null){
	            	other.setPoint(new TDPoint(tpoint.getRa(), tpoint.getDe()));
	            }
	            else{
	            	other.setPoint(new TDPoint());
	            }

				//////////////////////////
	            if(end_tpoint != null){
	            	other.setEndPoint(new TDPoint(end_tpoint.getRa(), end_tpoint.getDe()));
	            }
	            else{
	            	other.setEndPoint(new TDPoint());
	            }	            
//System.out.println("here");          

				//////////////////////////
				
	            if(bgpot != null){
	            	other.resetBgpot();	            
		            for(int i = 0;i<bgpot.size();i++){
		            	Double db = (Double)(bgpot.elementAt(i));
	//System.out.println("db = " + db + " " + i );	            	
						if(db == null){
		            		other.setBgpot(i,0.0);
						}
						else{
		            		other.setBgpot(i,db.doubleValue());
		            	}
		            }
		        }
//System.out.println("cloned completed");	     

				///////////////////////
				
				if(areaData != null){
					other.resetAreaData();
					for(int i = 0;i<areaData.size();i++){
						TDPoint pt = (TDPoint)(areaData.elementAt(i));
						if(pt == null) continue;
						other.addAreaData(new TDPoint(pt));
					}
				}
					            
	            return other;
	        }
	        catch (CloneNotSupportedException e)
	        {
	            // this shouldn't happen, since we are Cloneable
	            throw new InternalError();
	        }
   
	}
	
	//////////// set and get of basic data/////////////////////////////
	////////////////////////////////////////////////////////////
	
	//***** Name **********//
	public void setName(String str){
		name = new String(str);
	}
	public String getName(){
		if(name != null) return name;
		else return "no_name";
	}

	//***** Position i.e. Ra and dec***************//
	public void setPosData(String str[]){
		_setPosData(str,true);
	}
	public void setEndPosData(String str[]){
		_setPosData(str,false);
		setAreaData(); //by putting here.		
	}
	
	private void _setPosData(String str[],boolean flag){
		for(int i = 0;i<3;i++){
			try{
				if(flag)
					ra[i] = (Integer.valueOf(str[i])).intValue();
				else
					end_ra[i] = (Integer.valueOf(str[i])).intValue();					
			}
			catch(NumberFormatException e){
				if(flag) ra[i] = 0;
				else end_ra[i] = 0;
			}				
			try{
				if(flag)
					dec[i] = (Integer.valueOf(str[i+3])).intValue();
				else
					end_dec[i] = (Integer.valueOf(str[i+3])).intValue();				
			}
			catch(NumberFormatException e){
				if(flag) dec[i] = 0;
				else end_dec[i] = 0;
			}			
		}
		if(flag){
			double ravalue = ra[0] + (ra[1]/60.0) + (ra[2]/3600.0);
			double decvalue = dec[0] + (dec[1]/60.0) + (dec[2] / 3600.0);
			tpoint = new TDPoint(ravalue*Math.PI/12,decvalue*Math.PI/180);
		}
		else{
			double ravalue = end_ra[0] + (end_ra[1]/60.0) + (end_ra[2]/3600.0);
			double decvalue = end_dec[0] + (end_dec[1]/60.0) + (end_dec[2] / 3600.0);
			end_tpoint = new TDPoint(ravalue*Math.PI/12,decvalue*Math.PI/180);		
		}
	}// end of ResultData
	
	///////////////////////
	
	public void setRa(String str){
		setRaDec(str,true,true);
	}
	public void setDec(String str){
		setRaDec(str,false,true);
	}
	public void setEndRa(String str){
		if(end_tpoint == null) end_tpoint = new TDPoint();
		setRaDec(str,true,false);
		setAreaData(); //by putting here.		
	}
	public void setEndDec(String str){
		if(end_tpoint == null) end_tpoint = new TDPoint();	
		setRaDec(str,false,false);
		setAreaData(); //by putting here. 
	}	
	// if flag == true that is ra value, if false it is dec value
	// maynot be elegant, but ,,, I hope it will work
	// if startEndFlag == tue, it is start , false it is end
	private void setRaDec(String str,boolean flag , boolean startEndFlag){
//System.out.println(str + " " + tpoint);		
		int ret[] = {0,0,0};
		double val = 0;
		try{
			val = (Double.valueOf(str)).doubleValue();
		}
		catch(NumberFormatException e){
			val = 0.0;
		}		
		
		if(flag == true){
			if(startEndFlag)
				tpoint.setRa(val*Math.PI/12); 
			else
				end_tpoint.setRa(val*Math.PI/12); 
		}
		else{
			if(startEndFlag)
				tpoint.setDe(val*Math.PI/180);
			else	
				end_tpoint.setDe(val*Math.PI/180);				
		}
		
		///////////////////
		
		ret[0] = (int)val;
		val -= ret[0];
		ret[1] = (int)(val / (1/60.0));
		val -= (ret[1]*(1/60.0));
		ret[2] = (int)(val/(1/3600.0));
		
		for(int i = 0;i<3;i++){
			if(startEndFlag){
				if(flag == true) ra[i] = ret[i];
				else dec[i] = ret[i];
			}
			else{
				if(flag == true) end_ra[i] = ret[i];
				else end_dec[i] = ret[i];			
			}
		}
	}	
	
	private String getPosStr(){
		return _getPosStr(true);
	}
	
	private String getEndPosStr(){
		return _getPosStr(false);
	}
	private String _getPosStr(boolean flag){
		int ra0,ra1,ra2;
		int de0,de1,de2;
		if(flag){
			ra0 = ra[0];  ra1 = ra[1]; ra2 = ra[2];
			de0 = dec[0]; de1 = dec[1]; de2 = dec[2];
		}
		else{
			ra0 = end_ra[0];  ra1 = end_ra[1];  ra2 = end_ra[2];
			de0 = end_dec[0]; de1 = end_dec[1]; de2 = end_dec[2];
		}
		String ret = (Integer.toString(ra0))+"hr "+(Integer.toString(ra1)) + 
			"min "+(Integer.toString(ra2))+"sec RA,";
		if(getDecValue() > 0) ret = ret + "+";
		ret = ret + (Integer.toString(de0))+"deg "+(Integer.toString(de1))+
			"min "+(Integer.toString(de2))+"sec DEC";
		return ret;
	}
	
	//////////////
	public double getRaValue(){return tpoint.getRa();}
	public double getDecValue(){return tpoint.getDe();}
	public double getRaHMS(){return tpoint.getRa()*12/Math.PI;}
	public double getDecDeg(){return tpoint.getDe()*180/Math.PI;}	

	public double getEndRaValue(){
		if(end_tpoint == null) return 0.0;
		else return end_tpoint.getRa();
	}
	public double getEndDecValue(){
		if(end_tpoint == null) return 0.0;
		else return end_tpoint.getDe();
	}
	public double getEndRaHMS(){
		if(end_tpoint == null) return 0.0;
		else return end_tpoint.getRa()*12/Math.PI;
	}
	public double getEndDecDeg(){
		if(end_tpoint == null) return 0.0;
		else return end_tpoint.getDe()*180/Math.PI;
	}		
	///////////////////////
	public TDPoint getPoint(){return tpoint;}	
	public void setPoint(TDPoint _tpoint){tpoint = _tpoint;}
	
	public TDPoint getEndPoint(){return end_tpoint;}
	public void setEndPoint(TDPoint _tpoint){end_tpoint = _tpoint;}	
	
	//***************** suband base **************//
	public void setBand(String str){
		try{
			subband_base =( Double.valueOf(str)).doubleValue();
		}
		catch(NumberFormatException e){
			subband_base = 0.0;
		}		
	}
	
	//*************bs and bg series**************//
	public void setBsPower(String str){
		bs_power = new String(str);
		try{
			bs_power_val = (Double.valueOf(bs_power)).doubleValue();		
		}
		catch(NumberFormatException e){
			bs_power = "ND";
			bs_power_val = 0.0;
		}
	}
	public void setBsScore(String str){
		bs_score = new String(str);
		try{
			bs_score_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bs_score = "ND";
			bs_score_val = 0.0;
		}
	}

	public void setBsBin(String str){
		bs_bin = new String(str);
		try{
			bs_bin_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bs_bin = "ND";
			bs_bin_val = 0.0;
		}
	}	
	
	public void setBsFftInd(String str){
		bs_fft_ind = new String(str);
		try{
			bs_fft_ind_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bs_fft_ind = "ND";
			bs_fft_ind_val = 0.0;
		}
	}
	
	public void setBsChirpRate(String str){
		bs_chirp_rate = new String(str);
		try{
			bs_chirp_rate_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bs_chirp_rate = "ND";
			bs_chirp_rate_val = 0.0;
		}
	}		
	public void setBsFftLen(String str){
		bs_fft_len = new String(str);
		try{
			bs_fft_len_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bs_fft_len = "ND";
			bs_fft_len_val = 0.0;
		}
	}			
	//////////////////////////////// bg series////////
	public void setBgPower(String str){
		bg_power = new String(str);
		try{
			bg_power_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_power = "ND";
			bg_power_val = 0.0;
		}
	}
	
	public double getBgPower(){
		return bg_power_val;
	}
	public void setBgScore(String str){
		bg_score  = new String (str);
		try{
			bg_score_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_score = "ND";
			bg_score_val = 0.0;
		}		
	}
	public void setBgChisq(String str){
		bg_chisq = new String(str);
		try{
			bg_chisq_val = (Double.valueOf(str)).doubleValue();		
		}
		catch(NumberFormatException e){
			bg_chisq = "ND";
			bg_chisq_val = 0.0;
		}							
	}
	public double getBgChisq(){
		return bg_chisq_val;
	}
	public void setBgTrueMean(String str){
		bg_true_mean = new String(str);
		try{
			bg_true_mean_val = (Double.valueOf(str)).doubleValue();		
		}
		catch(NumberFormatException e){
			bg_true_mean = "ND";
			bg_true_mean_val = 0.0;
		}							
	}
	public double getBgTrueMean(){
		return bg_true_mean_val;
	}
	
	public void setBgSigma(String str){
		bg_sigma = new String(str);
		try{
			bg_sigma_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_sigma = "ND";
			bg_sigma_val = 0.0;
		}
	}	
		
	public void setBgBin(String str){
		bg_bin = new String(str);
		try{
			bg_bin_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_bin = "ND";
			bg_bin_val = 0.0;
		}
	}	
	
	public void setBgFftInd(String str){
		bg_fft_ind = new String(str);
		try{
			bg_fft_ind_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_fft_ind = "ND";
			bg_fft_ind_val = 0.0;
		}
	}
	
	public void setBgChirpRate(String str){
		bg_chirp_rate = new String(str);
		try{
			bg_chirp_rate_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_chirp_rate = "ND";
			bg_chirp_rate_val = 0.0;
		}
	}		
	public void setBgFftLen(String str){
		bg_fft_len = new String(str);
		try{
			bg_fft_len_val = (Double.valueOf(str)).doubleValue();				
		}
		catch(NumberFormatException e){
			bg_fft_len = "ND";
			bg_fft_len_val = 0.0;
		}
	}			
	//*************cput time**************//	
	public void setCpu(String str){
		try{
			cpu = (Double.valueOf(str)).doubleValue();
		}
		catch(NumberFormatException e){
			cpu = 0.0;
		}			
	}	
	public String getCpuString(){
		double val = cpu;
		if(val < 0) val = 0.0;
		return ResultData.genHMSString(val);
	}	

	//************** prog ****************//
	public void setProg(String str){
		try{
			prog = (Double.valueOf(str)).doubleValue();
		}
		catch(NumberFormatException e){
			prog = 0.0;
		}		
	}
	public double getProgValue(){return prog;}
	public String getProgString(){
		double val = prog;
		if(val < 0) val = 0.0;
		return (DoubleFormat.toString(val*100, 3)+" %");
	}
	
	//********** time_recorded************//
			
	public void setTimeRecorded(String str){
//System.out.println("str = "+str);		
		if(str == null){
			time_recorded = "ND";
			time_recorded_yms = "ND";
			recordedTime = new Date(0);
			return;
		}

		///////// need to do this weird process for MS VM////////////
		///////// day has to be 01,02 format instead of 1,2,/////////
		
		StringTokenizer st;
		if((str.indexOf("(") == -1)||(str.indexOf(")") == -1)){
			st = new StringTokenizer(str);
		}
		else{
			st = new StringTokenizer(str.substring(1,(str.length()-1)));
		}
		int index  = 0;
		time_recorded = "";
		while(st.hasMoreTokens()){
			String sstr = st.nextToken();
//System.out.println("sstr = "+sstr);			
			if(index == 2){
				int val = 0;
				try{
					val = (Integer.valueOf(sstr)).intValue();
				}
				catch(NumberFormatException e){val = 0;}
//System.out.println("val = "+val);				
				if(val < 10) time_recorded = time_recorded+"0";
			}
			time_recorded = time_recorded + sstr + " " ;					
			index ++;
		}

		SimpleDateFormat iformatter
	     		= new SimpleDateFormat ("EEE MMM dd HH:mm:ss yyyy",new DateFormatSymbols(Locale.US));;//Sun Feb 21 01:22:54 1999
	     	ParsePosition ps = new ParsePosition(0);     				
		recordedTime = iformatter.parse(time_recorded, ps); 	

		if(recordedTime == null){
			iformatter
	     		= new SimpleDateFormat ("yyyy/MM/dd HH:mm:ss",new DateFormatSymbols(Locale.US));;//Sun Feb 21 01:22:54 1999     				
			recordedTime = iformatter.parse(time_recorded, ps); 			
		}
		if(recordedTime == null){
			recordedTime = new Date((long)0);
		}
		SimpleDateFormat outformatter = 
	 		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
	 	time_recorded_yms = outformatter.format(recordedTime);
	}		

	//********* info updated********************//
	public void setInfoUpdated(Date _updatedTime){
		infoUpdatedTime = _updatedTime;
	}
		
	private String getUpdatedStr(){
		SimpleDateFormat outformatter = 
	 		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
	 	outformatter.setTimeZone(TimeZone.getTimeZone(timeZoneID));
	 	return(outformatter.format(infoUpdatedTime)); 		
	}
		
	//********* started time ********************//

	public void setStartedTime(Date _startedTime){
		startedTime = _startedTime;
		//setStartedTimeStr();
	}
	
	public Date getStartedTime(){return startedTime;}

	private void setStartedTimeStr(){// this function is called from setTimeZone
		//if(timeZoneID == null) timeZoneID = "GMT";
		SimpleDateFormat outformatter = 
	 		new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
	 	outformatter.setTimeZone(TimeZone.getTimeZone(timeZoneID));
	 	if(startedTime == null){
	 		startedTimeStr = "ND";
	 	}
	 	else{
//System.out.println(startedTime);	 	
			startedTimeStr = outformatter.format(startedTime);
		}
	}
	
	//******** time zone**********************//
	public void setTimeZone(String _timeZoneID){
		timeZoneID = _timeZoneID;
		setStartedTimeStr();
	}
	//******** dir name*************************//
	public void setDirName(String _dirname){dirname = _dirname;}
	public void setShortName(String _shortname){shortname = _shortname;}
	public String getDirName(){
		return dirname;
	}
	
	//************ finished flag********************//

	public void setFinishedFlag(boolean _flag){
		finishedFlag = _flag;
	}
	public boolean getFinishedFlag(){
		return finishedFlag;
	}

	//************* point data *******************//

	public void setPointData(PointData  _pt){pt = _pt;}
	public PointData getPointData(){return pt;}

	//************* plot data *******************//

	public void setPlotData(PlotData  _pt){plt = _pt;}
	public PlotData getPlotData(){return plt;}
				
	
	//************* color name *******************//
	public void setColorName(String _colorname){
		colorname = _colorname;
		if(pt != null){
			pt.setColor(colorname);
		}
	}
	public String getColorName(){return colorname;}
	

	///************little bit generated data ***********//	
	public String getTitle(){
		return getPosStr();
	}
	public void setMd(MxData _md){
		md = _md;
	}
	public void clearLinkToMx(){
		md = null;	
	}	
	public boolean getVisible(){
		if(md == null) return true;
		return md.getVisible();
	}
	public boolean getSelected(){
		return selected;
	}
	public void setSelected(boolean flag){
		selected = flag;
	}
	public String getRemainCpuString(){
		if(prog == 0) return null;
		double val = (cpu/prog) - cpu;
		if(val < 0.0) val = 0.0;
		int hr = (int)(val / 3600);
		val -= (hr*3600);
		int min = (int)(val / 60);
		val -= (min * 60);
		if(val > 1.0){
			min ++;
			if(min == 60){
				min = 0;
				hr ++;
			}
		}
		String ret = (Integer.toString(hr)) + "hr "+(Integer.toString(min)) + "min";
		return ret;
	}	
	
	///************bgpot generated data ***********//	
	public void setBgpot(int index, double value){
		if(bgpot == null) bgpot = new Vector();
		if(index > (bgpot.size()-1)) bgpot.setSize(index + 1);
		bgpot.setElementAt((new Double(value)),index);
	}
	
	public Vector getBgpot(){
		return bgpot;
	}
	
	private void resetBgpot(){ 
		bgpot = new Vector();
	}
	
	///////// areaData related/////////
	private void resetAreaData(){
		areaData = new Vector();
	}
	private void addAreaData(TDPoint pt){
		areaData.addElement(pt);
	}
	
	public void getAreaData(Vector ct){
		if((areaData == null)||(areaData.size() == 0)){
			setAreaData();
		}
		for(int i = 0;i<areaData.size();i++){
			TDPoint pt = (TDPoint)(areaData.elementAt(i));
//System.out.println("i = " + i + " " + pt.getX() + " " + pt.getY() + " " + pt.getZ());			
			ct.addElement(new TDPoint(pt));
		}
	}
	
	private void setAreaData(){
		areaData = new Vector();
		if((tpoint != null) && (end_tpoint == null)){
			areaData.addElement(new TDPoint(tpoint));
		}
		else if((tpoint != null)&&(end_tpoint != null)){
			TDPoint delta = tpoint.subtract(end_tpoint);
			if(delta.length() == 0.0){
				double angle = (Math.PI/2) - tpoint.getDe()  ;
				delta = new TDPoint(tpoint.getRa(),	angle);
				setAreaPoint(tpoint,delta, areaData);	
							
				angle = tpoint.getRa() + (Math.PI/2);
				if(angle > 2*Math.PI) angle -= 2*Math.PI;
				TDPoint delta0 = new TDPoint(angle,0);	
				setAreaPoint(tpoint,delta0, areaData);	
				
				//TDPoint delta1 = delta.add(delta0);
				//setAreaPoint(tpoint,delta1,areaData);
				
				//TDPoint delta2 = delta.subtract(delta0);
				//setAreaPoint(tpoint,delta2,areaData);
				
				TDPoint pt = (TDPoint)areaData.elementAt(1);
				areaData.setElementAt(areaData.elementAt(2),1);
				areaData.setElementAt(pt,2);			
				
				//pt = (TDPoint)areaData.elementAt(6);
				//areaData.setElementAt(areaData.elementAt(3),6);
				//areaData.setElementAt(pt,3);												
			}
			else{
				setAreaPoint(tpoint,delta, areaData);
				setAreaPoint(end_tpoint,delta,areaData);
				TDPoint pt = (TDPoint)areaData.elementAt(2);
				areaData.setElementAt(areaData.elementAt(3),2);
				areaData.setElementAt(pt,3);
//TDPoint p0 = (TDPoint)(areaData.elementAt(0));
//TDPoint p1 = (TDPoint)(areaData.elementAt(1));
//double ang = p0.getAngle(p1.getRa(), p1.getDe());
//System.out.println("angle = "+ ang * 180 / (Math.PI));				
			}	
		}	
	}
	private void setAreaPoint(TDPoint pt, TDPoint delta, Vector bag){
		double length = pt.length() * Math.tan(GLB.VIEW_ANGLE);
//System.out.println("lenght = "+ length + " " + pt.length() );		
		TDPoint ct = pt.cross(delta);
//System.out.println(ct.getX() + " " + ct.getY() + " " + ct.getZ());		
		ct.changeLength(length);
//System.out.println(ct.getX() + " " + ct.getY() + " " + ct.getZ());	
		TDPoint n1 = ct.add(pt);
		n1.changeLength(1.0);
//System.out.println(n1.getX() + " " + n1.getY() + " " + n1.getZ());					
		bag.addElement(n1);
		
		TDPoint ct2 = delta.cross(pt);
		ct2.changeLength(length);
		TDPoint n2 = ct2.add(pt);
		n2.changeLength(1.0);		
		bag.addElement(n2);
	
	}
	
	public boolean getTop(){
		if((getBgChisq() < 2.0 + (1.5 * getBgPower())) &&
		 (getBgChisq() <= 10.0)&&
		 (getBgPower() > 0.0)) return true;
		else return false;
	}
	
	//////////////////////////////////////
	
	public void clearStateInfo(){
		setCpu("0.0");
		setProg("0.0"); 		
		
		resetBgpot();
		
		setBsPower("0.0");
		setBsScore("0.0");
		setBgPower("0.0");
		setBgScore("0.0");
		setBgChisq("0.0");	
		setBgTrueMean("0.0");
		
		setBgSigma("0.0"); // added after 0.732
		setBgBin("0.0");
		setBgFftInd("0.0");
		setBgChirpRate("0.0");
		setBgFftLen("0.0");		
		//resetAreaData();
	}
	
	
	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////
	//      Data generating functions*************************/////////////	
	//////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////

/// used to generate strings for data text//////////

	public String getDataStr(){
		String ret = "";
		if(name != null) ret = ret + "Name : "+name;
		if(shortname != null){
			ret = ret + " (@ "+shortname+")";
		}
		if((name != null)||(shortname != null)) ret = ret +"\n";
		ret = ret + "From : " + (getPosStr()) + "\n";
		if(time_recorded != null)ret = ret + "Recorded on : " + time_recorded + "\n";
		if(subband_base >= 0)ret = ret + "Base Frequency : " +DoubleFormat.toString((subband_base/1000000000),9) + " GHz\n";
		if(bs_power != null) ret = ret + "Strongest Peak : power " + bs_power;
		if(bs_score !=null) ret = ret + ", score " + bs_score + "\n";
		if(bg_power != null) ret = ret + "Strongest Gaussian : power " +bg_power;
		if(bg_chisq != null) ret = ret + ", fit "+bg_chisq;
		if(bg_score != null) ret = ret + ", score " + bg_score+"\n";
		if(prog >= 0){
			ret = ret + "Overall : "+(getProgString())+" Done";
		}
		if(cpu >= 0){
			ret = ret + " CPU Time : " + getCpuString() + "\n";
		}
		if((cpu > 0)&&(prog > 0)&&(finishedFlag == false)){
			ret = ret + "Estimated remaining CPU Time: "+getRemainCpuString()+ "\n";	
		}
		if(startedTime != null){			
 			ret = ret + "Analysis started : "+ startedTimeStr+" \n";
		}
		if(infoUpdatedTime != null){
 			ret = ret + "Information Updated : "+getUpdatedStr();
		}		
		return ret;
	}	
	
//////////// used to save the data on file//////////////////
	
	public String getFileOutStr(boolean flag){
		String ret = "";
		ret = ret + "name="+getName()+"\r";
		ret = ret + "start_ra=" + (DoubleFormat.toString(getRaHMS(),3)) + "\r";
		ret = ret + "start_dec=" + (DoubleFormat.toString(getDecDeg(),3)) + "\r";
		if(end_tpoint != null){
			if(end_tpoint.isNull() == false){
				ret = ret + "end_ra=" + (DoubleFormat.toString(getEndRaHMS(),3)) + "\r";
				ret = ret + "end_dec=" + (DoubleFormat.toString(getEndDecDeg(),3)) + "\r";
			}	
		}	
		ret = ret + "subband_base=" +subband_base+ "\r";
		ret = ret + "time_recorded=" +"("+ time_recorded +")"+ "\r";
		ret = ret + "bs_power=" + bs_power+"\r";
		ret = ret + "bs_score=" + bs_score + "\r";
		ret = ret + "bs_bin=" + bs_bin + "\r";		
		ret = ret + "bs_fft_ind=" + bs_fft_ind + "\r";	
		ret = ret + "bs_chirp_rate=" + bs_chirp_rate + "\r";		
		ret = ret + "bs_fft_len=" + bs_fft_len + "\r";			
		
		ret = ret + "bg_power=" +bg_power + "\r";
		ret = ret + "bg_chisq="+bg_chisq + "\r";
		ret = ret + "bg_score=" + bg_score+"\r";
		ret = ret + "bg_true_mean="+bg_true_mean+"\r";
		ret = ret + "bg_sigma=" + bg_sigma + "\r";	
		ret = ret + "bg_bin=" + bg_bin + "\r";		
		ret = ret + "bg_fft_ind=" + bg_fft_ind + "\r";	
		ret = ret + "bg_chirp_rate=" + bg_chirp_rate + "\r";		
		ret = ret + "bg_fft_len=" + bg_fft_len + "\r";	
		
		ret = ret + "prog="+(Double.toString(prog))+"\r";
		ret = ret + "cpu=" +(Double.toString(cpu))+"\r";
		if(flag) ret = ret + "DataDirName="+dirname+"\r";

		String dateString = null;
		if(startedTime != null){
			SimpleDateFormat outformatter = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss");
			outformatter.setTimeZone(TimeZone.getTimeZone("GMT"));

 			dateString = outformatter.format(startedTime);
 			ret = ret + "started_time="+dateString+"\r";
 		}
 		
 		if(bgpot != null){
 			for(int i = 0;i<bgpot.size();i++){
 				Double dt = (Double)(bgpot.elementAt(i));
 				if(dt != null){
 					ret = ret + "bg_pot " + i + "="+(dt.toString()) + "\r";
 				}
 			}
 		}
		return ret;
	}	


	////// used to generate FIle out strings..
	
	public void getCSVStr(Vector svect){

		/////unit name
		String namestr = "ND";
		if(name != null){
			namestr = name;	
		}
		svect.addElement(namestr);

		// progress
		double val = prog;
		if(val < 0) val = 0.0;
		svect.addElement(DoubleFormat.toString(val,6));
				
		///////CPU Time
		if(cpu >=0){
			svect.addElement(Double.toString(cpu));
			svect.addElement(getCpuString());
		}
		else{
			svect.addElement("ND");
			svect.addElement("ND");
		}
		
		///////////analysis started
		if(startedTimeStr == null){
			svect.addElement("ND");
		}
		else{
			svect.addElement(startedTimeStr);
		}
 		 		 		
 		/////////////Peak,gaussian	
 		if(bs_power == null) svect.addElement("ND"); else svect.addElement(bs_power);
  		if(bs_score == null) svect.addElement("ND"); else svect.addElement(bs_score);
  		if(bs_chirp_rate == null) svect.addElement("ND"); else svect.addElement(bs_chirp_rate);  		
 		if(bg_power == null) svect.addElement("ND"); else  svect.addElement(bg_power);
 		if(bg_chisq == null) svect.addElement("ND"); else  svect.addElement(bg_chisq);
 		if(bg_score == null) svect.addElement("ND"); else  svect.addElement(bg_score);
  		if(bg_chirp_rate == null) svect.addElement("ND"); else svect.addElement(bg_chirp_rate);  		
		
		//////////////From 			
		svect.addElement(	 DoubleFormat.toString(tpoint.getRa(),3));
		svect.addElement(	DoubleFormat.toString(tpoint.getDe(),3));

		//////////////To
		if(end_tpoint == null){
				svect.addElement("ND");
				svect.addElement("ND");			
		}
		else{
			if(end_tpoint.isNull() == true){
				svect.addElement("ND");
				svect.addElement("ND");		
			}
			else{ 			
				svect.addElement(	 DoubleFormat.toString(end_tpoint.getRa(),3));
				svect.addElement(	DoubleFormat.toString(end_tpoint.getDe(),3));
			}
		}
		////// Recorded on
		if(time_recorded_yms == null){
			svect.addElement("ND");
		}
		else{
			svect.addElement(time_recorded_yms);
		}
		
		////////// Base band
		if(subband_base < 0.0){svect.addElement("ND");}
		else{
			svect.addElement(DoubleFormat.toString(subband_base,2));
		}
	}	

//////////////////////////////////////////////////////////////////
////// This one is used for data table
//////////////////////////////////////////////////////////////////	
//	final static TITLE[] = {"Name","Progress","CPU Time(h:m:s)","Analysis started",
//"Peak Power","Peak Score","Gaussian Power","Gaussian Fit","Gaussian Score",
//"From(RA:DEC)","Recorded (GMT)","Base Freq"};
//////////////////////////////////////////////////////////////////

	public StrDbl getMxVal(String title){
//System.out.println(title);
		if(title.equals(GLBX.TITLE[1])){// name
			return(new StrDbl(name,0.0));
		}
		else if(title.equals(GLBX.TITLE[2])){// progress
			double val = prog;
			if(val < 0) val = 0.0;
			return(new StrDbl(DoubleFormat.toString(val,6),val));
		}
		else if(title.equals(GLBX.TITLE[3])){// CPU Time
			return(new StrDbl(ResultData.cvrToTime(cpu),cpu));
		}
		else if(title.equals(GLBX.TITLE[4])){// analysis started
			if(startedTime == null){
				return new StrDbl("ND",0.0);
			}
			else{
				return new StrDbl(startedTimeStr,startedTime.getTime());
			}
		}
		else if(title.equals(GLBX.TITLE[5])){// Peak pow
			return(new StrDbl(bs_power,bs_power_val));
		}
		else if(title.equals(GLBX.TITLE[6])){// peak score
			return(new StrDbl(bs_score,bs_score_val));
		}
		else if(title.equals(GLBX.TITLE[7])){// peak Drift rate
			return(new StrDbl(bs_chirp_rate,bs_chirp_rate_val));
		}		
		else if(title.equals(GLBX.TITLE[8])){// g pow
			return(new StrDbl(bg_power,bg_power_val));
		}		
		else if(title.equals(GLBX.TITLE[9])){// g fit
			return(new StrDbl(bg_chisq,bg_chisq_val));
		}
		else if(title.equals(GLBX.TITLE[10])){// g score
			return(new StrDbl( bg_score,bg_score_val));
		}
		else if(title.equals(GLBX.TITLE[11])){// g Drift Rate
			return(new StrDbl(bg_chirp_rate,bg_chirp_rate_val));
		}		
		else if(title.equals(GLBX.TITLE[12])){// from ra
			return(new StrDbl(DoubleFormat.toString(getRaHMS(),3),getRaValue()));
		}
		else if(title.equals(GLBX.TITLE[13])){// from de
			return(new StrDbl(DoubleFormat.toString(getDecDeg(),3),getDecValue()));
		}
		else if(title.equals(GLBX.TITLE[14])){// to ra
			if(end_tpoint == null) return new StrDbl("ND",0.0);
			else return(new StrDbl(DoubleFormat.toString(getEndRaHMS(),3),getEndRaValue()));
		}
		else if(title.equals(GLBX.TITLE[15])){// to de
			if(end_tpoint == null) return new StrDbl("ND",0.0);
			else return(new StrDbl(DoubleFormat.toString(getEndDecDeg(),3),getEndDecValue()));
		}		
		else if(title.equals(GLBX.TITLE[16])){// Recorded
			if(time_recorded == null){
				return new StrDbl("ND",0.0);
			}
			else{
				return new StrDbl(time_recorded_yms,recordedTime.getTime());
			}
		}
		else if(title.equals(GLBX.TITLE[17])){// base freq
			String ret = "ND";
			if(subband_base >=0){
				ret = DoubleFormat.toString(subband_base,2);
			}
			return (new StrDbl(ret,subband_base));
		}
		return null;// dummy	
	}// getMxStr


	
	//************* class functions********************/
	public static String genHMSString(double val){
		int hr = (int)(val/3600);
		val -= (hr*3600);
		int min = (int)(val/60);
		val -= (min * 60);
		String ret = "";
		
		ret =  ret  +(Integer.toString(hr)) + " hr "+(Integer.toString(min))+" min "+ (Integer.toString((int)val))+" sec";
		return ret;
	}

	
	public static String cvrToTime(double val){
		if(val < 0) val = 0.0;
		int hr = (int)(val/3600.0);
		val = val - (hr*3600);
		int min = (int)(val/60.0);
		val = val - (min * 60);
		
		String ret = "";
		if(hr < 10) ret = ret + "0";
		ret = ret + Integer.toString(hr)+"h:";
		if(min < 10) ret = ret + "0";
		ret = ret + Integer.toString(min)+"m:";
		if(val < 10) ret = ret + "0";
		ret = ret + Integer.toString((int)val)+"s";
		return ret;	
	}	
}// end of class ResultData