import java.util.Vector;
import java.util.Random;
import java.awt.Point;
import java.awt.Color;

public class PointData {
	Random dice  = new Random(0);

	int currentLevel;
	int maxLevel;
	Vector particles;
	int maxParticleNo = 300;
	ResultData orgData;
	Color cl;
	DPos pos;
	//DPos endpos;
	Vector areaData;
	/////////BW specific variable/////
	Vector rings;
//	int destx;
//	int desty;
//	int count = 0;
	
	public PointData( int firstLevel,int _maxLevel,ResultData _org){

		//selected = false;
		maxLevel = _maxLevel;
		currentLevel = firstLevel;
		particles = new Vector();
		orgData = _org;
		orgData.setPointData(this);
		rings = new Vector();
		cl = Color.yellow;
		pos = new DPos();
		//endpos = new DPos();
	}//end of constructor PointData()
	
	////////////////////////////////////////////
	/////Get and SEt funcitons
	////////////////////////////////////////////
			
	public boolean getFinished(){
		if(orgData == null) return false;
		else return (orgData.getFinishedFlag());
	}
	public boolean getSelected(){
		if(orgData == null) return false;
		else return (orgData.getSelected());
	}
	public void setSelected( boolean flag){
		if(orgData != null){
			orgData.setSelected(flag);
		}
	}
	public int getLevel(){
		return currentLevel;
	}// end of getLevel 
	public void setLevel(int _level){
		currentLevel = _level;
	}
	public void addLevel(){
		currentLevel ++;
		if(currentLevel >= maxLevel) currentLevel = 0;
	}
	public double getProgValue(){
		//return 0.97;
		return orgData.getProgValue();
	}	
	public String getProgString(){
		return orgData.getProgString();
	}
	public String getCpuString(){
		return orgData.getCpuString();
	}	
	public String getRemainCpuString(){
		return orgData.getRemainCpuString();
	}
	public ResultData getOrgData(){return orgData;}
	
	public void setColor(String colorName){
		if(colorName == null) return;
		if(colorName.equals("Yellow")) cl = Color.yellow;
		else if(colorName.equals("LightBlue")) cl= Color.getHSBColor((float)0.5,(float)0.5,(float)1.0);
		else if(colorName.equals("Green")) cl = Color.getHSBColor((float)0.32,(float)0.51,(float)1.0);
		else if(colorName.equals("Magenta")) cl = Color.getHSBColor((float)0.83,(float)0.5,(float)1.0);
		else if(colorName.equals("Orange")) cl = Color.getHSBColor((float)0.073,(float)0.7,(float)1.0);
		else if(colorName.equals("Pink")) cl = Color.pink;
		else if(colorName.equals("Red")) cl = Color.getHSBColor((float)0,(float)0.6,(float)1.0);
		else if(colorName.equals("White")) cl = Color.white;
	}
	public Color getColor(){
		return cl;
	}
	public boolean getVisible(){
		return (orgData.getVisible());
	}	
	public DPos getPoint(){
		pos.setPos(orgData.getPoint());
		return pos;
	}
	public DPos getEndPoint(){
		pos.setPos(orgData.getEndPoint());
		return pos;
	}
	public Vector getBgpot(){
		if(orgData == null) return null;
		else return orgData.getBgpot();
	}
	public double getBgTrueMean(){
		if(orgData == null) return 0.0;
		else return orgData.getBgTrueMean();
	}
	public double getBgPower(){
		if(orgData == null) return 0.0;
		else return orgData.getBgPower();	
	}
	public double getBgChisq(){
		if(orgData == null) return 0.0;
		else return orgData.getBgChisq();	
	}	
	
	public void resetDPoints(){
		pos.resetDPoint();
		if(areaData != null){
			for(int i = 0;i<areaData.size();i++){
				DPos pt = (DPos)(areaData.elementAt(i));
				pt.resetDPoint();
			}
		}
	}
	
	public boolean getTop(){
		if(orgData == null) return false;
		else return orgData.getTop();
	}
	///////////////////////////////////////
	// add particle related functions...
	///////////////////////////////////////
		
	public void addParticle(Point pt, int no, int dist, int mindist){
		int totalno = particles.size() + no;
		for(int i = 0;i<totalno - maxParticleNo;i++){
			particles.removeElement((ParticleData)(particles.elementAt(0)));
		}
		for(int i =0;i<no;i++) particles.addElement(genParticle(pt,dist,mindist));
	}

	private ParticleData genParticle(Point pt, int dist,int mindist){
		int length = (int)(dice.nextDouble()*dist) + dist;
		double phai = (dice.nextDouble()) * 2 * 3.1416;
	
/*System.out.println(x+" "+y+" "+dx+" " + dy + " ");*/
		return (new ParticleData(pt.x,pt.y,mindist,length,phai));
	}

	public Vector getPtVect(){
		Vector deadlist = new Vector();
		for(int i = 0;i<particles.size();i++){
			ParticleData pt = (ParticleData)(particles.elementAt(i));
			pt.act();
//System.out.println(particles.size());
			if(pt.getLifeValue() < 0.1 ){
				deadlist.addElement(pt);
			}
		}
		for(int i = 0;i<deadlist.size();i++){
			particles.removeElement((ParticleData)(deadlist.elementAt(i)));
		}
		return particles;
	}
	
	public void getAreaData(Vector ct){
		if(areaData == null){
			areaData = new Vector();
			Vector bg = new Vector();
			orgData.getAreaData(bg);
			for(int i = 0;i<bg.size();i++){
				TDPoint pt = (TDPoint)(bg.elementAt(i));
				areaData.addElement(new DPos(pt));
			}
		}
		for(int i = 0;i<areaData.size();i++){
			DPos pt = (DPos)(areaData.elementAt(i));
			ct.addElement(pt);
		}
	}
	////////////BW Specific methods....//////////////////
	double brtable[] = {1.0,0.9,0.8,0.7,0.45,0.4,0.3,0.2,0.2,0.1};
		
	public boolean hasLingP(){
		if(rings.size() == 0) return false; 
		else return true;
	}
	public void initRings(){
		for(int i =0;i<maxLevel;i++){
//			rings.addElement( new SRing(maxLevel+(i*2),7,brtable[i])); 
			rings.addElement( new SRing(7,brtable[i])); 
		}
	//	initDest();
	}
	public Vector getRings(){ return rings;}

	public void rotate(){
		for(int i =0;i<rings.size();i++){
			SRing sr = (SRing)(rings.elementAt(i));
			sr.rotate(13-i);
		}		
	}

}// end of class PointData