import java.util.Vector;
import java.util.Random;
import java.awt.Point;
import java.awt.Color;

public class PlotData{

	int currentLevel;
	int maxLevel;
	ResultData orgData;
	Point pt;
	Color cl;

	public PlotData( int firstLevel,int _maxLevel,ResultData _org){
		maxLevel = _maxLevel;
		currentLevel = firstLevel;
		orgData = _org;
		orgData.setPlotData(this);
		cl = Color.yellow;
	}//end of constructor PointData()
	
	////////////////////////////////////////////
	/////Get and SEt funcitons
	////////////////////////////////////////////
			
	public boolean getFinished(){
		if(orgData == null) return false;
		else return (orgData.getFinishedFlag());
	}
	public boolean getSelected(){
		if(orgData == null) return false;	
		return (orgData.getSelected());
	}
	public boolean getTop(){
		if(orgData == null) return false;
		else return orgData.getTop();
	}

	
	//public void setSelected( boolean flag){selected = flag;}
	public int getLevel(){
		return currentLevel;
	}// end of getLevel 
	public void setLevel(int _level){
		currentLevel = _level;
	}
	public void addLevel(){
		currentLevel ++;
		if(currentLevel >= maxLevel) currentLevel = 0;
	}
	public double getProgValue(){
		//return 0.97;
		return orgData.getProgValue();
	}	
	public String getProgString(){
		return orgData.getProgString();
	}
	public String getCpuString(){
		return orgData.getCpuString();
	}	
	public String getRemainCpuString(){
		return orgData.getRemainCpuString();
	}
	public ResultData getOrgData(){return orgData;}
	
	public void setColor(String colorName){
		if(colorName == null) return;
		if(colorName.equals("Yellow")) cl = Color.yellow;
		else if(colorName.equals("LightBlue")) cl= Color.getHSBColor((float)0.5,(float)0.5,(float)1.0);
		else if(colorName.equals("Green")) cl = Color.getHSBColor((float)0.32,(float)0.51,(float)1.0);
		else if(colorName.equals("Magenta")) cl = Color.getHSBColor((float)0.83,(float)0.5,(float)1.0);
		else if(colorName.equals("Orange")) cl = Color.getHSBColor((float)0.073,(float)0.7,(float)1.0);
		else if(colorName.equals("Pink")) cl = Color.pink;
		else if(colorName.equals("Red")) cl = Color.getHSBColor((float)0,(float)0.6,(float)1.0);
		else if(colorName.equals("White")) cl = Color.white;
	}
	public Color getColor(){
		return cl;
	}
	public boolean getVisible(){
		return (orgData.getVisible());
	}	
	public TDPoint getPoint(){
		return orgData.getPoint();
	}
	public Vector getBgpot(){
		if(orgData == null) return null;
		else return orgData.getBgpot();
	}
	public double getBgTrueMean(){
		if(orgData == null) return 0.0;
		else return orgData.getBgTrueMean();
	}
	public double getBgPower(){
		if(orgData == null) return 0.0;
		else return orgData.getBgPower();	
	}
	public double getBgChisq(){
		if(orgData == null) return 0.0;
		else return orgData.getBgChisq();	
	}	
	public void setPt(Point _pt){ pt = _pt;}
	public Point getPt(){return pt;}		

}// end of class PointData