import java.awt.*;

class MyLayout extends Object implements LayoutManager {
	private Component c1;
	private Component c2;
	private Component c3;

	public void addLayoutComponent(String name, Component comp){
		if(name.equals("Center")){
			c1 = comp;
		}else if(name.equals("East")){
			c2 = comp;
		}else if(name.equals("South")){
			c3 = comp;
 		}
	}

	public void removeLayoutComponent(Component comp){
		if(c2 == comp) c2 = null;
		else if(c3 == comp) c3 = null;
	}

	public Dimension preferredLayoutSize(Container parent){
		return new Dimension(100,100);
	}

	public Dimension minimumLayoutSize(Container parent){
		return new Dimension(0,0);
	}

	public void layoutContainer(Container parent){
		int c2width = 0;

		if(c2 == null) c2width = 0;
		else  c2width = c2.getPreferredSize().width;

		
		int c3height =  0;
		
		if(c3 == null) c3height = 0;
		else c3height = c3.getPreferredSize().height;

		c1.setBounds(0,0,	parent.getSize().width-c2width,
    							parent.getSize().height-c3height);
    		  
    		 if(c2 != null){
			 c2.setBounds(parent.getSize().width-c2width,0,
     		 					c2width,parent.getSize().height-c3height);
     		 }
     		 
     		 if(c3 != null){
			c3.setBounds(0,parent.getSize().height-c3height,
							parent.getSize().width-c2width, c3height);
		}
 	 }
}