
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Polygon;

public class MyClipper{

    static final int C_LEFT = 0;
    static final int C_RIGHT = 1;
    static final int C_TOP = 2;
    static final int C_BOTTOM = 3;
    
	Dimension dim;
	
	MyClipper(){
		dim = new Dimension();
	}
	
	public boolean clipPoint(Point pt){
		if(pt == null) return false;
		if((pt.x < 0)||(pt.x > dim.width)||(pt.y<0)||(pt.y>dim.height)){
			return false;
		}
		else{
			return true;
		}
	}
	public void setClipRange(Dimension d){
		dim = d;
	}
	
	public Rectangle lineclip(Point p1, Point p2){
		Rectangle ret = new Rectangle(p1.x, p1.y, p2.x, p2.y);
		ret = clipByLine(ret, 0, C_LEFT);
		ret = clipByLine(ret, dim.width, C_RIGHT);
		ret = clipByLine(ret, 0, C_TOP);
		ret = clipByLine(ret, dim.height, C_BOTTOM);
		return ret;
	}
	
    private Rectangle clipByLine(Rectangle rec, int val, int edge) {
    	boolean inside;
 		Point cross;

		int x0 = rec.x;
		int y0 = rec.y;
		int x1 = rec.width;
		int y1 = rec.height;
		Polygon newPoly = new Polygon();
		
		inside = insideArea(x0, y0, val, edge);

		if (insideArea(x1,y1, val, edge)) {
			if (inside) {
				newPoly.addPoint(x0,y0);
				newPoly.addPoint(x1,y1);
			}
			else {
				cross = getCrossing(x0, y0, x1, y1, val, edge);
      			newPoly.addPoint(cross.x, cross.y);
      			newPoly.addPoint(x1, y1);
  			}
     	}
     	else {
			if (inside) {
				cross = getCrossing(x0, y0, x1, y1, val, edge);
				newPoly.addPoint(cross.x, cross.y);
				newPoly.addPoint(x0,y0);
			}
		}
		Rectangle ret = new Rectangle();
		ret.x = newPoly.xpoints[0]; ret.y = newPoly.ypoints[0];
		ret.width = newPoly.xpoints[1]; ret.height = newPoly.ypoints[1];
		return ret;
 }


	
    private boolean insideArea(int x, int y, int val, int edge) {
 		switch (edge) {
			case C_LEFT:
	     		if (x >= val) {
	 			 return true;
	    	 }
	    	 break;
			 case C_RIGHT:
	   			  if (x <= val) {
				  return true;
	 	    }
	    	break;
	 		case C_TOP:
	    		 if (y >= val) {
				 return true;
	     	}
	   		break;
	 		case C_BOTTOM:
	     		if (y <= val) {
	  				return true;
	     	}
	     	break;
		}
 		return false;
    }


	private Point getCrossing(int x1, int y1, int x2, int y2, int val, int edge) {
		Point cross = new Point(0, 0);

		switch (edge) {
			case C_LEFT:
			case C_RIGHT:
				cross.x = val;
				cross.y = ((y1-y2)*val+(x1*y2-x2*y1))/(x1-x2);
			break;
			case C_TOP:
			case C_BOTTOM:
				cross.x = ((x1-x2)*val-(x1*y2-x2*y1))/(y1-y2);
				cross.y = val;
			break;
		}
		 return cross;
    }	
}