import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.Font;
import java.awt.Image;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

import java.util.Vector;
import java.util.StringTokenizer;

//import java.net.*;

public class MtxCanvas extends Canvas {
	MatrixViewer boss;

	Vector datavect;
	Vector titlevect;
	MxPrefValue pref;
	
	Image offscreen = null;
	Dimension offscreensize;
	Graphics offgraphics;   
				
    	FontMetrics fm;      // fontmetrics for font
    	FontMetrics boldfm; // fontmetrics for bold    	
	Font font;             // font used to display char
	Font boldfont;             // font used to display char
	int charHeight;    // height of the char used
     	int charDescent;    // descent of the char
     	int charLeading;     //leading of the char
     	int charAscent; // ascent of the char
     	int arrowWidth;
     	 TitleData selectedTd;
     	boolean sortRequiredFlag;
     	boolean cutOffRequiredFlag;
     	int lineHeight;
     	int arrowindex = -1;
     	
     	int tindex = 1;
     	int dindex = 1;
     	int maxTIndex = 0;
     	int maxDIndex = 0;
     	int tvisible = 0;
     	int dvisible = 0;
     	
     	int hgap = 4;
     	int vgap = 2;
     	
     	boolean vfinishflag  = true;
     	boolean hfinishflag = true;
 	
     	
	public MtxCanvas(MatrixViewer _boss,MxPrefValue _pref){
		super();
		sortRequiredFlag = true;
		cutOffRequiredFlag = true;
		pref = _pref;
		boss = _boss;
		//sortData = new Vector();
		Vector temp_titlevect = new Vector();
		for(int i =0;i<GLBX.TITLE.length+1;i++) temp_titlevect.addElement(null);
		temp_titlevect.setElementAt((new TitleData(GLBX.NO_TITLE)),0);
		
		Vector titlename= new Vector();
		pref.getTitleVect(titlename);
				
		Vector cvect = pref.getCondVect();		
				
		for(int i = 0;i<GLBX.TITLE.length;i++){

			TitleData ntd = new TitleData(GLBX.TITLE[i]);
			boolean addedFlag  = false;
			
			for(int j= 0;j<titlename.size();j++){
				String tstr = (String)(titlename.elementAt(j));
				boolean visibleFlag = true;
				if(tstr.charAt(0) == '*'){
					visibleFlag = false;
					tstr = tstr.substring(1);
				}
//System.out.println((ntd.getTitle())+ " " + visibleFlag);				
				if(tstr.equals(ntd.getTitle())){
					temp_titlevect.setElementAt(ntd,j);
					
					ntd.setVisible(visibleFlag);					
					addedFlag = true;
					break;
				}
			}			
			if(addedFlag == false) temp_titlevect.addElement(ntd);
			
			for(int j = 0;j<cvect.size();j++){
				String str = (String)(cvect.elementAt(j));
	//System.out.println(str);
				StringTokenizer st = new StringTokenizer(str,"$");
				String tstr = st.nextToken();
//System.out.println(tstr+(ntd.getTitle()));				
				if(tstr.equals(ntd.getTitle())){
					ntd.setCutCond(new CutCond(st.nextToken()));	
				}	
			}			
		}				

		titlevect = new Vector();

		for(int i = 0;i<temp_titlevect.size();i++){
			TitleData td = (TitleData)(temp_titlevect.elementAt(i));
			if(td != null) titlevect.addElement(td);
		}

		
		datavect = new Vector();
		
		tindex = 0;
		dindex = 0;
		
		setFont(10);

	
		//{{REGISTER_LISTENERS
		SymMouse aSymMouse = new SymMouse();
		this.addMouseListener(aSymMouse);
		SymComponent aSymComponent = new SymComponent();
		this.addComponentListener(aSymComponent);
		//}}
	}


	
	public  void setFont(int fontSize)
	{
	      String[] fontNames = Toolkit.getDefaultToolkit().getFontList();
	      font = new Font(fontNames[1], Font.PLAIN, fontSize);	// used be 0
	      boldfont = new Font(fontNames[1],Font.BOLD,fontSize);// used be 0
	      fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
	      boldfm = Toolkit.getDefaultToolkit().getFontMetrics(boldfont);
        	charHeight = fm.getHeight();// + 3;
		charDescent = fm.getDescent();
		charAscent = fm.getAscent();
		charLeading = fm.getLeading();
		arrowWidth = charHeight/2;
		lineHeight = charHeight + (2*vgap);		
    }
    
	public void setData(Vector _datavect){
		datavect.removeAllElements();
	
		for(int i = 0;i<_datavect.size();i++){
			ResultData rd = (ResultData)(_datavect.elementAt(i));
			if(rd.getFinishedFlag()){
				datavect.addElement(new MxData(i+1,(Integer.toString(i+1)), rd));
			}
			else{
				datavect.addElement(new MxData(i+1,("*"+Integer.toString(i+1)),rd));
			}
			//sortData.addElement(new Integer(i));	
     			sortRequiredFlag = true;
			cutOffRequiredFlag = true;	
		}
		
	}
	
	public void update(Graphics g){
		paint(g);
	}
	public void paint(Graphics g)
	{
//System.out.println("paing alled");		
		Dimension d = getSize();
		

		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());

		}

		cutOffData();				
		sortData();
		handleCutOff();
		
		offgraphics.setColor(getBackground());
		offgraphics.fillRect(0, 0, d.width, d.height);
		
		paintData(offgraphics);
		g.drawImage(offscreen, 0, 0, null);
		
		setMaxTDIndex();
		
		boss.resetScrollBar(tindex,tvisible,1,maxTIndex,dindex,dvisible,0,maxDIndex);		
	}
	
	private void handleCutOff(){
		TitleData td  = (TitleData)(titlevect.elementAt(0));
		if(td.hasCutCond() == false) return;
				
		int cutOffNo = (int)(td.getCutCond()).getVal();;
		int count = 0;
		for(int i = 0;i<datavect.size();i++){
			MxData md = (MxData)(datavect.elementAt(i));
			if(md.getVisible() == false) continue;
			else count ++;
			if(count > cutOffNo) md.setVisible(false);
		}
	}
	private int findThOfTd(TitleData _td){
		int index = 0;
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == false) continue;
			if(td == _td) return index;
			index ++;
		}
		return 0;
	}
	
	private int findThOfMd(MxData _md){
		int index = 0;
		for(int i = 0;i<datavect.size();i++){
			MxData md = (MxData)(datavect.elementAt(i));
			if(md.getVisible() == false) continue;
			if(md == _md) return index;
			index ++;
		}
		return 0;
	}	
	private void setMaxTDIndex(){
		int dwidth = (getSize()).width;
		
		int width =( (TitleData)(titlevect.elementAt(0))).getWidth();// No column is always addes		

		TitleData oldtd = null;
		for(int i = titlevect.size()-1;i>=0;i--){
			TitleData td = (TitleData)(titlevect.elementAt(i));	
			if(td.getVisible() == false) continue;

			width += td.getWidth();
			if(width > dwidth){
				if(oldtd == null) oldtd = td;
				break;
			}	
			oldtd = td;	
		}
		maxTIndex = findThOfTd(oldtd);
//System.out.println("maxt name = "+(oldtd.getTitle()));
		
		int height = lineHeight;	
		MxData oldmd = null;
		for(int i = datavect.size()-1;i >= 0;i--){
			MxData md = (MxData)(datavect.elementAt(i));
			if(md.getVisible() == false) continue;

			height += lineHeight;
			if(height >  (getSize()).height){
				if(oldmd == null) oldmd = md;
				break;
			}	
			oldmd = md;
		}
		maxDIndex = findThOfMd(oldmd);
//System.out.println("max td = "+maxTIndex + " " + maxDIndex);		
	}	
	


	private void paintData(Graphics g){
		
		vfinishflag = true;
		hfinishflag = true;
		
		g.setFont(font);
		int x = 0;

		int dwidth = (getSize()).width;
		int dheight = (getSize()).height;
				
		boolean colorflag = true;
		boolean drawflag = true;
		
		tvisible = 0;
		dvisible = 0;
		
		int vtindex = 0;
		for(int i = 0;i<titlevect.size();i++){
						
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == false) continue;
			vtindex ++;		
			if(((vtindex-1) < tindex)&&(i != 0)) continue;

			tvisible ++;
			int maxw = 0;
			int width = 0;
			boolean noflag = GLBX.NO_TITLE.equals(td.getTitle());
			int count = 0;	
			int y = charLeading+charAscent+vgap;// initial y for every column
			for(int  j = 0;j<datavect.size()+1;j++){

				String str = "";			

				if(j == 0){ // title row		
					str = td.getTitle();
					if(td.hasCutCond()) str = "["+str+"]";

					width = fm.stringWidth(str);
					if((td.getTitle()).equals(pref.getSortTitle()) == true) width += (arrowWidth*2);

					g.setColor(Color.darkGray);		
					
					if((i == 0)&&drawflag){
						g.fillRect(0,y -charAscent - charLeading-vgap,dwidth,lineHeight);		
						g.setColor(Color.darkGray);
						g.drawLine(0,y+charDescent+vgap-1,dwidth,y+charDescent+vgap-1);								
					}	
					g.setColor(Color.pink);	
					g.drawString(str,x+hgap,y);					
					if((td.getTitle()).equals(pref.getSortTitle()) == true){
						paintSortArrow(g,str,x,y);
					}												
				}
				else{// other rows...
					MxData rd = (MxData)(datavect.elementAt(j-1));
					if(rd.getVisible() == false) continue;
					count ++;
					if((count-1) < dindex) continue;// this line should be here to count up
					if(noflag){// first column
						str = (new Integer(count)).toString();

						if(rd.getFinishedFlag() == false ){
							//g.setColor(Color.cyan);
							double ph = (1-(rd.getProgValue()))/2;
							//ph = 0.5;
							g.setColor(Color.getHSBColor((float)ph,(float)0.5,(float)1.0));							
						}
						else if(colorflag){
							g.setColor(Color.lightGray);		
							colorflag = false;							
						}
						else{
							g.setColor(Color.white);
							colorflag = true;
						}		
						if(drawflag){
							g.fillRect(0,y -charAscent - charLeading-vgap,dwidth,lineHeight);		
							if(rd.getSelected()){
								g.setColor(Color.black);
								g.fillRect(0,y -charAscent - charLeading-vgap,2,lineHeight);
								g.fillRect(0,y+1,dwidth,charDescent+vgap -1);	
							}
							g.setColor(Color.darkGray);
							g.drawLine(0,y+charDescent+vgap-1,dwidth,y+charDescent+vgap-1);	
																							
						}
						dvisible ++;						
					}
					else{       // other data columns
						str = rd.getMxStr(td.getTitle());
						if((str == null)||(str.equals("null"))) {str = "ND";}
					}
					width = fm.stringWidth(str);
					if(drawflag){	
						g.setColor(Color.black);	
						g.drawString(str,x+hgap,y);

					}										
				}	
				if(width > maxw) maxw = width;					
				if(y > dheight){
					y += lineHeight;// this looks awkward, but need this to draw last ine
					vfinishflag = false;
					break;
				}	
				y = y +lineHeight;	
			}// end of for j loop
			
			td.setRect(x,0,maxw + hgap*2,lineHeight);				
			x = x + maxw + hgap*2;
			if(x > dwidth){
				drawflag = false;
				hfinishflag = false;
				continue;
			}
			g.setColor(Color.white);
			g.drawLine(x,0,x,lineHeight);
			g.setColor(Color.darkGray);
			g.drawLine(x,lineHeight,x,y+charDescent+vgap-lineHeight-1);
			if(i == 0){
				g.setColor(Color.white);
				g.drawLine(x-2,0,x-2,lineHeight);
				g.setColor(Color.darkGray);
				g.drawLine(x-2,lineHeight,x-2,y+charDescent+vgap-lineHeight-1);				
			}

		}	// end of for title loop
		
	}


	private void paintSortArrow(Graphics g,String str,int x , int y){
		int arx = x + hgap + fm.stringWidth(str)+arrowWidth;
		int aryu = y - charAscent;
		int aryd = y ;
		
		g.setColor(Color.yellow);
		//Polygon rect = new Polygon();
		g.drawLine(arx,aryu,arx,aryd);
//System.out.println(arx+" " +aryu + " " + aryd);

		if(pref.getSortMode() == GLBX.DES){
			g.drawLine(arx - arrowWidth/2, aryu + arrowWidth,arx,aryu);
			g.drawLine(arx + arrowWidth/2, aryu + arrowWidth,arx,aryu);
		}
		else if(pref.getSortMode() == GLBX.ASC){
			g.drawLine(arx - arrowWidth/2, aryd - arrowWidth,arx,aryd);
			g.drawLine(arx + arrowWidth/2, aryd - arrowWidth,arx,aryd);			
		}
		//g.fillPolygon(rect);		
	}
	


	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mousePressed(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == MtxCanvas.this)
				MtxCanvas_MouseClicked(event);
		}
	}

	void MtxCanvas_MouseClicked(java.awt.event.MouseEvent event)
	{
		Point ept = event.getPoint();		

		boolean flag = false;
		for(int i = 0;i<titlevect.size();i++){
			if((i < tindex)&&(i != 0)) continue;
			
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == false) continue;
			if(td.contains(ept) == true){
				//System.out.println(td.getTitle());
				selectedTd = td;
				boss.popupmenu(ept,td);
				flag = true;
				break;
			}
		}		
		if(flag == false){// select data
			int y = ept.y;
			y -= lineHeight;
			int count = 0;
			for(int i = 0;i<datavect.size();i++){
				MxData md = (MxData)(datavect.elementAt(i));
				if(md.getVisible() == false) continue;
				count ++;
				if((count-1) < dindex) continue;				
				y -= lineHeight;		
//System.out.println("i = "+i + " y = "+y);				
				if(y < 0){
					boss.selectFromMx(md);	
					repaint();
					break;
				}	
			}
		}
	}
	
	public void listHiddenTitle(Vector vect){
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == false) vect.addElement(td);
		}
	}	

	public void hideCurrentTitle(){
		if(selectedTd == null) return;
		selectedTd.setVisible(false);
	//	pref.addHiddenTitle(selectedTd.getTitle());
		setMaxTDIndex();
		repaint();
		fileOutPref();
	}
	
	public void showTitle(String _title){
		if(_title == null) return;
		for(int i = 0;i<titlevect.size();i++){			
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == true) continue;
//System.out.println(_title + " " + td.getTitle());			
			if(_title.equals(td.getTitle()) == true){
				td.setVisible(true);
				//pref.delHiddenTitle(td.getTitle());
				break;				
			}
		}
		setMaxTDIndex();		
		repaint();
		fileOutPref();
	}
	public void miSortData(int mode){
		if(selectedTd == null) return; // should not happen
		pref.setSortTitle(selectedTd.getTitle());
		pref.setSortMode(mode);
		sortRequiredFlag = true;
		repaint();
		fileOutPref();
	}
	private void cutOffData(){
		if(cutOffRequiredFlag == false) return;
		clearCutOff();
		for(int i =1;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.hasCutCond() == false) continue;
			if((td.getTitle()).equals(GLBX.NO_TITLE)) continue; // dont care No column
			
			for(int j =0;j<datavect.size();j++){
				MxData mdt = (MxData)(datavect.elementAt(j));
   				double val = mdt.getMxVal(td.getTitle());
   				if(td.applyCond(val) == false){
   					mdt.setVisible(false);
   				}				
			}
		}		
		cutOffRequiredFlag = false;
	}
	
	private void clearCutOff(){
		for(int i =0;i<datavect.size();i++){
			MxData mdt = (MxData)(datavect.elementAt(i));
			mdt.setVisible(true);			
		}			
	}

	public void setCondition(CutCond _cond){
		if(_cond == null) return;
		if(selectedTd == null) return;
		selectedTd.setCutCond(_cond);

		fileOutPref();
		cutOffRequiredFlag = true;
		repaint();
	}
	
	public void delCondition(){
		if(selectedTd == null)  return;
		selectedTd.setCutCond(null);

		fileOutPref();
		cutOffRequiredFlag = true;
		repaint();
	}
	public void disableAllConditions(){
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			td.setCutCondState(false);		
		}		
		fileOutPref();
		cutOffRequiredFlag = true;		
		repaint();	
	}	
	private void sortData(){// this is called from inside paint
		if(sortRequiredFlag == false) return;
		if(pref.getSortTitle() == null) return;

		
		genSortData(findTitleData(pref.getSortTitle()),pref.getSortMode());
//System.out.println("sorted");		
		sortRequiredFlag = false;
	}
	public void setCutCondState(boolean flag){
		if(selectedTd == null) return;
		selectedTd.setCutCondState(flag);
		
		fileOutPref();
		cutOffRequiredFlag = true;
		repaint();			
	}
	private TitleData findTitleData(String name){
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
//System.out.println(td.getTitle() + " " + name);			
			if(td.getTitle().equals(name)) return td;
		}
		System.out.println("in MtxCanvas.findTitleData, no match found for "+name);		
		return null;
	}
	

	private void genSortData(TitleData td, int mode){
//System.out.println("sorting..");
		String title = td.getTitle();
		for(int i = 0;i<datavect.size();i++){

   			double val = ((MxData)(datavect.elementAt(i))).getMxVal(title);
			int index = i;
			 for(int j = i+1;j<datavect.size();j++){
				double cval = ((MxData)(datavect.elementAt(j))).getMxVal(title);
				if(compare(cval,val,mode) == false){
					val = cval;				
					index = j;
				}
			}
			Object t = datavect.elementAt(i);
			datavect.setElementAt(datavect.elementAt(index),i);
			datavect.setElementAt(t,index);
		}
//System.out.println("sort finished");		
	}
	
	boolean compare(double val1, double val2,int mode){
		boolean retvalue = false;
		if(mode == GLBX.ASC){
			 if(val1 >= val2) retvalue = true;
			else retvalue = false;
		}
  		else if(mode == GLBX.DES){
			if(val1 <= val2) retvalue = true;
			else retvalue = false;
		}
//System.out.println(val1 + " " +val2 + " " + retvalue+" " + mode);
		return retvalue;
	 }	
	 
	 public void setSortRequiredFlag(boolean flag){
	 	sortRequiredFlag = flag;
	 }
	 
	 public void setBoundPref(Rectangle rect){
	 	pref.setBound(rect);
	 }
	 
	 public void fileOutPref(){
		pref.clearCutCond();
		pref.clearTitle();
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			CutCond tcd = td.getCutCond();
			String str = td.getTitle();
			if(td.getVisible() == false) str = "*"+str;
			pref.addTitle(str);
			if(tcd != null)
				pref.addCutCond(td.getTitle(),td.getCutCond());
		}
		FileAnalyzer.fileOutMxPrefs(pref);		
	 }
	 public MxPrefValue getPref(){return pref;}

	public void setTIndex(int val){
		tindex = val;
//System.out.println("tindex = "+val);		
		repaint();
	}
	public void setDIndex(int val){
		dindex = val;
		repaint();
	}	 
	

	class SymComponent extends java.awt.event.ComponentAdapter
	{
		public void componentResized(java.awt.event.ComponentEvent event)
		{
			Object object = event.getSource();
			if (object == MtxCanvas.this)
				MtxCanvas_ComponentResized(event);
		}
	}

	void MtxCanvas_ComponentResized(java.awt.event.ComponentEvent event)
	{
		fileOutPref();
	}
	

	
	public void exportCSVFile(String fileName,int mode){
		Vector tvect = new Vector();
		Vector cvect = new Vector();
		
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td.getVisible() == false) continue;
			tvect.addElement(td.getTitle());			
		}
		cvect.addElement(tvect);
		
		int count = 0;
		for(int i =0;i<datavect.size();i++){
			MxData md = (MxData)(datavect.elementAt(i));
			if(md.getVisible() == false) continue;
			Vector svect = new Vector();
			count ++;
			for(int j = 0;j<tvect.size();j++){
				String tstr = (String)(tvect.elementAt(j));
				if(tstr.equals(GLBX.NO_TITLE)){
					svect.addElement(Integer.toString(count));
				}
				else{
					String sstr = md.getMxStr(tstr);
					if(sstr == null) sstr = "ND";
					svect.addElement(sstr);
				}
			}	
			cvect.addElement(svect);
		}	
		FileAnalyzer.exportCSVFile(fileName,cvect,mode);
	}
	
	public TitleData getSelectedTd(){return selectedTd;}
	
	public void setToSelectedData(){
		int count = 0;
		for(int i = 0;i<datavect.size();i++){
			MxData md = (MxData)(datavect.elementAt(i));
			if(md.getVisible() == false) continue;

			if(md.getSelected() == true){
					dindex = count;
					break;
			}
			count ++;			
		}
	}
	
	public void moveTitle(int direction){
		if(selectedTd == null) return; // should not happen
		int index = -1;
		for(int i = 0;i<titlevect.size();i++){
			TitleData td = (TitleData)(titlevect.elementAt(i));
			if(td == selectedTd){
				index = i;
				break;
			}
		}	
		if(index < 0) return;// should not happen again.
		
		int nindex = index;
		if(direction == GLBX.T_RIGHT){
//System.out.println(index + " " + (titlevect.size() - 1));
			do{			
				if(nindex == (titlevect.size() - 1)) return; // no more
				nindex ++;
			}while(((TitleData)(titlevect.elementAt(nindex))).getVisible() == false);
		}
		else if(direction == GLBX.T_LEFT){
			if(index == 0) return; // no less
			
			do{
				if(nindex -1 == 0) return; // cant replace no column
				nindex --;
			}while(((TitleData)(titlevect.elementAt(nindex))).getVisible() == false);
		}	
		titlevect.removeElement(selectedTd);		
		titlevect.insertElementAt(selectedTd,nindex);
		repaint();
		fileOutPref();
	}
	public boolean titleMoveEligible(int direction){
		if(selectedTd == null) return true;
		int index = -1;
		for(int i = 0;i<titlevect.size();i++){
			if(selectedTd == (TitleData)(titlevect.elementAt(i))){
				index = i;
				break;
			}	
		}
		if(index == -1) return true;// this should not happen
		int count = 0;
		
		if(direction == GLBX.T_LEFT){
			for(int i = 0;i<index;i++){
				TitleData td = (TitleData)(titlevect.elementAt(i));
				if(td.getVisible()) count ++;
			}
//System.out.println("l count = "+count);
			if(count <=1) return false;
			else return true;
		}
		else{// T_RIGHT
			for(int i = index+1;i<titlevect.size();i++){
				TitleData td = (TitleData)(titlevect.elementAt(i));
				if(td.getVisible()) count ++;
			}
//System.out.println("r count = "+count);
			if(count == 0) return false;
			else return true;			
		}
	}
	public boolean getHFinishFlag(){
		return (hfinishflag&&(tindex <= 1));
	}
	public boolean getVFinishFlag(){
		return (vfinishflag&&(dindex == 0));
	}
	public void clearData(){
		for(int i = 0;i<datavect.size();i++){
			MxData md = (MxData)(datavect.elementAt(i));
			md.clearLinkToRd();
		}	
	}
}// end of SkyCanvas