import java.awt.Point;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Dimension;
import java.awt.Component;
import java.awt.Toolkit;

import java.awt.event.WindowEvent;
//import java.io.*;
import java.util.Vector;
import java.util.StringTokenizer;
//import java.text.*;
import java.awt.event.AdjustmentListener;

public class MatrixViewer extends Frame implements ScrollBoss
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	SETISupport boss;
	MtxCanvas maincanvas;
	
	java.awt.MenuBar mainMenuBar;
	java.awt.Menu menu1;
	java.awt.MenuItem miExportCSV;
	java.awt.MenuItem miExportTAB;
	java.awt.MenuItem miExportHTM;	
	java.awt.MenuItem miExit;
	java.awt.MenuItem miAllCondOff;
	java.awt.MenuItem miHide;
	java.awt.MenuItem miSortAsc;
	java.awt.MenuItem miSortDes;
	java.awt.MenuItem miTitleRight;
	java.awt.MenuItem miTitleLeft;	
	java.awt.MenuItem miCutOff;
	java.awt.MenuItem miEditCond;
	java.awt.PopupMenu pmenu;
	java.awt.Menu show_sub;
	java.awt.FileDialog exportFileDialog;
	CondInputDialog cdipDialog;
	
	
	GScroll  hbar;
	GScroll vbar;
	//ResultData progData;
	boolean startUpFlag = true;
	MxPrefValue pref;
	
	public MatrixViewer(SETISupport _boss)
	{
		pref = FileAnalyzer.readMxPrefs();
		
		boss = _boss;

				
		initLayout();	// pref will be passed to maincanvs in this function
		
		setData();

		//maincanvas.genDefaultSortData();
		//maincanvas.update((maincanvas.getGraphics()));
	
		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymComponent aSymComponent = new SymComponent();
		this.addComponentListener(aSymComponent);
		//}}
	}
	
	public void setData(){
		Vector datavect = new Vector();
		boss.setMxData(datavect);
		maincanvas.setData(datavect);
	}
	
	public void initLayout()
	{

		setTitle("SETI@Support Data Table");
		Rectangle dm = pref.getBound();
		int wwidth = dm.width;
		int wheight = dm.height;		
		setLocation(dm.x,dm.y);	
						
		setLayout(new BorderLayout(0,0));
		//setLayout(new MyLayout());
		setVisible(false);
		setSize(wwidth,wheight);	
		//setBackground(Color.black);

		
		maincanvas = new MtxCanvas(this,pref);

		//ScrollPane spane = new ScrollPane();
		add("Center",maincanvas);
		//maincanvas.setBackground(Color.black);
		//spane.add(maincanvas);

		hbar  = new GScroll(this , Scrollbar.HORIZONTAL);
		hbar.setUnitIncrement(1);

		vbar = new GScroll(this, Scrollbar.VERTICAL);
		vbar.setUnitIncrement(1);

						
		add("East",vbar);
		add("South",hbar);
		
		// init menues
		mainMenuBar = new java.awt.MenuBar();
		menu1 = new java.awt.Menu("File");
		
		Menu export_sub = new java.awt.Menu("Export  FIle..",true);
		miExportCSV = new java.awt.MenuItem("CSV");
		export_sub.add(miExportCSV);
		miExportTAB = new java.awt.MenuItem("Tab separator");
		export_sub.add(miExportTAB);		
		miExportHTM = new java.awt.MenuItem("HTML");
		export_sub.add(miExportHTM);			
		menu1.add(export_sub);
				
		menu1.addSeparator();
		miExit = new java.awt.MenuItem("Close");
		menu1.add(miExit);

		java.awt.Menu menu2 = new java.awt.Menu("Setting");
		show_sub = new java.awt.Menu("Show..");		
		menu2.add(show_sub);		
		updateShowMenu();
		miAllCondOff = new java.awt.MenuItem("Turn All Condition off");	
		menu2.add(miAllCondOff);			

		mainMenuBar.add(menu1);
		mainMenuBar.add(menu2);		
		setMenuBar(mainMenuBar);
						
		pmenu = new java.awt.PopupMenu();	
	

		miHide = new java.awt.MenuItem("Hide");
		miSortAsc = new java.awt.MenuItem("Sort Asc");
		miSortDes = new java.awt.MenuItem("Sort Des");
		miTitleRight = new java.awt.MenuItem("Move Title Right");
		miTitleLeft = new java.awt.MenuItem("Move Title Left");		
		miCutOff  = new java.awt.MenuItem(GLBX.NO_COND_STR);
		miEditCond = new java.awt.MenuItem("Edit Condition..");


		pmenu.add(miHide);
		pmenu.add(miTitleRight);
		pmenu.add(miTitleLeft);
		pmenu.add(miSortAsc);
		pmenu.add(miSortDes);
	
		pmenu.add(miEditCond);
		pmenu.add(miCutOff);
		
		maincanvas.add(pmenu);
			
		SymAction lSymAction = new SymAction();

		miExit.addActionListener(lSymAction);
		miAllCondOff.addActionListener(lSymAction);		
		miHide.addActionListener(lSymAction);
		miSortAsc.addActionListener(lSymAction);
		miSortDes.addActionListener(lSymAction);
		miTitleRight.addActionListener(lSymAction);	
		miTitleLeft.addActionListener(lSymAction);			
		miExportCSV.addActionListener(lSymAction);		
		miExportTAB.addActionListener(lSymAction);	
		miExportHTM.addActionListener(lSymAction);	
		miCutOff.addActionListener(lSymAction);					
		miEditCond.addActionListener(lSymAction);			
		
		exportFileDialog = new java.awt.FileDialog(this,"Please specify file name",FileDialog.SAVE);
		
		//SymItem lSymItem = new SymItem();
		//miCutOff.addItemListener(lSymItem);
		
		//SymAdjust lSymAdjust = new SymAdjust();
		//hbar.addAdjustmentListener(lSymAdjust);
		//vbar.addAdjustmentListener(lSymAdjust);
	}

	
    public void setVisible(boolean b)
	{
		if(b)
		{
			//setLocation(50, 50);
		}	
		super.setVisible(b);
	}
	
	/*static public void main(String args[])
	{
		(new MatrixViewer()).setVisible(true);
	}*/
	
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
/////////////
// call back related functions
/////////////


	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{						
			Object object = event.getSource();
			if (object == miExit)
				 MatrixViewer_WindowClosing(null);
			else if(object == miHide)
				miHide_Action(event);
			else if(object == miAllCondOff){
				miAllCondOff_Action(event);
			}
			else if(object == miSortAsc)
				miSort_Action(event,GLBX.ASC);
			else if(object == miSortDes)
				miSort_Action(event,GLBX.DES);	
			else if(object == miTitleRight)
				miTitleMove_Action(GLBX.T_RIGHT);
			else if(object == miTitleLeft)
				miTitleMove_Action(GLBX.T_LEFT);										
			else if(object == miExportCSV)
				miExport_Action(GLB.CSV);
			else if(object == miExportTAB)
				miExport_Action(GLB.TAB);	
			else if(object == miExportHTM)
				miExport_Action(GLB.HTM);								
			else if(object == miEditCond)
				miEditCond_Action(event);
			else if(object == miCutOff)
				miCutOff_Action(event);
			else{
				for(int i = 0;i<show_sub.getItemCount();i++){
					MenuItem mt = show_sub.getItem(i);
					if(object == mt){
						miShow_Action(mt);
					}	
				}	
			}							
		}
	}
	
	void miEditCond_Action(java.awt.event.ActionEvent event){
		TitleData selectedTd = maincanvas.getSelectedTd();
		String condstr = (miCutOff.getLabel());
		if(getCutOffState()) condstr = condstr.substring(1);
		
		//if(miCutOff.getState() == false)
			//condstr = GLBX.NO_COND_STR;
		if((selectedTd.getTitle()).equals(GLBX.NO_TITLE)){
			cdipDialog = new CondInputDialog(this,"Input Condition",condstr,(getCutOffState()),false);
		}
		else{
			cdipDialog = new CondInputDialog(this,"Input Condition",condstr,(getCutOffState()),true);
		}

		Dimension d = getSize();
		cdipDialog.setLocation(d.width/3,d.height/3);		
		cdipDialog.show();
	}
	private void miCutOff_Action(java.awt.event.ActionEvent event){
		boolean flag = getCutOffState();
		boolean nflag ;
		
		if(flag) nflag = false;
		else nflag = true;
		
		setCutOffState(nflag);

		maincanvas.setCutCondState(nflag);
	}
	
	private boolean getCutOffState(){
		String str = miCutOff.getLabel();
		if(str.charAt(0) == '*') return true;
		else return false;	
	}
	private void setCutOffState(boolean flag){
		boolean cflag = getCutOffState();
		if(flag == cflag) return;
		String str = miCutOff.getLabel();
		if(flag == true)
			str = "*"+str;
		else 
			str = str.substring(1);
//System.out.println("new labe = "+str);
		miCutOff.setLabel(str);
	}
	void setCondition(int relindex, String valstr,boolean val){
		maincanvas.setCondition(new CutCond(relindex,valstr,val));
	}
	
	void delCondition(){
		maincanvas.delCondition();
	}
	void miShow_Action(MenuItem mt){
		maincanvas.showTitle(mt.getLabel());
		updateShowMenu();
	}
	
	void miAllCondOff_Action(java.awt.event.ActionEvent event){
		maincanvas.disableAllConditions();
	}	
	
	void miExit_Action(java.awt.event.ActionEvent event)
	{
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));

	}

	void miHide_Action(java.awt.event.ActionEvent event){
		maincanvas.hideCurrentTitle();	
		updateShowMenu();
	}
	void miSort_Action(java.awt.event.ActionEvent event,int mode){
		maincanvas.miSortData(mode);	
	}	
	void miTitleMove_Action(int direction){
		maincanvas.moveTitle(direction);	
	}
	void miExport_Action(int mode)
	{

		int		defMode			= exportFileDialog.getMode();
		String	defTitle		= exportFileDialog.getTitle();
		String defDirectory	= exportFileDialog.getDirectory();
		String defFile			="";
		if(mode == GLB.CSV) defFile = "tst_data.csv";
		else if(mode == GLB.TAB) defFile = "tst_data.txt";
		else if(mode == GLB.HTM) defFile = "tst_data.htm";

		exportFileDialog = new java.awt.FileDialog(this, defTitle, defMode);
		exportFileDialog.setDirectory(defDirectory);
		exportFileDialog.setFile(defFile);
		exportFileDialog.show();
//System.out.println("htere");		
		String dirName =  (exportFileDialog.getDirectory());
		String fileName = (exportFileDialog.getFile());
		
		if((dirName == null)||(fileName == null)) return;
		else{
			maincanvas.exportCSVFile(dirName+fileName,mode);
		}
	}		
	
	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
			//Object object = event.getSource();
			//if (object == miCutOff)
				//miCutOff_ItemStateChanged(event);
		}// end of itemStateChanged
	}

	
	private void updateShowMenu(){
		
		//////// take care of "Show" menu item
		Vector hvect = new Vector();
		maincanvas.listHiddenTitle(hvect);
		
		show_sub.removeAll();
		SymAction lSymAction = new SymAction();

		for(int i = 0;i<hvect.size();i++){
			TitleData htd = (TitleData)(hvect.elementAt(i));
			java.awt.MenuItem mit = new java.awt.MenuItem(htd.getTitle());
			mit.addActionListener(lSymAction);	
			show_sub.add(mit);				
		}
		
	}
	
	public void popupmenu(Point pos,TitleData td){
		
		pmenu.removeAll();
		String title = td.getTitle();

		

		////////take care of sort menu...
		if((title.equals(GLBX.TITLE[1]) == false)&&(title.equals(GLBX.NO_TITLE) == false)){
			pmenu.add(miSortDes);			
			pmenu.add(miSortAsc);
			pmenu.addSeparator();		
		}
		
		/////// take care of "Hide" menu item.
		if(title.equals(GLBX.NO_TITLE) == false){
			pmenu.add(miHide);
			miHide.setLabel("Hide '"+(td.getTitle())+"'");
		}
		//////// take care of move meu				
		if(title.equals(GLBX.NO_TITLE) == false){
			if(maincanvas.titleMoveEligible(GLBX.T_RIGHT)) pmenu.add(miTitleRight);
			if(maincanvas.titleMoveEligible(GLBX.T_LEFT)) pmenu.add(miTitleLeft);
		}
				


		/////// take care of condition menu item.
		if((title.equals(GLBX.TITLE[0]))||(title.equals(GLBX.TITLE[2]))||
		      (title.equals(GLBX.TITLE[5]))||(title.equals(GLBX.TITLE[6]))||
		      (title.equals(GLBX.TITLE[7]))||(title.equals(GLBX.TITLE[8]))||
		      (title.equals(GLBX.TITLE[9]))||(title.equals(GLBX.TITLE[10]))||
		      (title.equals(GLBX.TITLE[11]))||(title.equals(GLBX.NO_TITLE))){

			if(pmenu.getItemCount() > 0) pmenu.addSeparator();
		      	
			CutCond cond = td.getCutCond();
			if(cond == null){
				miEditCond.setLabel("Add condition..");
				//pmenu.remove(miCutOff);
			}
			else{
				miEditCond.setLabel("Edit condition..");
				String str = cond.getStr();
				
				// need these procedure to avoid "true" at the end...
				StringTokenizer st  = new StringTokenizer(str);
				String labelstr = (st.nextToken())+" " + (st.nextToken())+" " + (st.nextToken());
				miCutOff.setLabel(labelstr);
				setCutOffState(cond.getState());
				pmenu.add(miCutOff);
			}
			pmenu.add(miEditCond);
			//miEditCond.setEnabled(true);
		}
		//else{
			//pmenu.remove(miEditCond);
			//pmenu.remove(miCutOff);
			//miEditCond.setLabel("Add conditoin..");
			//miEditCond.setEnabled(false);
		//}
			
		pmenu.show(maincanvas,pos.x, pos.y);
	}		


	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowDeactivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == MatrixViewer.this)
				MatrixViewer_WindowDeactivated(event);
		}

		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == MatrixViewer.this)
				MatrixViewer_WindowClosing(event);
		}
	}

	void MatrixViewer_WindowClosing(java.awt.event.WindowEvent event)
	{
		maincanvas.setBoundPref(getBounds());
		maincanvas.fileOutPref();

		maincanvas.clearData();
		
		setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		boss.clearMx();
		
		//System.exit(0);		// close the application
	}
	
	//////////////implements ScrollBoss
	public void changeScroll(int val, int mode){
		if(mode == Scrollbar.HORIZONTAL){
			maincanvas.setTIndex(val);
		}
		else{
			maincanvas.setDIndex(val);
		}
	}
	
/*	class SymAdjust implements java.awt.event.AdjustmentListener
	{
		public void adjustmentValueChanged(java.awt.event.AdjustmentEvent event)
		{
			Object object = event.getSource();
			if (object == hbar)
				MatrixViewer_Scroll(Scrollbar.HORIZONTAL,event.getAdjustmentType());
			else if(object == vbar)
				MatrixViewer_Scroll(Scrollbar.VERTICAL , event.getAdjustmentType());
		}
	}	
	
	void MatrixViewer_Scroll(int mode, int adjustmentType){
		int moveindex = 0;// nobody
		if((adjustmentType == AdjustmentEvent.UNIT_INCREMENT)&&(mode == Scrollbar.HORIZONTAL))
			 moveindex =GLBX.RIGHT_SLOW;
		else if((adjustmentType == AdjustmentEvent.BLOCK_INCREMENT)&&(mode == Scrollbar.HORIZONTAL))
			moveindex = GLBX.RIGHT_FAST;
		else if((adjustmentType == AdjustmentEvent.UNIT_DECREMENT)&&(mode == Scrollbar.HORIZONTAL))
			moveindex = GLBX.LEFT_SLOW;
		else if((adjustmentType == AdjustmentEvent.BLOCK_DECREMENT)&&(mode == Scrollbar.HORIZONTAL))
			moveindex =GLBX.LEFT_SLOW;	
		if((adjustmentType == AdjustmentEvent.UNIT_INCREMENT)&&(mode == Scrollbar.VERTICAL))
			 moveindex =GLBX.DOWN_SLOW;
		else if((adjustmentType == AdjustmentEvent.BLOCK_INCREMENT)&&(mode == Scrollbar.VERTICAL))
			moveindex = GLBX.DOWN_FAST;
		else if((adjustmentType == AdjustmentEvent.UNIT_DECREMENT)&&(mode == Scrollbar.VERTICAL))
			moveindex =GLBX.UP_SLOW;
		else if((adjustmentType == AdjustmentEvent.BLOCK_DECREMENT)&&(mode == Scrollbar.VERTICAL))
			moveindex = GLBX.UP_SLOW;				
				
		maincanvas.chgScroll(moveindex);
		
	}
*/

	public void update(boolean flag){
		if(flag) maincanvas.setSortRequiredFlag(true);
		maincanvas.repaint();	
	}

	public void updateWithScroll(){// this is sent from SETISupport. orogin is SKyCanvas
		maincanvas.setToSelectedData();
		maincanvas.repaint();
	}
	void MatrixViewer_WindowDeactivated(java.awt.event.WindowEvent event)
	{
		boss.SETISupport_WindowDeactivated(null);
	}
	public void selectFromMx(MxData md){
		boss.selectFromOutside(md.getRd(),false);	
	}
	public void resetScrollBar(int tindex,int tvisible,int minTIndex,int maxTIndex,
							     int dindex,int dvisible,int minDIndex,int maxDIndex){
		if(maincanvas.getHFinishFlag()){
			remove(hbar);
		}
		else{
			add("South",hbar);
			hbar.setValues(tindex,tvisible,minTIndex,maxTIndex);		
		}
//System.out.println("main " + maincanvas.getVFinishFlag());		
		if(maincanvas.getVFinishFlag()){
			remove(vbar);
		}
		else{
//System.out.println(vbar.getPreferredSize());			
			add("East",vbar);
		//	int visible = Math.min(dvisible*10,((maxDIndex - minDIndex)*10-5));
			vbar.setValues(dindex,dvisible,minDIndex,maxDIndex);
		}
		validate();
		doLayout();
	}

	class SymComponent extends java.awt.event.ComponentAdapter
	{
		public void componentShown(java.awt.event.ComponentEvent event)
		{
			Object object = event.getSource();
			if (object == MatrixViewer.this)
				MatrixViewer_ComponentShown(event);
		}
	}

	void MatrixViewer_ComponentShown(java.awt.event.ComponentEvent event)
	{
		if(startUpFlag){
			startUpFlag = false;
			Rectangle dm = pref.getBound();
			if((dm.width != 0)&&(dm.height != 0)){
				setSize(new Dimension(dm.width,dm.height));
				setLocation(dm.x, dm.y);
			}
			else{
				setLocation(80,80);
				setSize(new Dimension(600,200));
			}
		}
	}
}// end of class SETISupport

