import java.awt.Dialog;
import java.awt.Button;
import java.awt.Panel;
import java.awt.Label;
import java.awt.TextField;
import java.awt.TextArea;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Component;
import java.awt.Point;
//import java.awt.event.*;
//import java.io.*;
import java.util.Vector;
//import java.text.*;


public class ListDialog extends Dialog
{
	java.awt.List datalist;
	java.awt.Button okButton;
	java.awt.Button cancelButton;
	java.awt.Button addButton;
	java.awt.Button deleteButton;
	java.awt.Button changeNameButton;
	java.awt.Panel sidePanel;
	java.awt.Label strlabel;
	java.awt.TextField inputtext;
	java.awt.Button acceptButton;
	java.awt.TextArea dataText;
	java.awt.Choice colorChoice;
		
	SETISupport boss;
	Vector cvect = new Vector();
	DirData selectedItem;
	int dispmode;

public ListDialog(Frame parent, String title, int mode)
{
		super(parent, title);
		boss = (SETISupport) parent;
		
		int width = 450;
		int height = 0;
		if(mode == GLB.EDITOR){
			height = 180;
		}
		else if(mode == GLB.USER_INFO){
			height = 220;
		}
		else if(mode == GLB.PAST_DATA){
			height = 180;
			width = 500;
		}
		//setBackground(Color.black);
		//setForeground(Color.pink);
		setLayout(new BorderLayout(0,0));
		setSize(width,height);
		setBackground(Color.black);
		
		datalist = new java.awt.List(4,false);
		datalist.setBackground(Color.black);
		datalist.setForeground(Color.cyan);
		datalist.setSize((int)(width),(int)(height*0.3));
		if((mode == GLB.EDITOR)||(mode == GLB.PAST_DATA)){
			add("Center", datalist);
		}
		else if(mode == GLB.USER_INFO){
			add("North", datalist);
		}
		
		java.awt.Panel lowerPanel = new java.awt.Panel();
		lowerPanel.setLayout(new BorderLayout(0,0));
		lowerPanel.setBackground(Color.black);	
		add("South",lowerPanel);
		
		if((mode == GLB.EDITOR)||(mode == GLB.PAST_DATA)){
			java.awt.Panel lupanel = new java.awt.Panel();
			lupanel.setBackground(Color.black);	
			lupanel.setLayout(new FlowLayout(FlowLayout.LEFT));
			lowerPanel.add("North",lupanel);
		
			strlabel  = new java.awt.Label("Input Short Name");
			lupanel.add(strlabel);
			strlabel.setVisible(false);
			strlabel.setForeground(Color.pink);
			strlabel.setBackground(Color.black);
			
			inputtext = new java.awt.TextField(8);
			lupanel.add(inputtext);
			inputtext.setVisible(false);
			inputtext.setForeground(Color.pink);
			inputtext.setBackground(Color.black);
			
			acceptButton = new java.awt.Button("Accept");
			acceptButton.setBackground(Color.white);
			acceptButton.setForeground(Color.black);
			lupanel.add(acceptButton);
			acceptButton.setVisible(false);
//System.out.println("am here");			
			if(mode == GLB.PAST_DATA){
				colorChoice = new java.awt.Choice();
				colorChoice.setBackground(Color.white);
				colorChoice.setForeground(Color.black);				
				lowerPanel.add("Center",colorChoice);
				colorChoice.add("Yellow");
				colorChoice.add("LightBlue");
				colorChoice.add("Green");
				//colorChoice.add("Magenta");
				colorChoice.add("Orange");
				colorChoice.add("Pink");
				colorChoice.add("Red");
				colorChoice.add("White");			
			}
		}
		else{
			dataText = new java.awt.TextArea();
			dataText.setSize((int)(width),(int)(height*0.7));
			dataText.setBackground(Color.black);
			dataText.setForeground(Color.pink);
			add("Center", dataText);			
		}
		
		sidePanel = new java.awt.Panel();
		sidePanel.setLayout(new FlowLayout(FlowLayout.LEFT,3,3));
		sidePanel.setForeground(Color.black);
		lowerPanel.add("South",sidePanel);
		
		addButton = new Button("Add..");	
		addButton.setBackground(Color.white);
		addButton.setForeground(Color.black);		
		deleteButton = new Button("Delete");	
		deleteButton.setForeground(Color.black);		
		deleteButton.setBackground(Color.white);	
		
		changeNameButton = new Button("Change Name..");	
		changeNameButton.setForeground(Color.black);		
		changeNameButton.setBackground(Color.white);		
		
		cancelButton = new Button("Cancel");	
		cancelButton.setForeground(Color.black);		
		cancelButton.setBackground(Color.white);	
				
		okButton = new Button("OK");	
		okButton.setForeground(Color.black);		
		okButton.setBackground(Color.white);			

		if((mode == GLB.EDITOR)||(mode == GLB.PAST_DATA)){
			sidePanel.add(addButton);
			sidePanel.add(deleteButton);
			sidePanel.add(changeNameButton);
		}

		sidePanel.add(okButton);
		
		if((mode == GLB.EDITOR)||(mode == GLB.PAST_DATA)){
			sidePanel.add(cancelButton);
		}

		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);

		if((mode == GLB.EDITOR)||(mode == GLB.PAST_DATA)){
			cancelButton.addActionListener(lSymAction);
			addButton.addActionListener(lSymAction);
			deleteButton.addActionListener(lSymAction);
			changeNameButton.addActionListener(lSymAction);
			acceptButton.addActionListener(lSymAction);
		}
		
		SymItem lSymItem = new SymItem();
		datalist.addItemListener(lSymItem);	
		if(mode == GLB.PAST_DATA){
			colorChoice.addItemListener(lSymItem);
		}
		
		adjustButton();
		
		validate();
		doLayout();		

}
	// Add a constructor for Interactions (ignoring modal)
	public ListDialog(Frame parent, Vector _cvect,String title, int mode)
	{
		this(parent,title,mode);
		dispmode = mode;

		for(int i = 0;i<_cvect.size();i++){
			DirData cdata = (DirData)((DirData)(_cvect.elementAt(i))).clone();
			cvect.addElement(cdata);
		}
		setDataList();

	}

	private void setDataList(){
		selectedItem = null;
		datalist.removeAll();
		int selectedIndex = 0;
		for(int i = 0;i<cvect.size();i++){
			DirData ddata = (DirData)cvect.elementAt(i);
			datalist.add(ddata.getShortName() + " : " + ddata.getDir());
			ResultData rdata = ddata.getProg();
			if(rdata != null){
				if(rdata.getSelected() == true) selectedIndex = i;
			}
		}
		adjustButton();	
		if(dispmode== GLB.USER_INFO){
			if(datalist.getItemCount()  > 0){
				datalist.select(selectedIndex);
			}
			ptChoice_ItemStateChanged(null);
		}
	}
	
	public void addNotify()
	{
	    // Record the size of the window prior to calling parents addNotify.
	    Dimension d = getSize();
	    
		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
    // Used for addNotify check.
	boolean fComponentsAdjusted = false;

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ListDialog.this)
				InputDialog_WindowClosing(event);
		}
	}

	void InputDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_Clicked(event);
			else if (object == addButton)
				addButton_Clicked(event);
			else if (object == deleteButton)
				deleteButton_Clicked(event);
			else if (object == changeNameButton)
				changeNameButton_Clicked(event);
			else if (object == cancelButton)
				cancelButton_Clicked(event);
			else if (object == acceptButton)
				acceptButton_Clicked(event);
		}
	}

	void okButton_Clicked(java.awt.event.ActionEvent event)
	{
		if(dispmode == GLB.EDITOR){
			boss.updateDirData(cvect);
		}
		else if(dispmode == GLB.PAST_DATA){
			boss.updatePastDirData(cvect);	
		}
              dispose();
	}
	
	void addButton_Clicked(java.awt.event.ActionEvent event)
	{
		DirData ndata = null;
		if(dispmode == GLB.EDITOR){
			ndata = boss.miOpen_Action(null,cvect);
		}
		else if(dispmode == GLB.PAST_DATA){
			ndata = boss.miOpen_Action(null,cvect,false);
		}
		if(ndata == null) return;
		cvect.addElement(ndata);
		setDataList();
	}
	void deleteButton_Clicked(java.awt.event.ActionEvent event)
	{
		if(selectedItem == null) return;
		if(dispmode == GLB.PAST_DATA){
			if(datalist.getSelectedIndex() == 0) return; // cant delete default past data	
		}
		cvect.removeElement(selectedItem);
		setDataList();
	}
	void acceptButton_Clicked(java.awt.event.ActionEvent event)
	{
		String str = inputtext.getText();
		
		boolean flag = true;	
		
		for(int i = 0;i<str.length();i++){
			if(Character.isWhitespace(str.charAt(i)) == true){
				flag = false;
				break;
			}
		}

		for(int i = 0;i<cvect.size();i++){
			DirData ddata = (DirData)(cvect.elementAt(i));
			if(ddata == selectedItem) continue;
			if(str.equals(ddata.getShortName()) == true){
				flag = false;
				break;
			}
		}
		if(flag){
			selectedItem.setShortName(str);
		}
		strlabel.setVisible(false);
		inputtext.setVisible(false);
		acceptButton.setVisible(false);
		validate();
		doLayout();
		setDataList();
	}
	void changeNameButton_Clicked(java.awt.event.ActionEvent event)
	{
		strlabel.setVisible(true);
		inputtext.setVisible(true);
		acceptButton.setVisible(true);
		
		inputtext.setText(selectedItem.getShortName());
		inputtext.selectAll();
		validate();
		doLayout();
	}
	void cancelButton_Clicked(java.awt.event.ActionEvent event)
	{
                dispose();
	}	
	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
			Object object = event.getSource();
			if (object == datalist)
				ptChoice_ItemStateChanged(event);
			else if(object == colorChoice)
				colorChoice_ItemStateChanged(event);
		}// end of itemStateChanged
	}
	void colorChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
//System.out.println("called");
		if(selectedItem == null) return;
		String colorStr = colorChoice.getSelectedItem();		
		selectedItem.setColorName( colorStr);
	}
	
	void ptChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{	
		//DirData selectedItem;
		
		int selindex = datalist.getSelectedIndex();
		if(selindex >=0){
			selectedItem = (DirData)cvect.elementAt(selindex);
//System.out.println(selectedItem.getShortName());
		}
		else{

			selectedItem = null;
		}
		if((dispmode == GLB.EDITOR)||(dispmode == GLB.PAST_DATA)){
			adjustButton();
			if(dispmode == GLB.PAST_DATA){
				if(selectedItem != null){
//System.out.println("s "+selectedItem.getColorName());
					colorChoice.select(selectedItem.getColorName());	
				}	
			}
		}
		else if(dispmode == GLB.USER_INFO){
			if(selectedItem != null){
				dataText.setText(FileAnalyzer.getUserString(selectedItem.getDir()));	
			}		
		}
	}	
	
	private void adjustButton()
	{
		//System.out.println("coming");
		if(selectedItem == null){
			deleteButton.setEnabled(false);
			changeNameButton.setEnabled(false);
		}
		else{

			changeNameButton.setEnabled(true);	
			if((dispmode == GLB.PAST_DATA)&&(datalist.getSelectedIndex() == 0)){
				deleteButton.setEnabled(false);
			}
			else{
				deleteButton.setEnabled(true);
			}		
		}	

	}
}// end of class
