//import java.awt.*;
//import java.awt.event.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import java.util.StringTokenizer;
//import java.text.*;

public class KFileAnalyzer{

	static public void readPTData(Vector ptvect,Object boss){

		try{
			String filename = "SS_STAR5.TXT";
			BufferedReader ds = null;
			
			if((new File(filename)).exists() == true){
				ds = new BufferedReader(new FileReader(filename));			
			}		
			else{
				InputStream inURL = (boss.getClass()).getResourceAsStream(filename);	
				ds = new BufferedReader(new InputStreamReader(inURL));	
			}
			
			if(ds == null) return;
	
			String line;
	
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				if(line.equals("--")) break;
				StringTokenizer st = new StringTokenizer(line);
				StarData pt = new StarData(st.nextToken(),st.nextToken(),st.nextToken());
				ptvect.addElement(pt);
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
	}// end of readDirData

	static public void readCstData(Vector cstvect,Object boss){

		try{
			String filename = "SS_CST_DATA.TXT";
			
			BufferedReader ds = null;
			
			if((new File(filename)).exists() == true){
				ds = new BufferedReader(new FileReader(filename));			
			}		
			else{
				InputStream inURL = (boss.getClass()).getResourceAsStream(filename);	
				ds = new BufferedReader(new InputStreamReader(inURL));	
			}
			
			if(ds == null) return;		
			CstData cst = null;
			String line;
			
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				if(line.equals("--")) break;
				
				StringTokenizer st = new StringTokenizer(line);
								
				if((line.substring(0,2)).equals("##")){
					st.nextToken(); // skip ##
					cst = new CstData(st.nextToken(), st.nextToken(), 
					(Double.valueOf(st.nextToken())).doubleValue(),
					(Double.valueOf(st.nextToken())).doubleValue(),
					(Integer.valueOf(st.nextToken())).intValue());					

					cstvect.addElement(cst);
				}
				else{
					TLine pt = new TLine( (Double.valueOf(st.nextToken())).doubleValue(), 
					(Double.valueOf(st.nextToken())).doubleValue(),
				 	(Double.valueOf(st.nextToken())).doubleValue(), 
				 	(Double.valueOf(st.nextToken())).doubleValue());
				 	cst.addLine(pt);
				}
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
	}
	/*
	static public void readStNameData(Vector stvect){

		try{
			String line;
			BufferedReader ds
					= new BufferedReader(new FileReader("ss_st_name.txt"));
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				if(line.equals("--")) break;
				StringTokenizer st = new StringTokenizer(line);
				StarData pt = new StarData(st.nextToken(),st.nextToken(),
				 (Double.valueOf(st.nextToken())).doubleValue(), (Double.valueOf(st.nextToken())).doubleValue());
				stvect.addElement(pt);
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
	}// end of readDirData	
	*/
}// end of class FileAnalyzer