import java.awt.Panel;
import java.awt.Dimension;
import java.awt.Scrollbar;
import java.awt.Component;
import java.awt.Point;

public class GScroll extends Panel{
	final static int NORMAL = 0;
	final static int SLIDER = 1;
	
	GDirectionButton sbtn;
	GDirectionButton lbtn;
	GSCanvas scanvas;
	boolean fComponentsAdjusted = false;
	int mode;
	int unitincrement;
	ScrollBoss boss;
	int dragoffset = 0;
	static final int busize = 15;
	static final int slidersize = 10;	
	int type;
	
	GScroll(ScrollBoss _boss, int _mode){
		setVars(_boss,_mode,NORMAL);
	}
	GScroll(ScrollBoss _boss, int _mode , int _type){
		setVars(_boss,_mode,_type);
	}
	private void setVars(ScrollBoss _boss, int _mode , int _type){
		type = _type;
		boss = _boss;
		mode = _mode;
		setLayout(null);		
		//setVisile(true);
		//setLayout(new BorderLayout(0,0));
		if(type == NORMAL)
			scanvas = new GSCanvas(this,busize,mode);
		else if(type == SLIDER)
			scanvas = new GSCanvas(this,slidersize,mode);				
		if(mode == Scrollbar.HORIZONTAL){
			sbtn = new GDirectionButton(GDirectionButton.LEFT);
			lbtn = new GDirectionButton(GDirectionButton.RIGHT);
		}
		else{
			sbtn = new GDirectionButton(GDirectionButton.UP);
			lbtn = new GDirectionButton(GDirectionButton.DOWN);			
		}
		if(type == NORMAL){
			if(mode == Scrollbar.HORIZONTAL){
				add("East",lbtn);
				add("West",sbtn);
				add("Center",scanvas);
				//add(lbtn);  add(scanvas);add(sbtn);
			}
			else if(mode == Scrollbar.VERTICAL){
				add("South",lbtn);
				add("North",sbtn);
				add("Center",scanvas);			
			}
		}
		else if(type == SLIDER){
			add("Center",scanvas);
		}
	
		//{{REGISTER_LISTENERS
		SymMouse aSymMouse = new SymMouse();
		sbtn.addMouseListener(aSymMouse);
		lbtn.addMouseListener(aSymMouse);	
		scanvas.addMouseListener(aSymMouse);				
		SymMouseMotion aSymMouseMotion = new SymMouseMotion();
		scanvas.addMouseMotionListener(aSymMouseMotion);
		//}}
	}
	public void setBounds(int x, int y, int width,int height){
		super.setBounds(x,y,width,height);
		if(mode == Scrollbar.HORIZONTAL){
			sbtn.setBounds(0,0,busize,busize);
			scanvas.setBounds(busize,0,width - (2*busize),busize);
			lbtn.setBounds( width - busize,0,busize,busize);	
		}	
		else{
			sbtn.setBounds(0,0,busize,busize);
			scanvas.setBounds(0,busize,busize,height - (2*busize));
			lbtn.setBounds(0,height - busize, busize,busize);	
		}
//System.out.println(sbtn.getBounds()+ " " +scanvas.getBounds()+" " + lbtn.getBounds());		
	}
	public void setValues(int _value, int _visible, int _min, int _max){
		scanvas.setValues(_value,_visible,_min,_max);	
	}
	public int getValue(){
		return scanvas.getValue();
	}
	public void setUnitIncrement(int _val){
		unitincrement = _val;
	}
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}	
	
	public Dimension getPreferredSize()
	{
    		Dimension p = getSize();
    		if(mode == Scrollbar.HORIZONTAL){
    			return new Dimension(Math.max(p.width, busize*4), Math.max(p.height, busize));
    		}
    		else{
    			return new Dimension(Math.max(p.width, busize), Math.max(p.height, busize*4));    			
    		}
	}
	public Dimension getMinimumSize()
	{
		if(mode == Scrollbar.HORIZONTAL){
	   		 return new Dimension(busize*4, busize);
	   	}
	   	else{
	   		return new Dimension(busize,busize*4);	
	   	}
	}

	public int getType(){return type;}
	
	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mouseReleased(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object ==sbtn)
				GScroll_MouseReleased(sbtn,-1*unitincrement);
			else if(object == lbtn)
				GScroll_MouseReleased(lbtn,unitincrement);
			else if(object == scanvas)
				GScroll_MouseReleasedOnCV(event);
				
			boss.changeScroll(scanvas.getValue(),mode);	
		}
		public void mousePressed(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if(object == scanvas)
				GScroll_MousePressedOnCV(event);
			else if(object == sbtn){
				sbtn.setPressed(true);
				sbtn.repaint();
			}
			else if(object == lbtn){
				lbtn.setPressed(true);
				lbtn.repaint();				
			}
		}	
	}

	void GScroll_MouseReleased(GDirectionButton btn, int val)
	{
		btn.setPressed(false);
		btn.repaint();
		scanvas.setChangeValue(val);
		scanvas.repaint();
	}

	void GScroll_MouseReleasedOnCV(java.awt.event.MouseEvent event){
		//System.out.println("called");	
		if(scanvas.getDragMode()){	
			scanvas.confirmValue();	
			scanvas.setDragMode(false);				
			scanvas.repaint();

		}
		else{
			int x= event.getX();
			if(mode == Scrollbar.VERTICAL) x = event.getY();			
			scanvas.chgBlockValue(x);
			scanvas.repaint();
		}
	}
	void GScroll_MousePressedOnCV(java.awt.event.MouseEvent event){
		int val = event.getX();
		if(mode == Scrollbar.VERTICAL) val = event.getY();
		if(scanvas.isOnMarker(val)){
			scanvas.setDragMode(true);
			dragoffset = scanvas.getBarX() - val;
		}
		else{
			scanvas.setDragMode(false);
		}
		
	}
	class SymMouseMotion extends java.awt.event.MouseMotionAdapter
	{
		public void mouseDragged(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object ==scanvas)
				GScroll_MouseDragged(event);
		}
	}

	void GScroll_MouseDragged(java.awt.event.MouseEvent event)
	{
		if(scanvas.getDragMode() == false) return;
		int x = event.getX();
		if(mode == Scrollbar.VERTICAL) x = event.getY();
//System.out.println("x = "+x);		
		scanvas.setTempValue(x+dragoffset);
		scanvas.repaint();
		if(type == SLIDER){
			scanvas.confirmValue();
			boss.changeScroll(scanvas.getValue(),mode);	
		}
	}
}// end of class