import java.awt.Image;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Canvas;
import java.awt.Scrollbar;
import java.awt.Color;
//import java.awt.event.*;
//import java.awt.image.*;
//import java.util.*;
//import java.net.*;

public class GSCanvas extends Canvas {
	GScroll boss;
	int value;
	int visible;
	int min;
	int max;
	int barwidth;
	int mode;
	Image offscreen = null;
	Dimension offscreensize;
	Graphics offgraphics;   
	int busize;
	int barx;
	int tempvalue;
	boolean dragmode = false;
	
	public GSCanvas(GScroll _boss,int _busize,int _mode){
		super();
		mode  = _mode;
		busize = _busize;
		boss = _boss;
		min = 0;
		max = 0;
		value = 0;
		visible = 0;
		tempvalue = -1;
	}

	public Dimension getMinimumSize(){
		if(mode == Scrollbar.HORIZONTAL)
			return new Dimension(busize*2,busize);	
		else 
			return new Dimension(busize,busize*2);
	}
    
	public void setValues(int _value, int _visible, int _min, int _max){
		min = _min; max = _max; value = _value;
		 visible = _visible;
		if(value < min) value = min;
		else if(value > max) value = max;
		if(min == max) max = min + 1;
	}
	public void setChangeValue(int chgvalue){
//System.out.println("chg = "+chgvalue);		
		value  +=  chgvalue;
		if(value < min) value = min;
		else if(value > max) value = max;
//System.out.println("value = "+value);		
	}
	public void update(Graphics g){
		paint(g);
	}
	public void paint(Graphics g)
	{
		Dimension d = getSize();
		

		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());

		}


		//offgraphics.setColor(getBackground());
		//offgraphics.fillRect(0, 0, d.width, d.height);
		
		paintBar(offgraphics);
		//if(tempvalue >=0) paintTempBox(offgraphics);
		if((dragmode)&&(boss.getType() == GScroll.NORMAL)) paintTempBox(offgraphics);
		g.drawImage(offscreen, 0, 0, null);
	}
	
	private void paintBar(Graphics g){
	
		Dimension d = getSize();
		if(boss.getType() == GScroll.NORMAL){
			g.setColor(Color.darkGray);
			g.fillRect(0,0,d.width,d.height);
		}
		else if(boss.getType() == GScroll.SLIDER){
			g.setColor(Color.black);
			g.fillRect(0,0,d.width,d.height);		
			g.setColor(Color.darkGray);
			int width = d.width/3;
			g.fillRect(width,0,width,d.height);
		}
		int width  = max - min;
		if(width <=0) width = 1;
		
		int sval = d.width;
		if(mode == Scrollbar.VERTICAL) sval = d.height;
		barwidth = (int)(((double)sval/(width + visible))*visible);
		
		if(barwidth < busize) barwidth = busize;
		barx = (int)(((double)(value - min)/width) *(sval-barwidth));
//System.out.println("barx = "+barx);

		if(boss.getType() == GScroll.NORMAL)
			g.setColor(Color.white);
		else if(boss.getType() == GScroll.SLIDER)
			g.setColor(Color.lightGray);	
					
		if(mode == Scrollbar.HORIZONTAL)
			g.fill3DRect(barx,1,barwidth,d.height-2,true);	
		else
			g.fill3DRect(1,barx,d.width-2,barwidth,true);		

	}
	private void paintTempBox(Graphics g){
		g.setColor(Color.white);
		if(mode == Scrollbar.HORIZONTAL)
			g.draw3DRect(tempvalue,1,barwidth,(getSize()).height -2, true);
		else
			g.draw3DRect(1,tempvalue,(getSize()).width -2,barwidth,true);		
	}
	public void confirmValue(){
		int sval = getSize().width;
		if(mode == Scrollbar.VERTICAL) sval = getSize().height;
		
		double delta = (double) tempvalue / (double)(sval- barwidth)*(max - min);
		value =(int) delta + min ; 
//System.out.println("delta = " + delta + "temp = "+tempvalue + "value = "+value);		
//		tempvalue = -1;
	}
	public void setTempValue(int val){
		tempvalue = val;
		int tempmax = (getSize().width) - barwidth;
		if(mode == Scrollbar.VERTICAL) tempmax = (getSize().height) - barwidth;
		
		if(tempvalue < 0) tempvalue = 0;
		else if(tempvalue > tempmax) tempvalue = tempmax;
	}
	public void setDragMode(boolean _val){
		dragmode = _val;
	}
	public boolean getDragMode(){
		return dragmode;
	}
	public boolean isOnMarker(int x){
		return ((x > barx)&&(x < barx + barwidth));
	}
	public void chgBlockValue(int x){
		int chgvalue = visible /2;
		if(chgvalue < 1) chgvalue = 1;
		if(x < barx){
			chgvalue *= -1;
		}
		setChangeValue(chgvalue);
	}
	public int getValue(){return value;}
	public int getBarX(){return barx;}
}// end of SkyCanvas