import java.awt.Canvas;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class GDirectionButton extends Canvas
{
	public static final int LEFT = 0;
   	public static final int RIGHT = 1;
   	public static final int UP = 2;
  	public static final int DOWN = 3;
	
	int direction;
	int margin;
	boolean pressed = false;
	Image offscreen = null;
	Dimension offscreensize;
	Graphics offgraphics;   
		
   	 public GDirectionButton()
  	  {
       	 this(LEFT);
   	 
		//{{REGISTER_LISTENERS
		//SymMouse aSymMouse = new SymMouse();
		//this.addMouseListener(aSymMouse);
		//}}
	}

	public GDirectionButton(int d)
	{
		direction 	= d;
		margin = 2;
	}
	
	public void setDirection(int d) 
	{
		if(direction != d)
		{
			direction = d;
			repaint();
		}
	}

    public int getDirection()
    {
        return direction;
    }
    public Dimension getPreferredSize()
    {
    		Dimension defaultSize = super.getPreferredSize();
		return new Dimension(defaultSize.width + 7, defaultSize.height + 7);
    }

    public Dimension getMinimumSize()
    {
    	Dimension defaultSize = super.getPreferredSize();

		return new Dimension(defaultSize.width + 3, defaultSize.height + 3);
    }
	public void update(Graphics g){
		paint(g);
	}
	public void paint(Graphics g)
	{
		Dimension d = getSize();
		

		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());

		}
		
		paintArrow(offgraphics);
		g.drawImage(offscreen, 0, 0, null);
	}
	
	private void paintArrow(Graphics g){	
		Dimension d = getSize();
		margin = d.width / 6;
		if(margin < 2) margin = 2;
		if(pressed)
			g.setColor(Color.darkGray);
		else 
			g.setColor(Color.lightGray);
		boolean flag = true;
		if(pressed) flag = false;
		g.fill3DRect(0,0,d.width,d.height,flag);
		
		Polygon rect = new Polygon();
		
		switch(direction){
			case LEFT:
				rect.addPoint(margin,d.height/2);
				rect.addPoint(d.width - margin,margin);
				rect.addPoint(d.width - margin, d.height - margin);
				break;
			case RIGHT:
				rect.addPoint(d.width - margin, d.height /2);
				rect.addPoint(margin, margin);
				rect.addPoint(margin,d.height - margin);
				break;
			case UP:
				rect.addPoint(d.width/2, margin);
				rect.addPoint(margin,d.height - margin);
				rect.addPoint(d.width - margin, d.height - margin);
				break;
			case DOWN:
				rect.addPoint(d.width/2, d.height - margin);
				rect.addPoint(margin,margin);
				rect.addPoint(d.width - margin, margin);
				break;	
		}
		if(pressed) g.setColor(Color.lightGray);
		else g.setColor(Color.darkGray);
		g.fillPolygon(rect);	
		g.setColor(Color.black);	
		g.drawRect(0,0,d.width,d.height);

	}
	
	public void setPressed(boolean val){
		pressed = val;
	}
/*

	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mouseExited(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == GDirectionButton.this)
				GDirectionButton_MouseExited(event);
		}

		public void mouseReleased(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == GDirectionButton.this)
				GDirectionButton_MouseReleased(event);
		}

		public void mousePressed(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == GDirectionButton.this)
				GDirectionButton_MousePressed(event);
		}
	}

	void GDirectionButton_MousePressed(java.awt.event.MouseEvent event)
	{
		pressed = true;
//System.out.println("pressed called");		
		repaint();
	}

	void GDirectionButton_MouseReleased(java.awt.event.MouseEvent event)
	{
		pressed = false;
		repaint();
	}

	void GDirectionButton_MouseExited(java.awt.event.MouseEvent event)
	{
		if(pressed) pressed  = false;
	}
	*/
}