import java.awt.Point;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Dimension;
import java.awt.Component;
import java.awt.Toolkit;

import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.StringTokenizer;
//import java.text.*;
import java.awt.event.AdjustmentListener;

public class GDViewer extends Frame 
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	boolean startUpFlag = true;
	SETISupport boss;
	GDCanvas maincanvas;
	GDPrefValue pref;	
	
	java.awt.MenuBar mainMenuBar;
	java.awt.Menu menu1;
	java.awt.Menu menu2;
	
	java.awt.MenuItem miExit;
	java.awt.CheckboxMenuItem miCrossLine;	
	java.awt.CheckboxMenuItem miArrow;	
	java.awt.CheckboxMenuItem miHiCur;	
	java.awt.CheckboxMenuItem miBlink;	
	java.awt.CheckboxMenuItem miSnow;	
				
	public GDViewer(SETISupport _boss)
	{
		pref = FileAnalyzer.readGDPrefs();		
		boss = _boss;

				
		initLayout();	// pref will be passed to maincanvs in this function
		
		setData();

		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymComponent aSymComponent = new SymComponent();
		this.addComponentListener(aSymComponent);
		//}}
	}
	
	public void setData(){
		Vector datavect = new Vector();
		boss.setMxData(datavect);
		maincanvas.setData(datavect);
	}
	
	public void initLayout()
	{

		setTitle("SETI@Support Gaussian Distribution");

		Rectangle dm = pref.getBound();
		int wwidth = dm.width;
		int wheight = dm.height;		
		setLocation(dm.x,dm.y);	
						
		setLayout(new BorderLayout(0,0));
		//setLayout(new MyLayout());
		setVisible(false);
		setSize(wwidth,wheight);	
		
		maincanvas = new GDCanvas(this);
		maincanvas.start();
		add("Center",maincanvas);

		
		// init menues
		mainMenuBar = new java.awt.MenuBar();
		menu1 = new java.awt.Menu("File");

		miExit = new java.awt.MenuItem("Close");
		menu1.add(miExit);
		
		menu2 =  new java.awt.Menu("Setting");
		boolean flag;
		if(pref.getClPref() == 0) flag = false; else flag = true;
		miCrossLine = new java.awt.CheckboxMenuItem("Cross Line",flag);
		miCrossLineAction(flag);
		menu2.add(miCrossLine);

		if(pref.getArPref() == 0) flag = false; else flag = true;
		miArrow = new java.awt.CheckboxMenuItem("Arrow",flag);
		miArrowAction(flag);
		menu2.add(miArrow);

		if(pref.getHiCurPref() == 0) flag = false; else flag = true;
		miHiCur = new java.awt.CheckboxMenuItem("Highlight analyzing data",flag);
		miHiCurAction(flag);
		menu2.add(miHiCur);

		if(pref.getBlinkPref() == 0) flag = false; else flag = true;
		miBlink = new java.awt.CheckboxMenuItem("Blink",flag);
		miBlinkAction(flag);
		menu2.add(miBlink);

		if(pref.getSnowPref() == 0) flag = false; else flag = true;
		miSnow = new java.awt.CheckboxMenuItem("View",flag);
		miSnowAction(flag);
		if((new File("goro")).exists())  menu2.add(miSnow);
										
		mainMenuBar.add(menu1);
		mainMenuBar.add(menu2);
		setMenuBar(mainMenuBar);
			
		SymAction lSymAction = new SymAction();

		miExit.addActionListener(lSymAction);
		
		SymItem lSymItem = new SymItem();	
		
		miCrossLine.addItemListener(lSymItem);		
		miArrow.addItemListener(lSymItem);	
		miHiCur.addItemListener(lSymItem);	
		miBlink.addItemListener(lSymItem);		
		miSnow.addItemListener(lSymItem);							
	}

	
    public void setVisible(boolean b)
	{
		if(b)
		{
			//setLocation(50, 50);
		}	
		super.setVisible(b);
	}

	
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();
		
		super.addNotify();
	
		if (fComponentsAdjusted)
			return;
	
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
	 public void setBoundPref(Rectangle rect){
//System.out.println("bound set " + rect);	 
	 	pref.setBound(rect);
	 }
	 
	 private void fileOutPref(){
//System.out.println("called");	 
		FileAnalyzer.fileOutGDPrefs(pref);		
	 }	
	 public void setAnimeTime(int t){
	 	maincanvas.setAnimeTime(t);
	 }
	 public void resetSleepThread(){
	 	boss.resetSleepThread();
	 }
/////////////
// call back related functions
/////////////


	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{						
			Object object = event.getSource();
			if (object == miExit)
				 GDViewer_WindowClosing(null);					
		}
	}
	
	
	void miExit_Action(java.awt.event.ActionEvent event)
	{
		Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));

	}
	
	
	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{	
			Object object = event.getSource();
			if (object == miCrossLine){
				if(miCrossLine.getState())  pref.setClPref(1);
				else pref.setClPref(0);		
				miCrossLineAction(miCrossLine.getState());	
			}	
			else if(object == miArrow){
				if(miArrow.getState())  pref.setArPref(1);
				else pref.setArPref(0);	
				miArrowAction(miArrow.getState());			
			}	
			else if(object == miHiCur){
				if(miHiCur.getState())  pref.setHiCurPref(1);
				else pref.setHiCurPref(0);	
				miHiCurAction(miHiCur.getState());			
			}	
			else if(object == miBlink){
				if(miBlink.getState())  pref.setBlinkPref(1);
				else pref.setBlinkPref(0);	
				miBlinkAction(miBlink.getState());			
			}	
			else if(object == miSnow){
				if(miSnow.getState())  pref.setSnowPref(1);
				else pref.setSnowPref(0);	
				miSnowAction(miSnow.getState());			
			}									
			fileOutPref();
		}// end of itemStateChanged
	}
	private void miCrossLineAction(boolean flag){
		maincanvas.setCenterLineFlag(flag);
	}
	private void miArrowAction(boolean flag){
		maincanvas.setDrawArrowFlag(flag);	
	}
	private void miHiCurAction(boolean flag){
		maincanvas.setHiCurFlag(flag);	
	}
	private void miBlinkAction(boolean flag){
		maincanvas.setBlinkFlag(flag);	
	}	
	private void miSnowAction(boolean flag){
		maincanvas.setSnowFlag(flag);	
	}		
	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowDeactivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_WindowDeactivated(event);
		}
		public void windowActivated(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_WindowActivated(event);
		}

		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_WindowClosing(event);
		}
		public void windowOpened(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_WindowOpened(event);
		}		
	}

	void GDViewer_WindowClosing(java.awt.event.WindowEvent event)
	{

		setBoundPref(getBounds());
		fileOutPref();
		//maincanvas.clearData();
		
		setVisible(false);	// hide the Frame
		dispose();			// free the system resources
		boss.clearGdx();
	}

	public void update(){
		maincanvas.repaint();	
	}
	void GDViewer_WindowOpened(java.awt.event.WindowEvent event)
	{
		//resetSleepThread();
	}
	void GDViewer_WindowActivated(java.awt.event.WindowEvent event)
	{
		resetSleepThread();
	}	
	void GDViewer_WindowDeactivated(java.awt.event.WindowEvent event)
	{
		boss.SETISupport_WindowDeactivated(null);
	}
	class SymComponent extends java.awt.event.ComponentAdapter
	{
		public void componentShown(java.awt.event.ComponentEvent event)
		{
			//resetSleepThread();
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_ComponentShown(event);
		}
		public void componentMoved(java.awt.event.ComponentEvent event)
		{
			Object object = event.getSource();
			if (object == GDViewer.this)
				GDViewer_ComponentMoved(event);
		}
		
	}

	void GDViewer_ComponentMoved(java.awt.event.ComponentEvent event)
	{
		//setBoundPref(getBounds());
		//fileOutPref();
	}
	void GDViewer_ComponentShown(java.awt.event.ComponentEvent event)
	{
		if(startUpFlag){
			startUpFlag = false;
			
			Rectangle dm = pref.getBound();
//System.out.println("dm = "+ dm);			
			if((dm.width != 0)&&(dm.height != 0)){
				setSize(new Dimension(dm.width,dm.height));

				setLocation(dm.x, dm.y);			
			}
			else{
				setSize(new Dimension(400,400));
				setLocation(50,50);	
			}			
		}
	}		
	public void selectData(ResultData rd){
		boss.selectFromOutside(rd,true);
	}
	
			
}// end of class GDViewer

