import java.awt.Canvas;
import java.awt.FontMetrics;
import java.awt.Font;
import java.awt.Image;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Polygon;
import java.util.Vector;
import java.util.Random;
import java.util.StringTokenizer;

//import java.net.*;

public class GDCanvas extends Canvas  implements Runnable {

	Random dice  = new Random(0);
	GDViewer boss;

	Vector datavect;
	
	Image offscreen = null;
	Dimension offscreensize;
	Graphics offgraphics;   
	Thread relaxer;                 // me too
	int animetime = 200;
						
    	FontMetrics fm;      // fontmetrics for font
    	FontMetrics boldfm; // fontmetrics for bold    	
	Font font;             // font used to display char
	Font boldfont;             // font used to display char
	int charHeight;    // height of the char used
     	int charDescent;    // descent of the char
     	int charLeading;     //leading of the char
     	int charAscent; // ascent of the char

     	int lineHeight;
     	int hgap =3;
     	int vgap = 3;
	double vmax = 20;
	double vminmax = 10;
	double hmax = 10;
	double hminmax = 10;
	double hmin = 0.1;
	double chismax = 10;
 	int dwidth ; // distance between min and max in pixel in horizontal direction
 	int dheight; // distance between min and max in pixel in vertical direction
 	int inmargin  = 20;// margin in side 
 	int outmargin = 15; // margin outside
     	int markrad = 4; // size of mark
     	/////////  various flags
     	
     	boolean centerflag = true; // control cross line
     	boolean drawArrowFlag = true;
     	boolean blinkflag = true;
     	boolean hiCurFlag  = true;
     	boolean snowflag = true;
     	boolean rightflag ;
     	boolean leftflag ;
     	boolean upflag;
     	boolean downflag;
     	boolean arrowflag[] = {false,false,false,false};
     	Polygon arrowpol[] = {null,null,null,null};
     	final static int A_UP = 0;
     	final static int A_DOWN  = 1;
     	final static int A_RIGHT = 2;
     	final static int A_LEFT = 3;
     	int lcount[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
	int tracx; // center of tracking line
	int tracy; // center of tracking ine
	     	
	public GDCanvas(GDViewer _boss){
		super();

		boss = _boss;
		
		datavect = new Vector();
		
		setFont(10);
		
		initlcount();
	
		//{{REGISTER_LISTENERS
		SymMouse aSymMouse = new SymMouse();
		this.addMouseListener(aSymMouse);
		SymComponent aSymComponent = new SymComponent();
		this.addComponentListener(aSymComponent);
		//}}
	}
	private void initlcount(){
		for(int i = 0;i<lcount.length;i++){
			lcount[i] = 10 - (int)(dice.nextDouble()*8.0);	
			//System.out.println("l = "+ lcount[i]);
		}	
	}
	public void setAnimeTime(int val){
//System.out.println("set to "+val);		
		animetime = val;
	}
	 public void start() {
		relaxer = new Thread(this);
		relaxer.start();
		relaxer.setPriority(Thread.MIN_PRIORITY);
    	}
    	
	 public void stop() {
		if(relaxer != null)
			relaxer.stop();
	}
	public void suspend(){
		if(relaxer != null)
			relaxer.suspend();
	}	
	public void resume(){
		if(relaxer != null)
			relaxer.resume();
	}
	public void run() {
		while (true) {
			//setSize(mySize);
			repaint();
			try {
				relaxer.sleep(animetime);
			} catch (InterruptedException e) {
				break;
			} // end of catch
		}// end of while(true)
	}// end of run()
	
	public  void setFont(int fontSize)
	{
	      String[] fontNames = Toolkit.getDefaultToolkit().getFontList();
	      font = new Font(fontNames[1], Font.PLAIN, fontSize);	// used be 0
	      boldfont = new Font(fontNames[1],Font.BOLD,fontSize);// used be 0
	      fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
	      boldfm = Toolkit.getDefaultToolkit().getFontMetrics(boldfont);
        		charHeight = fm.getHeight();// + 3;
		charDescent = fm.getDescent();
		charAscent = fm.getAscent();
		charLeading = fm.getLeading();
		lineHeight = charHeight + (2*vgap);		
   	 }
   	public void setCenterLineFlag(boolean val){ centerflag = val;}
   	public void setDrawArrowFlag(boolean val){ drawArrowFlag = val;}
   	public void setHiCurFlag(boolean val){ hiCurFlag = val;}
   	public void setBlinkFlag(boolean val){ blinkflag = val;}
   	public void setSnowFlag(boolean val){ snowflag = val;}
   	   	   	
	public void setData(Vector _datavect){
		datavect.removeAllElements();
	
		for(int i = 0;i<_datavect.size();i++){
			ResultData rd = (ResultData)(_datavect.elementAt(i));
			int firstLevel = (int)(dice.nextDouble()*SkyCanvas.maxCircleLevel);	

				
			PlotData pt = new PlotData(firstLevel,SkyCanvas.maxCircleLevel,rd);

		
			pt.setColor(rd.getColorName());
			datavect.addElement(pt);
		}
	}

	public void update(Graphics g){
		paint(g);
	}
	public void paint(Graphics g)
	{
//System.out.println("paing alled");		
		Dimension d = getSize();
		

		if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height)) {
			offscreen = createImage(d.width, d.height);
			offscreensize = d;
			offgraphics = offscreen.getGraphics();
			offgraphics.setFont(getFont());

		}

		
		offgraphics.setColor(Color.black);
		offgraphics.fillRect(0, 0, d.width, d.height);
		
		paintGrid(offgraphics);
		resetArrowFlag();
		paintData(offgraphics);
		if(drawArrowFlag) paintArrow(offgraphics);
		g.drawImage(offscreen, 0, 0, null);
	
	}
	

	private void paintGrid(Graphics g){
		String t_str = DoubleFormat.toString(vmax,1);
		int tempwidth = fm.stringWidth(t_str)+hgap*2;
		if(inmargin < tempwidth) inmargin = tempwidth;
		if(inmargin < charHeight) inmargin = charHeight+outmargin;
		
		dwidth = (getSize()).width-inmargin - outmargin;
		dheight = (getSize()).height-inmargin - outmargin;	
		
		/////// interesting region
		// y = 2 + 1.5x -> x = (y-2)/1.5
		// 
		Polygon pl = new Polygon();
		Polygon spl = new Polygon();
		for(double y = 2 + 1.5*hmin; y < chismax ; y += 0.3){
			double x = (y - 2.0)/1.5;
			Point p = getConvPt(x,y);
			pl.addPoint(p.x, p.y);
			if(y > chismax/2){
				spl.addPoint(p.x,p.y);
			}
		}
		Point p = getConvPt((chismax - 2.0)/1.5, chismax); // left top corner
		pl.addPoint(p.x, p.y);
		spl.addPoint(p.x,p.y);
		
		p = getConvPt(hmax,chismax);				//right top corner
		pl.addPoint(dwidth + inmargin + outmargin, p.y);
		
		p = getConvPt(hmax,0.0);
		pl.addPoint(dwidth + inmargin + outmargin,p.y);
		p = getConvPt(hmin,0.0);
		pl.addPoint(p.x, p.y);
		g.setColor(Color.blue);
		g.fillPolygon(pl);
		
		if(snowflag){
			g.setColor(Color.white);
			int minx = spl.xpoints[spl.npoints-1];
			int maxx =dwidth + inmargin + outmargin;
//System.out.println(minx + " " + maxx);			
			for(int sx = minx;sx < maxx; sx++){
				double ratio = ((double)(maxx- sx)) / (maxx - minx);
//System.out.println(sx + " rati = " + ratio);		
				int count = lcount[sx%(lcount.length)];
		
				for(int i = spl.npoints-1;i > count;i--){
					g.drawLine(maxx - (int)((maxx - spl.xpoints[i])*ratio),spl.ypoints[i],
							maxx - (int)((maxx - spl.xpoints[i-1])*ratio),spl.ypoints[i-1]);				
				}
			}
		}
		
		int subMemWidth = 3;
		g.setColor(Color.white);

		/////// Vertical line
		g.drawLine(inmargin,0,inmargin,dheight + outmargin);

		for(int i = 1;i<=4;i++){
			int hd = (dheight/4)*i;
			g.drawLine(inmargin, dheight + outmargin - hd,inmargin+subMemWidth, dheight + outmargin - hd);
			String str = DoubleFormat.toString(((vmax/4) * i),1);
			int strw = fm.stringWidth(str);
			g.drawString(str,inmargin - strw - 2*hgap,dheight + outmargin - hd +(charHeight/2));
		}
		g.drawString("Fit",inmargin + subMemWidth,charHeight);
		//////// Horizontal Line
		g.drawLine(inmargin,dheight + outmargin, dwidth + inmargin + outmargin ,dheight + outmargin);

		double val = hmin;
		for(int i = 0;i<=2;i++){
			int wd = (dwidth /2)*i;
			g.drawLine(inmargin + wd, dheight + outmargin, inmargin+wd,dheight + outmargin-subMemWidth);
			String str = Double.toString(val);
			int strw = fm.stringWidth(str);
			g.drawString(str, inmargin+wd - (strw/2), dheight + outmargin + charHeight);
			val = val * 10;
		}		
		String str = "Power";
		g.drawString(str, inmargin + dwidth  - (fm.stringWidth(str)),outmargin + dheight);
	}
	private void paintData(Graphics g){
		for(int i = 0;i<datavect.size();i++){
			PlotData pt = (PlotData)(datavect.elementAt(i));
			if(pt.getBgChisq() == 0.0) continue; // if that is empty gaussian, skip it.
			pt.addLevel();
			if(pt.getVisible() == false) continue;
			markrad = 4;

			Point p;
			
			if((pt.getFinished() == false)||(pt.getPt() == null)){
				p= getConvPt(pt);
				pt.setPt(p);
			}
			else{
				p = pt.getPt();
			}			
			if(setArrowFlag(p) == false) continue;
		
			if((pt.getFinished() == false)&&(hiCurFlag == true)){		
				for(int j = 0;j<pt.getLevel();j+=2){
					int srad = markrad+2 + j*3;
					g.setColor(Color.cyan);
	     				g.drawOval(p.x - (srad/2),p.y - (srad/2),srad,srad);
	     			}	
				if(pt.getTop()) g.setColor(Color.red);
				else g.setColor(Color.cyan);			     			
	     			g.fillOval(p.x-(markrad/2),p.y-(markrad/2),markrad,markrad);
			}
			else{
				if(pt.getTop()) pt.setColor("Red");
				else pt.setColor("White");		
				Color orcolor = pt.getColor();
				if(blinkflag){
					float cl[] = {(float)0.0,(float)0.0,(float)0.0};
					cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(),cl);
					Color nwcolor = Color.getHSBColor(cl[0],cl[1],(float)(1.0 - ((float)pt.getLevel())/SkyCanvas.maxCircleLevel));
					g.setColor(nwcolor);		
				}
				else{
					g.setColor(orcolor);
				}			
		     		g.fill3DRect(p.x-(markrad/2),p.y - (markrad/2) ,markrad,markrad,true);	
		     	}
	     		
	     		String str = "(" + Double.toString(pt.getBgPower()) + " , " + Double.toString(pt.getBgChisq()) + ")";
	     		//g.drawString(str,x,y + charHeight);		
	     		
			if((pt.getSelected() == true)&&(centerflag == true)){ // selected
				Point npt = paintCrossLine(g,pt,tracx, tracy);
				tracx = npt.x;
				tracy = npt.y;
			}	     		
	     	}
	}
	private Point getConvPt(PlotData pt){
		return getConvPt(pt.getBgPower(),pt.getBgChisq());
	}
	private Point getConvPt(double xval, double yval){
		int y = outmargin + (int)((1-(yval/vmax))*dheight);
		int x = inmargin + (int) (((Math.log(xval) - Math.log(hmin))/(Math.log(hmax) - Math.log(hmin)))*dwidth);
		return new Point(x,y);
	}
	private boolean setArrowFlag(Point p){
		boolean retflag = true;
		if(p.x < 0){
			retflag = false;
		}
		else if(p.x > getSize().width){
			retflag = false;
			arrowflag[A_RIGHT] = true;
		}
		if(p.y < 0){
			retflag = false;
			arrowflag[A_UP] = true;			
		}
		else if(p.y > getSize().height){
			retflag = false;
		}	
		if(vmax > vminmax) arrowflag[A_DOWN] = true;
		if(hmax > hminmax) arrowflag[A_LEFT] = true;
		
		return retflag;
	}		
	
	private void resetArrowFlag(){
		for(int i = 0;i<arrowflag.length;i++){ arrowflag[i] = false;}
	}
	
	private void paintArrow(Graphics g){
		for(int i = 0;i<arrowpol.length; i++){ arrowpol[i] = null;}
		int arrowwidth = 20;
		int arrowheight = 10;
		Dimension d = getSize();
		
		//vertical arrow
	
		arrowpol[A_UP] = new Polygon();
		arrowpol[A_UP].addPoint(d.width/2 - (arrowwidth/2), arrowheight);
		arrowpol[A_UP].addPoint(d.width/2  , 0);
		arrowpol[A_UP].addPoint(d.width/2  + (arrowwidth/2), arrowheight);
		
		arrowpol[A_DOWN] = new Polygon();
		arrowpol[A_DOWN].addPoint(d.width/2 - (arrowwidth/2), arrowheight+vgap);
		arrowpol[A_DOWN].addPoint(d.width/2  , arrowheight*2 + vgap);
		arrowpol[A_DOWN].addPoint(d.width/2  + (arrowwidth/2), arrowheight+vgap);
		
		// horizontal arrow
		
		arrowpol[A_RIGHT] = new Polygon();
		arrowpol[A_RIGHT].addPoint(d.width, d.height/2);
		arrowpol[A_RIGHT].addPoint(d.width - arrowheight,d.height/2 - arrowwidth/2);
		arrowpol[A_RIGHT].addPoint(d.width - arrowheight,d.height/2 + arrowwidth/2);

		arrowpol[A_LEFT] = new Polygon();
		arrowpol[A_LEFT].addPoint(d.width - (arrowheight*2) - hgap, d.height/2);
		arrowpol[A_LEFT].addPoint(d.width - arrowheight - hgap,d.height/2 - arrowwidth/2);
		arrowpol[A_LEFT].addPoint(d.width - arrowheight - hgap,d.height/2 + arrowwidth/2);		
		
		g.setColor(Color.yellow);
		for(int i = 0;i<arrowpol.length;i++){
			if(arrowflag[i])g.drawPolygon(arrowpol[i]);
		}
	}
	 private Point paintCrossLine(Graphics g, PlotData pt,int tracx, int tracy){
			Point ppt = getConvPt(pt);	
			Dimension d = getSize();
			g.setColor(Color.pink);
		    	int len = markrad * 2;
		    	double alpha = 0.7;
	    	
		    	tracx =(int)(ppt.x*alpha + (tracx * (1-alpha)));
		    	tracy = (int)(ppt.y*alpha + (tracy * (1-alpha))); 	
		    	g.drawRect(tracx-(int)(len*0.5),tracy-(int)(len*0.5),len,len);
		
		   	g.drawLine(tracx,0,           tracx,tracy  - (int)(len*0.5));
		    	g.drawLine(tracx,d.height, tracx,tracy  + (int)(len*0.5));
		   	g.drawLine(0,tracy,         tracx - (int)(len*0.5), tracy);
		    	g.drawLine(d.width,tracy, tracx+(int)(len*0.5),tracy);		
		    	
		    	return new Point(tracx,tracy);
	}

	private void clearPtData(){
		for(int i = 0;i<datavect.size();i++){
			PlotData pt = (PlotData)(datavect.elementAt(i));
			pt.setPt(null);
		}	
	}
	 		
	class SymMouse extends java.awt.event.MouseAdapter
	{
		public void mousePressed(java.awt.event.MouseEvent event)
		{
			Object object = event.getSource();
			if (object == GDCanvas.this)
				GDCanvas_MouseClicked(event);
		}
	}

	void GDCanvas_MouseClicked(java.awt.event.MouseEvent event)
	{
		///////////////////////////////
		////// Data Selection
		/////////////////////////////////
		
		Point ept = event.getPoint();		
		int cl = markrad * 2;
		Rectangle checkrect = new Rectangle(ept.x - cl, ept.y - cl, cl*2,cl*2);
		Vector cvect = new Vector();
		for(int i = 0;i<datavect.size();i++){
			PlotData pt = (PlotData)(datavect.elementAt(i));
			Point ppt = pt.getPt();
			if(ppt == null) continue;
			if(checkrect.contains(ppt)) cvect.addElement(pt);
		}		
		PlotData selpt = null;
		if(cvect.size() == 1){
			selpt = (PlotData)(cvect.elementAt(0));
		}
		else{// more than one candidate
			int mind = (cl * 2)*(cl*2);
			for(int i = 0;i<cvect.size();i++){
				PlotData pt = (PlotData)cvect.elementAt(i);
				if(pt.getSelected() == true) continue; // don't want to select again
				Point dpt = getConvPt(pt);			
				int dx = ept.x -dpt.x;
				int dy = ept.y -dpt.y;
				int d = 	dx*dx + dy*dy;
//System.out.println(d + " : " + mind);				
				if(d < mind){
					mind = d;
					selpt = pt;
				}
			}
		}
		if(selpt != null){
			boss.selectData(selpt.getOrgData());
		}		
		else{
			clickForScroll(ept);
		}
		
		boss.resetSleepThread();
	}
	
	private void clickForScroll(Point pt){
		for(int i = 0;i<arrowpol.length;i++){
			Polygon pol = arrowpol[i];
			if(arrowflag[i] == false) continue;
			if(pol != null){
				if(pol.contains(pt)){
					switch(i){
						case A_UP:
							vmax += 10;
							break;
						case A_DOWN:
							vmax -= 10;
							if(vmax < vminmax) vmax = vminmax;
							break;
						case A_RIGHT:
							hmax *= 10;
							break;
						case A_LEFT:
							hmax /= 10;
							if(hmax < hminmax) hmax = hminmax;
						 	break;
					}
					clearPtData();
					repaint();
					break;
				}
			}
		}
	}

	class SymComponent extends java.awt.event.ComponentAdapter
	{
		public void componentResized(java.awt.event.ComponentEvent event)
		{
			Object object = event.getSource();
			if (object == GDCanvas.this)
				GDCanvas_ComponentResized(event);
		}
	}

	void GDCanvas_ComponentResized(java.awt.event.ComponentEvent event)
	{
		clearPtData();
		//boss.setBoundPref(getBounds());
		//boss.fileOutPref();
	}
	

}// end of GDCanvas