//import java.lang.*;
import java.io.File;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ByteArrayOutputStream;
import java.io.BufferedWriter;
import java.io.RandomAccessFile;
import java.io.OutputStreamWriter;

import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Date;
import java.util.TimeZone;
import java.util.Enumeration;
import java.util.NoSuchElementException ;

import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.awt.Rectangle;

public class FileReadThread implements Runnable{
	private ListCanvas boss;
	int readmode;
	
//////// readData series////////////////////////////////////
	// read "accessno" or "raccessno" file into vt.
	
	public FileReadThread(ListCanvas _boss, int _readmode){
		super();
		readmode = _readmode;
		boss = _boss;
	}
	
	public void run() {
		String filename = null;
		String latestfilename = null;	
		if(readmode == GLB.ACCESS){
			filename = GLB.accessFileName;
		}
		else if(readmode == GLB.REF){
			filename = GLB.refFileName;
		}
		latestfilename = GLB.LATEST_DATE+filename;	
		getLatestDate(latestfilename);
		readAccessFile(filename);
    	//System.out.println("Done loading stars");
    	boss.finishedReading(readmode);
    	return;
  	}
  		
	public  void readAccessFile(String filename){

		
		File fp = new File((System.getProperty("user.dir")), filename);
		if(fp.exists() == false) return;
		try{
			String line;
			BufferedReader ds
					= new BufferedReader(new FileReader(fp));
			while((line = ds.readLine())!= null){
				if(line.length() == 0) continue;
				if(line.charAt(0) == '#') continue;
				StringTokenizer st = new StringTokenizer(line);
				String daystr = null;
				String timestr = null;
				String pgstr = null;
				String hststr = null;
				try{
					daystr = st.nextToken();
				}
				catch(NoSuchElementException e){
					daystr = " ";
				}
				try{
					timestr = st.nextToken();
				}
				catch(NoSuchElementException e){
					timestr = " ";
				}				
				try{
					pgstr = st.nextToken();
				}
				catch(NoSuchElementException e){
					pgstr = " ";
				}		
				int pgindex = pgstr.indexOf(".htm")	;
				if(pgindex != -1){
					pgstr = pgstr.substring(0,pgindex);
				}		
				try{
					hststr = st.nextToken();
				}
				catch(NoSuchElementException e){
					hststr = " ";
				}				
				int index = line.indexOf(hststr);
				String qstr = null;
				try{
					qstr = line.substring(index + (hststr.length())+1);
				}
				catch(StringIndexOutOfBoundsException  e){
					qstr = " ";
				}
				GAData gd = null;
				if(readmode == GLB.ACCESS){
					gd = new GAData(daystr,timestr,hststr,qstr,pgstr,null,null,null);
				}
				else if(readmode == GLB.REF){
					gd = new GAData(daystr,timestr,hststr,null,pgstr,qstr,null,null);
				}
				boss.addGadata(gd,readmode);	
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}		

	}// end of readDirData

	private void getLatestDate(String filename){
	
		File fp = new File((System.getProperty("user.dir")), filename);
		if(fp.exists() == false) return;
		String line = null;
		try{
			
			BufferedReader ds
					= new BufferedReader(new FileReader(fp));
			line = ds.readLine();
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
		Date retdate = null;
		if(line.length() == 0) retdate =  (new Date());
		else{
			try{
				long val = (new Long(line)).longValue();
				retdate =  new Date(val);
			}
			catch(NumberFormatException e){
				retdate =  (new Date());
			}
		}	
		boss.setLatestDate(retdate,readmode);
	}
}// end of class FileAnalyzer