//import java.lang.*;
import java.io.File;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ByteArrayOutputStream;
import java.io.BufferedWriter;
import java.io.RandomAccessFile;
import java.io.OutputStreamWriter;

import java.util.Vector;
import java.util.StringTokenizer;
import java.util.Date;
import java.util.TimeZone;
import java.util.Enumeration;
import java.util.NoSuchElementException;

import java.text.SimpleDateFormat;
import java.text.ParsePosition;
import java.awt.Rectangle;

public class FileAnalyzer{
	static String versionFileName = "version.sah";
	
	static String stateFileName = "state.txt";
	static String workFileName = "work_unit.txt";
	static String userFileName = "user_info.txt";	

	static String n2_stateFileName = "state.sah";
	static String n2_workFileName = "work_unit.sah";
	static String n2_userFileName = "user_info.sah";	
	
	static String dataDirFileName = "ss_dir_data.txt";
	static String pastDirFileName = "ss_pdir.txt";
	static String pastDataFileName = "ss_past_data.txt";
	static String currentDataFileName = "ss_current_data.txt";
	static String prefFileName = "ss_pref.txt";
	static String mxPrefFileName = "ss_mx_pref.txt";
	static String gdPrefFileName = "ss_gd_pref.txt";
	
	//static String dateFormatStr = "dd/MM/yyyy:HH:mm:ss";
	
	//////////checkFIle series/////////////////////////
	public static boolean checkPastFile(){
		return checkFile((System.getProperty("user.dir"))+pastDataFileName);
	}// end of checkPastFile
	public static boolean checkFile(String filename){
		File fp = new File(filename);
		return (fp.exists());
	}
	public static boolean checkCurrentFile(){
		return checkFile((System.getProperty("user.dir"))+currentDataFileName);
	}// end of checkCurrentFile	
	
	public static boolean checkStateFile(String dataDir){
		boolean flag;
		if(checkVerFile(dataDir)){
			flag = (new File(dataDir,n2_stateFileName)).exists();
		}
		else{
			flag = (new File(dataDir,stateFileName)).exists();
		}
		return flag;
	}// end
	
	public static boolean checkWorkFile(String dataDir){
		boolean flag;
		if(checkVerFile(dataDir)){	
			flag = (new File(dataDir,n2_workFileName)).exists();
		}
		else{
			flag = (new File(dataDir,workFileName)).exists();		
		}
		return flag;
	}// end	
	
	public static boolean checkVerFile(String dataDir){
		boolean flag = (new File(dataDir,versionFileName)).exists();
		return flag;
	}


//////// readData series////////////////////////////////////

	public static void readDirData(Vector vt){
//System.out.println("dir = "+(System.getProperty("user.dir")));		
		File fp = new File((System.getProperty("user.dir")),dataDirFileName);
		if(fp.exists() == false) return ;
		try{
			String line;
			BufferedReader ds
					= new BufferedReader(new FileReader(fp));
			while((line = ds.readLine())!= null){
				StringTokenizer st = new StringTokenizer(line);
				String shortName = st.nextToken();
				String dirName = line.substring(shortName.length()+1);
				vt.addElement(new DirData(shortName, dirName));	
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
	}// end of readDirData
	
	public static void readPastDataDir(Vector vt){
		File fp = new File((System.getProperty("user.dir")),pastDirFileName);
		if(fp.exists() == false) return ;
		try{
			String line;
			BufferedReader ds
					= new BufferedReader(new FileReader(fp));
			while((line = ds.readLine())!= null){
				StringTokenizer st = new StringTokenizer(line);
				String shortName = st.nextToken();
				String colorName = st.nextToken();
				String dirName = line.substring(shortName.length()+(colorName.length())+2);
				vt.addElement(new DirData(shortName,colorName, dirName));	
			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
	}// end of readDirData
	
	
	public static void FileoutDirData(Vector vt){
//System.out.println("dir = "+(System.getProperty("user.dir")));		
		File fp = new File((System.getProperty("user.dir")),dataDirFileName);
		PrintWriter outfp = null;
		try{
			outfp = new PrintWriter(new FileWriter(fp));
			for(int i = 0;i<vt.size();i++){
				DirData ddata = (DirData)(vt.elementAt(i));
				outfp.println(ddata.getShortName()+" " + ddata.getDir());
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();
	}// end of dirname
	
	public static void FileoutPastDataDir(Vector vt){
		PrintWriter outfp = null;
		File fp = new File((System.getProperty("user.dir")),pastDirFileName);		
		try{
			outfp = new PrintWriter(new FileWriter(fp));
			for(int i = 0;i<vt.size();i++){
				DirData ddata = (DirData)(vt.elementAt(i));
				outfp.println(ddata.getShortName()+" " +(ddata.getColorName())+" " + ddata.getDir());					
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();
	}// end of dirname
	
	/*public static void readCurrentData(Vector currentData, String dirName){
		if((new File(dirName,workFileName)).exists()) readWorkFile(currentData,dirName,workFileName);
		else if((new File(dirName,n2_workFileName)).exists()) readWorkFile(currentData,dirName,n2_workFileName);
		if( (new File(dirName,n2_stateFileName)).exists()) readStateFile(currentData,dirName,n2_stateFileName);
		else if( (new File(dirName,stateFileName)).exists()) readStateFile(currentData,dirName,stateFileName);
	}*/
	
	public static void readCurrentData(Vector currentData,String dirName){
		if(checkVerFile(dirName)){ // version 2 client
			if(checkWorkFile(dirName)) readWorkFile(currentData,dirName,n2_workFileName);
			if(checkStateFile(dirName)) readStateFile(currentData,dirName,n2_stateFileName);
		}
		else{
			if(checkWorkFile(dirName)) readWorkFile(currentData,dirName,workFileName);
			if(checkStateFile(dirName)) readStateFile(currentData,dirName,stateFileName);		
		}
	}
	
	private static void readWorkFile(Vector currentData, String dataDir,String readFileName){
			String filename = dataDir + readFileName;
	//System.out.println(filename);
			try{
				BufferedReader ds
					= new BufferedReader(new FileReader(filename));
				analyzeDataFile(ds,currentData);
				File tf = new File(filename);
				Date d = new Date(tf.lastModified());
				ResultData rdata = (ResultData)(currentData.elementAt(0));
				rdata.setStartedTime(d);
			}
			catch (IOException e){
				System.out.println("File error:"+e);
			}		
	}
	
	private static void readStateFile(Vector currentData, String dataDir,String readFileName){
		String filename = dataDir + readFileName;
		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(filename));
			boolean flag = analyzeDataFile(ds,currentData);
			if((flag == false)&&(currentData.size() > 0)){
//System.out.println("empty state");				
				ResultData rdata = (ResultData)(currentData.elementAt(0));	
				rdata.clearStateInfo();			
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
	}// end of readCurrentData
	
	public static void readSavedCurrentData(Vector currentData){
		File fp = new File((System.getProperty("user.dir")),currentDataFileName);
		if(fp.exists() == false) return;
		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			analyzeDataFile(ds,currentData);
		}
		catch (IOException e){
			//System.out.println("File error:"+e);
		}			
	}
	
	public static void fileOutCurrentData(Vector cv){
		File fp = new File((System.getProperty("user.dir")),currentDataFileName);		
		PrintWriter outfp = null;
		try{
			outfp = new PrintWriter(new FileWriter(fp));
			for(int i = 0;i<cv.size();i++){

				ResultData data = ((DirData)(cv.elementAt(i))).getProg();
//System.out.println(data);
				if(data == null) continue;
				outfp.println("!");
				outfp.println(data.getFileOutStr(true));				
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();		
	}//end of fileOutCurrentData
	
		
	public static void readPastFile(String filename, Vector pastData,String timeZoneID){
		File fp = null;
		if(filename.equals(pastDataFileName)){
			fp = new File((System.getProperty("user.dir")),filename);
		}
		else{
			fp = new File(filename);
		}
		if(fp.exists()== false) return;
		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			String line = ds.readLine();
			if(line == null) {
				System.out.println("wao error in past read file");
			}
			else{
				line.trim();
				boolean myPastFile = true;
				if(line.length() > 6){
//System.out.println("line = "+(line.substring(1,5)));	
					CSVTokenizer st = new CSVTokenizer(line);			
					if((st.nextToken()).equals("date")){
						myPastFile = false;
					}
				}
				BufferedReader dds
					= new BufferedReader(new FileReader(fp));			
				if(myPastFile){
					analyzeDataFile(dds,pastData);				
				}
				else{
					analyzeSetiLogFile(dds,pastData,timeZoneID);
				}
			}

		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
	}// end of readPastFile
	

	
	private static boolean analyzeDataFile(BufferedReader ds, Vector datavect)
	{
		boolean readFlag = false;
		try{
			ResultData rdata = null;

			// if there is already data in datavect , set it default
			if(datavect.size() > 0){
				rdata = (ResultData)(datavect.elementAt(0));
			}
			String line;
			
			while((line = ds.readLine())!= null){
//System.out.println("line = "+line);
				line = line.trim();
				if(line.length() == 0) continue;
				
				readFlag = true;
				String fstr;
				String sstr;
				
				int index = line.indexOf("=");
				if(index == -1){
					fstr = line;
					sstr = null;	
				}
				else{
					fstr = line.substring(0,index);
					sstr = line.substring(index+1);
				}
				//StringTokenizer st = new StringTokenizer(line,"\t\n\r= ",false);
				
				//fstr = st.nextToken();
				//fstr = fstr.trim();
//System.out.println("fst r = " + fstr+" " + (fstr.length()));

				if(fstr.equals("!") == true){
					rdata = new ResultData();
					datavect.addElement(rdata);
//System.out.println("added datea");
				}
				else if(fstr.equals("pos") == true){
					StringTokenizer st = new StringTokenizer(sstr);
					String str[]={null,null,null, null,null,null};
					for(int i = 0;i<6;i++){
						str[i] = st.nextToken();
					}
					rdata.setPosData(str);
				}
				else if(fstr.equals("end_pos") == true){
					StringTokenizer st = new StringTokenizer(sstr);
					String str[]={null,null,null, null,null,null};
					for(int i = 0;i<6;i++){
						str[i] = st.nextToken();
					}
					rdata.setEndPosData(str);
				}				
				else if(fstr.equals("start_ra")== true){
		//System.out.println("setr a data");
					//rdata.setRaDec(st.nextToken(),true);
					rdata.setRa(sstr);
				}
				else if(fstr.equals("start_dec") == true){
					//rdata.setRaDec(st.nextToken(),false);
					rdata.setDec(sstr);
				}
				else if(fstr.equals("end_ra")== true){
		//System.out.println("setr a data");
					//rdata.setRaDec(st.nextToken(),true);
					rdata.setEndRa(sstr);
				}
				else if(fstr.equals("end_dec") == true){
					//rdata.setRaDec(st.nextToken(),false);
					rdata.setEndDec(sstr);
				}				
				else if(fstr.equals("subband_base")==true){
					if(rdata == null){
						// throw something
						System.out.println("Wrong fromat, rdata for band is null");
					}
					//rdata.setBand(st.nextToken());
					rdata.setBand(sstr);
				}
				else if(fstr.equals("time_recorded") == true){
					if((sstr.indexOf("(") == -1)||(sstr.indexOf(")") == -1)){
						rdata.setTimeRecorded("ND");
					}
					else{
						String datestr = sstr.substring((sstr.indexOf("(")),(sstr.indexOf(")")+1));
						rdata.setTimeRecorded(datestr);
					}
				}
				else if(fstr.equals("name") == true){
					if(rdata == null) rdata = new ResultData();//for backward compatibility
					//rdata.setName(st.nextToken());
					rdata.setName(sstr);
				}
				else if(fstr.equals("bs_power") == true){
					//rdata.setBsPower(st.nextToken());
					rdata.setBsPower(sstr);
				}
				else if(fstr.equals("bs_score") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBsScore(sstr);
				}
				else if(fstr.equals("bs_bin") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBsBin(sstr);
				}	
				else if(fstr.equals("bs_fft_ind") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBsFftInd(sstr);
				}		
				else if(fstr.equals("bs_chirp_rate") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBsChirpRate(sstr);
				}		
				else if(fstr.equals("bs_fft_len") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBsFftLen(sstr);
				}														
				else if(fstr.equals("bg_power") == true){
					//rdata.setBgPower(st.nextToken());
					rdata.setBgPower(sstr);
				}
				else if(fstr.equals("bg_score") == true){
					//rdata.setBgScore(st.nextToken());
					rdata.setBgScore(sstr);
				}
				else if(fstr.equals("bg_chisq") == true){
					//rdata.setBgChisq(st.nextToken());
					rdata.setBgChisq(sstr);
				}
				else if(fstr.equals("bg_true_mean") == true){
					rdata.setBgTrueMean(sstr);
				}	
				else if(fstr.equals("bg_sigma") == true){
					rdata.setBgSigma(sstr);
				}				
				else if(fstr.equals("bg_bin") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBgBin(sstr);
				}	
				else if(fstr.equals("bg_fft_ind") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBgFftInd(sstr);
				}		
				else if(fstr.equals("bg_chirp_rate") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBgChirpRate(sstr);
				}		
				else if(fstr.equals("bg_fft_len") == true){
					//rdata.setBsScore(st.nextToken());
					rdata.setBgFftLen(sstr);
				}							
				else if(fstr.equals("cpu") == true){
					//rdata.setCpu(st.nextToken());
					rdata.setCpu(sstr);
				}
				else if(fstr.equals("prog") == true){
					rdata.setProg(sstr);
				}
				else if(fstr.equals("started_time") == true){
				 	SimpleDateFormat formatter
     						= new SimpleDateFormat ("dd/MM/yyyy:HH:mm:ss");
     					formatter.setTimeZone(TimeZone.getTimeZone("GMT"));					
					ParsePosition pos = new ParsePosition(0);

					Date adate = formatter.parse(sstr, pos); 
					rdata.setStartedTime(adate);
				}
				else if(fstr.equals("DataDirName") == true){
					rdata.setDirName(sstr);
				}
				else if(fstr.startsWith("bg_pot") == true){// support for Ver2.0
					StringTokenizer st = new StringTokenizer(fstr);
					String istr = "0";
					try{
						st.nextToken();
						istr = st.nextToken();

					}
					
					catch(NoSuchElementException e){
						istr = "0";
					}
					int potindex = 0;
					try{
						potindex = (Integer.valueOf(istr)).intValue();					
					}
					catch(NumberFormatException  e){
						potindex = 0;
					}
					double potvalue = 0.0;
					try{
						potvalue = (Double.valueOf(sstr)).doubleValue();
					}
					catch(NumberFormatException e){
						potvalue = 0.0;
					}
					rdata.setBgpot(potindex, potvalue);
				}				
				else if(fstr.equals("end_seti_header") == true){
					//System.out.println("found end mark");
					break;
				}
				else if(fstr.equals("num_positions") == true){
					// I am not sure about this one...
					//System.out.println("found end mark");
					break;
				}

			}
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
		try{
			ds.close();
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
		return readFlag;
	}// end of readfile
	

	private static void analyzeSetiLogFile(BufferedReader ds, Vector datavect,String timeZoneID)
	{
		String keys[] = {"date","name","start_ra","start_dec","end_ra", "end_dec","time_recorded",
						"subband_base",
						 "cpu","prog",
						 "bs_power","bs_score","bs_bin","bs_fft_ind","bs_chirp_rate","bs_fft_len",
						 "bg_score","bg_power","bg_chisq","bg_true_mean","bg_sigma","bg_bin",
						 "bg_fft_ind","bg_chirp_rate","bg_fft_len"};

		Vector refvect = new Vector();

		for(int i = 0;i<keys.length;i++) refvect.addElement(null);

		String line = null;
		try{
			line = ds.readLine();
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}			
		CSVTokenizer st = new CSVTokenizer(line);
		
		for(int index = 0; st.hasMoreTokens();index++){
			String str = st.nextToken();
//System.out.println("str = "+str + " " + index);
			for(int i =0;i<keys.length;i++){
				if(keys[i].equals(str)){
					try{
						refvect.setElementAt((new Integer(index)),i);
					}
					catch(ArrayIndexOutOfBoundsException  e){
						System.out.println("please let Goro Otsuo know this bug");
					}
				}
			}
		}

//for(int i = 0;i<refvect.size();i++){
//	System.out.println("ref = "+(Integer)(refvect.elementAt(i)));
//}

		try{	
			while((line = ds.readLine())!= null){		
				ResultData rdata = new ResultData();
				datavect.addElement(rdata);
				
				st = new CSVTokenizer(line);
				Vector strvect = new Vector();
				for(int index = 0;st.hasMoreTokens();index++){
					String str = st.nextToken();
					strvect.addElement(str);
//System.out.println("str = "+str + " " + index);					
				}
		
				Vector argvect = new Vector();
				for(int i = 0;i<refvect.size();i++){
					Integer indexOfKey = (Integer)(refvect.elementAt(i));
					if(indexOfKey != null){
						argvect.addElement(strvect.elementAt(indexOfKey.intValue()));
					}
					else{
						argvect.addElement(null);
					}
				}
/*for(int i =0;i<argvect.size();i++){
		System.out.println("arg = "+(String)(argvect.elementAt(i)));
}*/
			    Enumeration e = argvect.elements() ;
			    
			    /// should be 'date'0
				String str = (String)(e.nextElement());
				if(str != null){
				 	SimpleDateFormat formatter
							= new SimpleDateFormat ("yyyy.MM.dd HH:mm:ss");
						formatter.setTimeZone(TimeZone.getTimeZone(timeZoneID));			// need to be fixed		
					ParsePosition pos = new ParsePosition(0);
					Date adate = formatter.parse(str, pos); 
					rdata.setStartedTime(adate);	
				}		
				// name 1
				str = (String)(e.nextElement());
				if(str != null) rdata.setName(str);
				// start ra 2
				str = (String)(e.nextElement());
				if(str != null) rdata.setRa(str);
				
				// start_dec 3
				
				str = (String)(e.nextElement());
				if(str != null) rdata.setDec(str);
				
				// end ra 4
				str = (String)(e.nextElement());
				if(str != null) rdata.setEndRa(str);
				
				//end dec 5
				str = (String)(e.nextElement());
				if(str != null) rdata.setEndDec(str);
				
				//"time_recorded" 6
				str = (String)(e.nextElement());
				if(str != null){
					if((str.indexOf("(") == -1)||(str.indexOf(")") == -1)){
						rdata.setTimeRecorded("ND");
					}
					else{
						String datestr = str.substring((str.indexOf("(")),(str.indexOf(")")+1));
						rdata.setTimeRecorded(datestr);
					}	
				}			
				//rdata.setTimeRecorded(str);
				
				//"subband_base" 7
				str = (String)(e.nextElement());
				if(str != null) rdata.setBand(str);
				
				//"cpu" 8
				str = (String)(e.nextElement());
				if(str != null) rdata.setCpu(str);
				
				//"prog" 9
				str = (String)(e.nextElement());
				if(str != null) rdata.setProg(str);
				
				//"bs_power" 10
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsPower(str);
				
				//"bs_score" 11
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsScore(str);
				
				//"bs_bin" 12
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsBin(str);

				//"bs_fft_ind" 13
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsFftInd(str);

				//"bs_chirp_date" 14
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsChirpRate(str);

				//"bs_fft_len" 15
				str = (String)(e.nextElement());
				if(str != null) rdata.setBsFftLen(str);
				
				//////////////////////////////////////////
				
				//"bg_score" 16
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgScore(str);
				
				//"bg_power" 17
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgPower(str);
				
				//"bg_chisq" 18
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgChisq(str);
				
				//"bg_bin" 19
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgTrueMean(str);	
				
				//"bg_sigma" 20
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgSigma(str);	
				
				//"bg_bin" 21
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgBin(str);		
				
				//"bg_fft_ind" 22
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgFftInd(str);

				//"bg_chirp_date" 23
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgChirpRate(str);

				//"bg_fft_len" 24
				str = (String)(e.nextElement());
				if(str != null) rdata.setBgFftLen(str);										
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
	}
	

//	public static String stripPhr(String str){
//		return ((str.replace('"',' ')).trim());
//	}
	
	public static void addPastData(ResultData data){
		try{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PrintWriter ot =new PrintWriter( new BufferedWriter(new OutputStreamWriter(baos)));
			ot.println("!");
			ot.println(data.getFileOutStr(false));
//System.out.println(data.getFileOutStr(false));			
			ot.flush();
			byte[] bout = baos.toByteArray();
		
			RandomAccessFile rfp = new RandomAccessFile( new File((System.getProperty("user.dir")),pastDataFileName),"rw");
			rfp.seek(rfp.length());
			rfp.write(bout);
			rfp.close();			
		}
		catch(IOException e){
			System.out.println("FileAccessError " + e);
		}
	}// addPastData
	
	public static PrefValue  readPrefs()//updatePref, int progPref, int dispPref)
	{
		PrefValue ret = new PrefValue();
		
		ret.setUpdatePref(1);
		ret.setProgPref(1);
		ret.setDispPref(0);
		ret.setScrollPref(0);
		ret.setCLPref(1);
		ret.setBlinkPref(GLB.BLINK_RANDOM);
		ret.setCurrentTimeZoneID("JST");
		ret.setPaintPref("Standard");	
		ret.setAPaintPref("Circle");	
		ret.setAmPref("Auto");
		ret.setSkyPref(GLB.CONV);
		ret.setCstPref(GLB.MINIMUM);
		ret.setCstNamePref(GLB.MINIMUM);
		ret.setGridPref(1);
		ret.setGpPref(1);
		ret.setStarBrPref(5.5);
		ret.setSSizePref("Standard");
		ret.setAcPref(10);
		ret.setStarTracePref(1);
		ret.setAutoVanglePref(0);
		ret.setDatatablePref(0);
		ret.setGsdPref(0);
		ret.setTopPref(1);
		ret.setLogDataPref(1);
		
		File fp = new File((System.getProperty("user.dir")),prefFileName);
		if(fp.exists() == false) return ret;

		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			String line;
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
//System.out.println("line = "+line);
				StringTokenizer st = new StringTokenizer(line);
				
				String fstr = st.nextToken();
				fstr = fstr.trim();		
				if(fstr.equals("updatePref") == true){
					ret.setUpdatePref(( Integer.valueOf(st.nextToken())).intValue());
				}
				else if(fstr.equals("progPref") == true){
					ret.setProgPref(( Integer.valueOf(st.nextToken())).intValue());
				}
				else if(fstr.equals("dispPref") == true){
					ret.setDispPref(( Integer.valueOf(st.nextToken())).intValue());
				}
				else if(fstr.equals("clPref") == true){
					ret.setCLPref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("blinkPref") == true){
					ret.setBlinkPref(( Integer.valueOf(st.nextToken())).intValue());
				}									
				else if(fstr.equals("scrollPref") == true){
					ret.setScrollPref(( Integer.valueOf(st.nextToken())).intValue());
				}
				else if(fstr.equals("tzPref") == true){
					ret.setCurrentTimeZoneID((st.nextToken()));
				}
				else if(fstr.equals("paintPref") == true){
					ret.setPaintPref((st.nextToken()));
				}
				else if(fstr.equals("apaintPref") == true){
					ret.setAPaintPref((st.nextToken()));
				}			
				else if(fstr.equals("boundPref") == true){
					ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(),st.nextToken());
				}
				else if(fstr.equals("amPref") == true){
					ret.setAmPref(st.nextToken());
				}		
				else if(fstr.equals("skyPref") == true){
					ret.setSkyPref(( Integer.valueOf(st.nextToken())).intValue());
				}	
				else if(fstr.equals("cstPref") == true){
					ret.setCstPref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("cstNamePref") == true){
					ret.setCstNamePref(( Integer.valueOf(st.nextToken())).intValue());
				}	
				else if(fstr.equals("gridPref") == true){
					ret.setGridPref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("gpPref") == true){
					ret.setGpPref(( Integer.valueOf(st.nextToken())).intValue());
				}					
				else if(fstr.equals("starBrPref") == true){
					ret.setStarBrPref(( Double.valueOf(st.nextToken())).doubleValue());
				}	
				else if(fstr.equals("acPref") == true){
					ret.setAcPref(( Integer.valueOf(st.nextToken())).intValue());
				}						
				else if(fstr.equals("ssizePref") == true){
					ret.setSSizePref(st.nextToken());
				}			
				else if(fstr.equals("starTracePref") == true){
					ret.setStarTracePref(( Integer.valueOf(st.nextToken())).intValue());
				}			
				else if(fstr.equals("datatablePref") == true){
					ret.setDatatablePref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("gsdPref") == true){
					ret.setGsdPref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("topPref") == true){
					ret.setTopPref(( Integer.valueOf(st.nextToken())).intValue());
				}		
				else if(fstr.equals("logDataPref") == true){
					ret.setLogDataPref(( Integer.valueOf(st.nextToken())).intValue());
				}																																				
			}// end of while
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
		return ret;
	}//readPrefs
	
	public static void fileOutPrefs(PrefValue val){
		PrintWriter outfp = null;
		File fp = new File((System.getProperty("user.dir")),prefFileName);		
		try{
			outfp = new PrintWriter(new FileWriter(fp));
			outfp.println("updatePref "+val.getUpdatePref());
			outfp.println("progPref "+val.getProgPref());
			outfp.println("dispPref "+val.getDispPref());
			outfp.println("scrollPref " + val.getScrollPref());
			outfp.println("clPref " + val.getCLPref());
			outfp.println("blinkPref " + val.getBlinkPref());			
			outfp.println("tzPref "+val.getCurrentTimeZoneID());
			outfp.println("paintPref "+val.getPaintPref());
			outfp.println("apaintPref "+val.getAPaintPref());			
			outfp.println("boundPref " + val.getBoundStr());
			outfp.println("amPref " + val.getAmPref());	
			outfp.println("skyPref " + val.getSkyPref());	
			outfp.println("cstPref " + val.getCstPref());	
			outfp.println("cstNamePref " + val.getCstNamePref());	
			outfp.println("gridPref " + val.getGridPref());	
			outfp.println("gpPref " + val.getGpPref());					
			outfp.println("starBrPref " + val.getStarBrPref());	
			outfp.println("acPref " + val.getAcPref());
			outfp.println("ssizePref " + val.getSSizePref());	
			outfp.println("starTracePref " + val.getStarTracePref());		
			outfp.println("datatablePref " + val.getDatatablePref());	
			outfp.println("gsdPref " + val.getGsdPref());	
			outfp.println("topPref " + val.getTopPref());
			outfp.println("logDataPref " + val.getLogDataPref());										
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();		
	}//end of fileOutCurrentData
	
	public static String getUserString(String dirName){
		String filename = dirName + userFileName;
		File fp = new File(filename);
		
		/////////////// to process ver 2 data...
		if(fp.exists() == false){
			filename = dirName + n2_userFileName;
			fp = new File(filename);
			if(fp.exists() == false) return("");
		} 
		
		String ret = "";
//System.out.println(filename);
		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			 String line;
			 int dataunitno = 0;
			 double cputime = 0.0;
			while(( line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				
				String fstr;
				String sstr;
				
				int index = line.indexOf("=");
				if(index == -1){
					fstr = line;
					sstr = null;	
				}
				else{
					fstr = line.substring(0,index);
					sstr = line.substring(index+1);
				}
				if(fstr.equals("name") == true){
					ret = ret + "Name: " + sstr + "\n";
				}
				else if(fstr.equals("nwus") == true){
					ret = ret + "Work units sent: " + sstr + "\n";
				}
				else if(fstr.equals("nresults") == true){
					ret = ret + "Results received: " + sstr + "\n";
					dataunitno = (Integer.valueOf(sstr).intValue());
				}
				else if(fstr.equals("total_cpu") == true){
					cputime =  (Double.valueOf(sstr)).doubleValue();
					ret = ret + "Total CPU time: " +(ResultData.genHMSString(cputime)) ;
					if(cputime >= (24*3600*37)){
						String str = DoubleFormat.toString((cputime/(24*3600*365)),2);
						ret = ret + " ("+str+ " years )";
					}
					ret = ret + "\n";
				}
			}
			if((dataunitno != 0)&&(cputime != 0)){
				ret = ret + "Average CPU time per work unit: " + (ResultData.genHMSString(cputime/dataunitno))+"\n";
			}			
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}			

		return ret;
	}
	
	static void exportCSVFile(String fileName,Vector cvect,int mode){
		PrintWriter outfp = null;
		
		try{
			outfp = new PrintWriter(new FileWriter(fileName));
			String sep= "";
			if(mode == GLB.CSV){
				sep = ",";
			}
			else if(mode == GLB.TAB){
				sep = "\t";
			}
			else if(mode == GLB.HTM){
				sep = "</TD><TD>";
				outfp.println("<HTML>");
				outfp.println("<HEAD>");
				outfp.println("<TITLE>SETI@home data</TITLE>");
				outfp.println("<BODY>");
				outfp.println("<TABLE BORDER=1>");

			}

			for(int i = 0;i<cvect.size();i++){
				Vector svect = (Vector)(cvect.elementAt(i));
				if(mode == GLB.HTM){
					if(i == 0){
						outfp.print("<TR><TH>");					
					}
					else{
						outfp.print("<TR><TD>");
					}
				}
				for(int j = 0;j<svect.size();j++){
					String str = (String)(svect.elementAt(j));
					if(j == (svect.size()-1)){
						outfp.print(str);
					}
					else if((i == 0)&&(mode == GLB.HTM)){
						outfp.print(str + "</TH><TH>");
					}
					else{
						outfp.print(str + sep);						
					}
				}
				if(mode == GLB.HTM){
					if(i == 0){
						outfp.println("</TH></TR>");
					}
					else{
						outfp.println("</TD></TR>");
					}
				}
				else{
					outfp.println();
				}
			}
			if(mode == GLB.HTM){
				outfp.println("</TABLE>");
				outfp.println("</BODY>");
				outfp.println("</HTML>");
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();			
		
	}
	
	public static MxPrefValue  readMxPrefs()//updatePref, int progPref, int dispPref)
	{
		MxPrefValue ret = new MxPrefValue();
		
		ret.setSortTitle("No");
		ret.setSortMode(GLBX.ASC);
		ret.setBound(new Rectangle(50,50,600,400));
		ret.addTitle(GLBX.NO_TITLE);
		for(int i = 0;i<GLBX.TITLE.length;i++){
			ret.addTitle(GLBX.TITLE[i]);	
		}
		File fp = new File((System.getProperty("user.dir")),mxPrefFileName);
		if(fp.exists() == false) return ret;

		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			String line;
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				int index = line.indexOf("=");
				String fstr = line.substring(0,index);
				String sstr = line.substring(index+1);
				
				if(fstr.equals("sortTitle") == true){
					ret.setSortTitle(sstr);
				}
				else if(fstr.equals("sortmode") == true){
					ret.setSortMode(( Integer.valueOf(sstr)).intValue());
				}
				else if(fstr.equals("boundPref") == true){
					StringTokenizer st = new StringTokenizer(sstr);
					ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(),st.nextToken());
				}
				/*else if(fstr.equals("hiddenTitle") == true){
					StringTokenizer st = new StringTokenizer(sstr,"$");
					while(st.hasMoreTokens()){
						ret.addHiddenTitle(st.nextToken());	
					}	
				}*/
				else if(fstr.equals("title") == true){
					ret.clearTitle();					
					StringTokenizer st = new StringTokenizer(sstr,"$");

					while(st.hasMoreTokens()){
						ret.addTitle(st.nextToken());	
					}	
				}				
				else if(fstr.equals("cutcond") == true){
					ret.addCutCondStr(sstr);
				}
			}// end of while
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
		return ret;
	}//readPrefs
	
	public static void fileOutMxPrefs(MxPrefValue val){
		File fp = new File((System.getProperty("user.dir")),mxPrefFileName);		
		PrintWriter outfp = null;
		try{
			outfp = new PrintWriter(new FileWriter(fp));
			outfp.println("sortTitle="+val.getSortTitle());
			outfp.println("sortmode="+val.getSortMode());	
			outfp.println("boundPref=" + val.getBoundStr());
			//outfp.println("hiddenTitle="+val.getHiddenTitleStr());
			outfp.println("title="+val.getTitleStr());			
			Vector condvect = val.getCondVect();
			for(int i = 0;i<condvect.size();i++){
				outfp.println("cutcond="+(String)(condvect.elementAt(i)));
			}
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();		
	}//end of fileOutCurrentData
	
//////////////////////////
//////// GDPref 
////////////////////////////
	
	public static GDPrefValue  readGDPrefs()//updatePref, int progPref, int dispPref)
	{
		GDPrefValue ret = new GDPrefValue();

		ret.setBound(new Rectangle(50,50,400,400));
		ret.setClPref(1);
		ret.setArPref(1);
		ret.setHiCurPref(1);
		ret.setBlinkPref(0);
		ret.setSnowPref(0);
		
		File fp = new File((System.getProperty("user.dir")),gdPrefFileName);
		if(fp.exists() == false) return ret;

		try{
			BufferedReader ds
				= new BufferedReader(new FileReader(fp));
			String line;
			while((line = ds.readLine())!= null){
				line = line.trim();
				if(line.length() == 0) continue;
				int index = line.indexOf("=");
				String fstr = line.substring(0,index);
				String sstr = line.substring(index+1);
				
				if(fstr.equals("boundPref") == true){
					StringTokenizer st = new StringTokenizer(sstr);
					ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(),st.nextToken());
				}
				else if(fstr.equals("clPref") == true){
					ret.setClPref(( Integer.valueOf(sstr)).intValue());				
				}
				else if(fstr.equals("arPref") == true){
					ret.setArPref(( Integer.valueOf(sstr)).intValue());				
				}			
				else if(fstr.equals("hiCurPref") == true){
					ret.setHiCurPref(( Integer.valueOf(sstr)).intValue());				
				}	
				else if(fstr.equals("blinkPref") == true){
					ret.setBlinkPref(( Integer.valueOf(sstr)).intValue());				
				}		
				else if(fstr.equals("snowPref") == true){
					ret.setSnowPref(( Integer.valueOf(sstr)).intValue());				
				}												
			}// end of while
		}// end of try
		catch (IOException e){
			System.out.println("File error:"+e);
		}	
		return ret;
	}//readPrefs	
	
	public static void fileOutGDPrefs(GDPrefValue val){
		File fp = new File((System.getProperty("user.dir")),gdPrefFileName);		
		PrintWriter outfp = null;
		try{
			outfp = new PrintWriter(new FileWriter(fp));

			outfp.println("boundPref=" + val.getBoundStr());
			outfp.println("clPref=" + val.getClPref());	
			outfp.println("arPref=" + val.getArPref());			
			outfp.println("hiCurPref=" + val.getHiCurPref());		
			outfp.println("blinkPref=" + val.getBlinkPref());		
			outfp.println("snowPref=" + val.getSnowPref());									
		}
		catch (IOException e){
			System.out.println("File error:"+e);
		}		
		outfp.close();		
	}//end of fileOutCurrentData	
}// end of class FileAnalyzer