//import java.lang.*;

class DoubleFormat {
	public static String toString(double inValue, int precision) {
		return toString(inValue, precision, false);
	}

	public static String toString (double inValue, int precision, boolean use_comma)
	 {
		 boolean trailing_zero;
		 double absval= Math.abs(inValue); // get positive portion

		 if (precision < 0) {
         		 precision = -precision;
         		 trailing_zero = false;
       	 }
     		 else{
        		trailing_zero = true;
        	}
		String signStr = "";

		 if (inValue < 0) signStr= "-";

		 long intDigit = (long) Math.floor(absval); // get integer part

		 String intDigitStr = String.valueOf(intDigit);

		 if (use_comma) {
			int intDigitStrLen= intDigitStr.length();
			
			int dig_index= (intDigitStrLen - 1) % 3;
			dig_index++;
			String intCommaDigitStr = intDigitStr.substring(0,dig_index);
	
			while (dig_index < intDigitStrLen) {
	            		intCommaDigitStr += "," +
	              	intDigitStr.substring(dig_index, dig_index+3);
				dig_index+= 3;
			}
			intDigitStr= intCommaDigitStr;
		}// end of if

     		String precDigitStr= "";

     		long precDigit= Math.round((absval - intDigit) *  Math.pow(10.0, precision));

     		precDigitStr= String.valueOf(precDigit);

     		// pad zeros between decimal and precision digits
    		 String zeroFilling= "";

     		for (int i= 0; i < precision-precDigitStr.length(); i++){
       		zeroFilling += "0";
       	}

		precDigitStr= zeroFilling + precDigitStr;

		if (!trailing_zero) {
			int lastZero;

			for (lastZero = precDigitStr.length() - 1;  lastZero >= 0; lastZero--){
				if (precDigitStr.charAt(lastZero)!= '0') break;
	              }
			 precDigitStr= precDigitStr.substring(0, lastZero + 1);
		}

		if (precDigitStr.equals(""))
			return signStr + intDigitStr;
		     else
		         return signStr + intDigitStr + "." + precDigitStr;
	}// end of method
    
  }// end of class

