/*
	A basic extension of the java.awt.Dialog class
 */

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.FlowLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;

public class ConfirmDialog extends Dialog {
	java.awt.Label commentLabel;
	java.awt.Button okButton;
	java.awt.Button cancelButton;
	SETISupport boss;
	
	boolean fComponentsAdjusted = false;
	
	public ConfirmDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		boss = (SETISupport)parent;
		
		setBackground(Color.black);
		
		setLayout(new BorderLayout(0,0));
		setSize(250,80);
		commentLabel = new java.awt.Label("Are you sure to turn logging off ?");
		commentLabel.setBackground(Color.black);		
		commentLabel.setForeground(Color.cyan);	
		add("Center",commentLabel);
		
		
		java.awt.Panel sidePanel = new java.awt.Panel();
		sidePanel.setLayout(new FlowLayout(FlowLayout.CENTER,3,3));
		sidePanel.setBackground(Color.black);				
		add("South",sidePanel);		
		okButton = new java.awt.Button("OK");
		okButton.setSize(70,30);
		okButton.setForeground(Color.black);		
		okButton.setBackground(Color.white);		 		
		sidePanel.add(okButton);
		
		cancelButton = new java.awt.Button("Cancel");
		cancelButton.setSize(70,30);
		cancelButton.setForeground(Color.black);		
		cancelButton.setBackground(Color.white);		 		
		sidePanel.add(cancelButton);
				
		setTitle("Confirmation");
		setResizable(false);
		//}}
		validate();
		doLayout();
		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);
		cancelButton.addActionListener(lSymAction);		
		//}}

	}

	public ConfirmDialog(Frame parent, String title, boolean modal) 
	{
		this(parent, modal);
		setTitle(title);
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		
		super.addNotify();
		
		// Only do this once.
		if (fComponentsAdjusted)
			return;
		
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + getSize().width, getInsets().top + getInsets().bottom + getSize().height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		
		// Used for addNotify check.
		fComponentsAdjusted = true;
	}

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			Rectangle bounds = getParent().getBounds();
			Rectangle abounds = getBounds();
	
			setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
				 bounds.y + (bounds.height - abounds.height)/2);
		}
		super.setVisible(b);
	}



	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ConfirmDialog.this)
				AboutDialog_WindowClosing(event);
		}
	}

	void AboutDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_Clicked(event);
			else if(object == cancelButton)
				cancelButton_Clicked(event);
		}
	}

	void okButton_Clicked(java.awt.event.ActionEvent event)
	{
		boss.miLogDataAction(false);
        dispose();
	}
	
	void cancelButton_Clicked(java.awt.event.ActionEvent event)
	{
		boss.miLogDataAction(true);
        dispose();
	}
}
