import java.awt.Dialog;
import java.awt.TextField;
import java.awt.Label;
import java.awt.Button;
import java.awt.Button;
import java.awt.Button ;
import java.awt.Choice ;
import java.awt.Checkbox ;
import java.awt.Frame;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;

public class CondInputDialog extends Dialog
{
	TextField valueField;
	java.awt.Label nameLabel;
	java.awt.Button okButton;
	java.awt.Button delButton;
	java.awt.Button cancelButton;
	java.awt.Choice relChoice;
	java.awt.Checkbox chkbox;
	CutCond cond;
	int relindex;
	MatrixViewer boss;
    // Used for addNotify check.
	boolean fComponentsAdjusted = false;
	
	public CondInputDialog(Frame parent, String title){
		this(parent,title,null,true,true);	
	}
	public CondInputDialog(Frame parent, String title,String condstr,boolean state, boolean flag)
	{
		super(parent, title,true);
	//System.out.println("donc = " + condstr);
		boss = (MatrixViewer) parent;
		
		if(condstr.equals(GLBX.NO_COND_STR)){
			cond = null;
		}
		else{
			cond = new CutCond(condstr);
			cond.setState(state);
		}
		
		setLayout(new BorderLayout(0,0));
		setSize(220, 70);
		setBackground(Color.white);
		

		
		java.awt.Panel uppanel = new java.awt.Panel();
		uppanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		add("Center",uppanel);
		
		chkbox = new java.awt.Checkbox();		
		chkbox.setState(state);
		uppanel.add(chkbox);
		
		nameLabel = new Label("Data");
		uppanel.add(nameLabel);

		relChoice = new java.awt.Choice();
		uppanel.add(relChoice);
		if(flag){
			for(int i = 0;i<GLBX.COND_STR.length;i++){
				relChoice.addItem(GLBX.COND_STR[i]);
			}
		}
		else{
			relChoice.addItem(GLBX.COND_STR[3]);	
		}
		
		valueField = new TextField(5);
		uppanel.add(valueField);


				
		java.awt.Panel lupanel = new java.awt.Panel();
		lupanel.setLayout(new FlowLayout(FlowLayout.CENTER));
		add("South",lupanel);	
			
		okButton = new Button("OK");
		lupanel.add(okButton);
		delButton = new Button("Delete");
		lupanel.add(delButton);
		cancelButton = new Button("Cancel");
		lupanel.add(cancelButton);
		

		
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);
		delButton.addActionListener(lSymAction);
		cancelButton.addActionListener(lSymAction);
		
		SymText aSymText = new SymText();
		valueField.addTextListener(aSymText);
		
		MSymItem lSymItem = new MSymItem();
		relChoice.addItemListener(lSymItem);
		//chkbox.addItemListener(lSymItem);
		

		setItems();
	}


	// Add a constructor for Interactions (ignoring modal)
	public CondInputDialog(Frame parent, boolean modal)
	{
		this(parent,"title");
	}

	// Add a constructor for Interactions (ignoring modal)
	public CondInputDialog(Frame parent, String title, boolean modal)
	{
		this(parent, title);
	}



	public void addNotify()
	{
	    // Record the size of the window prior to calling parents addNotify.
	    Dimension d = getSize();
	    
		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + d.width, getInsets().top + getInsets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}
	
	private void setItems(){
//System.out.println(cond);
		if(cond == null){
			String selectedStr = relChoice.getItem(0);// default
//System.out.println(selectedStr+chkbox);
			for(int i = 0;i<GLBX.COND_STR.length;i++){
				if(selectedStr.equals(GLBX.COND_STR[i])){
					relindex = i;
					break;
				}	
			}
			chkbox.setState(true);
		}
		else{
			String str = cond.getValStr();
			valueField.setText(str);
			//valueField.setCaretPosition(str.length());			
			relindex = cond.getRelation();
			if((relindex >= 0)&&(relChoice.getItemCount() > 1)){
				relChoice.select(relindex);	
			}
			chkbox.setState(cond.getState());
		}
	}


	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == this)
				InputDialog_WindowClosing(event);
		}
	}

	void InputDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_Clicked(event);
			else if(object == delButton)
				delButton_Clicked(event);
			else if(object == cancelButton)
				cancelButton_Clicked(event);
				
		}
	}


	
	void okButton_Clicked(java.awt.event.ActionEvent event)
	{
		String str = valueField.getText();
		str = str.trim();
		if(str.length() == 0) return;
		boss.setCondition(relindex,valueField.getText(),chkbox.getState());
              dispose();
	}
	void delButton_Clicked(java.awt.event.ActionEvent event)
	{
		boss.delCondition();
              dispose();
	}
	void cancelButton_Clicked(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Clicked from okButton Hide the Dialog
                dispose();
		//}}
	}
	
	class MSymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
			Object object = event.getSource();
			if (object == relChoice)
				relChoice_ItemStateChanged(event);
		}
	}
	
	void relChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		relindex = relChoice.getSelectedIndex();
		//System.out.println("relchocie " + index);
	}	
	
	class SymText implements java.awt.event.TextListener
	{
		public void textValueChanged(java.awt.event.TextEvent event)
		{
			Object object = event.getSource();
			if ((object == valueField)&&(event.getID() == java.awt.event.TextEvent.TEXT_VALUE_CHANGED))
				valueFileld_Kicked(event);
		}
	}	
	void valueFileld_Kicked(java.awt.event.TextEvent event)
	{
		StringBuffer buf = new StringBuffer();
		String str = valueField.getText();
		boolean flag  = false;
		//for(int i = str.length() -1;i>=0;i--){
		for(int i =0;i<str.length();i++){
			char tch = str.charAt(i);
			if((Character.isDigit(tch) == false)&&(tch != '-')&&(tch != '.')){
				flag = true;
				continue;
			}
			buf.append(tch);
		}		
		if(flag){
			str = buf.toString();
			valueField.setText(str);
			valueField.setCaretPosition(str.length());
		}
	}
}
