package jp.ac.wakhok.tomoharu.csv;

import java.util.Vector;
import java.util.Enumeration;

/**
 * CSV`1s̃f[^eێNXB
 * CSV`ւ̏oAo̍ۂ̃GNH[g̎wA
 * ڂ̒ǉȂǂ\łB
 *
 * @version 1.0.1 (1999.4.13)
 * @author TAMURA Kent <kent@muraoka.info.waseda.ac.jp>
 * @author ANDOH Tomoharu <tomoharu@wakhok.ac.jp>
 */

public class CSVLine {
	public static final String copyright =
			"Copyright 1997 TAMURA Kent" + "\n" +
			"Copyright 1999 ANDOH Tomoharu";
	private Vector items;

	/**
	 * CSVLine ̃CX^X쐬B
	 */
	public CSVLine() {
		items = new Vector();
	}

	/**
	 * Ŏw肳ꂽAɒǉB
	 *
	 * @param item ǉ镶
	 */
	public void addItem(String item) {
		addItem(item, false);
	}

	/**
	 * Ŏw肳ꂽAɒǉB
	 * CSV`̃f[^Ƃďo͂ƂA̍ڂI
	 * GNH[g邩ǂɂĎw肷B
	 *
	 * @param item ǉ镶
	 * @param enquote trueƁAIɃGNH[gB
	 */
	public void addItem(String item, boolean enquote) {
		items.addElement(new Element(item, enquote));
	}

	/**
	 * Ŏw肳ꂽCSVTokenizerɊ܂܂邷ׂĂ̍ڂA
	 * ɒǉB
	 *
	 * @param ct CSVTokenizer̃CX^XBɊ܂܂Ă鍀
	 * ́AɒǉB
	 * @see jp.ac.wakhok.tomoharu.csv.CSVTokenizer
	 */
	public void addItem(CSVTokenizer ct) {
		while (ct.hasMoreTokens()) {
			String item = ct.nextToken();
			items.addElement(new Element(item));
		}
	}

	/**
	 * 1sCSV`̃f[^ԂB
	 *
	 * @return PsCSV`̃f[^
	 */
	public String getLine() {
		StringBuffer list = new StringBuffer();
		for (int n = 0; n < items.size(); n ++) {
			Element element = (Element)items.elementAt(n);
			String item = element.getItem();
			list.append(item);
			if (items.size() - 1 != n) {
				list.append(',');
			}
		}
		return new String(list);
	}

	/**
	 * 1s̍ڐԂB
	 *
	 * @return CSVLineɊ܂ł鍀ڂ̐
	 */
	public int size() {
		return items.size();
	}

	/**
	 * nԖڂ̍ڂ String ŕԂB
	 *
	 * @param n ڂ̔ԍ [0 ` size()-1]
	 * @return nԖڂ̕BGNH[g͂ȂB
	 */
	public String getItem(int n) {
		Element element = (Element)items.elementAt(n);
		return element.getRawItem();
    }

	/**
	 * nԖڂ̍ڂ폜B
	 *
	 * @param n ڂ̔ԍ [0 ` size()-1]
	 */
	public void removeItem(int n) {
		items.removeElementAt(n);
	}

	/**
	 * CSVLine̍ڂ̃XgԂB
	 *
	 * @return CSVLineɊ܂܂Ă镶̃Xg
	 * @see java.util.Enumeration
	 */
	public Enumeration elements() {
		return new CSVLineEnumerator(items);
	}

	/**
	 * CSVLineɊ܂܂邻ꂼ̍ڂێCi[NXB
	 */
	class Element {
		private String item;
		private boolean enquote;

		Element(String item) {
			this(item, false);
		}

		Element(String item, boolean enquote) {
			this.item = item;
			this.enquote = enquote;
		}

		/**
		 * w肳Ă΁AGNH[gsB
		 */
		public String getItem() {
			return enquote(item, enquote);
		}

		/**
		 * GNH[g͈؂ȂB
		 */
		public String getRawItem() {
			return item;
		}
	}

	/**
	 * elements()\bhŕԂ EnumerationNX
	 */
	class CSVLineEnumerator implements Enumeration {
		private Vector items;
		private int n;

		CSVLineEnumerator(Vector items) {
			this.items = items;
			n = 0;
		}

		public Object nextElement() {
			n ++;
			Element element = (Element)items.elementAt(n-1);
			return element.getRawItem();
		}

		public boolean hasMoreElements() {
			return n < items.size();
		}
	}

	/**
	 * ̕ item  CSV ŏo͂ł悤ɉH
	 * ԂB<br>
	 * item  "  , ܂łƂɂ item Ŝ " ň͂
	 * iGNH[gjA"  "" ɒuB܂"  , ̂ǂ
	 * ܂łȂƂ́Aitem ̂܂ܕԂB<br>
	 *
	 * @param item 
	 * @return item 
	 */
    public static String enquote(String item) {
		return enquote(item, false);
	}

	/**
	 * ̕ item  CSV ŏo͂ł悤ɉH
	 * ԂB<br>
	 * enquote  true ̂Ƃ́AIɃGNH[gB܂A
	 * item  " ň͂ԂB<br>
	 * false ̂Ƃ́AGNH[g邩ǂ́Aitem ɂB
	 * item  "  , ܂łƂɂ item Ŝ " ň͂
	 * iGNH[gjA"  "" ɒuB܂"  , ̂ǂ
	 * ܂łȂƂ́Aitem ̂܂ܕԂB<br>
	 * item A܂蒷[̕񂾂ꍇA
	 * ̂̕܂ܕԂB
	 *
	 * @param item 
	 * @param enquote trueȂ狭IɃGNH[g
	 * @return item 
	 */
	public static String enquote(String item, boolean enquote) {
		if (item.length() == 0) {
			return item;
		}
		if (item.indexOf('"') < 0 && item.indexOf(',') < 0 && enquote == false) {
			return item;
        }

		// StringBuffer̃TCÝAłُȏꍇz肵B
		//  """"" GNH[gďo͂悤ȂƂ̂ƁB

		StringBuffer sb = new StringBuffer(item.length() * 2 + 2);
		sb.append('"');
		for (int ind = 0; ind < item.length(); ind ++) {
			char ch = item.charAt(ind);
			if ('"' == ch) {
				sb.append("\"\"");
			} else {
				sb.append(ch);
			}
		}
		sb.append('"');

		return new String(sb);
	}
}
