
public class BlinkRing{

	static double MAX_DELTA = Math.PI*0.7;
	double ra;
	double de;
	double val;
	
	BlinkRing(DPos pt){
		ra = pt.getRa();
		de = pt.getDe();
		val = 0.0;
	}
	
	public boolean liveP(){
		if(val >= Math.PI) return false;
		else return true;
	}
	public void expand(){
		val += (Math.PI/10);
	}
	public int getLevel(DPos pt){
		double angle = (pt.getPoint()).getAngle(ra,de);
		if(angle > val) return SkyCanvas.maxCircleLevel;
		double delta = val - angle;
		if(delta > MAX_DELTA) return SkyCanvas.maxCircleLevel;
		else{
			return (int)(SkyCanvas.maxCircleLevel*(delta/MAX_DELTA));
		}
	}

}// end of class BlinkRing