/*
	A basic extension of the java.awt.Dialog class
 */

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Color;
import java.awt.BorderLayout;
import java.awt.TextArea;
import java.awt.FlowLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;

public class AboutDialog extends Dialog {

	public AboutDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.

		//{{INIT_CONTROLS
		setBackground(Color.black);
		
		setLayout(new BorderLayout(0,0));
		setSize(250,150);
		commentText = new java.awt.TextArea("SETI@Support Ver0.74c\n",30,3,TextArea.SCROLLBARS_VERTICAL_ONLY );
		
		commentText.append("by Goro Otsubo PFA01521@nifty.ne.jp\n");
		commentText.append("http://member.nifty.ne.jp/GOtsubo/\n");
		commentText.append("\n");
		commentText.append("SETI@Support is free. Please use SETI@Support at your own risk. \n");
		commentText.append("Goro Otsubo can not be responsible for any lost work units or for any expense, damage or loss caused by your use of SETI@Support\n");
		commentText.append("Constellation data by Chris Dolan (dolan@astro.wisc.edu). Thanks!");
		commentText.setEditable(false);
		commentText.setForeground(Color.cyan);
		commentText.setBackground(Color.black);		
		add("Center",commentText);
		
		
		java.awt.Panel sidePanel = new java.awt.Panel();
		sidePanel.setLayout(new FlowLayout(FlowLayout.CENTER,3,3));
		sidePanel.setBackground(Color.black);				
		add("South",sidePanel);		
		okButton = new java.awt.Button("OK");
		okButton.setSize(70,30);
		okButton.setForeground(Color.black);		
		okButton.setBackground(Color.white);		 		
		sidePanel.add(okButton);
		setTitle("About SETI@Support");
		setResizable(false);
		//}}
		validate();
		doLayout();
		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);
		//}}

	}

	public AboutDialog(Frame parent, String title, boolean modal) 
	{
		this(parent, modal);
		setTitle(title);
	}

	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		
		super.addNotify();
		
		// Only do this once.
		if (fComponentsAdjusted)
			return;
		
		// Adjust components according to the insets
		setSize(getInsets().left + getInsets().right + getSize().width, getInsets().top + getInsets().bottom + getSize().height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(getInsets().left, getInsets().top);
			components[i].setLocation(p);
		}
		
		// Used for addNotify check.
		fComponentsAdjusted = true;
	}

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			Rectangle bounds = getParent().getBounds();
			Rectangle abounds = getBounds();
	
			setLocation(bounds.x + (bounds.width - abounds.width)/ 2,
				 bounds.y + (bounds.height - abounds.height)/2);
		}
		super.setVisible(b);
	}

	//{{DECLARE_CONTROLS
	java.awt.TextArea commentText;
	java.awt.Button okButton;
	//}}

    // Used for addNotify redundency check.
	boolean fComponentsAdjusted = false;

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == AboutDialog.this)
				AboutDialog_WindowClosing(event);
		}
	}

	void AboutDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_Clicked(event);
		}
	}

	void okButton_Clicked(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Clicked from okButton Hide the Dialog
                dispose();
		//}}
	}
}
