/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

class TDPoint {
    double ra;
    double de;
    double x;
    double y;
    double z;

    TDPoint() {
        this.ra = 0.0;
        this.de = 0.0;
        this.setXYZ();
    }

    TDPoint(double ravalue, double devalue) {
        this.ra = ravalue;
        this.de = devalue;
        this.setXYZ();
    }

    TDPoint(int radeg, int dedeg) {
        this.ra = (double)radeg * Math.PI / 180.0;
        this.de = (double)dedeg * Math.PI / 180.0;
        this.setXYZ();
    }

    TDPoint(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
        this.setRaDe();
    }

    TDPoint(TDPoint ps) {
        this.x = ps.getX();
        this.y = ps.getY();
        this.z = ps.getZ();
        this.setRaDe();
    }

    private void setXYZ() {
        this.x = Math.cos(this.de) * Math.cos(this.ra);
        this.y = Math.cos(this.de) * Math.sin(this.ra);
        this.z = Math.sin(this.de);
    }

    private void setRaDe() {
        double len = this.length();
        this.de = Math.asin(this.z / len);
        this.ra = Math.atan2(this.y, this.x);
    }

    boolean isNull() {
        return this.ra == 0.0 && this.de == 0.0;
    }

    double getRa() {
        return this.ra;
    }

    double getDe() {
        return this.de;
    }

    public void setRa(double val) {
        this.ra = val;
        this.setXYZ();
    }

    public void setDe(double val) {
        this.de = val;
        this.setXYZ();
    }

    double getX() {
        return this.x;
    }

    double getY() {
        return this.y;
    }

    double getZ() {
        return this.z;
    }

    public Point getConv(double vra, double vde, double dist) {
        TDouble tr = this.getConvedTD(vra, vde);
        if (tr.getZ() > 1.0E-4) {
            int px = (int)(dist * (tr.getX() / tr.getZ()));
            int py = (int)(dist * (tr.getY() / tr.getZ()));
            return new Point(px, py);
        }
        return null;
    }

    public Point getPtConv(double vra, double vde, double length) {
        TDouble tr = this.getConvedTD(vra, vde);
        if (tr.getZ() > 1.0E-4) {
            int px = (int)(length * tr.getX());
            int py = (int)(length * tr.getY());
            return new Point(px, py);
        }
        return null;
    }

    private TDouble getConvedTD(double vra, double vde) {
        double sinra = Math.sin(vra);
        double cosra = Math.cos(vra);
        double sinde = Math.sin(vde);
        double cosde = Math.cos(vde);
        double dx = cosra * this.y - sinra * this.x;
        double dy = cosde * this.z - cosra * sinde * this.x - sinra * sinde * this.y;
        double dz = cosra * cosde * this.x + sinra * cosde * this.y + sinde * this.z;
        return new TDouble(dx, dy, dz);
    }

    public double getAngle(double vra, double vde) {
        TDouble tr = this.getConvedTD(vra, vde);
        double length = Math.sqrt(tr.getX() * tr.getX() + tr.getY() * tr.getY());
        double val = Math.atan(length / tr.getZ());
        if (val < 0.0) {
            val = Math.PI + val;
        }
        return val;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public TDPoint cross(TDPoint A) {
        double cx = this.y * A.getZ() - A.getY() * this.z;
        double cy = A.getX() * this.z - this.x * A.getZ();
        double cz = this.x * A.getY() - A.getX() * this.y;
        TDPoint retp = new TDPoint(cx, cy, cz);
        retp.setRaDe();
        return retp;
    }

    public TDPoint subtract(TDPoint A) {
        double cx = this.x - A.getX();
        double cy = this.y - A.getY();
        double cz = this.z - A.getZ();
        TDPoint retp = new TDPoint(cx, cy, cz);
        retp.setRaDe();
        return retp;
    }

    public TDPoint add(TDPoint A) {
        double cx = this.x + A.getX();
        double cy = this.y + A.getY();
        double cz = this.z + A.getZ();
        TDPoint retp = new TDPoint(cx, cy, cz);
        retp.setRaDe();
        return retp;
    }

    public void changeLength(double len) {
        double ratio = len / this.length();
        this.x *= ratio;
        this.y *= ratio;
        this.z *= ratio;
    }
}

