/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.Vector;

public class SkyPainter {
    static double[] bbtable;
    static double[] brtable;
    double sybVolume = 1.0;
    static final int smallRadius = 6;
    final int ingSizeFactor = 3;
    final int particleNo = 50;
    final int particleRad = 100;
    SkyCanvas boss;
    int paintmode;
    int pre_paintmode = this.paintmode = 0;
    boolean gridFlag = true;
    boolean topFlag = true;
    int cstmode = 1;
    int cstnamemode = 1;
    int calccount = 0;
    int gpcount = 0;
    double vra;
    double prev_vra;
    double vde;
    double prev_vde;
    double vangle;
    double prev_vangle;
    Dimension pre_dimension;
    int movelesscount = 0;
    final int movelessValue = 3;
    boolean moveflag;
    boolean pre_moveflag = this.moveflag = false;
    double starBrVal = 5.0;
    boolean tailflag = true;
    double tailbr = 1.0;
    MyClipper mycp;
    int[][] x_line;
    int[][] y_line;
    int[] x_vect;
    int[] y_vect;
    int phase_no;

    static {
        double[] dArray = new double[11];
        dArray[2] = 0.2;
        dArray[3] = 0.4;
        dArray[4] = 0.6;
        dArray[5] = 0.8;
        dArray[6] = 1.0;
        dArray[7] = 1.0;
        dArray[8] = 1.0;
        dArray[9] = 1.0;
        dArray[10] = 1.0;
        bbtable = dArray;
        double[] dArray2 = new double[10];
        dArray2[0] = 1.0;
        dArray2[1] = 0.9;
        dArray2[2] = 0.8;
        dArray2[3] = 0.8;
        dArray2[4] = 0.7;
        dArray2[5] = 0.6;
        dArray2[6] = 0.5;
        dArray2[7] = 0.4;
        dArray2[8] = 0.2;
        brtable = dArray2;
    }

    SkyPainter(SkyCanvas _boss) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -3;
        nArray[3] = -2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[1] = -2;
        nArray2[2] = -3;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = -1;
        nArray3[2] = 3;
        nArray3[3] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = -1;
        nArray4[1] = 2;
        nArray4[2] = 3;
        nArrayArray[3] = nArray4;
        this.x_line = nArrayArray;
        int[][] nArrayArray2 = new int[4][];
        int[] nArray5 = new int[4];
        nArray5[0] = 1;
        nArray5[1] = -2;
        nArray5[2] = -3;
        nArrayArray2[0] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = -1;
        nArray6[2] = 3;
        nArray6[3] = 2;
        nArrayArray2[1] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = -1;
        nArray7[1] = -2;
        nArray7[2] = 3;
        nArrayArray2[2] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[0] = 1;
        nArray8[2] = -3;
        nArray8[3] = -2;
        nArrayArray2[3] = nArray8;
        this.y_line = nArrayArray2;
        this.x_vect = new int[]{1, 1, -1, -1};
        this.y_vect = new int[]{1, -1, -1, 1};
        this.phase_no = 0;
        this.boss = _boss;
        this.mycp = new MyClipper();
    }

    Dimension getSize() {
        return this.boss.getSize();
    }

    Dimension getSkyMapSize() {
        return this.boss.getSkyMapSize();
    }

    public void paintIngNode(PointData pt, Graphics g, int cpaintmode) {
        pt.resetDPoints();
        DPos tpt = pt.getPoint();
        Point ppt = this.mapToCanvasWithClip(tpt);
        if (ppt == null) {
            pt.resetDPoints();
            return;
        }
        if (this.moveflag && this.paintmode != 0) {
            this.paintSimpleINode(pt, ppt, g);
        } else {
            if (cpaintmode == 0) {
                this.paintNNode(pt, ppt, g);
            } else if (cpaintmode == 1) {
                this.paintWNode(pt, ppt, g);
            } else if (cpaintmode == 2) {
                this.paintBWNode(pt, ppt, g);
            } else if (cpaintmode == 3) {
                this.paintLineNode(pt, ppt, g);
            }
            if (pt.getTop() && this.topFlag) {
                this.paintTopRing(pt, g, ppt, (int)((double)(SkyCanvas.maxCircleLevel * 3) * this.sybVolume) + 4);
            }
        }
    }

    private void paintTopRing(PointData pt, Graphics g, Point ppt, int i_rad) {
        int i = 0;
        while (i < 3) {
            double cratio = 1.0 - (double)((float)pt.getLevel() / (float)SkyCanvas.maxCircleLevel);
            if (i % 2 == 1) {
                cratio = 1.0 - cratio;
            }
            Color orcolor = Color.pink;
            float[] cl = new float[3];
            cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(), cl);
            Color nwcolor = Color.getHSBColor(cl[0], cl[1], (float)cratio);
            g.setColor(nwcolor);
            int length = (int)((double)i_rad / Math.sqrt(2.0)) + i + 1;
            g.drawLine(ppt.x, ppt.y + length, ppt.x + length, ppt.y);
            g.drawLine(ppt.x + length, ppt.y, ppt.x, ppt.y - length);
            g.drawLine(ppt.x, ppt.y - length, ppt.x - length, ppt.y);
            g.drawLine(ppt.x - length, ppt.y, ppt.x, ppt.y + length);
            ++i;
        }
    }

    private void paintSimpleINode(PointData pt, Point ppt, Graphics offgraphics) {
        int level = 3;
        double bb = bbtable[level];
        double br = brtable[level] + 0.2;
        if (br > 1.0) {
            br = 1.0;
        }
        double ph = (1.0 - pt.getProgValue()) / 2.0;
        offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)br));
        int rad = (int)(18.0 * this.sybVolume);
        int x = ppt.x - (int)((double)rad * 0.5);
        int y = ppt.y - (int)((double)rad * 0.5);
        offgraphics.fillOval(x, y, rad, rad);
    }

    private void paintNNode(PointData pt, Point ppt, Graphics offgraphics) {
        int ptlevel = pt.getLevel();
        int rad = (int)((double)(ptlevel * 3) * this.sybVolume);
        while (rad >= 0) {
            int level = (int)((double)rad / (3.0 * this.sybVolume));
            double bb = bbtable[level];
            double br = brtable[level] + 0.2;
            if (br > 1.0) {
                br = 1.0;
            }
            double ph = (1.0 - pt.getProgValue()) / 2.0;
            offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)br));
            int x = ppt.x - (int)((double)rad * 0.5);
            int y = ppt.y - (int)((double)rad * 0.5);
            offgraphics.drawOval(x, y, rad, rad);
            rad -= 2;
        }
    }

    private void paintWNode(PointData pt, Point ppt, Graphics offgraphics) {
        int offset = Calendar.getInstance().get(13);
        if (offset > 30) {
            offset = 60 - offset;
        }
        double mvalue = 0.75 + (double)offset / 120.0;
        int i = 0;
        while (i < SkyCanvas.maxCircleLevel) {
            int rad = (int)((double)(i * 3) * this.sybVolume);
            int modrad = (int)((double)rad * mvalue);
            int k = 0;
            while (k < SkyCanvas.maxCircleLevel) {
                int index = (pt.getLevel() + k + i) % SkyCanvas.maxCircleLevel;
                int da = 36;
                double bb = bbtable[index];
                double br = brtable[index];
                double ph = (1.0 - pt.getProgValue()) / 2.0;
                offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)br));
                int x = ppt.x;
                int y = ppt.y;
                offgraphics.drawArc(x - modrad / 2, y - rad / 2, modrad, rad, k * da + offset, da);
                offgraphics.drawArc(x - rad / 2, y - modrad / 2, rad, modrad, (SkyCanvas.maxCircleLevel - 1 - k) * da, da);
                ++k;
            }
            ++i;
        }
    }

    private void paintBWNode(PointData pt, Point ppt, Graphics offgraphics) {
        if (!pt.hasLingP()) {
            pt.initRings();
        }
        Vector rings = pt.getRings();
        pt.rotate();
        int i = 0;
        while (i < rings.size()) {
            double bb = bbtable[i];
            double br = brtable[i] + 0.2;
            if (br > 1.0) {
                br = 1.0;
            }
            double ph = (1.0 - pt.getProgValue()) / 2.0;
            offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)br));
            SRing sr = (SRing)rings.elementAt(i);
            int rad = (int)((double)(SkyCanvas.maxCircleLevel + i * 2) * this.sybVolume);
            int x = ppt.x - (int)((double)rad * 0.5);
            int y = ppt.y - (int)((double)rad * 0.5);
            Vector infovect = sr.getInfoVect();
            int j = 0;
            while (j < infovect.size()) {
                Point npt = (Point)infovect.elementAt(j);
                offgraphics.drawArc(x, y, rad, rad, npt.x, npt.y);
                ++j;
            }
            ++i;
        }
    }

    private void paintLineNode(PointData pt, Point ppt, Graphics offgraphics) {
        int level = pt.getLevel();
        double bb = bbtable[level];
        double br = brtable[level] + 0.2;
        if (br > 1.0) {
            br = 1.0;
        }
        double ph = (1.0 - pt.getProgValue()) / 2.0;
        offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)br));
        this.paintLineANode(pt, ppt, offgraphics, true, true);
    }

    public void paintEdNode(PointData pt, Graphics g, int apaintmode, int ablinkmode, boolean oflag) {
        if (ablinkmode == 3 || ablinkmode == 2) {
            Color orcolor = pt.getColor();
            float[] cl = new float[3];
            cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(), cl);
            Color nwcolor = Color.getHSBColor(cl[0], cl[1], (float)(1.0 - (double)((float)pt.getLevel() / (float)SkyCanvas.maxCircleLevel)));
            g.setColor(nwcolor);
        } else {
            g.setColor(pt.getColor());
        }
        Point ppt = this.mapToCanvasWithClip(pt.getPoint());
        if (ppt == null) {
            pt.resetDPoints();
            return;
        }
        if (this.moveflag) {
            pt.resetDPoints();
            if (this.paintmode != 0) {
                this.paintSimpleANode(ppt, g);
            }
        } else {
            if (apaintmode == 0) {
                this.paintCircleANode(pt, ppt, g, oflag);
            } else if (apaintmode == 1) {
                this.paintSquareANode(pt, ppt, g, oflag);
            } else if (apaintmode == 2) {
                this.paintDiaANode(pt, ppt, g, oflag);
            } else if (apaintmode == 3) {
                this.paintLineANode(pt, ppt, g, oflag, false);
            }
            if (pt.getTop() && this.topFlag) {
                this.paintTopRing(pt, g, ppt, (int)(6.0 * this.sybVolume) + 4);
            }
        }
    }

    private void paintSimpleANode(Point ppt, Graphics g) {
        int x = ppt.x;
        int y = ppt.y;
        int delta = (int)(2.4000000000000004 * this.sybVolume);
        int ddelta = (int)(1.7999999999999998 * this.sybVolume);
        g.drawLine(x, y - delta, x, y + delta);
        g.drawLine(x - delta, y, x + delta, y);
        g.drawLine(x - ddelta, y - ddelta, x + ddelta, y + ddelta);
        g.drawLine(x - ddelta, y + ddelta, x + ddelta, y - ddelta);
    }

    private void paintCircleANode(PointData pt, Point ppt, Graphics offgraphics, boolean flag) {
        int rad = (int)(6.0 * this.sybVolume);
        int x = ppt.x;
        int y = ppt.y;
        x -= rad / 2;
        y -= rad / 2;
        if (flag) {
            offgraphics.fillOval(x, y, rad, rad);
        } else {
            offgraphics.drawOval(x, y, rad, rad);
        }
    }

    private void paintSquareANode(PointData pt, Point ppt, Graphics offgraphics, boolean flag) {
        int rad = (int)(6.0 * this.sybVolume);
        int x = ppt.x;
        int y = ppt.y;
        x -= rad / 2;
        y -= rad / 2;
        if (flag) {
            offgraphics.fill3DRect(x, y, rad, rad, true);
        } else {
            offgraphics.draw3DRect(x, y, rad, rad, false);
        }
    }

    private void paintDiaANode(PointData pt, Point ppt, Graphics offgraphics, boolean flag) {
        int x = ppt.x;
        int y = ppt.y;
        int delta = (int)(2.4000000000000004 * this.sybVolume);
        int ll = (int)(6.0 * this.sybVolume);
        if (flag) {
            ll = (int)((double)ll * 0.7);
            offgraphics.drawLine(x, y - ll, x, y + ll);
            offgraphics.drawLine(x - ll, y, x + ll, y);
            offgraphics.drawLine(x - delta, y - delta, x + delta, y + delta);
            offgraphics.drawLine(x - delta, y + delta, x + delta, y - delta);
        } else {
            Polygon rect = new Polygon();
            rect.addPoint(x + ll, y);
            rect.addPoint(x + (delta /= 2), y + delta);
            rect.addPoint(x, y + ll);
            rect.addPoint(x - delta, y + delta);
            rect.addPoint(x - ll, y);
            rect.addPoint(x - delta, y - delta);
            rect.addPoint(x, y - ll);
            rect.addPoint(x + delta, y - delta);
            offgraphics.drawPolygon(rect);
        }
    }

    private void paintLineANode(PointData pt, Point ppt, Graphics offgraphics, boolean flag, boolean fillflag) {
        Vector bg = new Vector();
        pt.getAreaData(bg);
        if (bg.size() == 0) {
            return;
        }
        Polygon pol = new Polygon();
        TDPoint spt = ((DPos)bg.elementAt(0)).getPoint();
        int i = 1;
        while (i <= bg.size()) {
            DPos pos = i == bg.size() ? (DPos)bg.elementAt(0) : (DPos)bg.elementAt(i);
            TLine tl = new TLine(spt, pos.getPoint());
            if (flag) {
                this.drawLine(offgraphics, offgraphics.getColor(), tl);
            }
            spt = pos.getPoint();
            ++i;
        }
    }

    public void paintTermParticle(PointData pt, Graphics offgraphics) {
        double prog = pt.getProgValue();
        Point ppt = this.mapToCanvasWithClip(pt.getPoint());
        if (ppt == null) {
            return;
        }
        int ptlevel = pt.getLevel();
        if (prog > 0.96 && ptlevel == SkyCanvas.maxCircleLevel - 1) {
            pt.addParticle(ppt, 50, 100, ptlevel * 3);
        }
        double bb = bbtable[ptlevel];
        double ph = (1.0 - prog) / 2.0;
        Vector ptvect = pt.getPtVect();
        int j = 0;
        while (j < ptvect.size()) {
            ParticleData prt = (ParticleData)ptvect.elementAt(j);
            offgraphics.setColor(Color.getHSBColor((float)ph, (float)bb, (float)prt.getLifeValue()));
            offgraphics.drawLine(prt.getX(), prt.getY(), prt.getTX(), prt.getTY());
            ++j;
        }
    }

    public void paintProgValue(PointData pt, Graphics offgraphics) {
        if (this.moveflag && this.paintmode != 0) {
            return;
        }
        FontMetrics fm = offgraphics.getFontMetrics();
        boolean clearflag = pt.getSelected();
        String cpustr = pt.getCpuString();
        String progstr = pt.getProgString();
        String remainstr = pt.getRemainCpuString();
        if (remainstr != null) {
            remainstr = "(+" + remainstr + ")";
        }
        int strw = Math.max(fm.stringWidth(cpustr), fm.stringWidth(progstr));
        int strh = fm.getLeading() + fm.getAscent();
        int rstrh = strh + fm.getDescent();
        int margin = 3;
        int xoffset = SkyCanvas.maxCircleLevel * 3 / 2 + margin;
        Dimension d = this.getSkyMapSize();
        Point ppt = this.mapToCanvasWithClip(pt.getPoint());
        if (ppt == null) {
            return;
        }
        boolean rflag = false;
        if (ppt.x + strw + xoffset < d.width) {
            rflag = true;
        }
        int x = 0;
        int y = 0;
        x = rflag ? ppt.x + xoffset : ppt.x - xoffset - fm.stringWidth(progstr);
        y = ppt.y - margin;
        offgraphics.setColor(Color.black);
        if (clearflag) {
            offgraphics.fillRect(x, y - strh, fm.stringWidth(progstr), rstrh);
        }
        offgraphics.setColor(Color.pink);
        offgraphics.drawString(progstr, x, y);
        x = rflag ? ppt.x + xoffset : ppt.x - xoffset - fm.stringWidth(cpustr);
        y = ppt.y + strh;
        offgraphics.setColor(Color.black);
        if (clearflag) {
            offgraphics.fillRect(x, y - strh, fm.stringWidth(cpustr), rstrh);
        }
        offgraphics.setColor(Color.pink);
        offgraphics.drawString(cpustr, x, y);
        if (remainstr != null) {
            x = rflag ? ppt.x + xoffset : ppt.x - xoffset - fm.stringWidth(remainstr);
            y = ppt.y + strh * 2;
            offgraphics.setColor(Color.black);
            if (clearflag) {
                offgraphics.fillRect(x, y - strh, fm.stringWidth(remainstr), rstrh);
            }
            offgraphics.setColor(Color.pink);
            offgraphics.drawString(remainstr, x, y);
        }
    }

    public void paintGPattern(PointData pt, Graphics offgraphics) {
        Vector bgpot = pt.getBgpot();
        if (bgpot == null) {
            return;
        }
        Point ppt = this.mapToCanvasWithClip(pt.getPoint());
        if (ppt == null) {
            return;
        }
        double maxval = 0.0;
        int i = 0;
        while (i < bgpot.size()) {
            Double ddt = (Double)bgpot.elementAt(i);
            double mval = 0.0;
            if (ddt != null) {
                mval = ddt;
            }
            if (mval > maxval) {
                maxval = mval;
            }
            ++i;
        }
        int rheight = 40;
        int rwidth = 6;
        Dimension d = this.getSkyMapSize();
        if (maxval > 0.0) {
            FontMetrics fm = offgraphics.getFontMetrics();
            int y = ppt.y + rheight + SkyCanvas.maxCircleLevel * 3 / 2 + fm.getHeight();
            int x = ppt.x - bgpot.size() * rwidth / 2;
            if (x < 0) {
                x = 0;
            } else if (x + bgpot.size() * rwidth > d.width) {
                x = d.width - bgpot.size() * rwidth;
            }
            int org_x = x;
            int dy = y;
            int o_dy = y;
            int i2 = 0;
            while (i2 < bgpot.size()) {
                double br = 0.5;
                if (i2 < this.gpcount) {
                    br = 1.0;
                }
                offgraphics.setColor(Color.getHSBColor(0.0f, 0.9f, (float)br));
                Double ddt = (Double)bgpot.elementAt(i2);
                double mval = 0.0;
                if (ddt != null) {
                    mval = ddt;
                }
                o_dy = dy;
                dy = y - (int)(mval / maxval * (double)rheight);
                offgraphics.drawLine(x, o_dy, x, dy);
                offgraphics.drawLine(x, dy, x + 6, dy);
                x += 6;
                ++i2;
            }
            if (this.gpcount >= bgpot.size() && pt.getBgTrueMean() > 0.0) {
                offgraphics.setColor(Color.lightGray);
                dy = y - (int)(pt.getBgTrueMean() / maxval * (double)rheight);
                dy = y - (int)(pt.getBgPower() / maxval * (double)rheight);
            }
            this.gpcount += 2;
            if (this.gpcount > bgpot.size() * 2) {
                this.gpcount = 0;
            }
        }
    }

    public Point paintCrossLine(Graphics g, PointData pt, int tracx, int tracy) {
        Point ppt = this.mapToCanvasWithClip(pt.getPoint());
        if (ppt == null) {
            return new Point();
        }
        Dimension d = this.getSkyMapSize();
        g.setColor(Color.yellow);
        int len = SkyCanvas.maxCircleLevel * 3;
        double alpha = 0.7;
        tracx = (int)((double)ppt.x * alpha + (double)tracx * (1.0 - alpha));
        tracy = (int)((double)ppt.y * alpha + (double)tracy * (1.0 - alpha));
        g.drawRect(tracx - (int)((double)len * 0.5), tracy - (int)((double)len * 0.5), len, len);
        g.drawLine(tracx, 0, tracx, tracy - (int)((double)len * 0.5));
        g.drawLine(tracx, d.height, tracx, tracy + (int)((double)len * 0.5));
        g.drawLine(0, tracy, tracx - (int)((double)len * 0.5), tracy);
        g.drawLine(d.width, tracy, tracx + (int)((double)len * 0.5), tracy);
        return new Point(tracx, tracy);
    }

    public void paintStarData(Graphics offgraphics, Vector starVect) {
        int i = 0;
        while (i < starVect.size()) {
            StarData pt = (StarData)starVect.elementAt(i);
            Point npt = pt.getDPoint();
            Point vp = this.mapToCanvasWithClip(pt.getPoint());
            if (vp != null) {
                offgraphics.setColor(Color.white);
                double br = pt.getBr();
                if (!(br > this.starBrVal)) {
                    int x = vp.x;
                    int y = vp.y;
                    if (this.moveflag && this.tailflag && (this.paintmode == 1 || this.paintmode == 3)) {
                        if (npt != null && br < 4.5) {
                            offgraphics.setColor(Color.getHSBColor(0.0f, 0.0f, (float)this.tailbr));
                            offgraphics.drawLine(x, y, npt.x, npt.y);
                        }
                    } else if (br < 1.0) {
                        int dt = 4;
                        offgraphics.fillOval(x - dt / 2, y - dt / 2, dt, dt);
                    } else if (br < 2.0) {
                        offgraphics.drawLine(vp.x - 2, y, x + 2, y);
                        offgraphics.drawLine(x, y - 2, x, y + 2);
                        offgraphics.drawLine(x - 1, y - 1, x + 1, y + 1);
                        offgraphics.drawLine(x - 1, y + 1, x + 1, y - 1);
                    } else if (br < 3.0) {
                        offgraphics.drawLine(x, y - 1, x, y + 1);
                        offgraphics.drawLine(x - 1, y, x + 1, y);
                    } else if (!this.moveflag) {
                        offgraphics.drawLine(x, y, x, y);
                    }
                }
            }
            ++i;
        }
    }

    public void paintCst(Graphics g, Vector cstVect) {
        int i = 0;
        while (i < cstVect.size()) {
            CstData cst = (CstData)cstVect.elementAt(i);
            if (this.moveflag) {
                cst.resetDPoint();
            } else {
                DPos pt = cst.getNamePos();
                if (this.cstnamemode == 1) {
                    this.drawString(g, pt, cst.getShortName(), Color.cyan);
                } else if (this.cstnamemode == 0) {
                    this.drawString(g, pt, cst.getName(), Color.cyan);
                }
                if (this.cstmode != 2 && (this.cstmode != 1 || cst.getRank() <= 0)) {
                    Vector lineVect = cst.getLineVect();
                    int j = 0;
                    while (j < lineVect.size()) {
                        TLine ln = (TLine)lineVect.elementAt(j);
                        this.drawLine(g, Color.blue, ln);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void paintGrid(Graphics g, Vector gridVect) {
        if (!this.gridFlag) {
            return;
        }
        int i = 0;
        while (i < gridVect.size()) {
            StarData spt = (StarData)gridVect.elementAt(i);
            DPos pt = spt.getPoint();
            if (this.moveflag) {
                spt.resetDPoint();
            } else {
                double delta = this.vangle / 80.0;
                TDPoint[] p = new TDPoint[]{null, null, null, null, null};
                p[0] = new TDPoint(pt.getRa() + delta, pt.getDe());
                p[1] = new TDPoint(pt.getRa() - delta, pt.getDe());
                p[2] = new TDPoint(pt.getRa(), pt.getDe() + delta);
                p[3] = new TDPoint(pt.getRa(), pt.getDe() - delta);
                this.drawLine(g, Color.lightGray, new TLine(p[0], p[1]));
                this.drawLine(g, Color.lightGray, new TLine(p[2], p[3]));
            }
            if (pt.getDe() == 0.0 || pt.getRa() == 0.0) {
                this.drawString(g, pt, spt.getStr(), Color.lightGray);
            }
            ++i;
        }
    }

    public void setVra(double val) {
        this.vra = val;
    }

    public void setVde(double val) {
        this.vde = val;
        this.adjustVde();
    }

    public void setVangle(double val) {
        this.vangle = val * Math.PI / 180.0;
        this.adjustVde();
    }

    public double getVangle() {
        return this.vangle;
    }

    public double getRa() {
        return this.vra;
    }

    public double getDe() {
        return this.vde;
    }

    public void setPaintMode(int mode) {
        this.pre_paintmode = this.paintmode;
        this.paintmode = mode;
        this.movelesscount = 3;
        this.checkMovement();
    }

    public void setGridMode(boolean flag) {
        this.gridFlag = flag;
    }

    public void setTopMode(boolean flag) {
        this.topFlag = flag;
    }

    public void checkMovement() {
        this.pre_moveflag = this.moveflag;
        Dimension dim = this.getSize();
        if (this.vra == this.prev_vra && this.vde == this.prev_vde && this.vangle == this.prev_vangle && !this.boss.getMouseDownFlag() && dim.equals(this.pre_dimension) && this.paintmode == this.pre_paintmode) {
            ++this.movelesscount;
        } else {
            this.movelesscount = 0;
            this.moveflag = true;
        }
        if (this.movelesscount >= 3) {
            this.movelesscount = 3;
            this.moveflag = false;
        }
        this.prev_vra = this.vra;
        this.prev_vde = this.vde;
        this.pre_dimension = dim;
        this.prev_vangle = this.vangle;
        this.pre_paintmode = this.paintmode;
    }

    public void setCstMode(int val) {
        this.cstmode = val;
    }

    public void setCstNameMode(int val) {
        this.cstnamemode = val;
    }

    public void setStarBr(double val) {
        this.starBrVal = val;
    }

    public void setSybSize(String str) {
        if (str.equals("Standard") || str.equals("Normal")) {
            this.sybVolume = 1.0;
        } else if (str.equals("Small")) {
            this.sybVolume = 0.8;
        } else if (str.equals("VerySmall")) {
            this.sybVolume = 0.5;
        } else if (!str.equals("Normal")) {
            System.out.println("Wao, we are in trouble for setSybSize with " + str);
        }
    }

    public void setTailBr(int n) {
        switch (n) {
            case 1: {
                this.tailbr = 1.0;
                break;
            }
            case 2: {
                this.tailbr = 0.9;
                break;
            }
            case 3: {
                this.tailbr = 0.7;
                break;
            }
            case 4: {
                this.tailbr = 0.5;
                break;
            }
            default: {
                System.out.println("outrange in setTailBr " + n);
            }
        }
    }

    public void setStarTrace(boolean flag) {
        this.tailflag = flag;
    }

    private void drawString(Graphics g, DPos pt, String str, Color cl) {
        Point vp = this.mapToCanvasWithClip(pt);
        if (vp == null) {
            return;
        }
        g.setColor(cl);
        g.drawString(str, vp.x, vp.y);
    }

    private void drawLine(Graphics g, Color cl, TLine ln) {
        if (this.leapP(ln)) {
            return;
        }
        Point p1 = this.mapToCanvas(ln.getP1());
        Point p2 = this.mapToCanvas(ln.getP2());
        if (p1 == null || p2 == null) {
            return;
        }
        Rectangle lr = null;
        if (this.moveflag) {
            if (!this.mycp.clipPoint(p1) || !this.mycp.clipPoint(p2)) {
                return;
            }
            lr = new Rectangle(p1.x, p1.y, p2.x, p2.y);
        } else {
            lr = this.mycp.lineclip(p1, p2);
        }
        g.setColor(cl);
        g.drawLine(lr.x, lr.y, lr.width, lr.height);
    }

    private boolean leapP(TLine ln) {
        double ra2;
        double ra1;
        if (this.paintmode != 2 && this.paintmode != 0) {
            return false;
        }
        double r_vra = this.vra + Math.PI;
        if (this.paintmode == 0) {
            r_vra = Math.PI;
        }
        if (r_vra > Math.PI * 2) {
            r_vra -= Math.PI * 2;
        }
        if ((ra1 = ln.getP1().getRa()) < 0.0) {
            ra1 += Math.PI * 2;
        }
        if ((ra2 = ln.getP2().getRa()) < 0.0) {
            ra2 += Math.PI * 2;
        }
        double minRa = Math.min(ra1, ra2);
        double maxRa = Math.max(ra1, ra2);
        if (maxRa - minRa < Math.PI) {
            return maxRa >= r_vra && minRa <= r_vra;
        }
        return r_vra >= maxRa || r_vra <= minRa;
    }

    private boolean leapP2(TLine ln) {
        double raddif2;
        if (this.paintmode != 2) {
            return false;
        }
        double r_vra = this.vra + Math.PI;
        if (r_vra > Math.PI * 2) {
            r_vra -= Math.PI * 2;
        }
        double ra1 = ln.getP1().getRa();
        double ra2 = ln.getP2().getRa();
        double radiff1 = ra1 - r_vra;
        if (Math.abs(radiff1) > Math.PI) {
            radiff1 = radiff1 > 0.0 ? Math.abs(radiff1) - Math.PI * 2 : Math.PI * 2 - Math.abs(radiff1);
        }
        if (Math.abs(raddif2 = ra2 - r_vra) > Math.PI) {
            raddif2 = raddif2 > 0.0 ? Math.abs(raddif2) - Math.PI * 2 : Math.PI * 2 - Math.abs(raddif2);
        }
        return radiff1 * raddif2 <= 0.0;
    }

    public void setClipRange(Dimension d) {
        this.mycp.setClipRange(d);
    }

    public Point mapToCanvasWithClip(DPos pt) {
        Point ppt = this.mapToCanvas(pt);
        if (this.clipPoint(ppt)) {
            return ppt;
        }
        pt.resetDPoint();
        return null;
    }

    private boolean clipPoint(Point pt) {
        Dimension d = this.getSize();
        if (pt == null) {
            return false;
        }
        return pt.x >= 0 && pt.x <= d.width && pt.y >= 0 && pt.y <= d.height;
    }

    private Point mapToCanvas(DPos pt) {
        if (this.moveflag || !pt.isDPointSet()) {
            Point npt = this.calcMapToCanvas(pt.getPoint());
            pt.setDPoint(npt);
            return npt;
        }
        return pt.getDPoint();
    }

    private Point calcMapToCanvas(TDPoint pt) {
        Dimension d = this.getSkyMapSize();
        Point vp = new Point();
        if (this.paintmode == 0) {
            vp = this.get2DConv(pt, (double)d.width / (Math.PI * 2));
            --vp.x;
        } else if (this.paintmode == 1) {
            int mind = Math.min(d.width, d.height) / 2;
            double dist = (double)mind / Math.tan(this.vangle / 2.0);
            vp = pt.getConv(this.vra, this.vde, dist);
        } else if (this.paintmode == 2) {
            vp = this.get2DConv(pt, this.getVolume());
        } else if (this.paintmode == 3) {
            int length = Math.min(d.height / 2, d.width / 2);
            vp = pt.getPtConv(this.vra, this.vde, length);
        }
        if (vp == null) {
            return null;
        }
        int x = d.width / 2 - vp.x;
        int y = d.height / 2 - vp.y;
        return new Point(x, y);
    }

    private double getVolume() {
        Dimension d = this.getSkyMapSize();
        int length = Math.max(d.height, d.width / 2);
        return (double)length / this.vangle;
    }

    private Point get2DConv(TDPoint pt, double vol) {
        double raddiff = pt.getRa() - this.vra;
        if (Math.abs(raddiff) > Math.PI) {
            raddiff = raddiff > 0.0 ? -1.0 * (Math.PI * 2 - Math.abs(raddiff)) : Math.PI * 2 - Math.abs(raddiff);
        }
        int px = (int)(raddiff * vol);
        int py = (int)((pt.getDe() - this.vde) * vol);
        return new Point(px, py);
    }

    private void adjustVde() {
        if (this.paintmode != 2) {
            return;
        }
        double vol = this.getVolume();
        Dimension d = this.getSkyMapSize();
        double vdelta = (double)(d.height / 2) / vol;
        if (this.vde + vdelta > 1.5707963267948966) {
            this.vde = 1.5707963267948966 - vdelta;
        } else if (this.vde - vdelta < -1.5707963267948966) {
            this.vde = -1.5707963267948966 + vdelta;
        }
    }
}

