/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class SkyCanvas
extends Canvas
implements Runnable {
    static int maxCircleLevel = 10;
    Vector pointVect = new Vector();
    SkyPainter sptr;
    SETISupport boss;
    Random dice = new Random(0L);
    final Dimension mySize = new Dimension(964, 482);
    ScrollPane parentSp;
    Image skyImage;
    int tracx;
    int tracy;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    Thread relaxer;
    Font font;
    boolean progDisplayFlag = false;
    boolean gpDisplayFlag = false;
    boolean clDisplayFlag = true;
    String msgString;
    int msgcount = 0;
    int animetime = 100;
    boolean alwaysCenterFlag = false;
    int cpaintmode = 0;
    int apaintmode = 0;
    int ablinkmode = 2;
    int bpaintmode = 0;
    Vector starVect = new Vector();
    Vector cstVect = new Vector();
    Vector gridVect = new Vector();
    Vector bringVect = new Vector();
    Point morigin;
    double originra;
    double originde;
    boolean mouseDownFlag = false;
    Vector vptvect = new Vector();
    boolean autoAngleFlag = true;

    public SkyCanvas(SETISupport _boss) {
        try {
            this.skyImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)this.getClass().getResource("SKYMAP.GIF").getContent());
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        this.setSize(this.mySize);
        Dimension d = this.getSize();
        this.tracx = d.width / 2;
        this.tracy = d.height / 2;
        this.boss = _boss;
        String[] fontNames = this.getToolkit().getFontList();
        this.font = new Font(fontNames[0], 0, 10);
        this.sptr = new SkyPainter(this);
        this.setPaintMode(0);
        this.readTData();
        this.setGrid();
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion lSymMot = new SymMouseMotion();
        this.addMouseMotionListener(lSymMot);
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
        this.relaxer.setPriority(1);
    }

    public void stop() {
        if (this.relaxer != null) {
            this.relaxer.stop();
        }
    }

    public void suspend() {
        if (this.relaxer != null) {
            this.relaxer.suspend();
        }
    }

    public void resume() {
        if (this.relaxer != null) {
            this.relaxer.resume();
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(this.animetime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setAnimeTime(int val) {
        this.animetime = val;
    }

    public void setParentSp(ScrollPane sp) {
        this.parentSp = sp;
    }

    public void setMessage(String str) {
        this.msgString = new String(str);
        this.msgcount = 3000 / this.animetime;
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.bpaintmode == 0) {
            super.setBounds(x, y, this.mySize.width, this.mySize.height);
        } else if (this.bpaintmode == 1 || this.bpaintmode == 2 || this.bpaintmode == 3) {
            super.setBounds(x, y, w, h);
        }
    }

    public Dimension getMinimumSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return super.getMinimumSize();
    }

    public void setPMode(int mode) {
        this.cpaintmode = mode;
    }

    public void setAPMode(int mode) {
        this.apaintmode = mode;
    }

    public void setABMode(int mode) {
        this.ablinkmode = mode;
        if (this.ablinkmode != 2) {
            int i = 0;
            while (i < this.pointVect.size()) {
                PointData pt = (PointData)this.pointVect.elementAt(i);
                pt.setLevel((int)(this.dice.nextDouble() * (double)maxCircleLevel));
                ++i;
            }
            this.bringVect.removeAllElements();
        }
    }

    public int getABMode() {
        return this.ablinkmode;
    }

    public void setProgDisplay(boolean _val) {
        this.progDisplayFlag = _val;
    }

    public void setGpDisplay(boolean _val) {
        this.gpDisplayFlag = _val;
    }

    public void setCLDisplay(boolean _val) {
        this.clDisplayFlag = _val;
    }

    public void setCenterFlag(boolean _val) {
        this.alwaysCenterFlag = _val;
        this.setScrollPos();
    }

    public void setPaintMode(int mode) {
        this.vptvect.removeAllElements();
        this.bpaintmode = mode;
        this.sptr.setPaintMode(mode);
        this.sptr.setVra(0.0);
        this.sptr.setVde(0.0);
        if (mode == 0) {
            this.setSize(this.mySize);
        }
        this.repaint();
    }

    public void setVangle(int val) {
        this.sptr.setVangle(val);
        this.setScrollPos();
    }

    public void setGridMode(boolean flag) {
        this.sptr.setGridMode(flag);
    }

    public void setTopMode(boolean flag) {
        this.sptr.setTopMode(flag);
    }

    public void setCstMode(int val) {
        this.sptr.setCstMode(val);
    }

    public void setCstNameMode(int val) {
        this.sptr.setCstNameMode(val);
    }

    public boolean getMouseDownFlag() {
        return this.mouseDownFlag;
    }

    public void setStarBr(double val) {
        this.sptr.setStarBr(val);
    }

    public void setSybSize(String str) {
        this.sptr.setSybSize(str);
    }

    public Dimension getSkyMapSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return this.getSize();
    }

    public void setStarTrace(boolean flag) {
        this.sptr.setStarTrace(flag);
    }

    public void setAutoVangle(boolean flag) {
        this.autoAngleFlag = flag;
    }

    public void update(Graphics g) {
        this.sptr.setClipRange(this.getSize());
        if (this.vptvect.size() > 0) {
            this.sptr.setTailBr(this.vptvect.size());
            Point pt = (Point)this.vptvect.elementAt(0);
            this.sptr.setVra((double)pt.x / 1000.0);
            this.sptr.setVde((double)pt.y / 1000.0);
            this.vptvect.removeElementAt(0);
        }
        if (this.autoAngleFlag) {
            this.autoAngleAdjust();
        }
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintBackground(this.offgraphics);
        this.paintPoints(this.offgraphics);
        this.sptr.checkMovement();
        g.drawImage(this.offscreen, 0, 0, null);
        if (this.ablinkmode == 2) {
            Vector<BlinkRing> deadVect = new Vector<BlinkRing>();
            int i = 0;
            while (i < this.bringVect.size()) {
                BlinkRing br = (BlinkRing)this.bringVect.elementAt(i);
                br.expand();
                if (!br.liveP()) {
                    deadVect.addElement(br);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < deadVect.size()) {
                this.bringVect.removeElement(deadVect.elementAt(i2));
                ++i2;
            }
        }
    }

    private void paintBackground(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, d.width, d.height);
        switch (this.bpaintmode) {
            case 0: {
                g.drawImage(this.skyImage, 0, 0, this);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.sptr.paintStarData(g, this.starVect);
                this.sptr.paintGrid(this.offgraphics, this.gridVect);
                this.sptr.paintCst(this.offgraphics, this.cstVect);
                break;
            }
        }
    }

    void paintPoints(Graphics offgraphics) {
        Vector<PointData> pveg = new Vector<PointData>();
        int i = 0;
        while (i < this.pointVect.size()) {
            PointData pt = (PointData)this.pointVect.elementAt(i);
            pt.addLevel();
            if (pt.getVisible()) {
                if (pt.getSelected()) {
                    pveg.addElement(pt);
                } else {
                    pveg.insertElementAt(pt, 0);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < pveg.size()) {
            PointData pt = (PointData)pveg.elementAt(i2);
            if (!pt.getFinished()) {
                this.sptr.paintIngNode(pt, offgraphics, this.cpaintmode);
                this.sptr.paintTermParticle(pt, offgraphics);
                if (pt.getLevel() == maxCircleLevel - 1) {
                    this.bringVect.addElement(new BlinkRing(pt.getPoint()));
                }
                if (this.progDisplayFlag) {
                    this.sptr.paintProgValue(pt, offgraphics);
                }
            } else {
                boolean oflag = true;
                if (this.ablinkmode == 2) {
                    int n_level = maxCircleLevel;
                    int j = 0;
                    while (j < this.bringVect.size()) {
                        BlinkRing br = (BlinkRing)this.bringVect.elementAt(j);
                        int temp_level = br.getLevel(pt.getPoint());
                        if (temp_level < n_level) {
                            n_level = temp_level;
                        }
                        ++j;
                    }
                    pt.setLevel(n_level);
                } else if (this.ablinkmode == 1 && pt.getLevel() < maxCircleLevel / 2) {
                    oflag = false;
                }
                this.sptr.paintEdNode(pt, offgraphics, this.apaintmode, this.ablinkmode, oflag);
            }
            if (pt.getSelected()) {
                if (this.clDisplayFlag) {
                    Point npt = this.sptr.paintCrossLine(offgraphics, pt, this.tracx, this.tracy);
                    this.tracx = npt.x;
                    this.tracy = npt.y;
                }
                if (this.gpDisplayFlag) {
                    this.sptr.paintGPattern(pt, offgraphics);
                }
            }
            ++i2;
        }
        if (this.msgcount > 0) {
            FontMetrics fm = offgraphics.getFontMetrics();
            offgraphics.setColor(Color.red);
            Point ofp = new Point();
            if (this.bpaintmode == 0) {
                ofp = this.parentSp.getScrollPosition();
            }
            offgraphics.drawString(this.msgString, ofp.x + 10, ofp.y + fm.getHeight() * 2);
            --this.msgcount;
        }
    }

    public void addPoint(double rd, double dec, ResultData rdata, boolean finished) {
        int firstLevel = (int)(this.dice.nextDouble() * (double)maxCircleLevel);
        PointData pt = new PointData(firstLevel, maxCircleLevel, rdata);
        pt.setColor(rdata.getColorName());
        this.pointVect.addElement(pt);
    }

    public void selectPt(PointData spt) {
        if (spt == null) {
            return;
        }
        int i = 0;
        while (i < this.pointVect.size()) {
            PointData pt = (PointData)this.pointVect.elementAt(i);
            pt.setSelected(false);
            ++i;
        }
        spt.setSelected(true);
        this.setScrollPos();
    }

    public void setScrollPos() {
        if (this.alwaysCenterFlag) {
            PointData spt = null;
            int i = 0;
            while (i < this.pointVect.size()) {
                PointData pt = (PointData)this.pointVect.elementAt(i);
                if (pt.getSelected()) {
                    spt = pt;
                    break;
                }
                ++i;
            }
            if (spt == null) {
                return;
            }
            DPos tpt = spt.getPoint();
            if (tpt == null) {
                return;
            }
            if (this.bpaintmode == 0) {
                if (this.parentSp == null) {
                    return;
                }
                Dimension parentd = this.parentSp.getViewportSize();
                Point dpt = this.sptr.mapToCanvasWithClip(tpt);
                if (dpt == null) {
                    return;
                }
                this.parentSp.setScrollPosition(dpt.x - parentd.width / 2, dpt.y - parentd.height / 2);
            } else if (this.bpaintmode == 1 || this.bpaintmode == 2 || this.bpaintmode == 3) {
                int divno = 10;
                double startra = this.sptr.getRa();
                double startde = this.sptr.getDe();
                double endra = tpt.getRa();
                double endde = tpt.getDe();
                double deltade = (endde - startde) / (double)divno;
                double deltara = endra - startra;
                if (Math.abs(deltara) > Math.PI) {
                    deltara = deltara > 0.0 ? -1.0 * (Math.PI * 2 - Math.abs(deltara)) : Math.PI * 2 - Math.abs(deltara);
                }
                deltara /= (double)divno;
                this.vptvect.removeAllElements();
                int[] seq = new int[]{4, 7, 9};
                int i2 = 0;
                while (i2 < seq.length) {
                    double newde = startde + deltade * (double)seq[i2];
                    double newra = startra + deltara * (double)seq[i2];
                    if (newra > Math.PI * 2) {
                        newra -= Math.PI * 2;
                    } else if (newra < 0.0) {
                        newra += Math.PI * 2;
                    }
                    Point pt = new Point((int)(newra * 1000.0), (int)(newde * 1000.0));
                    this.vptvect.addElement(pt);
                    ++i2;
                }
                this.vptvect.addElement(new Point((int)(endra * 1000.0), (int)(endde * 1000.0)));
            }
        }
    }

    public void removeAllPoints() {
        this.pointVect.removeAllElements();
    }

    public void readTData() {
        KFileAnalyzer.readPTData(this.starVect, this);
        KFileAnalyzer.readCstData(this.cstVect, this);
    }

    private void setGrid() {
        int d = -90;
        while (d <= 90) {
            int r = 0;
            while (r <= 330) {
                String str = "";
                if (r != 0 || d == 0) {
                    str = String.valueOf(Integer.toString(r / 15)) + "hr";
                }
                if (d != 0) {
                    str = d >= 0 ? String.valueOf(str) + "+" : String.valueOf(str) + "-";
                    str = String.valueOf(str) + Integer.toString(d) + "deg";
                }
                StarData tp = new StarData(r, d, str);
                this.gridVect.addElement(tp);
                r += 30;
            }
            d += 30;
        }
    }

    private void autoAngleAdjust() {
        if (!this.autoAngleFlag) {
            return;
        }
        ResultData srd = this.boss.getSelectedData();
        if (srd == null) {
            return;
        }
        if (srd.getFinishedFlag()) {
            return;
        }
        double val = srd.getProgValue();
        int nvangle = (int)(90.0 * val) + 60;
        this.setVangle(nvangle);
    }

    void GraphPanel_MouseClicked(MouseEvent event) {
        this.boss.resetSleepThread();
        int cl = 12;
        Point ept = event.getPoint();
        Rectangle checkRect = new Rectangle(ept.x - cl, ept.y - cl, cl * 2, cl * 2);
        Vector<PointData> candvect = new Vector<PointData>();
        int i = 0;
        while (i < this.pointVect.size()) {
            PointData pt = (PointData)this.pointVect.elementAt(i);
            Point dpt = this.sptr.mapToCanvasWithClip(pt.getPoint());
            if (dpt != null && checkRect.contains(dpt.x, dpt.y)) {
                candvect.addElement(pt);
            }
            ++i;
        }
        PointData selpt = null;
        if (candvect.size() == 1) {
            selpt = (PointData)candvect.elementAt(0);
        } else {
            int mind = cl * 2 * (cl * 2);
            int i2 = 0;
            while (i2 < candvect.size()) {
                PointData pt = (PointData)candvect.elementAt(i2);
                if (!pt.getSelected()) {
                    Point dpt = this.sptr.mapToCanvasWithClip(pt.getPoint());
                    int dx = ept.x - dpt.x;
                    int dy = ept.y - dpt.y;
                    int d = dx * dx + dy * dy;
                    if (d < mind) {
                        mind = d;
                        selpt = pt;
                    }
                }
                ++i2;
            }
        }
        if (selpt != null) {
            this.boss.selectData(selpt.getOrgData());
        }
    }

    void SkyCanvas_MousePressed(MouseEvent event) {
        this.morigin = event.getPoint();
        this.originra = this.sptr.getRa();
        this.originde = this.sptr.getDe();
        this.mouseDownFlag = true;
        this.boss.resetSleepThread();
    }

    void SkyCanvas_MouseReleased(MouseEvent event) {
        this.mouseDownFlag = false;
    }

    void SkyCanvas_MouseDragged(MouseEvent event) {
        if (this.bpaintmode != 1 && this.bpaintmode != 2 && this.bpaintmode != 3) {
            return;
        }
        Point pt = event.getPoint();
        Dimension d = this.getSkyMapSize();
        int deltax = this.morigin.x - pt.x;
        int deltay = this.morigin.y - pt.y;
        double vol = this.sptr.getVangle() / (double)Math.max(d.width / 2, d.height);
        double newra = this.originra - (double)deltax * vol;
        double newde = this.originde - (double)deltay * vol;
        if (newra > Math.PI * 2) {
            newra -= Math.PI * 2;
        }
        if (newra < 0.0) {
            newra = Math.PI * 2 + newra;
        }
        if (newde < -1.5707963267948966) {
            newde = -1.5707963267948966;
        }
        if (newde > 1.5707963267948966) {
            newde = 1.5707963267948966;
        }
        this.sptr.setVra(newra);
        this.sptr.setVde(newde);
        this.repaint();
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MousePressed(event);
            }
        }

        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MouseReleased(event);
            }
        }

        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.GraphPanel_MouseClicked(event);
            }
        }

        SymMouse() {
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MouseDragged(event);
            }
        }

        SymMouseMotion() {
        }
    }
}

