/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class ResultData
implements Cloneable {
    String name;
    int[] ra = new int[3];
    int[] dec = new int[3];
    TDPoint tpoint;
    int[] end_ra = new int[3];
    int[] end_dec = new int[3];
    TDPoint end_tpoint;
    double subband_base = -1.0;
    String bs_power;
    String bs_score;
    String bs_bin;
    String bs_fft_ind;
    String bs_chirp_rate;
    String bs_fft_len;
    String bg_power;
    String bg_score;
    String bg_chisq;
    String bg_sigma;
    String bg_bin;
    String bg_fft_ind;
    String bg_chirp_rate;
    String bg_fft_len;
    String bg_true_mean;
    double bs_power_val;
    double bs_score_val;
    double bs_bin_val;
    double bs_fft_ind_val;
    double bs_chirp_rate_val;
    double bs_fft_len_val;
    double bg_power_val;
    double bg_score_val;
    double bg_chisq_val;
    double bg_sigma_val;
    double bg_bin_val;
    double bg_fft_ind_val;
    double bg_chirp_rate_val;
    double bg_fft_len_val;
    double bg_true_mean_val;
    double cpu = -1.0;
    double prog = -1.0;
    String time_recorded;
    String time_recorded_yms;
    Date recordedTime;
    Date startedTime;
    String startedTimeStr;
    Date infoUpdatedTime;
    String dirname;
    String shortname;
    boolean finishedFlag = false;
    boolean selected;
    PointData pt;
    PlotData plt;
    String colorname;
    String timeZoneID;
    MxData md;
    Vector bgpot;
    Vector areaData;

    ResultData() {
        this.tpoint = new TDPoint();
    }

    public Object clone() {
        try {
            int i;
            ResultData other = (ResultData)super.clone();
            if (this.tpoint != null) {
                other.setPoint(new TDPoint(this.tpoint.getRa(), this.tpoint.getDe()));
            } else {
                other.setPoint(new TDPoint());
            }
            if (this.end_tpoint != null) {
                other.setEndPoint(new TDPoint(this.end_tpoint.getRa(), this.end_tpoint.getDe()));
            } else {
                other.setEndPoint(new TDPoint());
            }
            if (this.bgpot != null) {
                other.resetBgpot();
                i = 0;
                while (i < this.bgpot.size()) {
                    Double db = (Double)this.bgpot.elementAt(i);
                    if (db == null) {
                        other.setBgpot(i, 0.0);
                    } else {
                        other.setBgpot(i, db);
                    }
                    ++i;
                }
            }
            if (this.areaData != null) {
                other.resetAreaData();
                i = 0;
                while (i < this.areaData.size()) {
                    TDPoint pt = (TDPoint)this.areaData.elementAt(i);
                    if (pt != null) {
                        other.addAreaData(new TDPoint(pt));
                    }
                    ++i;
                }
            }
            return other;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setName(String str) {
        this.name = new String(str);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "no_name";
    }

    public void setPosData(String[] str) {
        this._setPosData(str, true);
    }

    public void setEndPosData(String[] str) {
        this._setPosData(str, false);
        this.setAreaData();
    }

    private void _setPosData(String[] str, boolean flag) {
        int i = 0;
        while (i < 3) {
            try {
                if (flag) {
                    this.ra[i] = Integer.valueOf(str[i]);
                } else {
                    this.end_ra[i] = Integer.valueOf(str[i]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (flag) {
                    this.ra[i] = 0;
                }
                this.end_ra[i] = 0;
            }
            try {
                if (flag) {
                    this.dec[i] = Integer.valueOf(str[i + 3]);
                } else {
                    this.end_dec[i] = Integer.valueOf(str[i + 3]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (flag) {
                    this.dec[i] = 0;
                }
                this.end_dec[i] = 0;
            }
            ++i;
        }
        if (flag) {
            double ravalue = (double)this.ra[0] + (double)this.ra[1] / 60.0 + (double)this.ra[2] / 3600.0;
            double decvalue = (double)this.dec[0] + (double)this.dec[1] / 60.0 + (double)this.dec[2] / 3600.0;
            this.tpoint = new TDPoint(ravalue * Math.PI / 12.0, decvalue * Math.PI / 180.0);
        } else {
            double ravalue = (double)this.end_ra[0] + (double)this.end_ra[1] / 60.0 + (double)this.end_ra[2] / 3600.0;
            double decvalue = (double)this.end_dec[0] + (double)this.end_dec[1] / 60.0 + (double)this.end_dec[2] / 3600.0;
            this.end_tpoint = new TDPoint(ravalue * Math.PI / 12.0, decvalue * Math.PI / 180.0);
        }
    }

    public void setRa(String str) {
        this.setRaDec(str, true, true);
    }

    public void setDec(String str) {
        this.setRaDec(str, false, true);
    }

    public void setEndRa(String str) {
        if (this.end_tpoint == null) {
            this.end_tpoint = new TDPoint();
        }
        this.setRaDec(str, true, false);
        this.setAreaData();
    }

    public void setEndDec(String str) {
        if (this.end_tpoint == null) {
            this.end_tpoint = new TDPoint();
        }
        this.setRaDec(str, false, false);
        this.setAreaData();
    }

    private void setRaDec(String str, boolean flag, boolean startEndFlag) {
        int[] ret = new int[3];
        double val = 0.0;
        try {
            val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            val = 0.0;
        }
        if (flag) {
            if (startEndFlag) {
                this.tpoint.setRa(val * Math.PI / 12.0);
            } else {
                this.end_tpoint.setRa(val * Math.PI / 12.0);
            }
        } else if (startEndFlag) {
            this.tpoint.setDe(val * Math.PI / 180.0);
        } else {
            this.end_tpoint.setDe(val * Math.PI / 180.0);
        }
        ret[0] = (int)val;
        ret[1] = (int)((val -= (double)ret[0]) / 0.016666666666666666);
        ret[2] = (int)((val -= (double)ret[1] * 0.016666666666666666) / 2.777777777777778E-4);
        int i = 0;
        while (i < 3) {
            if (startEndFlag) {
                if (flag) {
                    this.ra[i] = ret[i];
                } else {
                    this.dec[i] = ret[i];
                }
            } else if (flag) {
                this.end_ra[i] = ret[i];
            } else {
                this.end_dec[i] = ret[i];
            }
            ++i;
        }
    }

    private String getPosStr() {
        return this._getPosStr(true);
    }

    private String getEndPosStr() {
        return this._getPosStr(false);
    }

    private String _getPosStr(boolean flag) {
        int de2;
        int de1;
        int de0;
        int ra2;
        int ra1;
        int ra0;
        if (flag) {
            ra0 = this.ra[0];
            ra1 = this.ra[1];
            ra2 = this.ra[2];
            de0 = this.dec[0];
            de1 = this.dec[1];
            de2 = this.dec[2];
        } else {
            ra0 = this.end_ra[0];
            ra1 = this.end_ra[1];
            ra2 = this.end_ra[2];
            de0 = this.end_dec[0];
            de1 = this.end_dec[1];
            de2 = this.end_dec[2];
        }
        String ret = String.valueOf(Integer.toString(ra0)) + "hr " + Integer.toString(ra1) + "min " + Integer.toString(ra2) + "sec RA,";
        if (this.getDecValue() > 0.0) {
            ret = String.valueOf(ret) + "+";
        }
        ret = String.valueOf(ret) + Integer.toString(de0) + "deg " + Integer.toString(de1) + "min " + Integer.toString(de2) + "sec DEC";
        return ret;
    }

    public double getRaValue() {
        return this.tpoint.getRa();
    }

    public double getDecValue() {
        return this.tpoint.getDe();
    }

    public double getRaHMS() {
        return this.tpoint.getRa() * 12.0 / Math.PI;
    }

    public double getDecDeg() {
        return this.tpoint.getDe() * 180.0 / Math.PI;
    }

    public double getEndRaValue() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getRa();
    }

    public double getEndDecValue() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getDe();
    }

    public double getEndRaHMS() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getRa() * 12.0 / Math.PI;
    }

    public double getEndDecDeg() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getDe() * 180.0 / Math.PI;
    }

    public TDPoint getPoint() {
        return this.tpoint;
    }

    public void setPoint(TDPoint _tpoint) {
        this.tpoint = _tpoint;
    }

    public TDPoint getEndPoint() {
        return this.end_tpoint;
    }

    public void setEndPoint(TDPoint _tpoint) {
        this.end_tpoint = _tpoint;
    }

    public void setBand(String str) {
        try {
            this.subband_base = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.subband_base = 0.0;
        }
    }

    public void setBsPower(String str) {
        this.bs_power = new String(str);
        try {
            this.bs_power_val = Double.valueOf(this.bs_power);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_power = "ND";
            this.bs_power_val = 0.0;
        }
    }

    public void setBsScore(String str) {
        this.bs_score = new String(str);
        try {
            this.bs_score_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_score = "ND";
            this.bs_score_val = 0.0;
        }
    }

    public void setBsBin(String str) {
        this.bs_bin = new String(str);
        try {
            this.bs_bin_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_bin = "ND";
            this.bs_bin_val = 0.0;
        }
    }

    public void setBsFftInd(String str) {
        this.bs_fft_ind = new String(str);
        try {
            this.bs_fft_ind_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_fft_ind = "ND";
            this.bs_fft_ind_val = 0.0;
        }
    }

    public void setBsChirpRate(String str) {
        this.bs_chirp_rate = new String(str);
        try {
            this.bs_chirp_rate_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_chirp_rate = "ND";
            this.bs_chirp_rate_val = 0.0;
        }
    }

    public void setBsFftLen(String str) {
        this.bs_fft_len = new String(str);
        try {
            this.bs_fft_len_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_fft_len = "ND";
            this.bs_fft_len_val = 0.0;
        }
    }

    public void setBgPower(String str) {
        this.bg_power = new String(str);
        try {
            this.bg_power_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_power = "ND";
            this.bg_power_val = 0.0;
        }
    }

    public double getBgPower() {
        return this.bg_power_val;
    }

    public void setBgScore(String str) {
        this.bg_score = new String(str);
        try {
            this.bg_score_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_score = "ND";
            this.bg_score_val = 0.0;
        }
    }

    public void setBgChisq(String str) {
        this.bg_chisq = new String(str);
        try {
            this.bg_chisq_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_chisq = "ND";
            this.bg_chisq_val = 0.0;
        }
    }

    public double getBgChisq() {
        return this.bg_chisq_val;
    }

    public void setBgTrueMean(String str) {
        this.bg_true_mean = new String(str);
        try {
            this.bg_true_mean_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_true_mean = "ND";
            this.bg_true_mean_val = 0.0;
        }
    }

    public double getBgTrueMean() {
        return this.bg_true_mean_val;
    }

    public void setBgSigma(String str) {
        this.bg_sigma = new String(str);
        try {
            this.bg_sigma_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_sigma = "ND";
            this.bg_sigma_val = 0.0;
        }
    }

    public void setBgBin(String str) {
        this.bg_bin = new String(str);
        try {
            this.bg_bin_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_bin = "ND";
            this.bg_bin_val = 0.0;
        }
    }

    public void setBgFftInd(String str) {
        this.bg_fft_ind = new String(str);
        try {
            this.bg_fft_ind_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_fft_ind = "ND";
            this.bg_fft_ind_val = 0.0;
        }
    }

    public void setBgChirpRate(String str) {
        this.bg_chirp_rate = new String(str);
        try {
            this.bg_chirp_rate_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_chirp_rate = "ND";
            this.bg_chirp_rate_val = 0.0;
        }
    }

    public void setBgFftLen(String str) {
        this.bg_fft_len = new String(str);
        try {
            this.bg_fft_len_val = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_fft_len = "ND";
            this.bg_fft_len_val = 0.0;
        }
    }

    public void setCpu(String str) {
        try {
            this.cpu = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.cpu = 0.0;
        }
    }

    public String getCpuString() {
        double val = this.cpu;
        if (val < 0.0) {
            val = 0.0;
        }
        return ResultData.genHMSString(val);
    }

    public void setProg(String str) {
        try {
            this.prog = Double.valueOf(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.prog = 0.0;
        }
    }

    public double getProgValue() {
        return this.prog;
    }

    public String getProgString() {
        double val = this.prog;
        if (val < 0.0) {
            val = 0.0;
        }
        return String.valueOf(DoubleFormat.toString(val * 100.0, 3)) + " %";
    }

    public void setTimeRecorded(String str) {
        if (str == null) {
            this.time_recorded = "ND";
            this.time_recorded_yms = "ND";
            this.recordedTime = new Date(0L);
            return;
        }
        StringTokenizer st = str.indexOf("(") == -1 || str.indexOf(")") == -1 ? new StringTokenizer(str) : new StringTokenizer(str.substring(1, str.length() - 1));
        int index = 0;
        this.time_recorded = "";
        while (st.hasMoreTokens()) {
            String sstr = st.nextToken();
            if (index == 2) {
                int val = 0;
                try {
                    val = Integer.valueOf(sstr);
                }
                catch (NumberFormatException numberFormatException) {
                    val = 0;
                }
                if (val < 10) {
                    this.time_recorded = String.valueOf(this.time_recorded) + "0";
                }
            }
            this.time_recorded = String.valueOf(this.time_recorded) + sstr + " ";
            ++index;
        }
        SimpleDateFormat iformatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", new DateFormatSymbols(Locale.US));
        ParsePosition ps = new ParsePosition(0);
        this.recordedTime = iformatter.parse(this.time_recorded, ps);
        if (this.recordedTime == null) {
            iformatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", new DateFormatSymbols(Locale.US));
            this.recordedTime = iformatter.parse(this.time_recorded, ps);
        }
        if (this.recordedTime == null) {
            this.recordedTime = new Date(0L);
        }
        SimpleDateFormat outformatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.time_recorded_yms = outformatter.format(this.recordedTime);
    }

    public void setInfoUpdated(Date _updatedTime) {
        this.infoUpdatedTime = _updatedTime;
    }

    private String getUpdatedStr() {
        SimpleDateFormat outformatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        outformatter.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        return outformatter.format(this.infoUpdatedTime);
    }

    public void setStartedTime(Date _startedTime) {
        this.startedTime = _startedTime;
    }

    public Date getStartedTime() {
        return this.startedTime;
    }

    private void setStartedTimeStr() {
        SimpleDateFormat outformatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        outformatter.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        this.startedTimeStr = this.startedTime == null ? "ND" : outformatter.format(this.startedTime);
    }

    public void setTimeZone(String _timeZoneID) {
        this.timeZoneID = _timeZoneID;
        this.setStartedTimeStr();
    }

    public void setDirName(String _dirname) {
        this.dirname = _dirname;
    }

    public void setShortName(String _shortname) {
        this.shortname = _shortname;
    }

    public String getDirName() {
        return this.dirname;
    }

    public void setFinishedFlag(boolean _flag) {
        this.finishedFlag = _flag;
    }

    public boolean getFinishedFlag() {
        return this.finishedFlag;
    }

    public void setPointData(PointData _pt) {
        this.pt = _pt;
    }

    public PointData getPointData() {
        return this.pt;
    }

    public void setPlotData(PlotData _pt) {
        this.plt = _pt;
    }

    public PlotData getPlotData() {
        return this.plt;
    }

    public void setColorName(String _colorname) {
        this.colorname = _colorname;
        if (this.pt != null) {
            this.pt.setColor(this.colorname);
        }
    }

    public String getColorName() {
        return this.colorname;
    }

    public String getTitle() {
        return this.getPosStr();
    }

    public void setMd(MxData _md) {
        this.md = _md;
    }

    public void clearLinkToMx() {
        this.md = null;
    }

    public boolean getVisible() {
        if (this.md == null) {
            return true;
        }
        return this.md.getVisible();
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean flag) {
        this.selected = flag;
    }

    public String getRemainCpuString() {
        int min;
        if (this.prog == 0.0) {
            return null;
        }
        double val = this.cpu / this.prog - this.cpu;
        if (val < 0.0) {
            val = 0.0;
        }
        int hr = (int)(val / 3600.0);
        val -= (double)(hr * 3600);
        if ((val -= (double)((min = (int)(val / 60.0)) * 60)) > 1.0 && ++min == 60) {
            min = 0;
            ++hr;
        }
        String ret = String.valueOf(Integer.toString(hr)) + "hr " + Integer.toString(min) + "min";
        return ret;
    }

    public void setBgpot(int index, double value) {
        if (this.bgpot == null) {
            this.bgpot = new Vector();
        }
        if (index > this.bgpot.size() - 1) {
            this.bgpot.setSize(index + 1);
        }
        this.bgpot.setElementAt(new Double(value), index);
    }

    public Vector getBgpot() {
        return this.bgpot;
    }

    private void resetBgpot() {
        this.bgpot = new Vector();
    }

    private void resetAreaData() {
        this.areaData = new Vector();
    }

    private void addAreaData(TDPoint pt) {
        this.areaData.addElement(pt);
    }

    public void getAreaData(Vector ct) {
        if (this.areaData == null || this.areaData.size() == 0) {
            this.setAreaData();
        }
        int i = 0;
        while (i < this.areaData.size()) {
            TDPoint pt = (TDPoint)this.areaData.elementAt(i);
            ct.addElement(new TDPoint(pt));
            ++i;
        }
    }

    private void setAreaData() {
        this.areaData = new Vector();
        if (this.tpoint != null && this.end_tpoint == null) {
            this.areaData.addElement(new TDPoint(this.tpoint));
        } else if (this.tpoint != null && this.end_tpoint != null) {
            TDPoint delta = this.tpoint.subtract(this.end_tpoint);
            if (delta.length() == 0.0) {
                double angle = 1.5707963267948966 - this.tpoint.getDe();
                delta = new TDPoint(this.tpoint.getRa(), angle);
                this.setAreaPoint(this.tpoint, delta, this.areaData);
                angle = this.tpoint.getRa() + 1.5707963267948966;
                if (angle > Math.PI * 2) {
                    angle -= Math.PI * 2;
                }
                TDPoint delta0 = new TDPoint(angle, 0.0);
                this.setAreaPoint(this.tpoint, delta0, this.areaData);
                TDPoint pt = (TDPoint)this.areaData.elementAt(1);
                this.areaData.setElementAt(this.areaData.elementAt(2), 1);
                this.areaData.setElementAt(pt, 2);
            } else {
                this.setAreaPoint(this.tpoint, delta, this.areaData);
                this.setAreaPoint(this.end_tpoint, delta, this.areaData);
                TDPoint pt = (TDPoint)this.areaData.elementAt(2);
                this.areaData.setElementAt(this.areaData.elementAt(3), 2);
                this.areaData.setElementAt(pt, 3);
            }
        }
    }

    private void setAreaPoint(TDPoint pt, TDPoint delta, Vector bag) {
        double length = pt.length() * Math.tan(8.726646259971648E-4);
        TDPoint ct = pt.cross(delta);
        ct.changeLength(length);
        TDPoint n1 = ct.add(pt);
        n1.changeLength(1.0);
        bag.addElement(n1);
        TDPoint ct2 = delta.cross(pt);
        ct2.changeLength(length);
        TDPoint n2 = ct2.add(pt);
        n2.changeLength(1.0);
        bag.addElement(n2);
    }

    public boolean getTop() {
        return this.getBgChisq() < 2.0 + 1.5 * this.getBgPower() && this.getBgChisq() <= 10.0 && this.getBgPower() > 0.0;
    }

    public void clearStateInfo() {
        this.setCpu("0.0");
        this.setProg("0.0");
        this.resetBgpot();
        this.setBsPower("0.0");
        this.setBsScore("0.0");
        this.setBgPower("0.0");
        this.setBgScore("0.0");
        this.setBgChisq("0.0");
        this.setBgTrueMean("0.0");
        this.setBgSigma("0.0");
        this.setBgBin("0.0");
        this.setBgFftInd("0.0");
        this.setBgChirpRate("0.0");
        this.setBgFftLen("0.0");
    }

    public String getDataStr() {
        String ret = "";
        if (this.name != null) {
            ret = String.valueOf(ret) + "Name : " + this.name;
        }
        if (this.shortname != null) {
            ret = String.valueOf(ret) + " (@ " + this.shortname + ")";
        }
        if (this.name != null || this.shortname != null) {
            ret = String.valueOf(ret) + "\n";
        }
        ret = String.valueOf(ret) + "From : " + this.getPosStr() + "\n";
        if (this.time_recorded != null) {
            ret = String.valueOf(ret) + "Recorded on : " + this.time_recorded + "\n";
        }
        if (this.subband_base >= 0.0) {
            ret = String.valueOf(ret) + "Base Frequency : " + DoubleFormat.toString(this.subband_base / 1.0E9, 9) + " GHz\n";
        }
        if (this.bs_power != null) {
            ret = String.valueOf(ret) + "Strongest Peak : power " + this.bs_power;
        }
        if (this.bs_score != null) {
            ret = String.valueOf(ret) + ", score " + this.bs_score + "\n";
        }
        if (this.bg_power != null) {
            ret = String.valueOf(ret) + "Strongest Gaussian : power " + this.bg_power;
        }
        if (this.bg_chisq != null) {
            ret = String.valueOf(ret) + ", fit " + this.bg_chisq;
        }
        if (this.bg_score != null) {
            ret = String.valueOf(ret) + ", score " + this.bg_score + "\n";
        }
        if (this.prog >= 0.0) {
            ret = String.valueOf(ret) + "Overall : " + this.getProgString() + " Done";
        }
        if (this.cpu >= 0.0) {
            ret = String.valueOf(ret) + " CPU Time : " + this.getCpuString() + "\n";
        }
        if (this.cpu > 0.0 && this.prog > 0.0 && !this.finishedFlag) {
            ret = String.valueOf(ret) + "Estimated remaining CPU Time: " + this.getRemainCpuString() + "\n";
        }
        if (this.startedTime != null) {
            ret = String.valueOf(ret) + "Analysis started : " + this.startedTimeStr + " \n";
        }
        if (this.infoUpdatedTime != null) {
            ret = String.valueOf(ret) + "Information Updated : " + this.getUpdatedStr();
        }
        return ret;
    }

    public String getFileOutStr(boolean flag) {
        String ret = "";
        ret = String.valueOf(ret) + "name=" + this.getName() + "\r";
        ret = String.valueOf(ret) + "start_ra=" + DoubleFormat.toString(this.getRaHMS(), 3) + "\r";
        ret = String.valueOf(ret) + "start_dec=" + DoubleFormat.toString(this.getDecDeg(), 3) + "\r";
        if (this.end_tpoint != null && !this.end_tpoint.isNull()) {
            ret = String.valueOf(ret) + "end_ra=" + DoubleFormat.toString(this.getEndRaHMS(), 3) + "\r";
            ret = String.valueOf(ret) + "end_dec=" + DoubleFormat.toString(this.getEndDecDeg(), 3) + "\r";
        }
        ret = String.valueOf(ret) + "subband_base=" + this.subband_base + "\r";
        ret = String.valueOf(ret) + "time_recorded=" + "(" + this.time_recorded + ")" + "\r";
        ret = String.valueOf(ret) + "bs_power=" + this.bs_power + "\r";
        ret = String.valueOf(ret) + "bs_score=" + this.bs_score + "\r";
        ret = String.valueOf(ret) + "bs_bin=" + this.bs_bin + "\r";
        ret = String.valueOf(ret) + "bs_fft_ind=" + this.bs_fft_ind + "\r";
        ret = String.valueOf(ret) + "bs_chirp_rate=" + this.bs_chirp_rate + "\r";
        ret = String.valueOf(ret) + "bs_fft_len=" + this.bs_fft_len + "\r";
        ret = String.valueOf(ret) + "bg_power=" + this.bg_power + "\r";
        ret = String.valueOf(ret) + "bg_chisq=" + this.bg_chisq + "\r";
        ret = String.valueOf(ret) + "bg_score=" + this.bg_score + "\r";
        ret = String.valueOf(ret) + "bg_true_mean=" + this.bg_true_mean + "\r";
        ret = String.valueOf(ret) + "bg_sigma=" + this.bg_sigma + "\r";
        ret = String.valueOf(ret) + "bg_bin=" + this.bg_bin + "\r";
        ret = String.valueOf(ret) + "bg_fft_ind=" + this.bg_fft_ind + "\r";
        ret = String.valueOf(ret) + "bg_chirp_rate=" + this.bg_chirp_rate + "\r";
        ret = String.valueOf(ret) + "bg_fft_len=" + this.bg_fft_len + "\r";
        ret = String.valueOf(ret) + "prog=" + Double.toString(this.prog) + "\r";
        ret = String.valueOf(ret) + "cpu=" + Double.toString(this.cpu) + "\r";
        if (flag) {
            ret = String.valueOf(ret) + "DataDirName=" + this.dirname + "\r";
        }
        String dateString = null;
        if (this.startedTime != null) {
            SimpleDateFormat outformatter = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss");
            outformatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateString = outformatter.format(this.startedTime);
            ret = String.valueOf(ret) + "started_time=" + dateString + "\r";
        }
        if (this.bgpot != null) {
            int i = 0;
            while (i < this.bgpot.size()) {
                Double dt = (Double)this.bgpot.elementAt(i);
                if (dt != null) {
                    ret = String.valueOf(ret) + "bg_pot " + i + "=" + dt.toString() + "\r";
                }
                ++i;
            }
        }
        return ret;
    }

    public void getCSVStr(Vector svect) {
        String namestr = "ND";
        if (this.name != null) {
            namestr = this.name;
        }
        svect.addElement(namestr);
        double val = this.prog;
        if (val < 0.0) {
            val = 0.0;
        }
        svect.addElement(DoubleFormat.toString(val, 6));
        if (this.cpu >= 0.0) {
            svect.addElement(Double.toString(this.cpu));
            svect.addElement(this.getCpuString());
        } else {
            svect.addElement("ND");
            svect.addElement("ND");
        }
        if (this.startedTimeStr == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.startedTimeStr);
        }
        if (this.bs_power == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bs_power);
        }
        if (this.bs_score == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bs_score);
        }
        if (this.bs_chirp_rate == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bs_chirp_rate);
        }
        if (this.bg_power == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bg_power);
        }
        if (this.bg_chisq == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bg_chisq);
        }
        if (this.bg_score == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bg_score);
        }
        if (this.bg_chirp_rate == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.bg_chirp_rate);
        }
        svect.addElement(DoubleFormat.toString(this.tpoint.getRa(), 3));
        svect.addElement(DoubleFormat.toString(this.tpoint.getDe(), 3));
        if (this.end_tpoint == null) {
            svect.addElement("ND");
            svect.addElement("ND");
        } else if (this.end_tpoint.isNull()) {
            svect.addElement("ND");
            svect.addElement("ND");
        } else {
            svect.addElement(DoubleFormat.toString(this.end_tpoint.getRa(), 3));
            svect.addElement(DoubleFormat.toString(this.end_tpoint.getDe(), 3));
        }
        if (this.time_recorded_yms == null) {
            svect.addElement("ND");
        } else {
            svect.addElement(this.time_recorded_yms);
        }
        if (this.subband_base < 0.0) {
            svect.addElement("ND");
        } else {
            svect.addElement(DoubleFormat.toString(this.subband_base, 2));
        }
    }

    public StrDbl getMxVal(String title) {
        if (title.equals(GLBX.TITLE[1])) {
            return new StrDbl(this.name, 0.0);
        }
        if (title.equals(GLBX.TITLE[2])) {
            double val = this.prog;
            if (val < 0.0) {
                val = 0.0;
            }
            return new StrDbl(DoubleFormat.toString(val, 6), val);
        }
        if (title.equals(GLBX.TITLE[3])) {
            return new StrDbl(ResultData.cvrToTime(this.cpu), this.cpu);
        }
        if (title.equals(GLBX.TITLE[4])) {
            if (this.startedTime == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(this.startedTimeStr, this.startedTime.getTime());
        }
        if (title.equals(GLBX.TITLE[5])) {
            return new StrDbl(this.bs_power, this.bs_power_val);
        }
        if (title.equals(GLBX.TITLE[6])) {
            return new StrDbl(this.bs_score, this.bs_score_val);
        }
        if (title.equals(GLBX.TITLE[7])) {
            return new StrDbl(this.bs_chirp_rate, this.bs_chirp_rate_val);
        }
        if (title.equals(GLBX.TITLE[8])) {
            return new StrDbl(this.bg_power, this.bg_power_val);
        }
        if (title.equals(GLBX.TITLE[9])) {
            return new StrDbl(this.bg_chisq, this.bg_chisq_val);
        }
        if (title.equals(GLBX.TITLE[10])) {
            return new StrDbl(this.bg_score, this.bg_score_val);
        }
        if (title.equals(GLBX.TITLE[11])) {
            return new StrDbl(this.bg_chirp_rate, this.bg_chirp_rate_val);
        }
        if (title.equals(GLBX.TITLE[12])) {
            return new StrDbl(DoubleFormat.toString(this.getRaHMS(), 3), this.getRaValue());
        }
        if (title.equals(GLBX.TITLE[13])) {
            return new StrDbl(DoubleFormat.toString(this.getDecDeg(), 3), this.getDecValue());
        }
        if (title.equals(GLBX.TITLE[14])) {
            if (this.end_tpoint == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(DoubleFormat.toString(this.getEndRaHMS(), 3), this.getEndRaValue());
        }
        if (title.equals(GLBX.TITLE[15])) {
            if (this.end_tpoint == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(DoubleFormat.toString(this.getEndDecDeg(), 3), this.getEndDecValue());
        }
        if (title.equals(GLBX.TITLE[16])) {
            if (this.time_recorded == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(this.time_recorded_yms, this.recordedTime.getTime());
        }
        if (title.equals(GLBX.TITLE[17])) {
            String ret = "ND";
            if (this.subband_base >= 0.0) {
                ret = DoubleFormat.toString(this.subband_base, 2);
            }
            return new StrDbl(ret, this.subband_base);
        }
        return null;
    }

    public static String genHMSString(double val) {
        int hr = (int)(val / 3600.0);
        int min = (int)((val -= (double)(hr * 3600)) / 60.0);
        String ret = "";
        ret = String.valueOf(ret) + Integer.toString(hr) + " hr " + Integer.toString(min) + " min " + Integer.toString((int)(val -= (double)(min * 60))) + " sec";
        return ret;
    }

    public static String cvrToTime(double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        int hr = (int)(val / 3600.0);
        int min = (int)((val -= (double)(hr * 3600)) / 60.0);
        val -= (double)(min * 60);
        String ret = "";
        if (hr < 10) {
            ret = String.valueOf(ret) + "0";
        }
        ret = String.valueOf(ret) + Integer.toString(hr) + "h:";
        if (min < 10) {
            ret = String.valueOf(ret) + "0";
        }
        ret = String.valueOf(ret) + Integer.toString(min) + "m:";
        if (val < 10.0) {
            ret = String.valueOf(ret) + "0";
        }
        ret = String.valueOf(ret) + Integer.toString((int)val) + "s";
        return ret;
    }
}

