/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.util.Random;
import java.util.Vector;

public class PointData {
    Random dice = new Random(0L);
    int currentLevel;
    int maxLevel;
    Vector particles;
    int maxParticleNo = 300;
    ResultData orgData;
    Color cl;
    DPos pos;
    Vector areaData;
    Vector rings;
    double[] brtable = new double[]{1.0, 0.9, 0.8, 0.7, 0.45, 0.4, 0.3, 0.2, 0.2, 0.1};

    public PointData(int firstLevel, int _maxLevel, ResultData _org) {
        this.maxLevel = _maxLevel;
        this.currentLevel = firstLevel;
        this.particles = new Vector();
        this.orgData = _org;
        this.orgData.setPointData(this);
        this.rings = new Vector();
        this.cl = Color.yellow;
        this.pos = new DPos();
    }

    public boolean getFinished() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getFinishedFlag();
    }

    public boolean getSelected() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getSelected();
    }

    public void setSelected(boolean flag) {
        if (this.orgData != null) {
            this.orgData.setSelected(flag);
        }
    }

    public int getLevel() {
        return this.currentLevel;
    }

    public void setLevel(int _level) {
        this.currentLevel = _level;
    }

    public void addLevel() {
        ++this.currentLevel;
        if (this.currentLevel >= this.maxLevel) {
            this.currentLevel = 0;
        }
    }

    public double getProgValue() {
        return this.orgData.getProgValue();
    }

    public String getProgString() {
        return this.orgData.getProgString();
    }

    public String getCpuString() {
        return this.orgData.getCpuString();
    }

    public String getRemainCpuString() {
        return this.orgData.getRemainCpuString();
    }

    public ResultData getOrgData() {
        return this.orgData;
    }

    public void setColor(String colorName) {
        if (colorName == null) {
            return;
        }
        if (colorName.equals("Yellow")) {
            this.cl = Color.yellow;
        } else if (colorName.equals("LightBlue")) {
            this.cl = Color.getHSBColor(0.5f, 0.5f, 1.0f);
        } else if (colorName.equals("Green")) {
            this.cl = Color.getHSBColor(0.32f, 0.51f, 1.0f);
        } else if (colorName.equals("Magenta")) {
            this.cl = Color.getHSBColor(0.83f, 0.5f, 1.0f);
        } else if (colorName.equals("Orange")) {
            this.cl = Color.getHSBColor(0.073f, 0.7f, 1.0f);
        } else if (colorName.equals("Pink")) {
            this.cl = Color.pink;
        } else if (colorName.equals("Red")) {
            this.cl = Color.getHSBColor(0.0f, 0.6f, 1.0f);
        } else if (colorName.equals("White")) {
            this.cl = Color.white;
        }
    }

    public Color getColor() {
        return this.cl;
    }

    public boolean getVisible() {
        return this.orgData.getVisible();
    }

    public DPos getPoint() {
        this.pos.setPos(this.orgData.getPoint());
        return this.pos;
    }

    public DPos getEndPoint() {
        this.pos.setPos(this.orgData.getEndPoint());
        return this.pos;
    }

    public Vector getBgpot() {
        if (this.orgData == null) {
            return null;
        }
        return this.orgData.getBgpot();
    }

    public double getBgTrueMean() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgTrueMean();
    }

    public double getBgPower() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgPower();
    }

    public double getBgChisq() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgChisq();
    }

    public void resetDPoints() {
        this.pos.resetDPoint();
        if (this.areaData != null) {
            int i = 0;
            while (i < this.areaData.size()) {
                DPos pt = (DPos)this.areaData.elementAt(i);
                pt.resetDPoint();
                ++i;
            }
        }
    }

    public boolean getTop() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getTop();
    }

    public void addParticle(Point pt, int no, int dist, int mindist) {
        int totalno = this.particles.size() + no;
        int i = 0;
        while (i < totalno - this.maxParticleNo) {
            this.particles.removeElement((ParticleData)this.particles.elementAt(0));
            ++i;
        }
        int i2 = 0;
        while (i2 < no) {
            this.particles.addElement(this.genParticle(pt, dist, mindist));
            ++i2;
        }
    }

    private ParticleData genParticle(Point pt, int dist, int mindist) {
        int length = (int)(this.dice.nextDouble() * (double)dist) + dist;
        double phai = this.dice.nextDouble() * 2.0 * 3.1416;
        return new ParticleData(pt.x, pt.y, mindist, length, phai);
    }

    public Vector getPtVect() {
        Vector<ParticleData> deadlist = new Vector<ParticleData>();
        int i = 0;
        while (i < this.particles.size()) {
            ParticleData pt = (ParticleData)this.particles.elementAt(i);
            pt.act();
            if (pt.getLifeValue() < 0.1) {
                deadlist.addElement(pt);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < deadlist.size()) {
            this.particles.removeElement((ParticleData)deadlist.elementAt(i2));
            ++i2;
        }
        return this.particles;
    }

    public void getAreaData(Vector ct) {
        if (this.areaData == null) {
            this.areaData = new Vector();
            Vector bg = new Vector();
            this.orgData.getAreaData(bg);
            int i = 0;
            while (i < bg.size()) {
                TDPoint pt = (TDPoint)bg.elementAt(i);
                this.areaData.addElement(new DPos(pt));
                ++i;
            }
        }
        int i = 0;
        while (i < this.areaData.size()) {
            DPos pt = (DPos)this.areaData.elementAt(i);
            ct.addElement(pt);
            ++i;
        }
    }

    public boolean hasLingP() {
        return this.rings.size() != 0;
    }

    public void initRings() {
        int i = 0;
        while (i < this.maxLevel) {
            this.rings.addElement(new SRing(7, this.brtable[i]));
            ++i;
        }
    }

    public Vector getRings() {
        return this.rings;
    }

    public void rotate() {
        int i = 0;
        while (i < this.rings.size()) {
            SRing sr = (SRing)this.rings.elementAt(i);
            sr.rotate(13 - i);
            ++i;
        }
    }
}

