/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.util.Vector;

public class PlotData {
    int currentLevel;
    int maxLevel;
    ResultData orgData;
    Point pt;
    Color cl;

    public PlotData(int firstLevel, int _maxLevel, ResultData _org) {
        this.maxLevel = _maxLevel;
        this.currentLevel = firstLevel;
        this.orgData = _org;
        this.orgData.setPlotData(this);
        this.cl = Color.yellow;
    }

    public boolean getFinished() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getFinishedFlag();
    }

    public boolean getSelected() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getSelected();
    }

    public boolean getTop() {
        if (this.orgData == null) {
            return false;
        }
        return this.orgData.getTop();
    }

    public int getLevel() {
        return this.currentLevel;
    }

    public void setLevel(int _level) {
        this.currentLevel = _level;
    }

    public void addLevel() {
        ++this.currentLevel;
        if (this.currentLevel >= this.maxLevel) {
            this.currentLevel = 0;
        }
    }

    public double getProgValue() {
        return this.orgData.getProgValue();
    }

    public String getProgString() {
        return this.orgData.getProgString();
    }

    public String getCpuString() {
        return this.orgData.getCpuString();
    }

    public String getRemainCpuString() {
        return this.orgData.getRemainCpuString();
    }

    public ResultData getOrgData() {
        return this.orgData;
    }

    public void setColor(String colorName) {
        if (colorName == null) {
            return;
        }
        if (colorName.equals("Yellow")) {
            this.cl = Color.yellow;
        } else if (colorName.equals("LightBlue")) {
            this.cl = Color.getHSBColor(0.5f, 0.5f, 1.0f);
        } else if (colorName.equals("Green")) {
            this.cl = Color.getHSBColor(0.32f, 0.51f, 1.0f);
        } else if (colorName.equals("Magenta")) {
            this.cl = Color.getHSBColor(0.83f, 0.5f, 1.0f);
        } else if (colorName.equals("Orange")) {
            this.cl = Color.getHSBColor(0.073f, 0.7f, 1.0f);
        } else if (colorName.equals("Pink")) {
            this.cl = Color.pink;
        } else if (colorName.equals("Red")) {
            this.cl = Color.getHSBColor(0.0f, 0.6f, 1.0f);
        } else if (colorName.equals("White")) {
            this.cl = Color.white;
        }
    }

    public Color getColor() {
        return this.cl;
    }

    public boolean getVisible() {
        return this.orgData.getVisible();
    }

    public TDPoint getPoint() {
        return this.orgData.getPoint();
    }

    public Vector getBgpot() {
        if (this.orgData == null) {
            return null;
        }
        return this.orgData.getBgpot();
    }

    public double getBgTrueMean() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgTrueMean();
    }

    public double getBgPower() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgPower();
    }

    public double getBgChisq() {
        if (this.orgData == null) {
            return 0.0;
        }
        return this.orgData.getBgChisq();
    }

    public void setPt(Point _pt) {
        this.pt = _pt;
    }

    public Point getPt() {
        return this.pt;
    }
}

