/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class MyClipper {
    static final int C_LEFT = 0;
    static final int C_RIGHT = 1;
    static final int C_TOP = 2;
    static final int C_BOTTOM = 3;
    Dimension dim = new Dimension();

    MyClipper() {
    }

    public boolean clipPoint(Point pt) {
        if (pt == null) {
            return false;
        }
        return pt.x >= 0 && pt.x <= this.dim.width && pt.y >= 0 && pt.y <= this.dim.height;
    }

    public void setClipRange(Dimension d) {
        this.dim = d;
    }

    public Rectangle lineclip(Point p1, Point p2) {
        Rectangle ret = new Rectangle(p1.x, p1.y, p2.x, p2.y);
        ret = this.clipByLine(ret, 0, 0);
        ret = this.clipByLine(ret, this.dim.width, 1);
        ret = this.clipByLine(ret, 0, 2);
        ret = this.clipByLine(ret, this.dim.height, 3);
        return ret;
    }

    private Rectangle clipByLine(Rectangle rec, int val, int edge) {
        int x0 = rec.x;
        int y0 = rec.y;
        int x1 = rec.width;
        int y1 = rec.height;
        Polygon newPoly = new Polygon();
        boolean inside = this.insideArea(x0, y0, val, edge);
        if (this.insideArea(x1, y1, val, edge)) {
            if (inside) {
                newPoly.addPoint(x0, y0);
                newPoly.addPoint(x1, y1);
            } else {
                Point cross = this.getCrossing(x0, y0, x1, y1, val, edge);
                newPoly.addPoint(cross.x, cross.y);
                newPoly.addPoint(x1, y1);
            }
        } else if (inside) {
            Point cross = this.getCrossing(x0, y0, x1, y1, val, edge);
            newPoly.addPoint(cross.x, cross.y);
            newPoly.addPoint(x0, y0);
        }
        Rectangle ret = new Rectangle();
        ret.x = newPoly.xpoints[0];
        ret.y = newPoly.ypoints[0];
        ret.width = newPoly.xpoints[1];
        ret.height = newPoly.ypoints[1];
        return ret;
    }

    private boolean insideArea(int x, int y, int val, int edge) {
        switch (edge) {
            case 0: {
                if (x < val) break;
                return true;
            }
            case 1: {
                if (x > val) break;
                return true;
            }
            case 2: {
                if (y < val) break;
                return true;
            }
            case 3: {
                if (y > val) break;
                return true;
            }
        }
        return false;
    }

    private Point getCrossing(int x1, int y1, int x2, int y2, int val, int edge) {
        Point cross = new Point(0, 0);
        switch (edge) {
            case 0: 
            case 1: {
                cross.x = val;
                cross.y = ((y1 - y2) * val + (x1 * y2 - x2 * y1)) / (x1 - x2);
                break;
            }
            case 2: 
            case 3: {
                cross.x = ((x1 - x2) * val - (x1 * y2 - x2 * y1)) / (y1 - y2);
                cross.y = val;
                break;
            }
        }
        return cross;
    }
}

