/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class MtxCanvas
extends Canvas {
    MatrixViewer boss;
    Vector datavect;
    Vector titlevect;
    MxPrefValue pref;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    FontMetrics fm;
    FontMetrics boldfm;
    Font font;
    Font boldfont;
    int charHeight;
    int charDescent;
    int charLeading;
    int charAscent;
    int arrowWidth;
    TitleData selectedTd;
    boolean sortRequiredFlag = true;
    boolean cutOffRequiredFlag = true;
    int lineHeight;
    int arrowindex = -1;
    int tindex = 1;
    int dindex = 1;
    int maxTIndex = 0;
    int maxDIndex = 0;
    int tvisible = 0;
    int dvisible = 0;
    int hgap = 4;
    int vgap = 2;
    boolean vfinishflag = true;
    boolean hfinishflag = true;

    public MtxCanvas(MatrixViewer _boss, MxPrefValue _pref) {
        this.pref = _pref;
        this.boss = _boss;
        Vector<TitleData> temp_titlevect = new Vector<TitleData>();
        int i = 0;
        while (i < GLBX.TITLE.length + 1) {
            temp_titlevect.addElement(null);
            ++i;
        }
        temp_titlevect.setElementAt(new TitleData("No"), 0);
        Vector titlename = new Vector();
        this.pref.getTitleVect(titlename);
        Vector cvect = this.pref.getCondVect();
        int i2 = 0;
        while (i2 < GLBX.TITLE.length) {
            TitleData ntd = new TitleData(GLBX.TITLE[i2]);
            boolean addedFlag = false;
            int j = 0;
            while (j < titlename.size()) {
                String tstr = (String)titlename.elementAt(j);
                boolean visibleFlag = true;
                if (tstr.charAt(0) == '*') {
                    visibleFlag = false;
                    tstr = tstr.substring(1);
                }
                if (tstr.equals(ntd.getTitle())) {
                    temp_titlevect.setElementAt(ntd, j);
                    ntd.setVisible(visibleFlag);
                    addedFlag = true;
                    break;
                }
                ++j;
            }
            if (!addedFlag) {
                temp_titlevect.addElement(ntd);
            }
            int j2 = 0;
            while (j2 < cvect.size()) {
                String str = (String)cvect.elementAt(j2);
                StringTokenizer st = new StringTokenizer(str, "$");
                String tstr = st.nextToken();
                if (tstr.equals(ntd.getTitle())) {
                    ntd.setCutCond(new CutCond(st.nextToken()));
                }
                ++j2;
            }
            ++i2;
        }
        this.titlevect = new Vector();
        int i3 = 0;
        while (i3 < temp_titlevect.size()) {
            TitleData td = (TitleData)temp_titlevect.elementAt(i3);
            if (td != null) {
                this.titlevect.addElement(td);
            }
            ++i3;
        }
        this.datavect = new Vector();
        this.tindex = 0;
        this.dindex = 0;
        this.setFont(10);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
    }

    public void setFont(int fontSize) {
        String[] fontNames = Toolkit.getDefaultToolkit().getFontList();
        this.font = new Font(fontNames[1], 0, fontSize);
        this.boldfont = new Font(fontNames[1], 1, fontSize);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.boldfm = Toolkit.getDefaultToolkit().getFontMetrics(this.boldfont);
        this.charHeight = this.fm.getHeight();
        this.charDescent = this.fm.getDescent();
        this.charAscent = this.fm.getAscent();
        this.charLeading = this.fm.getLeading();
        this.arrowWidth = this.charHeight / 2;
        this.lineHeight = this.charHeight + 2 * this.vgap;
    }

    public void setData(Vector _datavect) {
        this.datavect.removeAllElements();
        int i = 0;
        while (i < _datavect.size()) {
            ResultData rd = (ResultData)_datavect.elementAt(i);
            if (rd.getFinishedFlag()) {
                this.datavect.addElement(new MxData(i + 1, Integer.toString(i + 1), rd));
            } else {
                this.datavect.addElement(new MxData(i + 1, "*" + Integer.toString(i + 1), rd));
            }
            this.sortRequiredFlag = true;
            this.cutOffRequiredFlag = true;
            ++i;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.cutOffData();
        this.sortData();
        this.handleCutOff();
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        this.paintData(this.offgraphics);
        g.drawImage(this.offscreen, 0, 0, null);
        this.setMaxTDIndex();
        this.boss.resetScrollBar(this.tindex, this.tvisible, 1, this.maxTIndex, this.dindex, this.dvisible, 0, this.maxDIndex);
    }

    private void handleCutOff() {
        TitleData td = (TitleData)this.titlevect.elementAt(0);
        if (!td.hasCutCond()) {
            return;
        }
        int cutOffNo = (int)td.getCutCond().getVal();
        int count = 0;
        int i = 0;
        while (i < this.datavect.size()) {
            MxData md = (MxData)this.datavect.elementAt(i);
            if (md.getVisible() && ++count > cutOffNo) {
                md.setVisible(false);
            }
            ++i;
        }
    }

    private int findThOfTd(TitleData _td) {
        int index = 0;
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td.getVisible()) {
                if (td == _td) {
                    return index;
                }
                ++index;
            }
            ++i;
        }
        return 0;
    }

    private int findThOfMd(MxData _md) {
        int index = 0;
        int i = 0;
        while (i < this.datavect.size()) {
            MxData md = (MxData)this.datavect.elementAt(i);
            if (md.getVisible()) {
                if (md == _md) {
                    return index;
                }
                ++index;
            }
            ++i;
        }
        return 0;
    }

    private void setMaxTDIndex() {
        int dwidth = this.getSize().width;
        int width = ((TitleData)this.titlevect.elementAt(0)).getWidth();
        TitleData oldtd = null;
        int i = this.titlevect.size() - 1;
        while (i >= 0) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td.getVisible()) {
                if ((width += td.getWidth()) > dwidth) {
                    if (oldtd != null) break;
                    oldtd = td;
                    break;
                }
                oldtd = td;
            }
            --i;
        }
        this.maxTIndex = this.findThOfTd(oldtd);
        int height = this.lineHeight;
        MxData oldmd = null;
        int i2 = this.datavect.size() - 1;
        while (i2 >= 0) {
            MxData md = (MxData)this.datavect.elementAt(i2);
            if (md.getVisible()) {
                if ((height += this.lineHeight) > this.getSize().height) {
                    if (oldmd != null) break;
                    oldmd = md;
                    break;
                }
                oldmd = md;
            }
            --i2;
        }
        this.maxDIndex = this.findThOfMd(oldmd);
    }

    private void paintData(Graphics g) {
        this.vfinishflag = true;
        this.hfinishflag = true;
        g.setFont(this.font);
        int x = 0;
        int dwidth = this.getSize().width;
        int dheight = this.getSize().height;
        boolean colorflag = true;
        boolean drawflag = true;
        this.tvisible = 0;
        this.dvisible = 0;
        int vtindex = 0;
        int i = 0;
        while (i < this.titlevect.size()) {
            block25: {
                TitleData td = (TitleData)this.titlevect.elementAt(i);
                if (!td.getVisible() || ++vtindex - 1 < this.tindex && i != 0) break block25;
                ++this.tvisible;
                int maxw = 0;
                int width = 0;
                boolean noflag = "No".equals(td.getTitle());
                int count = 0;
                int y = this.charLeading + this.charAscent + this.vgap;
                int j = 0;
                while (j < this.datavect.size() + 1) {
                    block28: {
                        block27: {
                            String str;
                            block26: {
                                str = "";
                                if (j != 0) break block26;
                                str = td.getTitle();
                                if (td.hasCutCond()) {
                                    str = "[" + str + "]";
                                }
                                width = this.fm.stringWidth(str);
                                if (td.getTitle().equals(this.pref.getSortTitle())) {
                                    width += this.arrowWidth * 2;
                                }
                                g.setColor(Color.darkGray);
                                if (i == 0 && drawflag) {
                                    g.fillRect(0, y - this.charAscent - this.charLeading - this.vgap, dwidth, this.lineHeight);
                                    g.setColor(Color.darkGray);
                                    g.drawLine(0, y + this.charDescent + this.vgap - 1, dwidth, y + this.charDescent + this.vgap - 1);
                                }
                                g.setColor(Color.pink);
                                g.drawString(str, x + this.hgap, y);
                                if (td.getTitle().equals(this.pref.getSortTitle())) {
                                    this.paintSortArrow(g, str, x, y);
                                }
                                break block27;
                            }
                            MxData rd = (MxData)this.datavect.elementAt(j - 1);
                            if (!rd.getVisible() || ++count - 1 < this.dindex) break block28;
                            if (noflag) {
                                str = new Integer(count).toString();
                                if (!rd.getFinishedFlag()) {
                                    double ph = (1.0 - rd.getProgValue()) / 2.0;
                                    g.setColor(Color.getHSBColor((float)ph, 0.5f, 1.0f));
                                } else if (colorflag) {
                                    g.setColor(Color.lightGray);
                                    colorflag = false;
                                } else {
                                    g.setColor(Color.white);
                                    colorflag = true;
                                }
                                if (drawflag) {
                                    g.fillRect(0, y - this.charAscent - this.charLeading - this.vgap, dwidth, this.lineHeight);
                                    if (rd.getSelected()) {
                                        g.setColor(Color.black);
                                        g.fillRect(0, y - this.charAscent - this.charLeading - this.vgap, 2, this.lineHeight);
                                        g.fillRect(0, y + 1, dwidth, this.charDescent + this.vgap - 1);
                                    }
                                    g.setColor(Color.darkGray);
                                    g.drawLine(0, y + this.charDescent + this.vgap - 1, dwidth, y + this.charDescent + this.vgap - 1);
                                }
                                ++this.dvisible;
                            } else {
                                str = rd.getMxStr(td.getTitle());
                                if (str == null || str.equals("null")) {
                                    str = "ND";
                                }
                            }
                            width = this.fm.stringWidth(str);
                            if (drawflag) {
                                g.setColor(Color.black);
                                g.drawString(str, x + this.hgap, y);
                            }
                        }
                        if (width > maxw) {
                            maxw = width;
                        }
                        if (y > dheight) {
                            y += this.lineHeight;
                            this.vfinishflag = false;
                            break;
                        }
                        y += this.lineHeight;
                    }
                    ++j;
                }
                td.setRect(x, 0, maxw + this.hgap * 2, this.lineHeight);
                x = x + maxw + this.hgap * 2;
                if (x > dwidth) {
                    drawflag = false;
                    this.hfinishflag = false;
                } else {
                    g.setColor(Color.white);
                    g.drawLine(x, 0, x, this.lineHeight);
                    g.setColor(Color.darkGray);
                    g.drawLine(x, this.lineHeight, x, y + this.charDescent + this.vgap - this.lineHeight - 1);
                    if (i == 0) {
                        g.setColor(Color.white);
                        g.drawLine(x - 2, 0, x - 2, this.lineHeight);
                        g.setColor(Color.darkGray);
                        g.drawLine(x - 2, this.lineHeight, x - 2, y + this.charDescent + this.vgap - this.lineHeight - 1);
                    }
                }
            }
            ++i;
        }
    }

    private void paintSortArrow(Graphics g, String str, int x, int y) {
        int arx = x + this.hgap + this.fm.stringWidth(str) + this.arrowWidth;
        int aryu = y - this.charAscent;
        int aryd = y;
        g.setColor(Color.yellow);
        g.drawLine(arx, aryu, arx, aryd);
        if (this.pref.getSortMode() == 1) {
            g.drawLine(arx - this.arrowWidth / 2, aryu + this.arrowWidth, arx, aryu);
            g.drawLine(arx + this.arrowWidth / 2, aryu + this.arrowWidth, arx, aryu);
        } else if (this.pref.getSortMode() == 0) {
            g.drawLine(arx - this.arrowWidth / 2, aryd - this.arrowWidth, arx, aryd);
            g.drawLine(arx + this.arrowWidth / 2, aryd - this.arrowWidth, arx, aryd);
        }
    }

    void MtxCanvas_MouseClicked(MouseEvent event) {
        Point ept = event.getPoint();
        boolean flag = false;
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td;
            if ((i >= this.tindex || i == 0) && (td = (TitleData)this.titlevect.elementAt(i)).getVisible() && td.contains(ept)) {
                this.selectedTd = td;
                this.boss.popupmenu(ept, td);
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            int y = ept.y;
            y -= this.lineHeight;
            int count = 0;
            int i2 = 0;
            while (i2 < this.datavect.size()) {
                MxData md = (MxData)this.datavect.elementAt(i2);
                if (md.getVisible() && ++count - 1 >= this.dindex && (y -= this.lineHeight) < 0) {
                    this.boss.selectFromMx(md);
                    this.repaint();
                    break;
                }
                ++i2;
            }
        }
    }

    public void listHiddenTitle(Vector vect) {
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (!td.getVisible()) {
                vect.addElement(td);
            }
            ++i;
        }
    }

    public void hideCurrentTitle() {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setVisible(false);
        this.setMaxTDIndex();
        this.repaint();
        this.fileOutPref();
    }

    public void showTitle(String _title) {
        if (_title == null) {
            return;
        }
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (!td.getVisible() && _title.equals(td.getTitle())) {
                td.setVisible(true);
                break;
            }
            ++i;
        }
        this.setMaxTDIndex();
        this.repaint();
        this.fileOutPref();
    }

    public void miSortData(int mode) {
        if (this.selectedTd == null) {
            return;
        }
        this.pref.setSortTitle(this.selectedTd.getTitle());
        this.pref.setSortMode(mode);
        this.sortRequiredFlag = true;
        this.repaint();
        this.fileOutPref();
    }

    private void cutOffData() {
        if (!this.cutOffRequiredFlag) {
            return;
        }
        this.clearCutOff();
        int i = 1;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td.hasCutCond() && !td.getTitle().equals("No")) {
                int j = 0;
                while (j < this.datavect.size()) {
                    MxData mdt = (MxData)this.datavect.elementAt(j);
                    double val = mdt.getMxVal(td.getTitle());
                    if (!td.applyCond(val)) {
                        mdt.setVisible(false);
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.cutOffRequiredFlag = false;
    }

    private void clearCutOff() {
        int i = 0;
        while (i < this.datavect.size()) {
            MxData mdt = (MxData)this.datavect.elementAt(i);
            mdt.setVisible(true);
            ++i;
        }
    }

    public void setCondition(CutCond _cond) {
        if (_cond == null) {
            return;
        }
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCond(_cond);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    public void delCondition() {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCond(null);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    public void disableAllConditions() {
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            td.setCutCondState(false);
            ++i;
        }
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    private void sortData() {
        if (!this.sortRequiredFlag) {
            return;
        }
        if (this.pref.getSortTitle() == null) {
            return;
        }
        this.genSortData(this.findTitleData(this.pref.getSortTitle()), this.pref.getSortMode());
        this.sortRequiredFlag = false;
    }

    public void setCutCondState(boolean flag) {
        if (this.selectedTd == null) {
            return;
        }
        this.selectedTd.setCutCondState(flag);
        this.fileOutPref();
        this.cutOffRequiredFlag = true;
        this.repaint();
    }

    private TitleData findTitleData(String name) {
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td.getTitle().equals(name)) {
                return td;
            }
            ++i;
        }
        System.out.println("in MtxCanvas.findTitleData, no match found for " + name);
        return null;
    }

    private void genSortData(TitleData td, int mode) {
        String title = td.getTitle();
        int i = 0;
        while (i < this.datavect.size()) {
            double val = ((MxData)this.datavect.elementAt(i)).getMxVal(title);
            int index = i;
            int j = i + 1;
            while (j < this.datavect.size()) {
                double cval = ((MxData)this.datavect.elementAt(j)).getMxVal(title);
                if (!this.compare(cval, val, mode)) {
                    val = cval;
                    index = j;
                }
                ++j;
            }
            Object t = this.datavect.elementAt(i);
            this.datavect.setElementAt(this.datavect.elementAt(index), i);
            this.datavect.setElementAt(t, index);
            ++i;
        }
    }

    boolean compare(double val1, double val2, int mode) {
        boolean retvalue = false;
        if (mode == 0) {
            retvalue = val1 >= val2;
        } else if (mode == 1) {
            retvalue = val1 <= val2;
        }
        return retvalue;
    }

    public void setSortRequiredFlag(boolean flag) {
        this.sortRequiredFlag = flag;
    }

    public void setBoundPref(Rectangle rect) {
        this.pref.setBound(rect);
    }

    public void fileOutPref() {
        this.pref.clearCutCond();
        this.pref.clearTitle();
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            CutCond tcd = td.getCutCond();
            String str = td.getTitle();
            if (!td.getVisible()) {
                str = "*" + str;
            }
            this.pref.addTitle(str);
            if (tcd != null) {
                this.pref.addCutCond(td.getTitle(), td.getCutCond());
            }
            ++i;
        }
        FileAnalyzer.fileOutMxPrefs(this.pref);
    }

    public MxPrefValue getPref() {
        return this.pref;
    }

    public void setTIndex(int val) {
        this.tindex = val;
        this.repaint();
    }

    public void setDIndex(int val) {
        this.dindex = val;
        this.repaint();
    }

    void MtxCanvas_ComponentResized(ComponentEvent event) {
        this.fileOutPref();
    }

    public void exportCSVFile(String fileName, int mode) {
        Vector<String> tvect = new Vector<String>();
        Vector cvect = new Vector();
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td.getVisible()) {
                tvect.addElement(td.getTitle());
            }
            ++i;
        }
        cvect.addElement(tvect);
        int count = 0;
        int i2 = 0;
        while (i2 < this.datavect.size()) {
            MxData md = (MxData)this.datavect.elementAt(i2);
            if (md.getVisible()) {
                Vector<String> svect = new Vector<String>();
                ++count;
                int j = 0;
                while (j < tvect.size()) {
                    String tstr = (String)tvect.elementAt(j);
                    if (tstr.equals("No")) {
                        svect.addElement(Integer.toString(count));
                    } else {
                        String sstr = md.getMxStr(tstr);
                        if (sstr == null) {
                            sstr = "ND";
                        }
                        svect.addElement(sstr);
                    }
                    ++j;
                }
                cvect.addElement(svect);
            }
            ++i2;
        }
        FileAnalyzer.exportCSVFile(fileName, cvect, mode);
    }

    public TitleData getSelectedTd() {
        return this.selectedTd;
    }

    public void setToSelectedData() {
        int count = 0;
        int i = 0;
        while (i < this.datavect.size()) {
            MxData md = (MxData)this.datavect.elementAt(i);
            if (md.getVisible()) {
                if (md.getSelected()) {
                    this.dindex = count;
                    break;
                }
                ++count;
            }
            ++i;
        }
    }

    public void moveTitle(int direction) {
        if (this.selectedTd == null) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i);
            if (td == this.selectedTd) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        int nindex = index;
        if (direction == 0) {
            do {
                if (nindex != this.titlevect.size() - 1) continue;
                return;
            } while (!((TitleData)this.titlevect.elementAt(++nindex)).getVisible());
        } else if (direction == 1) {
            if (index == 0) {
                return;
            }
            do {
                if (nindex - 1 != 0) continue;
                return;
            } while (!((TitleData)this.titlevect.elementAt(--nindex)).getVisible());
        }
        this.titlevect.removeElement(this.selectedTd);
        this.titlevect.insertElementAt(this.selectedTd, nindex);
        this.repaint();
        this.fileOutPref();
    }

    public boolean titleMoveEligible(int direction) {
        if (this.selectedTd == null) {
            return true;
        }
        int index = -1;
        int i = 0;
        while (i < this.titlevect.size()) {
            if (this.selectedTd == (TitleData)this.titlevect.elementAt(i)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return true;
        }
        int count = 0;
        if (direction == 1) {
            int i2 = 0;
            while (i2 < index) {
                TitleData td = (TitleData)this.titlevect.elementAt(i2);
                if (td.getVisible()) {
                    ++count;
                }
                ++i2;
            }
            return count > true;
        }
        int i3 = index + 1;
        while (i3 < this.titlevect.size()) {
            TitleData td = (TitleData)this.titlevect.elementAt(i3);
            if (td.getVisible()) {
                ++count;
            }
            ++i3;
        }
        return count != 0;
    }

    public boolean getHFinishFlag() {
        return this.hfinishflag && this.tindex <= 1;
    }

    public boolean getVFinishFlag() {
        return this.vfinishflag && this.dindex == 0;
    }

    public void clearData() {
        int i = 0;
        while (i < this.datavect.size()) {
            MxData md = (MxData)this.datavect.elementAt(i);
            md.clearLinkToRd();
            ++i;
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == MtxCanvas.this) {
                MtxCanvas.this.MtxCanvas_MouseClicked(event);
            }
        }

        SymMouse() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == MtxCanvas.this) {
                MtxCanvas.this.MtxCanvas_ComponentResized(event);
            }
        }

        SymComponent() {
        }
    }
}

