/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;

public class MatrixViewer
extends Frame
implements ScrollBoss {
    boolean fComponentsAdjusted = false;
    SETISupport boss;
    MtxCanvas maincanvas;
    MenuBar mainMenuBar;
    Menu menu1;
    MenuItem miExportCSV;
    MenuItem miExportTAB;
    MenuItem miExportHTM;
    MenuItem miExit;
    MenuItem miAllCondOff;
    MenuItem miHide;
    MenuItem miSortAsc;
    MenuItem miSortDes;
    MenuItem miTitleRight;
    MenuItem miTitleLeft;
    MenuItem miCutOff;
    MenuItem miEditCond;
    PopupMenu pmenu;
    Menu show_sub;
    FileDialog exportFileDialog;
    CondInputDialog cdipDialog;
    GScroll hbar;
    GScroll vbar;
    boolean startUpFlag = true;
    MxPrefValue pref = FileAnalyzer.readMxPrefs();

    public MatrixViewer(SETISupport _boss) {
        this.boss = _boss;
        this.initLayout();
        this.setData();
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
    }

    public void setData() {
        Vector datavect = new Vector();
        this.boss.setMxData(datavect);
        this.maincanvas.setData(datavect);
    }

    public void initLayout() {
        this.setTitle("SETI@Support Data Table");
        Rectangle dm = this.pref.getBound();
        int wwidth = dm.width;
        int wheight = dm.height;
        ((Component)this).setLocation(dm.x, dm.y);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        ((Component)this).setSize(wwidth, wheight);
        this.maincanvas = new MtxCanvas(this, this.pref);
        this.add("Center", this.maincanvas);
        this.hbar = new GScroll(this, 0);
        this.hbar.setUnitIncrement(1);
        this.vbar = new GScroll(this, 1);
        this.vbar.setUnitIncrement(1);
        this.add("East", this.vbar);
        this.add("South", this.hbar);
        this.mainMenuBar = new MenuBar();
        this.menu1 = new Menu("File");
        Menu export_sub = new Menu("Export  FIle..", true);
        this.miExportCSV = new MenuItem("CSV");
        export_sub.add(this.miExportCSV);
        this.miExportTAB = new MenuItem("Tab separator");
        export_sub.add(this.miExportTAB);
        this.miExportHTM = new MenuItem("HTML");
        export_sub.add(this.miExportHTM);
        this.menu1.add(export_sub);
        this.menu1.addSeparator();
        this.miExit = new MenuItem("Close");
        this.menu1.add(this.miExit);
        Menu menu2 = new Menu("Setting");
        this.show_sub = new Menu("Show..");
        menu2.add(this.show_sub);
        this.updateShowMenu();
        this.miAllCondOff = new MenuItem("Turn All Condition off");
        menu2.add(this.miAllCondOff);
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(menu2);
        this.setMenuBar(this.mainMenuBar);
        this.pmenu = new PopupMenu();
        this.miHide = new MenuItem("Hide");
        this.miSortAsc = new MenuItem("Sort Asc");
        this.miSortDes = new MenuItem("Sort Des");
        this.miTitleRight = new MenuItem("Move Title Right");
        this.miTitleLeft = new MenuItem("Move Title Left");
        this.miCutOff = new MenuItem("nodata");
        this.miEditCond = new MenuItem("Edit Condition..");
        this.pmenu.add(this.miHide);
        this.pmenu.add(this.miTitleRight);
        this.pmenu.add(this.miTitleLeft);
        this.pmenu.add(this.miSortAsc);
        this.pmenu.add(this.miSortDes);
        this.pmenu.add(this.miEditCond);
        this.pmenu.add(this.miCutOff);
        this.maincanvas.add(this.pmenu);
        SymAction lSymAction = new SymAction();
        this.miExit.addActionListener(lSymAction);
        this.miAllCondOff.addActionListener(lSymAction);
        this.miHide.addActionListener(lSymAction);
        this.miSortAsc.addActionListener(lSymAction);
        this.miSortDes.addActionListener(lSymAction);
        this.miTitleRight.addActionListener(lSymAction);
        this.miTitleLeft.addActionListener(lSymAction);
        this.miExportCSV.addActionListener(lSymAction);
        this.miExportTAB.addActionListener(lSymAction);
        this.miExportHTM.addActionListener(lSymAction);
        this.miCutOff.addActionListener(lSymAction);
        this.miEditCond.addActionListener(lSymAction);
        this.exportFileDialog = new FileDialog((Frame)this, "Please specify file name", 1);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    void miEditCond_Action(ActionEvent event) {
        TitleData selectedTd = this.maincanvas.getSelectedTd();
        String condstr = this.miCutOff.getLabel();
        if (this.getCutOffState()) {
            condstr = condstr.substring(1);
        }
        this.cdipDialog = selectedTd.getTitle().equals("No") ? new CondInputDialog(this, "Input Condition", condstr, this.getCutOffState(), false) : new CondInputDialog(this, "Input Condition", condstr, this.getCutOffState(), true);
        Dimension d = this.getSize();
        ((Component)this.cdipDialog).setLocation(d.width / 3, d.height / 3);
        this.cdipDialog.show();
    }

    private void miCutOff_Action(ActionEvent event) {
        boolean flag = this.getCutOffState();
        boolean nflag = !flag;
        this.setCutOffState(nflag);
        this.maincanvas.setCutCondState(nflag);
    }

    private boolean getCutOffState() {
        String str = this.miCutOff.getLabel();
        return str.charAt(0) == '*';
    }

    private void setCutOffState(boolean flag) {
        boolean cflag = this.getCutOffState();
        if (flag == cflag) {
            return;
        }
        String str = this.miCutOff.getLabel();
        str = flag ? "*" + str : str.substring(1);
        this.miCutOff.setLabel(str);
    }

    void setCondition(int relindex, String valstr, boolean val) {
        this.maincanvas.setCondition(new CutCond(relindex, valstr, val));
    }

    void delCondition() {
        this.maincanvas.delCondition();
    }

    void miShow_Action(MenuItem mt) {
        this.maincanvas.showTitle(mt.getLabel());
        this.updateShowMenu();
    }

    void miAllCondOff_Action(ActionEvent event) {
        this.maincanvas.disableAllConditions();
    }

    void miExit_Action(ActionEvent event) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    void miHide_Action(ActionEvent event) {
        this.maincanvas.hideCurrentTitle();
        this.updateShowMenu();
    }

    void miSort_Action(ActionEvent event, int mode) {
        this.maincanvas.miSortData(mode);
    }

    void miTitleMove_Action(int direction) {
        this.maincanvas.moveTitle(direction);
    }

    void miExport_Action(int mode) {
        int defMode = this.exportFileDialog.getMode();
        String defTitle = this.exportFileDialog.getTitle();
        String defDirectory = this.exportFileDialog.getDirectory();
        String defFile = "";
        if (mode == 0) {
            defFile = "tst_data.csv";
        } else if (mode == 1) {
            defFile = "tst_data.txt";
        } else if (mode == 2) {
            defFile = "tst_data.htm";
        }
        this.exportFileDialog = new FileDialog((Frame)this, defTitle, defMode);
        this.exportFileDialog.setDirectory(defDirectory);
        this.exportFileDialog.setFile(defFile);
        this.exportFileDialog.show();
        String dirName = this.exportFileDialog.getDirectory();
        String fileName = this.exportFileDialog.getFile();
        if (dirName == null || fileName == null) {
            return;
        }
        this.maincanvas.exportCSVFile(String.valueOf(dirName) + fileName, mode);
    }

    private void updateShowMenu() {
        Vector hvect = new Vector();
        this.maincanvas.listHiddenTitle(hvect);
        this.show_sub.removeAll();
        SymAction lSymAction = new SymAction();
        int i = 0;
        while (i < hvect.size()) {
            TitleData htd = (TitleData)hvect.elementAt(i);
            MenuItem mit = new MenuItem(htd.getTitle());
            mit.addActionListener(lSymAction);
            this.show_sub.add(mit);
            ++i;
        }
    }

    public void popupmenu(Point pos, TitleData td) {
        this.pmenu.removeAll();
        String title = td.getTitle();
        if (!title.equals(GLBX.TITLE[1]) && !title.equals("No")) {
            this.pmenu.add(this.miSortDes);
            this.pmenu.add(this.miSortAsc);
            this.pmenu.addSeparator();
        }
        if (!title.equals("No")) {
            this.pmenu.add(this.miHide);
            this.miHide.setLabel("Hide '" + td.getTitle() + "'");
        }
        if (!title.equals("No")) {
            if (this.maincanvas.titleMoveEligible(0)) {
                this.pmenu.add(this.miTitleRight);
            }
            if (this.maincanvas.titleMoveEligible(1)) {
                this.pmenu.add(this.miTitleLeft);
            }
        }
        if (title.equals(GLBX.TITLE[0]) || title.equals(GLBX.TITLE[2]) || title.equals(GLBX.TITLE[5]) || title.equals(GLBX.TITLE[6]) || title.equals(GLBX.TITLE[7]) || title.equals(GLBX.TITLE[8]) || title.equals(GLBX.TITLE[9]) || title.equals(GLBX.TITLE[10]) || title.equals(GLBX.TITLE[11]) || title.equals("No")) {
            CutCond cond;
            if (this.pmenu.getItemCount() > 0) {
                this.pmenu.addSeparator();
            }
            if ((cond = td.getCutCond()) == null) {
                this.miEditCond.setLabel("Add condition..");
            } else {
                this.miEditCond.setLabel("Edit condition..");
                String str = cond.getStr();
                StringTokenizer st = new StringTokenizer(str);
                String labelstr = String.valueOf(st.nextToken()) + " " + st.nextToken() + " " + st.nextToken();
                this.miCutOff.setLabel(labelstr);
                this.setCutOffState(cond.getState());
                this.pmenu.add(this.miCutOff);
            }
            this.pmenu.add(this.miEditCond);
        }
        this.pmenu.show(this.maincanvas, pos.x, pos.y);
    }

    void MatrixViewer_WindowClosing(WindowEvent event) {
        this.maincanvas.setBoundPref(this.getBounds());
        this.maincanvas.fileOutPref();
        this.maincanvas.clearData();
        this.setVisible(false);
        this.dispose();
        this.boss.clearMx();
    }

    public void changeScroll(int val, int mode) {
        if (mode == 0) {
            this.maincanvas.setTIndex(val);
        } else {
            this.maincanvas.setDIndex(val);
        }
    }

    public void update(boolean flag) {
        if (flag) {
            this.maincanvas.setSortRequiredFlag(true);
        }
        this.maincanvas.repaint();
    }

    public void updateWithScroll() {
        this.maincanvas.setToSelectedData();
        this.maincanvas.repaint();
    }

    void MatrixViewer_WindowDeactivated(WindowEvent event) {
        this.boss.SETISupport_WindowDeactivated(null);
    }

    public void selectFromMx(MxData md) {
        this.boss.selectFromOutside(md.getRd(), false);
    }

    public void resetScrollBar(int tindex, int tvisible, int minTIndex, int maxTIndex, int dindex, int dvisible, int minDIndex, int maxDIndex) {
        if (this.maincanvas.getHFinishFlag()) {
            this.remove(this.hbar);
        } else {
            this.add("South", this.hbar);
            this.hbar.setValues(tindex, tvisible, minTIndex, maxTIndex);
        }
        if (this.maincanvas.getVFinishFlag()) {
            this.remove(this.vbar);
        } else {
            this.add("East", this.vbar);
            this.vbar.setValues(dindex, dvisible, minDIndex, maxDIndex);
        }
        this.validate();
        this.doLayout();
    }

    void MatrixViewer_ComponentShown(ComponentEvent event) {
        if (this.startUpFlag) {
            this.startUpFlag = false;
            Rectangle dm = this.pref.getBound();
            if (dm.width != 0 && dm.height != 0) {
                ((Component)this).setSize(new Dimension(dm.width, dm.height));
                ((Component)this).setLocation(dm.x, dm.y);
            } else {
                ((Component)this).setLocation(80, 80);
                ((Component)this).setSize(new Dimension(600, 200));
            }
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == MatrixViewer.this.miExit) {
                MatrixViewer.this.MatrixViewer_WindowClosing(null);
            } else if (object == MatrixViewer.this.miHide) {
                MatrixViewer.this.miHide_Action(event);
            } else if (object == MatrixViewer.this.miAllCondOff) {
                MatrixViewer.this.miAllCondOff_Action(event);
            } else if (object == MatrixViewer.this.miSortAsc) {
                MatrixViewer.this.miSort_Action(event, 0);
            } else if (object == MatrixViewer.this.miSortDes) {
                MatrixViewer.this.miSort_Action(event, 1);
            } else if (object == MatrixViewer.this.miTitleRight) {
                MatrixViewer.this.miTitleMove_Action(0);
            } else if (object == MatrixViewer.this.miTitleLeft) {
                MatrixViewer.this.miTitleMove_Action(1);
            } else if (object == MatrixViewer.this.miExportCSV) {
                MatrixViewer.this.miExport_Action(0);
            } else if (object == MatrixViewer.this.miExportTAB) {
                MatrixViewer.this.miExport_Action(1);
            } else if (object == MatrixViewer.this.miExportHTM) {
                MatrixViewer.this.miExport_Action(2);
            } else if (object == MatrixViewer.this.miEditCond) {
                MatrixViewer.this.miEditCond_Action(event);
            } else if (object == MatrixViewer.this.miCutOff) {
                MatrixViewer.this.miCutOff_Action(event);
            } else {
                int i = 0;
                while (i < MatrixViewer.this.show_sub.getItemCount()) {
                    MenuItem mt = MatrixViewer.this.show_sub.getItem(i);
                    if (object == mt) {
                        MatrixViewer.this.miShow_Action(mt);
                    }
                    ++i;
                }
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
        }

        SymItem() {
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowDeactivated(WindowEvent event) {
            Object object = event.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_WindowDeactivated(event);
            }
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_WindowClosing(event);
            }
        }

        SymWindow() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentShown(ComponentEvent event) {
            Object object = event.getSource();
            if (object == MatrixViewer.this) {
                MatrixViewer.this.MatrixViewer_ComponentShown(event);
            }
        }

        SymComponent() {
        }
    }
}

