/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ListDialog
extends Dialog {
    List datalist;
    Button okButton;
    Button cancelButton;
    Button addButton;
    Button deleteButton;
    Button changeNameButton;
    Panel sidePanel;
    Label strlabel;
    TextField inputtext;
    Button acceptButton;
    TextArea dataText;
    Choice colorChoice;
    SETISupport boss;
    Vector cvect = new Vector();
    DirData selectedItem;
    int dispmode;
    boolean fComponentsAdjusted = false;

    public ListDialog(Frame parent, String title, int mode) {
        super(parent, title);
        this.boss = (SETISupport)parent;
        int width = 450;
        int height = 0;
        if (mode == 0) {
            height = 180;
        } else if (mode == 1) {
            height = 220;
        } else if (mode == 2) {
            height = 180;
            width = 500;
        }
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(width, height);
        ((Component)this).setBackground(Color.black);
        this.datalist = new List(4, false);
        this.datalist.setBackground(Color.black);
        this.datalist.setForeground(Color.cyan);
        this.datalist.setSize(width, (int)((double)height * 0.3));
        if (mode == 0 || mode == 2) {
            this.add("Center", this.datalist);
        } else if (mode == 1) {
            this.add("North", this.datalist);
        }
        Panel lowerPanel = new Panel();
        lowerPanel.setLayout(new BorderLayout(0, 0));
        lowerPanel.setBackground(Color.black);
        this.add("South", lowerPanel);
        if (mode == 0 || mode == 2) {
            Panel lupanel = new Panel();
            lupanel.setBackground(Color.black);
            lupanel.setLayout(new FlowLayout(0));
            lowerPanel.add("North", lupanel);
            this.strlabel = new Label("Input Short Name");
            lupanel.add(this.strlabel);
            this.strlabel.setVisible(false);
            this.strlabel.setForeground(Color.pink);
            this.strlabel.setBackground(Color.black);
            this.inputtext = new TextField(8);
            lupanel.add(this.inputtext);
            this.inputtext.setVisible(false);
            this.inputtext.setForeground(Color.pink);
            ((Component)this.inputtext).setBackground(Color.black);
            this.acceptButton = new Button("Accept");
            this.acceptButton.setBackground(Color.white);
            this.acceptButton.setForeground(Color.black);
            lupanel.add(this.acceptButton);
            this.acceptButton.setVisible(false);
            if (mode == 2) {
                this.colorChoice = new Choice();
                this.colorChoice.setBackground(Color.white);
                this.colorChoice.setForeground(Color.black);
                lowerPanel.add("Center", this.colorChoice);
                this.colorChoice.add("Yellow");
                this.colorChoice.add("LightBlue");
                this.colorChoice.add("Green");
                this.colorChoice.add("Orange");
                this.colorChoice.add("Pink");
                this.colorChoice.add("Red");
                this.colorChoice.add("White");
            }
        } else {
            this.dataText = new TextArea();
            this.dataText.setSize(width, (int)((double)height * 0.7));
            ((Component)this.dataText).setBackground(Color.black);
            this.dataText.setForeground(Color.pink);
            this.add("Center", this.dataText);
        }
        this.sidePanel = new Panel();
        this.sidePanel.setLayout(new FlowLayout(0, 3, 3));
        this.sidePanel.setForeground(Color.black);
        lowerPanel.add("South", this.sidePanel);
        this.addButton = new Button("Add..");
        this.addButton.setBackground(Color.white);
        this.addButton.setForeground(Color.black);
        this.deleteButton = new Button("Delete");
        this.deleteButton.setForeground(Color.black);
        this.deleteButton.setBackground(Color.white);
        this.changeNameButton = new Button("Change Name..");
        this.changeNameButton.setForeground(Color.black);
        this.changeNameButton.setBackground(Color.white);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.setForeground(Color.black);
        this.cancelButton.setBackground(Color.white);
        this.okButton = new Button("OK");
        this.okButton.setForeground(Color.black);
        this.okButton.setBackground(Color.white);
        if (mode == 0 || mode == 2) {
            this.sidePanel.add(this.addButton);
            this.sidePanel.add(this.deleteButton);
            this.sidePanel.add(this.changeNameButton);
        }
        this.sidePanel.add(this.okButton);
        if (mode == 0 || mode == 2) {
            this.sidePanel.add(this.cancelButton);
        }
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.okButton.addActionListener(lSymAction);
        if (mode == 0 || mode == 2) {
            this.cancelButton.addActionListener(lSymAction);
            this.addButton.addActionListener(lSymAction);
            this.deleteButton.addActionListener(lSymAction);
            this.changeNameButton.addActionListener(lSymAction);
            this.acceptButton.addActionListener(lSymAction);
        }
        SymItem lSymItem = new SymItem();
        this.datalist.addItemListener(lSymItem);
        if (mode == 2) {
            this.colorChoice.addItemListener(lSymItem);
        }
        this.adjustButton();
        this.validate();
        this.doLayout();
    }

    public ListDialog(Frame parent, Vector _cvect, String title, int mode) {
        this(parent, title, mode);
        this.dispmode = mode;
        int i = 0;
        while (i < _cvect.size()) {
            DirData cdata = (DirData)((DirData)_cvect.elementAt(i)).clone();
            this.cvect.addElement(cdata);
            ++i;
        }
        this.setDataList();
    }

    private void setDataList() {
        this.selectedItem = null;
        this.datalist.removeAll();
        int selectedIndex = 0;
        int i = 0;
        while (i < this.cvect.size()) {
            DirData ddata = (DirData)this.cvect.elementAt(i);
            this.datalist.add(String.valueOf(ddata.getShortName()) + " : " + ddata.getDir());
            ResultData rdata = ddata.getProg();
            if (rdata != null && rdata.getSelected()) {
                selectedIndex = i;
            }
            ++i;
        }
        this.adjustButton();
        if (this.dispmode == 1) {
            if (this.datalist.getItemCount() > 0) {
                this.datalist.select(selectedIndex);
            }
            this.ptChoice_ItemStateChanged(null);
        }
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    void InputDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void okButton_Clicked(ActionEvent event) {
        if (this.dispmode == 0) {
            this.boss.updateDirData(this.cvect);
        } else if (this.dispmode == 2) {
            this.boss.updatePastDirData(this.cvect);
        }
        this.dispose();
    }

    void addButton_Clicked(ActionEvent event) {
        DirData ndata = null;
        if (this.dispmode == 0) {
            ndata = this.boss.miOpen_Action(null, this.cvect);
        } else if (this.dispmode == 2) {
            ndata = this.boss.miOpen_Action(null, this.cvect, false);
        }
        if (ndata == null) {
            return;
        }
        this.cvect.addElement(ndata);
        this.setDataList();
    }

    void deleteButton_Clicked(ActionEvent event) {
        if (this.selectedItem == null) {
            return;
        }
        if (this.dispmode == 2 && this.datalist.getSelectedIndex() == 0) {
            return;
        }
        this.cvect.removeElement(this.selectedItem);
        this.setDataList();
    }

    void acceptButton_Clicked(ActionEvent event) {
        String str = this.inputtext.getText();
        boolean flag = true;
        int i = 0;
        while (i < str.length()) {
            if (Character.isWhitespace(str.charAt(i))) {
                flag = false;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.cvect.size()) {
            DirData ddata = (DirData)this.cvect.elementAt(i2);
            if (ddata != this.selectedItem && str.equals(ddata.getShortName())) {
                flag = false;
                break;
            }
            ++i2;
        }
        if (flag) {
            this.selectedItem.setShortName(str);
        }
        this.strlabel.setVisible(false);
        this.inputtext.setVisible(false);
        this.acceptButton.setVisible(false);
        this.validate();
        this.doLayout();
        this.setDataList();
    }

    void changeNameButton_Clicked(ActionEvent event) {
        this.strlabel.setVisible(true);
        this.inputtext.setVisible(true);
        this.acceptButton.setVisible(true);
        ((TextComponent)this.inputtext).setText(this.selectedItem.getShortName());
        this.inputtext.selectAll();
        this.validate();
        this.doLayout();
    }

    void cancelButton_Clicked(ActionEvent event) {
        this.dispose();
    }

    void colorChoice_ItemStateChanged(ItemEvent event) {
        if (this.selectedItem == null) {
            return;
        }
        String colorStr = this.colorChoice.getSelectedItem();
        this.selectedItem.setColorName(colorStr);
    }

    void ptChoice_ItemStateChanged(ItemEvent event) {
        int selindex = this.datalist.getSelectedIndex();
        this.selectedItem = selindex >= 0 ? (DirData)this.cvect.elementAt(selindex) : null;
        if (this.dispmode == 0 || this.dispmode == 2) {
            this.adjustButton();
            if (this.dispmode == 2 && this.selectedItem != null) {
                this.colorChoice.select(this.selectedItem.getColorName());
            }
        } else if (this.dispmode == 1 && this.selectedItem != null) {
            this.dataText.setText(FileAnalyzer.getUserString(this.selectedItem.getDir()));
        }
    }

    private void adjustButton() {
        if (this.selectedItem == null) {
            this.deleteButton.setEnabled(false);
            this.changeNameButton.setEnabled(false);
        } else {
            this.changeNameButton.setEnabled(true);
            if (this.dispmode == 2 && this.datalist.getSelectedIndex() == 0) {
                this.deleteButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ListDialog.this) {
                ListDialog.this.InputDialog_WindowClosing(event);
            }
        }

        SymWindow() {
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ListDialog.this.okButton) {
                ListDialog.this.okButton_Clicked(event);
            } else if (object == ListDialog.this.addButton) {
                ListDialog.this.addButton_Clicked(event);
            } else if (object == ListDialog.this.deleteButton) {
                ListDialog.this.deleteButton_Clicked(event);
            } else if (object == ListDialog.this.changeNameButton) {
                ListDialog.this.changeNameButton_Clicked(event);
            } else if (object == ListDialog.this.cancelButton) {
                ListDialog.this.cancelButton_Clicked(event);
            } else if (object == ListDialog.this.acceptButton) {
                ListDialog.this.acceptButton_Clicked(event);
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == ListDialog.this.datalist) {
                ListDialog.this.ptChoice_ItemStateChanged(event);
            } else if (object == ListDialog.this.colorChoice) {
                ListDialog.this.colorChoice_ItemStateChanged(event);
            }
        }

        SymItem() {
        }
    }
}

