/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class KFileAnalyzer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readPTData(Vector ptvect, Object boss) {
        try {
            String filename = "SS_STAR5.TXT";
            BufferedReader ds = null;
            if (new File(filename).exists()) {
                ds = new BufferedReader(new FileReader(filename));
            } else {
                InputStream inURL = boss.getClass().getResourceAsStream(filename);
                ds = new BufferedReader(new InputStreamReader(inURL));
            }
            if (ds == null) {
                return;
            }
            while (true) {
                String line;
                if ((line = ds.readLine()) == null) {
                    return;
                }
                if ((line = line.trim()).length() == 0) continue;
                if (line.equals("--")) return;
                StringTokenizer st = new StringTokenizer(line);
                StarData pt = new StarData(st.nextToken(), st.nextToken(), st.nextToken());
                ptvect.addElement(pt);
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    public static void readCstData(Vector cstvect, Object boss) {
        try {
            String line;
            String filename = "SS_CST_DATA.TXT";
            BufferedReader ds = null;
            if (new File(filename).exists()) {
                ds = new BufferedReader(new FileReader(filename));
            } else {
                InputStream inURL = boss.getClass().getResourceAsStream(filename);
                ds = new BufferedReader(new InputStreamReader(inURL));
            }
            if (ds == null) {
                return;
            }
            CstData cst = null;
            while ((line = ds.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (!line.equals("--")) {
                    StringTokenizer st = new StringTokenizer(line);
                    if (line.substring(0, 2).equals("##")) {
                        st.nextToken();
                        cst = new CstData(st.nextToken(), st.nextToken(), Double.valueOf(st.nextToken()), Double.valueOf(st.nextToken()), Integer.valueOf(st.nextToken()));
                        cstvect.addElement(cst);
                        continue;
                    }
                    TLine pt = new TLine(Double.valueOf(st.nextToken()), Double.valueOf(st.nextToken()), Double.valueOf(st.nextToken()), Double.valueOf(st.nextToken()));
                    cst.addLine(pt);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }
}

