/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class GScroll
extends Panel {
    static final int NORMAL = 0;
    static final int SLIDER = 1;
    GDirectionButton sbtn;
    GDirectionButton lbtn;
    GSCanvas scanvas;
    boolean fComponentsAdjusted = false;
    int mode;
    int unitincrement;
    ScrollBoss boss;
    int dragoffset = 0;
    static final int busize = 15;
    static final int slidersize = 10;
    int type;

    GScroll(ScrollBoss _boss, int _mode) {
        this.setVars(_boss, _mode, 0);
    }

    GScroll(ScrollBoss _boss, int _mode, int _type) {
        this.setVars(_boss, _mode, _type);
    }

    private void setVars(ScrollBoss _boss, int _mode, int _type) {
        this.type = _type;
        this.boss = _boss;
        this.mode = _mode;
        this.setLayout(null);
        if (this.type == 0) {
            this.scanvas = new GSCanvas(this, 15, this.mode);
        } else if (this.type == 1) {
            this.scanvas = new GSCanvas(this, 10, this.mode);
        }
        if (this.mode == 0) {
            this.sbtn = new GDirectionButton(0);
            this.lbtn = new GDirectionButton(1);
        } else {
            this.sbtn = new GDirectionButton(2);
            this.lbtn = new GDirectionButton(3);
        }
        if (this.type == 0) {
            if (this.mode == 0) {
                this.add("East", this.lbtn);
                this.add("West", this.sbtn);
                this.add("Center", this.scanvas);
            } else if (this.mode == 1) {
                this.add("South", this.lbtn);
                this.add("North", this.sbtn);
                this.add("Center", this.scanvas);
            }
        } else if (this.type == 1) {
            this.add("Center", this.scanvas);
        }
        SymMouse aSymMouse = new SymMouse();
        this.sbtn.addMouseListener(aSymMouse);
        this.lbtn.addMouseListener(aSymMouse);
        this.scanvas.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.scanvas.addMouseMotionListener(aSymMouseMotion);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.mode == 0) {
            this.sbtn.setBounds(0, 0, 15, 15);
            this.scanvas.setBounds(15, 0, width - 30, 15);
            this.lbtn.setBounds(width - 15, 0, 15, 15);
        } else {
            this.sbtn.setBounds(0, 0, 15, 15);
            this.scanvas.setBounds(0, 15, 15, height - 30);
            this.lbtn.setBounds(0, height - 15, 15, 15);
        }
    }

    public void setValues(int _value, int _visible, int _min, int _max) {
        this.scanvas.setValues(_value, _visible, _min, _max);
    }

    public int getValue() {
        return this.scanvas.getValue();
    }

    public void setUnitIncrement(int _val) {
        this.unitincrement = _val;
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    public Dimension getPreferredSize() {
        Dimension p = this.getSize();
        if (this.mode == 0) {
            return new Dimension(Math.max(p.width, 60), Math.max(p.height, 15));
        }
        return new Dimension(Math.max(p.width, 15), Math.max(p.height, 60));
    }

    public Dimension getMinimumSize() {
        if (this.mode == 0) {
            return new Dimension(60, 15);
        }
        return new Dimension(15, 60);
    }

    public int getType() {
        return this.type;
    }

    void GScroll_MouseReleased(GDirectionButton btn, int val) {
        btn.setPressed(false);
        btn.repaint();
        this.scanvas.setChangeValue(val);
        this.scanvas.repaint();
    }

    void GScroll_MouseReleasedOnCV(MouseEvent event) {
        if (this.scanvas.getDragMode()) {
            this.scanvas.confirmValue();
            this.scanvas.setDragMode(false);
            this.scanvas.repaint();
        } else {
            int x = event.getX();
            if (this.mode == 1) {
                x = event.getY();
            }
            this.scanvas.chgBlockValue(x);
            this.scanvas.repaint();
        }
    }

    void GScroll_MousePressedOnCV(MouseEvent event) {
        int val = event.getX();
        if (this.mode == 1) {
            val = event.getY();
        }
        if (this.scanvas.isOnMarker(val)) {
            this.scanvas.setDragMode(true);
            this.dragoffset = this.scanvas.getBarX() - val;
        } else {
            this.scanvas.setDragMode(false);
        }
    }

    void GScroll_MouseDragged(MouseEvent event) {
        if (!this.scanvas.getDragMode()) {
            return;
        }
        int x = event.getX();
        if (this.mode == 1) {
            x = event.getY();
        }
        this.scanvas.setTempValue(x + this.dragoffset);
        this.scanvas.repaint();
        if (this.type == 1) {
            this.scanvas.confirmValue();
            this.boss.changeScroll(this.scanvas.getValue(), this.mode);
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mouseReleased(MouseEvent event) {
            Object object = event.getSource();
            if (object == GScroll.this.sbtn) {
                GScroll.this.GScroll_MouseReleased(GScroll.this.sbtn, -1 * GScroll.this.unitincrement);
            } else if (object == GScroll.this.lbtn) {
                GScroll.this.GScroll_MouseReleased(GScroll.this.lbtn, GScroll.this.unitincrement);
            } else if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MouseReleasedOnCV(event);
            }
            GScroll.this.boss.changeScroll(GScroll.this.scanvas.getValue(), GScroll.this.mode);
        }

        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MousePressedOnCV(event);
            } else if (object == GScroll.this.sbtn) {
                GScroll.this.sbtn.setPressed(true);
                GScroll.this.sbtn.repaint();
            } else if (object == GScroll.this.lbtn) {
                GScroll.this.lbtn.setPressed(true);
                GScroll.this.lbtn.repaint();
            }
        }

        SymMouse() {
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == GScroll.this.scanvas) {
                GScroll.this.GScroll_MouseDragged(event);
            }
        }

        SymMouseMotion() {
        }
    }
}

