/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class GSCanvas
extends Canvas {
    GScroll boss;
    int value;
    int visible;
    int min;
    int max;
    int barwidth;
    int mode;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    int busize;
    int barx;
    int tempvalue;
    boolean dragmode = false;

    public GSCanvas(GScroll _boss, int _busize, int _mode) {
        this.mode = _mode;
        this.busize = _busize;
        this.boss = _boss;
        this.min = 0;
        this.max = 0;
        this.value = 0;
        this.visible = 0;
        this.tempvalue = -1;
    }

    public Dimension getMinimumSize() {
        if (this.mode == 0) {
            return new Dimension(this.busize * 2, this.busize);
        }
        return new Dimension(this.busize, this.busize * 2);
    }

    public void setValues(int _value, int _visible, int _min, int _max) {
        this.min = _min;
        this.max = _max;
        this.value = _value;
        this.visible = _visible;
        if (this.value < this.min) {
            this.value = this.min;
        } else if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.min == this.max) {
            this.max = this.min + 1;
        }
    }

    public void setChangeValue(int chgvalue) {
        this.value += chgvalue;
        if (this.value < this.min) {
            this.value = this.min;
        } else if (this.value > this.max) {
            this.value = this.max;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintBar(this.offgraphics);
        if (this.dragmode && this.boss.getType() == 0) {
            this.paintTempBox(this.offgraphics);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintBar(Graphics g) {
        int width;
        Dimension d = this.getSize();
        if (this.boss.getType() == 0) {
            g.setColor(Color.darkGray);
            g.fillRect(0, 0, d.width, d.height);
        } else if (this.boss.getType() == 1) {
            g.setColor(Color.black);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(Color.darkGray);
            width = d.width / 3;
            g.fillRect(width, 0, width, d.height);
        }
        width = this.max - this.min;
        if (width <= 0) {
            width = 1;
        }
        int sval = d.width;
        if (this.mode == 1) {
            sval = d.height;
        }
        this.barwidth = (int)((double)sval / (double)(width + this.visible) * (double)this.visible);
        if (this.barwidth < this.busize) {
            this.barwidth = this.busize;
        }
        this.barx = (int)((double)(this.value - this.min) / (double)width * (double)(sval - this.barwidth));
        if (this.boss.getType() == 0) {
            g.setColor(Color.white);
        } else if (this.boss.getType() == 1) {
            g.setColor(Color.lightGray);
        }
        if (this.mode == 0) {
            g.fill3DRect(this.barx, 1, this.barwidth, d.height - 2, true);
        } else {
            g.fill3DRect(1, this.barx, d.width - 2, this.barwidth, true);
        }
    }

    private void paintTempBox(Graphics g) {
        g.setColor(Color.white);
        if (this.mode == 0) {
            g.draw3DRect(this.tempvalue, 1, this.barwidth, this.getSize().height - 2, true);
        } else {
            g.draw3DRect(1, this.tempvalue, this.getSize().width - 2, this.barwidth, true);
        }
    }

    public void confirmValue() {
        int sval = this.getSize().width;
        if (this.mode == 1) {
            sval = this.getSize().height;
        }
        double delta = (double)this.tempvalue / (double)(sval - this.barwidth) * (double)(this.max - this.min);
        this.value = (int)delta + this.min;
    }

    public void setTempValue(int val) {
        this.tempvalue = val;
        int tempmax = this.getSize().width - this.barwidth;
        if (this.mode == 1) {
            tempmax = this.getSize().height - this.barwidth;
        }
        if (this.tempvalue < 0) {
            this.tempvalue = 0;
        } else if (this.tempvalue > tempmax) {
            this.tempvalue = tempmax;
        }
    }

    public void setDragMode(boolean _val) {
        this.dragmode = _val;
    }

    public boolean getDragMode() {
        return this.dragmode;
    }

    public boolean isOnMarker(int x) {
        return x > this.barx && x < this.barx + this.barwidth;
    }

    public void chgBlockValue(int x) {
        int chgvalue = this.visible / 2;
        if (chgvalue < 1) {
            chgvalue = 1;
        }
        if (x < this.barx) {
            chgvalue *= -1;
        }
        this.setChangeValue(chgvalue);
    }

    public int getValue() {
        return this.value;
    }

    public int getBarX() {
        return this.barx;
    }
}

