/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class GDirectionButton
extends Canvas {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;
    int direction;
    int margin;
    boolean pressed = false;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;

    public GDirectionButton() {
        this(0);
    }

    public GDirectionButton(int d) {
        this.direction = d;
        this.margin = 2;
    }

    public void setDirection(int d) {
        if (this.direction != d) {
            this.direction = d;
            this.repaint();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public Dimension getPreferredSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 7, defaultSize.height + 7);
    }

    public Dimension getMinimumSize() {
        Dimension defaultSize = super.getPreferredSize();
        return new Dimension(defaultSize.width + 3, defaultSize.height + 3);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintArrow(this.offgraphics);
        g.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintArrow(Graphics g) {
        Dimension d = this.getSize();
        this.margin = d.width / 6;
        if (this.margin < 2) {
            this.margin = 2;
        }
        if (this.pressed) {
            g.setColor(Color.darkGray);
        } else {
            g.setColor(Color.lightGray);
        }
        boolean flag = true;
        if (this.pressed) {
            flag = false;
        }
        g.fill3DRect(0, 0, d.width, d.height, flag);
        Polygon rect = new Polygon();
        switch (this.direction) {
            case 0: {
                rect.addPoint(this.margin, d.height / 2);
                rect.addPoint(d.width - this.margin, this.margin);
                rect.addPoint(d.width - this.margin, d.height - this.margin);
                break;
            }
            case 1: {
                rect.addPoint(d.width - this.margin, d.height / 2);
                rect.addPoint(this.margin, this.margin);
                rect.addPoint(this.margin, d.height - this.margin);
                break;
            }
            case 2: {
                rect.addPoint(d.width / 2, this.margin);
                rect.addPoint(this.margin, d.height - this.margin);
                rect.addPoint(d.width - this.margin, d.height - this.margin);
                break;
            }
            case 3: {
                rect.addPoint(d.width / 2, d.height - this.margin);
                rect.addPoint(this.margin, this.margin);
                rect.addPoint(d.width - this.margin, this.margin);
                break;
            }
        }
        if (this.pressed) {
            g.setColor(Color.lightGray);
        } else {
            g.setColor(Color.darkGray);
        }
        g.fillPolygon(rect);
        g.setColor(Color.black);
        g.drawRect(0, 0, d.width, d.height);
    }

    public void setPressed(boolean val) {
        this.pressed = val;
    }
}

