/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class GDViewer
extends Frame {
    boolean fComponentsAdjusted = false;
    boolean startUpFlag = true;
    SETISupport boss;
    GDCanvas maincanvas;
    GDPrefValue pref = FileAnalyzer.readGDPrefs();
    MenuBar mainMenuBar;
    Menu menu1;
    Menu menu2;
    MenuItem miExit;
    CheckboxMenuItem miCrossLine;
    CheckboxMenuItem miArrow;
    CheckboxMenuItem miHiCur;
    CheckboxMenuItem miBlink;
    CheckboxMenuItem miSnow;

    public GDViewer(SETISupport _boss) {
        this.boss = _boss;
        this.initLayout();
        this.setData();
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
    }

    public void setData() {
        Vector datavect = new Vector();
        this.boss.setMxData(datavect);
        this.maincanvas.setData(datavect);
    }

    public void initLayout() {
        this.setTitle("SETI@Support Gaussian Distribution");
        Rectangle dm = this.pref.getBound();
        int wwidth = dm.width;
        int wheight = dm.height;
        ((Component)this).setLocation(dm.x, dm.y);
        this.setLayout(new BorderLayout(0, 0));
        this.setVisible(false);
        ((Component)this).setSize(wwidth, wheight);
        this.maincanvas = new GDCanvas(this);
        this.maincanvas.start();
        this.add("Center", this.maincanvas);
        this.mainMenuBar = new MenuBar();
        this.menu1 = new Menu("File");
        this.miExit = new MenuItem("Close");
        this.menu1.add(this.miExit);
        this.menu2 = new Menu("Setting");
        boolean flag = this.pref.getClPref() != 0;
        this.miCrossLine = new CheckboxMenuItem("Cross Line", flag);
        this.miCrossLineAction(flag);
        this.menu2.add(this.miCrossLine);
        flag = this.pref.getArPref() != 0;
        this.miArrow = new CheckboxMenuItem("Arrow", flag);
        this.miArrowAction(flag);
        this.menu2.add(this.miArrow);
        flag = this.pref.getHiCurPref() != 0;
        this.miHiCur = new CheckboxMenuItem("Highlight analyzing data", flag);
        this.miHiCurAction(flag);
        this.menu2.add(this.miHiCur);
        flag = this.pref.getBlinkPref() != 0;
        this.miBlink = new CheckboxMenuItem("Blink", flag);
        this.miBlinkAction(flag);
        this.menu2.add(this.miBlink);
        flag = this.pref.getSnowPref() != 0;
        this.miSnow = new CheckboxMenuItem("View", flag);
        this.miSnowAction(flag);
        if (new File("goro").exists()) {
            this.menu2.add(this.miSnow);
        }
        this.mainMenuBar.add(this.menu1);
        this.mainMenuBar.add(this.menu2);
        this.setMenuBar(this.mainMenuBar);
        SymAction lSymAction = new SymAction();
        this.miExit.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        this.miCrossLine.addItemListener(lSymItem);
        this.miArrow.addItemListener(lSymItem);
        this.miHiCur.addItemListener(lSymItem);
        this.miBlink.addItemListener(lSymItem);
        this.miSnow.addItemListener(lSymItem);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    public void setBoundPref(Rectangle rect) {
        this.pref.setBound(rect);
    }

    private void fileOutPref() {
        FileAnalyzer.fileOutGDPrefs(this.pref);
    }

    public void setAnimeTime(int t) {
        this.maincanvas.setAnimeTime(t);
    }

    public void resetSleepThread() {
        this.boss.resetSleepThread();
    }

    void miExit_Action(ActionEvent event) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    private void miCrossLineAction(boolean flag) {
        this.maincanvas.setCenterLineFlag(flag);
    }

    private void miArrowAction(boolean flag) {
        this.maincanvas.setDrawArrowFlag(flag);
    }

    private void miHiCurAction(boolean flag) {
        this.maincanvas.setHiCurFlag(flag);
    }

    private void miBlinkAction(boolean flag) {
        this.maincanvas.setBlinkFlag(flag);
    }

    private void miSnowAction(boolean flag) {
        this.maincanvas.setSnowFlag(flag);
    }

    void GDViewer_WindowClosing(WindowEvent event) {
        this.setBoundPref(this.getBounds());
        this.fileOutPref();
        this.setVisible(false);
        this.dispose();
        this.boss.clearGdx();
    }

    public void update() {
        this.maincanvas.repaint();
    }

    void GDViewer_WindowOpened(WindowEvent event) {
    }

    void GDViewer_WindowActivated(WindowEvent event) {
        this.resetSleepThread();
    }

    void GDViewer_WindowDeactivated(WindowEvent event) {
        this.boss.SETISupport_WindowDeactivated(null);
    }

    void GDViewer_ComponentMoved(ComponentEvent event) {
    }

    void GDViewer_ComponentShown(ComponentEvent event) {
        if (this.startUpFlag) {
            this.startUpFlag = false;
            Rectangle dm = this.pref.getBound();
            if (dm.width != 0 && dm.height != 0) {
                ((Component)this).setSize(new Dimension(dm.width, dm.height));
                ((Component)this).setLocation(dm.x, dm.y);
            } else {
                ((Component)this).setSize(new Dimension(400, 400));
                ((Component)this).setLocation(50, 50);
            }
        }
    }

    public void selectData(ResultData rd) {
        this.boss.selectFromOutside(rd, true);
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this.miExit) {
                GDViewer.this.GDViewer_WindowClosing(null);
            }
        }

        SymAction() {
        }
    }

    class SymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this.miCrossLine) {
                if (GDViewer.this.miCrossLine.getState()) {
                    GDViewer.this.pref.setClPref(1);
                } else {
                    GDViewer.this.pref.setClPref(0);
                }
                GDViewer.this.miCrossLineAction(GDViewer.this.miCrossLine.getState());
            } else if (object == GDViewer.this.miArrow) {
                if (GDViewer.this.miArrow.getState()) {
                    GDViewer.this.pref.setArPref(1);
                } else {
                    GDViewer.this.pref.setArPref(0);
                }
                GDViewer.this.miArrowAction(GDViewer.this.miArrow.getState());
            } else if (object == GDViewer.this.miHiCur) {
                if (GDViewer.this.miHiCur.getState()) {
                    GDViewer.this.pref.setHiCurPref(1);
                } else {
                    GDViewer.this.pref.setHiCurPref(0);
                }
                GDViewer.this.miHiCurAction(GDViewer.this.miHiCur.getState());
            } else if (object == GDViewer.this.miBlink) {
                if (GDViewer.this.miBlink.getState()) {
                    GDViewer.this.pref.setBlinkPref(1);
                } else {
                    GDViewer.this.pref.setBlinkPref(0);
                }
                GDViewer.this.miBlinkAction(GDViewer.this.miBlink.getState());
            } else if (object == GDViewer.this.miSnow) {
                if (GDViewer.this.miSnow.getState()) {
                    GDViewer.this.pref.setSnowPref(1);
                } else {
                    GDViewer.this.pref.setSnowPref(0);
                }
                GDViewer.this.miSnowAction(GDViewer.this.miSnow.getState());
            }
            GDViewer.this.fileOutPref();
        }

        SymItem() {
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowDeactivated(WindowEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowDeactivated(event);
            }
        }

        public void windowActivated(WindowEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowActivated(event);
            }
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowClosing(event);
            }
        }

        public void windowOpened(WindowEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_WindowOpened(event);
            }
        }

        SymWindow() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentShown(ComponentEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_ComponentShown(event);
            }
        }

        public void componentMoved(ComponentEvent event) {
            Object object = event.getSource();
            if (object == GDViewer.this) {
                GDViewer.this.GDViewer_ComponentMoved(event);
            }
        }

        SymComponent() {
        }
    }
}

