/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import java.util.Vector;

public class GDCanvas
extends Canvas
implements Runnable {
    Random dice = new Random(0L);
    GDViewer boss;
    Vector datavect;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    Thread relaxer;
    int animetime = 200;
    FontMetrics fm;
    FontMetrics boldfm;
    Font font;
    Font boldfont;
    int charHeight;
    int charDescent;
    int charLeading;
    int charAscent;
    int lineHeight;
    int hgap = 3;
    int vgap = 3;
    double vmax = 20.0;
    double vminmax = 10.0;
    double hmax = 10.0;
    double hminmax = 10.0;
    double hmin = 0.1;
    double chismax = 10.0;
    int dwidth;
    int dheight;
    int inmargin = 20;
    int outmargin = 15;
    int markrad = 4;
    boolean centerflag = true;
    boolean drawArrowFlag = true;
    boolean blinkflag = true;
    boolean hiCurFlag = true;
    boolean snowflag = true;
    boolean rightflag;
    boolean leftflag;
    boolean upflag;
    boolean downflag;
    boolean[] arrowflag = new boolean[4];
    Polygon[] arrowpol = new Polygon[]{null, null, null, null};
    static final int A_UP = 0;
    static final int A_DOWN = 1;
    static final int A_RIGHT = 2;
    static final int A_LEFT = 3;
    int[] lcount = new int[32];
    int tracx;
    int tracy;

    public GDCanvas(GDViewer _boss) {
        this.boss = _boss;
        this.datavect = new Vector();
        this.setFont(10);
        this.initlcount();
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymComponent aSymComponent = new SymComponent();
        this.addComponentListener(aSymComponent);
    }

    private void initlcount() {
        int i = 0;
        while (i < this.lcount.length) {
            this.lcount[i] = 10 - (int)(this.dice.nextDouble() * 8.0);
            ++i;
        }
    }

    public void setAnimeTime(int val) {
        this.animetime = val;
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
        this.relaxer.setPriority(1);
    }

    public void stop() {
        if (this.relaxer != null) {
            this.relaxer.stop();
        }
    }

    public void suspend() {
        if (this.relaxer != null) {
            this.relaxer.suspend();
        }
    }

    public void resume() {
        if (this.relaxer != null) {
            this.relaxer.resume();
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(this.animetime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setFont(int fontSize) {
        String[] fontNames = Toolkit.getDefaultToolkit().getFontList();
        this.font = new Font(fontNames[1], 0, fontSize);
        this.boldfont = new Font(fontNames[1], 1, fontSize);
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.boldfm = Toolkit.getDefaultToolkit().getFontMetrics(this.boldfont);
        this.charHeight = this.fm.getHeight();
        this.charDescent = this.fm.getDescent();
        this.charAscent = this.fm.getAscent();
        this.charLeading = this.fm.getLeading();
        this.lineHeight = this.charHeight + 2 * this.vgap;
    }

    public void setCenterLineFlag(boolean val) {
        this.centerflag = val;
    }

    public void setDrawArrowFlag(boolean val) {
        this.drawArrowFlag = val;
    }

    public void setHiCurFlag(boolean val) {
        this.hiCurFlag = val;
    }

    public void setBlinkFlag(boolean val) {
        this.blinkflag = val;
    }

    public void setSnowFlag(boolean val) {
        this.snowflag = val;
    }

    public void setData(Vector _datavect) {
        this.datavect.removeAllElements();
        int i = 0;
        while (i < _datavect.size()) {
            ResultData rd = (ResultData)_datavect.elementAt(i);
            int firstLevel = (int)(this.dice.nextDouble() * (double)SkyCanvas.maxCircleLevel);
            PlotData pt = new PlotData(firstLevel, SkyCanvas.maxCircleLevel, rd);
            pt.setColor(rd.getColorName());
            this.datavect.addElement(pt);
            ++i;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(Color.black);
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        this.paintGrid(this.offgraphics);
        this.resetArrowFlag();
        this.paintData(this.offgraphics);
        if (this.drawArrowFlag) {
            this.paintArrow(this.offgraphics);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    private void paintGrid(Graphics g) {
        String t_str = DoubleFormat.toString(this.vmax, 1);
        int tempwidth = this.fm.stringWidth(t_str) + this.hgap * 2;
        if (this.inmargin < tempwidth) {
            this.inmargin = tempwidth;
        }
        if (this.inmargin < this.charHeight) {
            this.inmargin = this.charHeight + this.outmargin;
        }
        this.dwidth = this.getSize().width - this.inmargin - this.outmargin;
        this.dheight = this.getSize().height - this.inmargin - this.outmargin;
        Polygon pl = new Polygon();
        Polygon spl = new Polygon();
        double y = 2.0 + 1.5 * this.hmin;
        while (y < this.chismax) {
            double x = (y - 2.0) / 1.5;
            Point p = this.getConvPt(x, y);
            pl.addPoint(p.x, p.y);
            if (y > this.chismax / 2.0) {
                spl.addPoint(p.x, p.y);
            }
            y += 0.3;
        }
        Point p = this.getConvPt((this.chismax - 2.0) / 1.5, this.chismax);
        pl.addPoint(p.x, p.y);
        spl.addPoint(p.x, p.y);
        p = this.getConvPt(this.hmax, this.chismax);
        pl.addPoint(this.dwidth + this.inmargin + this.outmargin, p.y);
        p = this.getConvPt(this.hmax, 0.0);
        pl.addPoint(this.dwidth + this.inmargin + this.outmargin, p.y);
        p = this.getConvPt(this.hmin, 0.0);
        pl.addPoint(p.x, p.y);
        g.setColor(Color.blue);
        g.fillPolygon(pl);
        if (this.snowflag) {
            g.setColor(Color.white);
            int minx = spl.xpoints[spl.npoints - 1];
            int maxx = this.dwidth + this.inmargin + this.outmargin;
            int sx = minx;
            while (sx < maxx) {
                double ratio = (double)(maxx - sx) / (double)(maxx - minx);
                int count = this.lcount[sx % this.lcount.length];
                int i = spl.npoints - 1;
                while (i > count) {
                    g.drawLine(maxx - (int)((double)(maxx - spl.xpoints[i]) * ratio), spl.ypoints[i], maxx - (int)((double)(maxx - spl.xpoints[i - 1]) * ratio), spl.ypoints[i - 1]);
                    --i;
                }
                ++sx;
            }
        }
        int subMemWidth = 3;
        g.setColor(Color.white);
        g.drawLine(this.inmargin, 0, this.inmargin, this.dheight + this.outmargin);
        int i = 1;
        while (i <= 4) {
            int hd = this.dheight / 4 * i;
            g.drawLine(this.inmargin, this.dheight + this.outmargin - hd, this.inmargin + subMemWidth, this.dheight + this.outmargin - hd);
            String str = DoubleFormat.toString(this.vmax / 4.0 * (double)i, 1);
            int strw = this.fm.stringWidth(str);
            g.drawString(str, this.inmargin - strw - 2 * this.hgap, this.dheight + this.outmargin - hd + this.charHeight / 2);
            ++i;
        }
        g.drawString("Fit", this.inmargin + subMemWidth, this.charHeight);
        g.drawLine(this.inmargin, this.dheight + this.outmargin, this.dwidth + this.inmargin + this.outmargin, this.dheight + this.outmargin);
        double val = this.hmin;
        int i2 = 0;
        while (i2 <= 2) {
            int wd = this.dwidth / 2 * i2;
            g.drawLine(this.inmargin + wd, this.dheight + this.outmargin, this.inmargin + wd, this.dheight + this.outmargin - subMemWidth);
            String str = Double.toString(val);
            int strw = this.fm.stringWidth(str);
            g.drawString(str, this.inmargin + wd - strw / 2, this.dheight + this.outmargin + this.charHeight);
            val *= 10.0;
            ++i2;
        }
        String str = "Power";
        g.drawString(str, this.inmargin + this.dwidth - this.fm.stringWidth(str), this.outmargin + this.dheight);
    }

    private void paintData(Graphics g) {
        int i = 0;
        while (i < this.datavect.size()) {
            PlotData pt = (PlotData)this.datavect.elementAt(i);
            if (pt.getBgChisq() != 0.0) {
                pt.addLevel();
                if (pt.getVisible()) {
                    Point p;
                    this.markrad = 4;
                    if (!pt.getFinished() || pt.getPt() == null) {
                        p = this.getConvPt(pt);
                        pt.setPt(p);
                    } else {
                        p = pt.getPt();
                    }
                    if (this.setArrowFlag(p)) {
                        if (!pt.getFinished() && this.hiCurFlag) {
                            int j = 0;
                            while (j < pt.getLevel()) {
                                int srad = this.markrad + 2 + j * 3;
                                g.setColor(Color.cyan);
                                g.drawOval(p.x - srad / 2, p.y - srad / 2, srad, srad);
                                j += 2;
                            }
                            if (pt.getTop()) {
                                g.setColor(Color.red);
                            } else {
                                g.setColor(Color.cyan);
                            }
                            g.fillOval(p.x - this.markrad / 2, p.y - this.markrad / 2, this.markrad, this.markrad);
                        } else {
                            if (pt.getTop()) {
                                pt.setColor("Red");
                            } else {
                                pt.setColor("White");
                            }
                            Color orcolor = pt.getColor();
                            if (this.blinkflag) {
                                float[] cl = new float[3];
                                cl = Color.RGBtoHSB(orcolor.getRed(), orcolor.getGreen(), orcolor.getBlue(), cl);
                                Color nwcolor = Color.getHSBColor(cl[0], cl[1], (float)(1.0 - (double)((float)pt.getLevel() / (float)SkyCanvas.maxCircleLevel)));
                                g.setColor(nwcolor);
                            } else {
                                g.setColor(orcolor);
                            }
                            g.fill3DRect(p.x - this.markrad / 2, p.y - this.markrad / 2, this.markrad, this.markrad, true);
                        }
                        String str = "(" + Double.toString(pt.getBgPower()) + " , " + Double.toString(pt.getBgChisq()) + ")";
                        if (pt.getSelected() && this.centerflag) {
                            Point npt = this.paintCrossLine(g, pt, this.tracx, this.tracy);
                            this.tracx = npt.x;
                            this.tracy = npt.y;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private Point getConvPt(PlotData pt) {
        return this.getConvPt(pt.getBgPower(), pt.getBgChisq());
    }

    private Point getConvPt(double xval, double yval) {
        int y = this.outmargin + (int)((1.0 - yval / this.vmax) * (double)this.dheight);
        int x = this.inmargin + (int)((Math.log(xval) - Math.log(this.hmin)) / (Math.log(this.hmax) - Math.log(this.hmin)) * (double)this.dwidth);
        return new Point(x, y);
    }

    private boolean setArrowFlag(Point p) {
        boolean retflag = true;
        if (p.x < 0) {
            retflag = false;
        } else if (p.x > this.getSize().width) {
            retflag = false;
            this.arrowflag[2] = true;
        }
        if (p.y < 0) {
            retflag = false;
            this.arrowflag[0] = true;
        } else if (p.y > this.getSize().height) {
            retflag = false;
        }
        if (this.vmax > this.vminmax) {
            this.arrowflag[1] = true;
        }
        if (this.hmax > this.hminmax) {
            this.arrowflag[3] = true;
        }
        return retflag;
    }

    private void resetArrowFlag() {
        int i = 0;
        while (i < this.arrowflag.length) {
            this.arrowflag[i] = false;
            ++i;
        }
    }

    private void paintArrow(Graphics g) {
        int i = 0;
        while (i < this.arrowpol.length) {
            this.arrowpol[i] = null;
            ++i;
        }
        int arrowwidth = 20;
        int arrowheight = 10;
        Dimension d = this.getSize();
        this.arrowpol[0] = new Polygon();
        this.arrowpol[0].addPoint(d.width / 2 - arrowwidth / 2, arrowheight);
        this.arrowpol[0].addPoint(d.width / 2, 0);
        this.arrowpol[0].addPoint(d.width / 2 + arrowwidth / 2, arrowheight);
        this.arrowpol[1] = new Polygon();
        this.arrowpol[1].addPoint(d.width / 2 - arrowwidth / 2, arrowheight + this.vgap);
        this.arrowpol[1].addPoint(d.width / 2, arrowheight * 2 + this.vgap);
        this.arrowpol[1].addPoint(d.width / 2 + arrowwidth / 2, arrowheight + this.vgap);
        this.arrowpol[2] = new Polygon();
        this.arrowpol[2].addPoint(d.width, d.height / 2);
        this.arrowpol[2].addPoint(d.width - arrowheight, d.height / 2 - arrowwidth / 2);
        this.arrowpol[2].addPoint(d.width - arrowheight, d.height / 2 + arrowwidth / 2);
        this.arrowpol[3] = new Polygon();
        this.arrowpol[3].addPoint(d.width - arrowheight * 2 - this.hgap, d.height / 2);
        this.arrowpol[3].addPoint(d.width - arrowheight - this.hgap, d.height / 2 - arrowwidth / 2);
        this.arrowpol[3].addPoint(d.width - arrowheight - this.hgap, d.height / 2 + arrowwidth / 2);
        g.setColor(Color.yellow);
        int i2 = 0;
        while (i2 < this.arrowpol.length) {
            if (this.arrowflag[i2]) {
                g.drawPolygon(this.arrowpol[i2]);
            }
            ++i2;
        }
    }

    private Point paintCrossLine(Graphics g, PlotData pt, int tracx, int tracy) {
        Point ppt = this.getConvPt(pt);
        Dimension d = this.getSize();
        g.setColor(Color.pink);
        int len = this.markrad * 2;
        double alpha = 0.7;
        tracx = (int)((double)ppt.x * alpha + (double)tracx * (1.0 - alpha));
        tracy = (int)((double)ppt.y * alpha + (double)tracy * (1.0 - alpha));
        g.drawRect(tracx - (int)((double)len * 0.5), tracy - (int)((double)len * 0.5), len, len);
        g.drawLine(tracx, 0, tracx, tracy - (int)((double)len * 0.5));
        g.drawLine(tracx, d.height, tracx, tracy + (int)((double)len * 0.5));
        g.drawLine(0, tracy, tracx - (int)((double)len * 0.5), tracy);
        g.drawLine(d.width, tracy, tracx + (int)((double)len * 0.5), tracy);
        return new Point(tracx, tracy);
    }

    private void clearPtData() {
        int i = 0;
        while (i < this.datavect.size()) {
            PlotData pt = (PlotData)this.datavect.elementAt(i);
            pt.setPt(null);
            ++i;
        }
    }

    void GDCanvas_MouseClicked(MouseEvent event) {
        Point ept = event.getPoint();
        int cl = this.markrad * 2;
        Rectangle checkrect = new Rectangle(ept.x - cl, ept.y - cl, cl * 2, cl * 2);
        Vector<PlotData> cvect = new Vector<PlotData>();
        int i = 0;
        while (i < this.datavect.size()) {
            PlotData pt = (PlotData)this.datavect.elementAt(i);
            Point ppt = pt.getPt();
            if (ppt != null && checkrect.contains(ppt)) {
                cvect.addElement(pt);
            }
            ++i;
        }
        PlotData selpt = null;
        if (cvect.size() == 1) {
            selpt = (PlotData)cvect.elementAt(0);
        } else {
            int mind = cl * 2 * (cl * 2);
            int i2 = 0;
            while (i2 < cvect.size()) {
                PlotData pt = (PlotData)cvect.elementAt(i2);
                if (!pt.getSelected()) {
                    Point dpt = this.getConvPt(pt);
                    int dx = ept.x - dpt.x;
                    int dy = ept.y - dpt.y;
                    int d = dx * dx + dy * dy;
                    if (d < mind) {
                        mind = d;
                        selpt = pt;
                    }
                }
                ++i2;
            }
        }
        if (selpt != null) {
            this.boss.selectData(selpt.getOrgData());
        } else {
            this.clickForScroll(ept);
        }
        this.boss.resetSleepThread();
    }

    private void clickForScroll(Point pt) {
        int i = 0;
        while (i < this.arrowpol.length) {
            Polygon pol = this.arrowpol[i];
            if (this.arrowflag[i] && pol != null && pol.contains(pt)) {
                switch (i) {
                    case 0: {
                        this.vmax += 10.0;
                        break;
                    }
                    case 1: {
                        this.vmax -= 10.0;
                        if (!(this.vmax < this.vminmax)) break;
                        this.vmax = this.vminmax;
                        break;
                    }
                    case 2: {
                        this.hmax *= 10.0;
                        break;
                    }
                    case 3: {
                        this.hmax /= 10.0;
                        if (!(this.hmax < this.hminmax)) break;
                        this.hmax = this.hminmax;
                        break;
                    }
                }
                this.clearPtData();
                this.repaint();
                break;
            }
            ++i;
        }
    }

    void GDCanvas_ComponentResized(ComponentEvent event) {
        this.clearPtData();
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            Object object = event.getSource();
            if (object == GDCanvas.this) {
                GDCanvas.this.GDCanvas_MouseClicked(event);
            }
        }

        SymMouse() {
        }
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentResized(ComponentEvent event) {
            Object object = event.getSource();
            if (object == GDCanvas.this) {
                GDCanvas.this.GDCanvas_ComponentResized(event);
            }
        }

        SymComponent() {
        }
    }
}

