/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class FileAnalyzer {
    static String versionFileName = "version.sah";
    static String stateFileName = "state.txt";
    static String workFileName = "work_unit.txt";
    static String userFileName = "user_info.txt";
    static String n2_stateFileName = "state.sah";
    static String n2_workFileName = "work_unit.sah";
    static String n2_userFileName = "user_info.sah";
    static String dataDirFileName = "ss_dir_data.txt";
    static String pastDirFileName = "ss_pdir.txt";
    static String pastDataFileName = "ss_past_data.txt";
    static String currentDataFileName = "ss_current_data.txt";
    static String prefFileName = "ss_pref.txt";
    static String mxPrefFileName = "ss_mx_pref.txt";
    static String gdPrefFileName = "ss_gd_pref.txt";

    public static boolean checkPastFile() {
        return FileAnalyzer.checkFile(String.valueOf(System.getProperty("user.dir")) + pastDataFileName);
    }

    public static boolean checkFile(String filename) {
        File fp = new File(filename);
        return fp.exists();
    }

    public static boolean checkCurrentFile() {
        return FileAnalyzer.checkFile(String.valueOf(System.getProperty("user.dir")) + currentDataFileName);
    }

    public static boolean checkStateFile(String dataDir) {
        boolean flag = FileAnalyzer.checkVerFile(dataDir) ? new File(dataDir, n2_stateFileName).exists() : new File(dataDir, stateFileName).exists();
        return flag;
    }

    public static boolean checkWorkFile(String dataDir) {
        boolean flag = FileAnalyzer.checkVerFile(dataDir) ? new File(dataDir, n2_workFileName).exists() : new File(dataDir, workFileName).exists();
        return flag;
    }

    public static boolean checkVerFile(String dataDir) {
        boolean flag = new File(dataDir, versionFileName).exists();
        return flag;
    }

    public static void readDirData(Vector vt) {
        File fp = new File(System.getProperty("user.dir"), dataDirFileName);
        if (!fp.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            while ((line = ds.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String shortName = st.nextToken();
                String dirName = line.substring(shortName.length() + 1);
                vt.addElement(new DirData(shortName, dirName));
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    public static void readPastDataDir(Vector vt) {
        File fp = new File(System.getProperty("user.dir"), pastDirFileName);
        if (!fp.exists()) {
            return;
        }
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            while ((line = ds.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                String shortName = st.nextToken();
                String colorName = st.nextToken();
                String dirName = line.substring(shortName.length() + colorName.length() + 2);
                vt.addElement(new DirData(shortName, colorName, dirName));
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    public static void FileoutDirData(Vector vt) {
        File fp = new File(System.getProperty("user.dir"), dataDirFileName);
        PrintWriter outfp = null;
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            int i = 0;
            while (i < vt.size()) {
                DirData ddata = (DirData)vt.elementAt(i);
                outfp.println(String.valueOf(ddata.getShortName()) + " " + ddata.getDir());
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static void FileoutPastDataDir(Vector vt) {
        PrintWriter outfp = null;
        File fp = new File(System.getProperty("user.dir"), pastDirFileName);
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            int i = 0;
            while (i < vt.size()) {
                DirData ddata = (DirData)vt.elementAt(i);
                outfp.println(String.valueOf(ddata.getShortName()) + " " + ddata.getColorName() + " " + ddata.getDir());
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static void readCurrentData(Vector currentData, String dirName) {
        if (FileAnalyzer.checkVerFile(dirName)) {
            if (FileAnalyzer.checkWorkFile(dirName)) {
                FileAnalyzer.readWorkFile(currentData, dirName, n2_workFileName);
            }
            if (FileAnalyzer.checkStateFile(dirName)) {
                FileAnalyzer.readStateFile(currentData, dirName, n2_stateFileName);
            }
        } else {
            if (FileAnalyzer.checkWorkFile(dirName)) {
                FileAnalyzer.readWorkFile(currentData, dirName, workFileName);
            }
            if (FileAnalyzer.checkStateFile(dirName)) {
                FileAnalyzer.readStateFile(currentData, dirName, stateFileName);
            }
        }
    }

    private static void readWorkFile(Vector currentData, String dataDir, String readFileName) {
        String filename = String.valueOf(dataDir) + readFileName;
        try {
            BufferedReader ds = new BufferedReader(new FileReader(filename));
            FileAnalyzer.analyzeDataFile(ds, currentData);
            File tf = new File(filename);
            Date d = new Date(tf.lastModified());
            ResultData rdata = (ResultData)currentData.elementAt(0);
            rdata.setStartedTime(d);
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    private static void readStateFile(Vector currentData, String dataDir, String readFileName) {
        String filename = String.valueOf(dataDir) + readFileName;
        try {
            BufferedReader ds = new BufferedReader(new FileReader(filename));
            boolean flag = FileAnalyzer.analyzeDataFile(ds, currentData);
            if (!flag && currentData.size() > 0) {
                ResultData rdata = (ResultData)currentData.elementAt(0);
                rdata.clearStateInfo();
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    public static void readSavedCurrentData(Vector currentData) {
        File fp = new File(System.getProperty("user.dir"), currentDataFileName);
        if (!fp.exists()) {
            return;
        }
        try {
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            FileAnalyzer.analyzeDataFile(ds, currentData);
        }
        catch (IOException iOException) {}
    }

    public static void fileOutCurrentData(Vector cv) {
        File fp = new File(System.getProperty("user.dir"), currentDataFileName);
        PrintWriter outfp = null;
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            int i = 0;
            while (i < cv.size()) {
                ResultData data = ((DirData)cv.elementAt(i)).getProg();
                if (data != null) {
                    outfp.println("!");
                    outfp.println(data.getFileOutStr(true));
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static void readPastFile(String filename, Vector pastData, String timeZoneID) {
        File fp = null;
        fp = filename.equals(pastDataFileName) ? new File(System.getProperty("user.dir"), filename) : new File(filename);
        if (!fp.exists()) {
            return;
        }
        try {
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            String line = ds.readLine();
            if (line == null) {
                System.out.println("wao error in past read file");
            } else {
                CSVTokenizer st;
                line.trim();
                boolean myPastFile = true;
                if (line.length() > 6 && (st = new CSVTokenizer(line)).nextToken().equals("date")) {
                    myPastFile = false;
                }
                BufferedReader dds = new BufferedReader(new FileReader(fp));
                if (myPastFile) {
                    FileAnalyzer.analyzeDataFile(dds, pastData);
                } else {
                    FileAnalyzer.analyzeSetiLogFile(dds, pastData, timeZoneID);
                }
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    private static boolean analyzeDataFile(BufferedReader ds, Vector datavect) {
        boolean readFlag = false;
        try {
            String line;
            ResultData rdata = null;
            if (datavect.size() > 0) {
                rdata = (ResultData)datavect.elementAt(0);
            }
            while ((line = ds.readLine()) != null) {
                String[] str;
                StringTokenizer st;
                String sstr;
                String fstr;
                if ((line = line.trim()).length() == 0) continue;
                readFlag = true;
                int index = line.indexOf("=");
                if (index == -1) {
                    fstr = line;
                    sstr = null;
                } else {
                    fstr = line.substring(0, index);
                    sstr = line.substring(index + 1);
                }
                if (fstr.equals("!")) {
                    rdata = new ResultData();
                    datavect.addElement(rdata);
                    continue;
                }
                if (fstr.equals("pos")) {
                    st = new StringTokenizer(sstr);
                    str = new String[]{null, null, null, null, null, null};
                    int i = 0;
                    while (i < 6) {
                        str[i] = st.nextToken();
                        ++i;
                    }
                    rdata.setPosData(str);
                    continue;
                }
                if (fstr.equals("end_pos")) {
                    st = new StringTokenizer(sstr);
                    str = new String[]{null, null, null, null, null, null};
                    int i = 0;
                    while (i < 6) {
                        str[i] = st.nextToken();
                        ++i;
                    }
                    rdata.setEndPosData(str);
                    continue;
                }
                if (fstr.equals("start_ra")) {
                    rdata.setRa(sstr);
                    continue;
                }
                if (fstr.equals("start_dec")) {
                    rdata.setDec(sstr);
                    continue;
                }
                if (fstr.equals("end_ra")) {
                    rdata.setEndRa(sstr);
                    continue;
                }
                if (fstr.equals("end_dec")) {
                    rdata.setEndDec(sstr);
                    continue;
                }
                if (fstr.equals("subband_base")) {
                    if (rdata == null) {
                        System.out.println("Wrong fromat, rdata for band is null");
                    }
                    rdata.setBand(sstr);
                    continue;
                }
                if (fstr.equals("time_recorded")) {
                    if (sstr.indexOf("(") == -1 || sstr.indexOf(")") == -1) {
                        rdata.setTimeRecorded("ND");
                        continue;
                    }
                    String datestr = sstr.substring(sstr.indexOf("("), sstr.indexOf(")") + 1);
                    rdata.setTimeRecorded(datestr);
                    continue;
                }
                if (fstr.equals("name")) {
                    if (rdata == null) {
                        rdata = new ResultData();
                    }
                    rdata.setName(sstr);
                    continue;
                }
                if (fstr.equals("bs_power")) {
                    rdata.setBsPower(sstr);
                    continue;
                }
                if (fstr.equals("bs_score")) {
                    rdata.setBsScore(sstr);
                    continue;
                }
                if (fstr.equals("bs_bin")) {
                    rdata.setBsBin(sstr);
                    continue;
                }
                if (fstr.equals("bs_fft_ind")) {
                    rdata.setBsFftInd(sstr);
                    continue;
                }
                if (fstr.equals("bs_chirp_rate")) {
                    rdata.setBsChirpRate(sstr);
                    continue;
                }
                if (fstr.equals("bs_fft_len")) {
                    rdata.setBsFftLen(sstr);
                    continue;
                }
                if (fstr.equals("bg_power")) {
                    rdata.setBgPower(sstr);
                    continue;
                }
                if (fstr.equals("bg_score")) {
                    rdata.setBgScore(sstr);
                    continue;
                }
                if (fstr.equals("bg_chisq")) {
                    rdata.setBgChisq(sstr);
                    continue;
                }
                if (fstr.equals("bg_true_mean")) {
                    rdata.setBgTrueMean(sstr);
                    continue;
                }
                if (fstr.equals("bg_sigma")) {
                    rdata.setBgSigma(sstr);
                    continue;
                }
                if (fstr.equals("bg_bin")) {
                    rdata.setBgBin(sstr);
                    continue;
                }
                if (fstr.equals("bg_fft_ind")) {
                    rdata.setBgFftInd(sstr);
                    continue;
                }
                if (fstr.equals("bg_chirp_rate")) {
                    rdata.setBgChirpRate(sstr);
                    continue;
                }
                if (fstr.equals("bg_fft_len")) {
                    rdata.setBgFftLen(sstr);
                    continue;
                }
                if (fstr.equals("cpu")) {
                    rdata.setCpu(sstr);
                    continue;
                }
                if (fstr.equals("prog")) {
                    rdata.setProg(sstr);
                    continue;
                }
                if (fstr.equals("started_time")) {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss");
                    formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
                    ParsePosition pos = new ParsePosition(0);
                    Date adate = formatter.parse(sstr, pos);
                    rdata.setStartedTime(adate);
                    continue;
                }
                if (fstr.equals("DataDirName")) {
                    rdata.setDirName(sstr);
                    continue;
                }
                if (fstr.startsWith("bg_pot")) {
                    st = new StringTokenizer(fstr);
                    String istr = "0";
                    try {
                        st.nextToken();
                        istr = st.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        istr = "0";
                    }
                    int potindex = 0;
                    try {
                        potindex = Integer.valueOf(istr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        potindex = 0;
                    }
                    double potvalue = 0.0;
                    try {
                        potvalue = Double.valueOf(sstr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        potvalue = 0.0;
                    }
                    rdata.setBgpot(potindex, potvalue);
                    continue;
                }
                if (!fstr.equals("end_seti_header") && !fstr.equals("num_positions")) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        try {
            ds.close();
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        return readFlag;
    }

    private static void analyzeSetiLogFile(BufferedReader ds, Vector datavect, String timeZoneID) {
        String[] keys = new String[]{"date", "name", "start_ra", "start_dec", "end_ra", "end_dec", "time_recorded", "subband_base", "cpu", "prog", "bs_power", "bs_score", "bs_bin", "bs_fft_ind", "bs_chirp_rate", "bs_fft_len", "bg_score", "bg_power", "bg_chisq", "bg_true_mean", "bg_sigma", "bg_bin", "bg_fft_ind", "bg_chirp_rate", "bg_fft_len"};
        Vector<Integer> refvect = new Vector<Integer>();
        int i = 0;
        while (i < keys.length) {
            refvect.addElement(null);
            ++i;
        }
        String line = null;
        try {
            line = ds.readLine();
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        CSVTokenizer st = new CSVTokenizer(line);
        int index = 0;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            int i2 = 0;
            while (i2 < keys.length) {
                if (keys[i2].equals(str)) {
                    try {
                        refvect.setElementAt(new Integer(index), i2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("please let Goro Otsuo know this bug");
                    }
                }
                ++i2;
            }
            ++index;
        }
        try {
            while ((line = ds.readLine()) != null) {
                ResultData rdata = new ResultData();
                datavect.addElement(rdata);
                st = new CSVTokenizer(line);
                Vector<String> strvect = new Vector<String>();
                int index2 = 0;
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    strvect.addElement(str);
                    ++index2;
                }
                Vector argvect = new Vector();
                int i3 = 0;
                while (i3 < refvect.size()) {
                    Integer indexOfKey = (Integer)refvect.elementAt(i3);
                    if (indexOfKey != null) {
                        argvect.addElement(strvect.elementAt(indexOfKey));
                    } else {
                        argvect.addElement(null);
                    }
                    ++i3;
                }
                Enumeration e = argvect.elements();
                String str = (String)e.nextElement();
                if (str != null) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                    formatter.setTimeZone(TimeZone.getTimeZone(timeZoneID));
                    ParsePosition pos = new ParsePosition(0);
                    Date adate = formatter.parse(str, pos);
                    rdata.setStartedTime(adate);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setName(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setRa(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setDec(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setEndRa(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setEndDec(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    if (str.indexOf("(") == -1 || str.indexOf(")") == -1) {
                        rdata.setTimeRecorded("ND");
                    } else {
                        String datestr = str.substring(str.indexOf("("), str.indexOf(")") + 1);
                        rdata.setTimeRecorded(datestr);
                    }
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBand(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setCpu(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setProg(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsPower(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsScore(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsBin(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsFftInd(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsChirpRate(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBsFftLen(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgScore(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgPower(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgChisq(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgTrueMean(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgSigma(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgBin(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgFftInd(str);
                }
                if ((str = (String)e.nextElement()) != null) {
                    rdata.setBgChirpRate(str);
                }
                if ((str = (String)e.nextElement()) == null) continue;
                rdata.setBgFftLen(str);
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
    }

    public static void addPastData(ResultData data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter ot = new PrintWriter(new BufferedWriter(new OutputStreamWriter(baos)));
            ot.println("!");
            ot.println(data.getFileOutStr(false));
            ot.flush();
            byte[] bout = baos.toByteArray();
            RandomAccessFile rfp = new RandomAccessFile(new File(System.getProperty("user.dir"), pastDataFileName), "rw");
            rfp.seek(rfp.length());
            rfp.write(bout);
            rfp.close();
        }
        catch (IOException e) {
            System.out.println("FileAccessError " + e);
        }
    }

    public static PrefValue readPrefs() {
        PrefValue ret = new PrefValue();
        ret.setUpdatePref(1);
        ret.setProgPref(1);
        ret.setDispPref(0);
        ret.setScrollPref(0);
        ret.setCLPref(1);
        ret.setBlinkPref(1);
        ret.setCurrentTimeZoneID("JST");
        ret.setPaintPref("Standard");
        ret.setAPaintPref("Circle");
        ret.setAmPref("Auto");
        ret.setSkyPref(0);
        ret.setCstPref(1);
        ret.setCstNamePref(1);
        ret.setGridPref(1);
        ret.setGpPref(1);
        ret.setStarBrPref(5.5);
        ret.setSSizePref("Standard");
        ret.setAcPref(10);
        ret.setStarTracePref(1);
        ret.setAutoVanglePref(0);
        ret.setDatatablePref(0);
        ret.setGsdPref(0);
        ret.setTopPref(1);
        ret.setLogDataPref(1);
        File fp = new File(System.getProperty("user.dir"), prefFileName);
        if (!fp.exists()) {
            return ret;
        }
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            while ((line = ds.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line);
                String fstr = st.nextToken();
                if ((fstr = fstr.trim()).equals("updatePref")) {
                    ret.setUpdatePref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("progPref")) {
                    ret.setProgPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("dispPref")) {
                    ret.setDispPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("clPref")) {
                    ret.setCLPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("blinkPref")) {
                    ret.setBlinkPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("scrollPref")) {
                    ret.setScrollPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("tzPref")) {
                    ret.setCurrentTimeZoneID(st.nextToken());
                    continue;
                }
                if (fstr.equals("paintPref")) {
                    ret.setPaintPref(st.nextToken());
                    continue;
                }
                if (fstr.equals("apaintPref")) {
                    ret.setAPaintPref(st.nextToken());
                    continue;
                }
                if (fstr.equals("boundPref")) {
                    ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken());
                    continue;
                }
                if (fstr.equals("amPref")) {
                    ret.setAmPref(st.nextToken());
                    continue;
                }
                if (fstr.equals("skyPref")) {
                    ret.setSkyPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("cstPref")) {
                    ret.setCstPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("cstNamePref")) {
                    ret.setCstNamePref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("gridPref")) {
                    ret.setGridPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("gpPref")) {
                    ret.setGpPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("starBrPref")) {
                    ret.setStarBrPref(Double.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("acPref")) {
                    ret.setAcPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("ssizePref")) {
                    ret.setSSizePref(st.nextToken());
                    continue;
                }
                if (fstr.equals("starTracePref")) {
                    ret.setStarTracePref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("datatablePref")) {
                    ret.setDatatablePref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("gsdPref")) {
                    ret.setGsdPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (fstr.equals("topPref")) {
                    ret.setTopPref(Integer.valueOf(st.nextToken()));
                    continue;
                }
                if (!fstr.equals("logDataPref")) continue;
                ret.setLogDataPref(Integer.valueOf(st.nextToken()));
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        return ret;
    }

    public static void fileOutPrefs(PrefValue val) {
        PrintWriter outfp = null;
        File fp = new File(System.getProperty("user.dir"), prefFileName);
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            outfp.println("updatePref " + val.getUpdatePref());
            outfp.println("progPref " + val.getProgPref());
            outfp.println("dispPref " + val.getDispPref());
            outfp.println("scrollPref " + val.getScrollPref());
            outfp.println("clPref " + val.getCLPref());
            outfp.println("blinkPref " + val.getBlinkPref());
            outfp.println("tzPref " + val.getCurrentTimeZoneID());
            outfp.println("paintPref " + val.getPaintPref());
            outfp.println("apaintPref " + val.getAPaintPref());
            outfp.println("boundPref " + val.getBoundStr());
            outfp.println("amPref " + val.getAmPref());
            outfp.println("skyPref " + val.getSkyPref());
            outfp.println("cstPref " + val.getCstPref());
            outfp.println("cstNamePref " + val.getCstNamePref());
            outfp.println("gridPref " + val.getGridPref());
            outfp.println("gpPref " + val.getGpPref());
            outfp.println("starBrPref " + val.getStarBrPref());
            outfp.println("acPref " + val.getAcPref());
            outfp.println("ssizePref " + val.getSSizePref());
            outfp.println("starTracePref " + val.getStarTracePref());
            outfp.println("datatablePref " + val.getDatatablePref());
            outfp.println("gsdPref " + val.getGsdPref());
            outfp.println("topPref " + val.getTopPref());
            outfp.println("logDataPref " + val.getLogDataPref());
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static String getUserString(String dirName) {
        String filename = String.valueOf(dirName) + userFileName;
        File fp = new File(filename);
        if (!fp.exists() && !(fp = new File(filename = String.valueOf(dirName) + n2_userFileName)).exists()) {
            return "";
        }
        String ret = "";
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            int dataunitno = 0;
            double cputime = 0.0;
            while ((line = ds.readLine()) != null) {
                String sstr;
                String fstr;
                if ((line = line.trim()).length() == 0) continue;
                int index = line.indexOf("=");
                if (index == -1) {
                    fstr = line;
                    sstr = null;
                } else {
                    fstr = line.substring(0, index);
                    sstr = line.substring(index + 1);
                }
                if (fstr.equals("name")) {
                    ret = String.valueOf(ret) + "Name: " + sstr + "\n";
                    continue;
                }
                if (fstr.equals("nwus")) {
                    ret = String.valueOf(ret) + "Work units sent: " + sstr + "\n";
                    continue;
                }
                if (fstr.equals("nresults")) {
                    ret = String.valueOf(ret) + "Results received: " + sstr + "\n";
                    dataunitno = Integer.valueOf(sstr);
                    continue;
                }
                if (!fstr.equals("total_cpu")) continue;
                cputime = Double.valueOf(sstr);
                ret = String.valueOf(ret) + "Total CPU time: " + ResultData.genHMSString(cputime);
                if (cputime >= 3196800.0) {
                    String str = DoubleFormat.toString(cputime / 3.1536E7, 2);
                    ret = String.valueOf(ret) + " (" + str + " years )";
                }
                ret = String.valueOf(ret) + "\n";
            }
            if (dataunitno != 0 && cputime != 0.0) {
                ret = String.valueOf(ret) + "Average CPU time per work unit: " + ResultData.genHMSString(cputime / (double)dataunitno) + "\n";
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        return ret;
    }

    static void exportCSVFile(String fileName, Vector cvect, int mode) {
        PrintWriter outfp = null;
        try {
            outfp = new PrintWriter(new FileWriter(fileName));
            String sep = "";
            if (mode == 0) {
                sep = ",";
            } else if (mode == 1) {
                sep = "\t";
            } else if (mode == 2) {
                sep = "</TD><TD>";
                outfp.println("<HTML>");
                outfp.println("<HEAD>");
                outfp.println("<TITLE>SETI@home data</TITLE>");
                outfp.println("<BODY>");
                outfp.println("<TABLE BORDER=1>");
            }
            int i = 0;
            while (i < cvect.size()) {
                Vector svect = (Vector)cvect.elementAt(i);
                if (mode == 2) {
                    if (i == 0) {
                        outfp.print("<TR><TH>");
                    } else {
                        outfp.print("<TR><TD>");
                    }
                }
                int j = 0;
                while (j < svect.size()) {
                    String str = (String)svect.elementAt(j);
                    if (j == svect.size() - 1) {
                        outfp.print(str);
                    } else if (i == 0 && mode == 2) {
                        outfp.print(String.valueOf(str) + "</TH><TH>");
                    } else {
                        outfp.print(String.valueOf(str) + sep);
                    }
                    ++j;
                }
                if (mode == 2) {
                    if (i == 0) {
                        outfp.println("</TH></TR>");
                    } else {
                        outfp.println("</TD></TR>");
                    }
                } else {
                    outfp.println();
                }
                ++i;
            }
            if (mode == 2) {
                outfp.println("</TABLE>");
                outfp.println("</BODY>");
                outfp.println("</HTML>");
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static MxPrefValue readMxPrefs() {
        MxPrefValue ret = new MxPrefValue();
        ret.setSortTitle("No");
        ret.setSortMode(0);
        ret.setBound(new Rectangle(50, 50, 600, 400));
        ret.addTitle("No");
        int i = 0;
        while (i < GLBX.TITLE.length) {
            ret.addTitle(GLBX.TITLE[i]);
            ++i;
        }
        File fp = new File(System.getProperty("user.dir"), mxPrefFileName);
        if (!fp.exists()) {
            return ret;
        }
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            while ((line = ds.readLine()) != null) {
                StringTokenizer st;
                if ((line = line.trim()).length() == 0) continue;
                int index = line.indexOf("=");
                String fstr = line.substring(0, index);
                String sstr = line.substring(index + 1);
                if (fstr.equals("sortTitle")) {
                    ret.setSortTitle(sstr);
                    continue;
                }
                if (fstr.equals("sortmode")) {
                    ret.setSortMode(Integer.valueOf(sstr));
                    continue;
                }
                if (fstr.equals("boundPref")) {
                    st = new StringTokenizer(sstr);
                    ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken());
                    continue;
                }
                if (fstr.equals("title")) {
                    ret.clearTitle();
                    st = new StringTokenizer(sstr, "$");
                    while (st.hasMoreTokens()) {
                        ret.addTitle(st.nextToken());
                    }
                    continue;
                }
                if (!fstr.equals("cutcond")) continue;
                ret.addCutCondStr(sstr);
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        return ret;
    }

    public static void fileOutMxPrefs(MxPrefValue val) {
        File fp = new File(System.getProperty("user.dir"), mxPrefFileName);
        PrintWriter outfp = null;
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            outfp.println("sortTitle=" + val.getSortTitle());
            outfp.println("sortmode=" + val.getSortMode());
            outfp.println("boundPref=" + val.getBoundStr());
            outfp.println("title=" + val.getTitleStr());
            Vector condvect = val.getCondVect();
            int i = 0;
            while (i < condvect.size()) {
                outfp.println("cutcond=" + (String)condvect.elementAt(i));
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }

    public static GDPrefValue readGDPrefs() {
        GDPrefValue ret = new GDPrefValue();
        ret.setBound(new Rectangle(50, 50, 400, 400));
        ret.setClPref(1);
        ret.setArPref(1);
        ret.setHiCurPref(1);
        ret.setBlinkPref(0);
        ret.setSnowPref(0);
        File fp = new File(System.getProperty("user.dir"), gdPrefFileName);
        if (!fp.exists()) {
            return ret;
        }
        try {
            String line;
            BufferedReader ds = new BufferedReader(new FileReader(fp));
            while ((line = ds.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                int index = line.indexOf("=");
                String fstr = line.substring(0, index);
                String sstr = line.substring(index + 1);
                if (fstr.equals("boundPref")) {
                    StringTokenizer st = new StringTokenizer(sstr);
                    ret.setBound(st.nextToken(), st.nextToken(), st.nextToken(), st.nextToken());
                    continue;
                }
                if (fstr.equals("clPref")) {
                    ret.setClPref(Integer.valueOf(sstr));
                    continue;
                }
                if (fstr.equals("arPref")) {
                    ret.setArPref(Integer.valueOf(sstr));
                    continue;
                }
                if (fstr.equals("hiCurPref")) {
                    ret.setHiCurPref(Integer.valueOf(sstr));
                    continue;
                }
                if (fstr.equals("blinkPref")) {
                    ret.setBlinkPref(Integer.valueOf(sstr));
                    continue;
                }
                if (!fstr.equals("snowPref")) continue;
                ret.setSnowPref(Integer.valueOf(sstr));
            }
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        return ret;
    }

    public static void fileOutGDPrefs(GDPrefValue val) {
        File fp = new File(System.getProperty("user.dir"), gdPrefFileName);
        PrintWriter outfp = null;
        try {
            outfp = new PrintWriter(new FileWriter(fp));
            outfp.println("boundPref=" + val.getBoundStr());
            outfp.println("clPref=" + val.getClPref());
            outfp.println("arPref=" + val.getArPref());
            outfp.println("hiCurPref=" + val.getHiCurPref());
            outfp.println("blinkPref=" + val.getBlinkPref());
            outfp.println("snowPref=" + val.getSnowPref());
        }
        catch (IOException e) {
            System.out.println("File error:" + e);
        }
        outfp.close();
    }
}

