/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class CondInputDialog
extends Dialog {
    TextField valueField;
    Label nameLabel;
    Button okButton;
    Button delButton;
    Button cancelButton;
    Choice relChoice;
    Checkbox chkbox;
    CutCond cond;
    int relindex;
    MatrixViewer boss;
    boolean fComponentsAdjusted = false;

    public CondInputDialog(Frame parent, String title) {
        this(parent, title, null, true, true);
    }

    public CondInputDialog(Frame parent, String title, String condstr, boolean state, boolean flag) {
        super(parent, title, true);
        this.boss = (MatrixViewer)parent;
        if (condstr.equals("nodata")) {
            this.cond = null;
        } else {
            this.cond = new CutCond(condstr);
            this.cond.setState(state);
        }
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(220, 70);
        ((Component)this).setBackground(Color.white);
        Panel uppanel = new Panel();
        uppanel.setLayout(new FlowLayout(1));
        this.add("Center", uppanel);
        this.chkbox = new Checkbox();
        this.chkbox.setState(state);
        uppanel.add(this.chkbox);
        this.nameLabel = new Label("Data");
        uppanel.add(this.nameLabel);
        this.relChoice = new Choice();
        uppanel.add(this.relChoice);
        if (flag) {
            int i = 0;
            while (i < GLBX.COND_STR.length) {
                this.relChoice.addItem(GLBX.COND_STR[i]);
                ++i;
            }
        } else {
            this.relChoice.addItem(GLBX.COND_STR[3]);
        }
        this.valueField = new TextField(5);
        uppanel.add(this.valueField);
        Panel lupanel = new Panel();
        lupanel.setLayout(new FlowLayout(1));
        this.add("South", lupanel);
        this.okButton = new Button("OK");
        lupanel.add(this.okButton);
        this.delButton = new Button("Delete");
        lupanel.add(this.delButton);
        this.cancelButton = new Button("Cancel");
        lupanel.add(this.cancelButton);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.okButton.addActionListener(lSymAction);
        this.delButton.addActionListener(lSymAction);
        this.cancelButton.addActionListener(lSymAction);
        SymText aSymText = new SymText();
        this.valueField.addTextListener(aSymText);
        MSymItem lSymItem = new MSymItem();
        this.relChoice.addItemListener(lSymItem);
        this.setItems();
    }

    public CondInputDialog(Frame parent, boolean modal) {
        this(parent, "title");
    }

    public CondInputDialog(Frame parent, String title, boolean modal) {
        this(parent, title);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    private void setItems() {
        if (this.cond == null) {
            String selectedStr = this.relChoice.getItem(0);
            int i = 0;
            while (i < GLBX.COND_STR.length) {
                if (selectedStr.equals(GLBX.COND_STR[i])) {
                    this.relindex = i;
                    break;
                }
                ++i;
            }
            this.chkbox.setState(true);
        } else {
            String str = this.cond.getValStr();
            ((TextComponent)this.valueField).setText(str);
            this.relindex = this.cond.getRelation();
            if (this.relindex >= 0 && this.relChoice.getItemCount() > 1) {
                this.relChoice.select(this.relindex);
            }
            this.chkbox.setState(this.cond.getState());
        }
    }

    void InputDialog_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void okButton_Clicked(ActionEvent event) {
        String str = this.valueField.getText();
        if ((str = str.trim()).length() == 0) {
            return;
        }
        this.boss.setCondition(this.relindex, this.valueField.getText(), this.chkbox.getState());
        this.dispose();
    }

    void delButton_Clicked(ActionEvent event) {
        this.boss.delCondition();
        this.dispose();
    }

    void cancelButton_Clicked(ActionEvent event) {
        this.dispose();
    }

    void relChoice_ItemStateChanged(ItemEvent event) {
        this.relindex = this.relChoice.getSelectedIndex();
    }

    void valueFileld_Kicked(TextEvent event) {
        StringBuffer buf = new StringBuffer();
        String str = this.valueField.getText();
        boolean flag = false;
        int i = 0;
        while (i < str.length()) {
            char tch = str.charAt(i);
            if (!Character.isDigit(tch) && tch != '-' && tch != '.') {
                flag = true;
            } else {
                buf.append(tch);
            }
            ++i;
        }
        if (flag) {
            str = buf.toString();
            ((TextComponent)this.valueField).setText(str);
            this.valueField.setCaretPosition(str.length());
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == this) {
                CondInputDialog.this.InputDialog_WindowClosing(event);
            }
        }

        SymWindow() {
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == CondInputDialog.this.okButton) {
                CondInputDialog.this.okButton_Clicked(event);
            } else if (object == CondInputDialog.this.delButton) {
                CondInputDialog.this.delButton_Clicked(event);
            } else if (object == CondInputDialog.this.cancelButton) {
                CondInputDialog.this.cancelButton_Clicked(event);
            }
        }

        SymAction() {
        }
    }

    class MSymItem
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == CondInputDialog.this.relChoice) {
                CondInputDialog.this.relChoice_ItemStateChanged(event);
            }
        }

        MSymItem() {
        }
    }

    class SymText
    implements TextListener {
        public void textValueChanged(TextEvent event) {
            Object object = event.getSource();
            if (object == CondInputDialog.this.valueField && event.getID() == 900) {
                CondInputDialog.this.valueFileld_Kicked(event);
            }
        }

        SymText() {
        }
    }
}

