/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;

class TDPoint {
    double ra;
    double de;
    double x;
    double y;
    double z;

    TDPoint() {
        this.ra = 0.0;
        this.de = 0.0;
        this.setXYZ();
    }

    TDPoint(double d, double d2) {
        this.ra = d;
        this.de = d2;
        this.setXYZ();
    }

    TDPoint(int n, int n2) {
        this.ra = (double)n * Math.PI / 180.0;
        this.de = (double)n2 * Math.PI / 180.0;
        this.setXYZ();
    }

    TDPoint(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.setRaDe();
    }

    TDPoint(TDPoint tDPoint) {
        this.x = tDPoint.getX();
        this.y = tDPoint.getY();
        this.z = tDPoint.getZ();
        this.setRaDe();
    }

    private void setXYZ() {
        this.x = Math.cos(this.de) * Math.cos(this.ra);
        this.y = Math.cos(this.de) * Math.sin(this.ra);
        this.z = Math.sin(this.de);
    }

    private void setRaDe() {
        double d = this.length();
        this.de = Math.asin(this.z / d);
        this.ra = Math.atan2(this.y, this.x);
    }

    boolean isNull() {
        return this.ra == 0.0 && this.de == 0.0;
    }

    double getRa() {
        return this.ra;
    }

    double getDe() {
        return this.de;
    }

    public void setRa(double d) {
        this.ra = d;
        this.setXYZ();
    }

    public void setDe(double d) {
        this.de = d;
        this.setXYZ();
    }

    double getX() {
        return this.x;
    }

    double getY() {
        return this.y;
    }

    double getZ() {
        return this.z;
    }

    public Point getConv(double d, double d2, double d3) {
        TDouble tDouble = this.getConvedTD(d, d2);
        if (tDouble.getZ() > 1.0E-4) {
            int n = (int)(d3 * (tDouble.getX() / tDouble.getZ()));
            int n2 = (int)(d3 * (tDouble.getY() / tDouble.getZ()));
            return new Point(n, n2);
        }
        return null;
    }

    public Point getPtConv(double d, double d2, double d3) {
        TDouble tDouble = this.getConvedTD(d, d2);
        if (tDouble.getZ() > 1.0E-4) {
            int n = (int)(d3 * tDouble.getX());
            int n2 = (int)(d3 * tDouble.getY());
            return new Point(n, n2);
        }
        return null;
    }

    private TDouble getConvedTD(double d, double d2) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        double d7 = d4 * this.y - d3 * this.x;
        double d8 = d6 * this.z - d4 * d5 * this.x - d3 * d5 * this.y;
        double d9 = d4 * d6 * this.x + d3 * d6 * this.y + d5 * this.z;
        return new TDouble(d7, d8, d9);
    }

    public double getAngle(double d, double d2) {
        TDouble tDouble = this.getConvedTD(d, d2);
        double d3 = Math.sqrt(tDouble.getX() * tDouble.getX() + tDouble.getY() * tDouble.getY());
        double d4 = Math.atan(d3 / tDouble.getZ());
        if (d4 < 0.0) {
            d4 = Math.PI + d4;
        }
        return d4;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public TDPoint cross(TDPoint tDPoint) {
        double d = this.y * tDPoint.getZ() - tDPoint.getY() * this.z;
        double d2 = tDPoint.getX() * this.z - this.x * tDPoint.getZ();
        double d3 = this.x * tDPoint.getY() - tDPoint.getX() * this.y;
        TDPoint tDPoint2 = new TDPoint(d, d2, d3);
        tDPoint2.setRaDe();
        return tDPoint2;
    }

    public TDPoint subtract(TDPoint tDPoint) {
        double d = this.x - tDPoint.getX();
        double d2 = this.y - tDPoint.getY();
        double d3 = this.z - tDPoint.getZ();
        TDPoint tDPoint2 = new TDPoint(d, d2, d3);
        tDPoint2.setRaDe();
        return tDPoint2;
    }

    public TDPoint add(TDPoint tDPoint) {
        double d = this.x + tDPoint.getX();
        double d2 = this.y + tDPoint.getY();
        double d3 = this.z + tDPoint.getZ();
        TDPoint tDPoint2 = new TDPoint(d, d2, d3);
        tDPoint2.setRaDe();
        return tDPoint2;
    }

    public void changeLength(double d) {
        double d2 = d / this.length();
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
    }
}

