/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class ResultData
implements Cloneable {
    String name;
    int[] ra = new int[3];
    int[] dec = new int[3];
    TDPoint tpoint;
    int[] end_ra = new int[3];
    int[] end_dec = new int[3];
    TDPoint end_tpoint;
    double angle_range = -1.0;
    double subband_base = -1.0;
    String bs_power;
    String bs_score;
    String bs_bin;
    String bs_fft_ind;
    String bs_chirp_rate;
    String bs_fft_len;
    String bg_power;
    String bg_score;
    String bg_chisq;
    String bg_sigma;
    String bg_bin;
    String bg_fft_ind;
    String bg_chirp_rate;
    String bg_fft_len;
    String bg_true_mean;
    double bs_power_val;
    double bs_score_val;
    double bs_bin_val;
    double bs_fft_ind_val;
    double bs_chirp_rate_val;
    double bs_fft_len_val;
    double bg_power_val;
    double bg_score_val;
    double bg_chisq_val;
    double bg_sigma_val;
    double bg_bin_val;
    double bg_fft_ind_val;
    double bg_chirp_rate_val;
    double bg_fft_len_val;
    double bg_true_mean_val;
    double cpu = -1.0;
    double prog = -1.0;
    String time_recorded;
    String time_recorded_yms;
    Date recordedTime;
    Date startedTime;
    String startedTimeStr;
    Date infoUpdatedTime;
    String dirname;
    String shortname;
    boolean finishedFlag = false;
    boolean selected;
    PointData pt;
    PlotData plt;
    String colorname;
    String timeZoneID;
    MxData md;
    Vector bgpot;
    Vector areaData;

    ResultData() {
        this.tpoint = new TDPoint();
    }

    public Object clone() {
        try {
            Object object;
            int n;
            ResultData resultData = (ResultData)super.clone();
            if (this.tpoint != null) {
                resultData.setPoint(new TDPoint(this.tpoint.getRa(), this.tpoint.getDe()));
            } else {
                resultData.setPoint(new TDPoint());
            }
            if (this.end_tpoint != null) {
                resultData.setEndPoint(new TDPoint(this.end_tpoint.getRa(), this.end_tpoint.getDe()));
            } else {
                resultData.setEndPoint(new TDPoint());
            }
            if (this.bgpot != null) {
                resultData.resetBgpot();
                n = 0;
                while (n < this.bgpot.size()) {
                    object = (Double)this.bgpot.elementAt(n);
                    if (object == null) {
                        resultData.setBgpot(n, 0.0);
                    } else {
                        resultData.setBgpot(n, (Double)object);
                    }
                    ++n;
                }
            }
            if (this.areaData != null) {
                resultData.resetAreaData();
                n = 0;
                while (n < this.areaData.size()) {
                    object = (TDPoint)this.areaData.elementAt(n);
                    if (object != null) {
                        resultData.addAreaData(new TDPoint((TDPoint)object));
                    }
                    ++n;
                }
            }
            return resultData;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "no_name";
    }

    public void setPosData(String[] stringArray) {
        this._setPosData(stringArray, true);
    }

    public void setEndPosData(String[] stringArray) {
        this._setPosData(stringArray, false);
        this.setAreaData();
    }

    private void _setPosData(String[] stringArray, boolean bl) {
        int n = 0;
        while (n < 3) {
            try {
                if (bl) {
                    this.ra[n] = Integer.valueOf(stringArray[n]);
                } else {
                    this.end_ra[n] = Integer.valueOf(stringArray[n]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    this.ra[n] = 0;
                }
                this.end_ra[n] = 0;
            }
            try {
                if (bl) {
                    this.dec[n] = Integer.valueOf(stringArray[n + 3]);
                } else {
                    this.end_dec[n] = Integer.valueOf(stringArray[n + 3]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) {
                    this.dec[n] = 0;
                }
                this.end_dec[n] = 0;
            }
            ++n;
        }
        if (bl) {
            double d = (double)this.ra[0] + (double)this.ra[1] / 60.0 + (double)this.ra[2] / 3600.0;
            double d2 = (double)this.dec[0] + (double)this.dec[1] / 60.0 + (double)this.dec[2] / 3600.0;
            this.tpoint = new TDPoint(d * Math.PI / 12.0, d2 * Math.PI / 180.0);
        } else {
            double d = (double)this.end_ra[0] + (double)this.end_ra[1] / 60.0 + (double)this.end_ra[2] / 3600.0;
            double d3 = (double)this.end_dec[0] + (double)this.end_dec[1] / 60.0 + (double)this.end_dec[2] / 3600.0;
            this.end_tpoint = new TDPoint(d * Math.PI / 12.0, d3 * Math.PI / 180.0);
        }
    }

    public void setRa(String string) {
        this.setRaDec(string, true, true);
    }

    public void setDec(String string) {
        this.setRaDec(string, false, true);
    }

    public void setEndRa(String string) {
        if (this.end_tpoint == null) {
            this.end_tpoint = new TDPoint();
        }
        this.setRaDec(string, true, false);
        this.setAreaData();
    }

    public void setEndDec(String string) {
        if (this.end_tpoint == null) {
            this.end_tpoint = new TDPoint();
        }
        this.setRaDec(string, false, false);
        this.setAreaData();
    }

    private void setRaDec(String string, boolean bl, boolean bl2) {
        int[] nArray = new int[3];
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (bl) {
            if (bl2) {
                this.tpoint.setRa(d * Math.PI / 12.0);
            } else {
                this.end_tpoint.setRa(d * Math.PI / 12.0);
            }
        } else if (bl2) {
            this.tpoint.setDe(d * Math.PI / 180.0);
        } else {
            this.end_tpoint.setDe(d * Math.PI / 180.0);
        }
        nArray[0] = (int)d;
        nArray[1] = (int)((d -= (double)nArray[0]) / 0.016666666666666666);
        nArray[2] = (int)((d -= (double)nArray[1] * 0.016666666666666666) / 2.777777777777778E-4);
        int n = 0;
        while (n < 3) {
            if (bl2) {
                if (bl) {
                    this.ra[n] = nArray[n];
                } else {
                    this.dec[n] = nArray[n];
                }
            } else if (bl) {
                this.end_ra[n] = nArray[n];
            } else {
                this.end_dec[n] = nArray[n];
            }
            ++n;
        }
    }

    private String getPosStr() {
        return this._getPosStr(true);
    }

    private String getEndPosStr() {
        return this._getPosStr(false);
    }

    private String _getPosStr(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bl) {
            n6 = this.ra[0];
            n5 = this.ra[1];
            n4 = this.ra[2];
            n3 = this.dec[0];
            n2 = this.dec[1];
            n = this.dec[2];
        } else {
            n6 = this.end_ra[0];
            n5 = this.end_ra[1];
            n4 = this.end_ra[2];
            n3 = this.end_dec[0];
            n2 = this.end_dec[1];
            n = this.end_dec[2];
        }
        String string = String.valueOf(Integer.toString(n6)) + "hr " + Integer.toString(n5) + "min " + Integer.toString(n4) + "sec RA,";
        if (this.getDecValue() > 0.0) {
            string = String.valueOf(string) + "+";
        }
        string = String.valueOf(string) + Integer.toString(n3) + "deg " + Integer.toString(n2) + "min " + Integer.toString(n) + "sec DEC";
        return string;
    }

    public double getRaValue() {
        return this.tpoint.getRa();
    }

    public double getDecValue() {
        return this.tpoint.getDe();
    }

    public double getRaHMS() {
        return this.tpoint.getRa() * 12.0 / Math.PI;
    }

    public double getDecDeg() {
        return this.tpoint.getDe() * 180.0 / Math.PI;
    }

    public double getEndRaValue() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getRa();
    }

    public double getEndDecValue() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getDe();
    }

    public double getEndRaHMS() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getRa() * 12.0 / Math.PI;
    }

    public double getEndDecDeg() {
        if (this.end_tpoint == null) {
            return 0.0;
        }
        return this.end_tpoint.getDe() * 180.0 / Math.PI;
    }

    public TDPoint getPoint() {
        return this.tpoint;
    }

    public void setPoint(TDPoint tDPoint) {
        this.tpoint = tDPoint;
    }

    public TDPoint getEndPoint() {
        return this.end_tpoint;
    }

    public void setEndPoint(TDPoint tDPoint) {
        this.end_tpoint = tDPoint;
    }

    public void setAngleRange(String string) {
        try {
            this.angle_range = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.angle_range = 0.0;
        }
    }

    public void setBand(String string) {
        try {
            this.subband_base = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.subband_base = 0.0;
        }
    }

    public void setBsPower(String string) {
        this.bs_power = new String(string);
        try {
            this.bs_power_val = Double.valueOf(this.bs_power);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_power = "ND";
            this.bs_power_val = 0.0;
        }
    }

    public void setBsScore(String string) {
        this.bs_score = new String(string);
        try {
            this.bs_score_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_score = "ND";
            this.bs_score_val = 0.0;
        }
    }

    public void setBsBin(String string) {
        this.bs_bin = new String(string);
        try {
            this.bs_bin_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_bin = "ND";
            this.bs_bin_val = 0.0;
        }
    }

    public void setBsFftInd(String string) {
        this.bs_fft_ind = new String(string);
        try {
            this.bs_fft_ind_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_fft_ind = "ND";
            this.bs_fft_ind_val = 0.0;
        }
    }

    public void setBsChirpRate(String string) {
        this.bs_chirp_rate = new String(string);
        try {
            this.bs_chirp_rate_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_chirp_rate = "ND";
            this.bs_chirp_rate_val = 0.0;
        }
    }

    public void setBsFftLen(String string) {
        this.bs_fft_len = new String(string);
        try {
            this.bs_fft_len_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bs_fft_len = "ND";
            this.bs_fft_len_val = 0.0;
        }
    }

    public void setBgPower(String string) {
        this.bg_power = new String(string);
        try {
            this.bg_power_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_power = "ND";
            this.bg_power_val = 0.0;
        }
    }

    public double getBgPower() {
        return this.bg_power_val;
    }

    public void setBgScore(String string) {
        this.bg_score = new String(string);
        try {
            this.bg_score_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_score = "ND";
            this.bg_score_val = 0.0;
        }
    }

    public void setBgChisq(String string) {
        this.bg_chisq = new String(string);
        try {
            this.bg_chisq_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_chisq = "ND";
            this.bg_chisq_val = 0.0;
        }
    }

    public double getBgChisq() {
        return this.bg_chisq_val;
    }

    public void setBgTrueMean(String string) {
        this.bg_true_mean = new String(string);
        try {
            this.bg_true_mean_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_true_mean = "ND";
            this.bg_true_mean_val = 0.0;
        }
    }

    public double getBgTrueMean() {
        return this.bg_true_mean_val;
    }

    public void setBgSigma(String string) {
        this.bg_sigma = new String(string);
        try {
            this.bg_sigma_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_sigma = "ND";
            this.bg_sigma_val = 0.0;
        }
    }

    public void setBgBin(String string) {
        this.bg_bin = new String(string);
        try {
            this.bg_bin_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_bin = "ND";
            this.bg_bin_val = 0.0;
        }
    }

    public void setBgFftInd(String string) {
        this.bg_fft_ind = new String(string);
        try {
            this.bg_fft_ind_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_fft_ind = "ND";
            this.bg_fft_ind_val = 0.0;
        }
    }

    public void setBgChirpRate(String string) {
        this.bg_chirp_rate = new String(string);
        try {
            this.bg_chirp_rate_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_chirp_rate = "ND";
            this.bg_chirp_rate_val = 0.0;
        }
    }

    public void setBgFftLen(String string) {
        this.bg_fft_len = new String(string);
        try {
            this.bg_fft_len_val = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.bg_fft_len = "ND";
            this.bg_fft_len_val = 0.0;
        }
    }

    public void setCpu(String string) {
        try {
            this.cpu = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.cpu = 0.0;
        }
    }

    public String getCpuString() {
        double d = this.cpu;
        if (d < 0.0) {
            d = 0.0;
        }
        return ResultData.genHMSString(d);
    }

    public void setProg(String string) {
        try {
            this.prog = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.prog = 0.0;
        }
    }

    public double getProgValue() {
        return this.prog;
    }

    public String getProgString() {
        double d = this.prog;
        if (d < 0.0) {
            d = 0.0;
        }
        return String.valueOf(DoubleFormat.toString(d * 100.0, 3)) + " %";
    }

    public void setTimeRecorded(String string) {
        Object object;
        if (string == null) {
            this.time_recorded = "ND";
            this.time_recorded_yms = "ND";
            this.recordedTime = new Date(0L);
            return;
        }
        StringTokenizer stringTokenizer = string.indexOf("(") == -1 || string.indexOf(")") == -1 ? new StringTokenizer(string) : new StringTokenizer(string.substring(1, string.length() - 1));
        int n = 0;
        this.time_recorded = "";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (n == 2) {
                int n2 = 0;
                try {
                    n2 = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
                if (n2 < 10) {
                    this.time_recorded = String.valueOf(this.time_recorded) + "0";
                }
            }
            this.time_recorded = String.valueOf(this.time_recorded) + (String)object + " ";
            ++n;
        }
        object = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", new DateFormatSymbols(Locale.US));
        ParsePosition parsePosition = new ParsePosition(0);
        this.recordedTime = ((SimpleDateFormat)object).parse(this.time_recorded, parsePosition);
        if (this.recordedTime == null) {
            object = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", new DateFormatSymbols(Locale.US));
            this.recordedTime = ((SimpleDateFormat)object).parse(this.time_recorded, parsePosition);
        }
        if (this.recordedTime == null) {
            this.recordedTime = new Date(0L);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.time_recorded_yms = simpleDateFormat.format(this.recordedTime);
    }

    public void setInfoUpdated(Date date) {
        this.infoUpdatedTime = date;
    }

    private String getUpdatedStr() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        return simpleDateFormat.format(this.infoUpdatedTime);
    }

    public void setStartedTime(Date date) {
        this.startedTime = date;
    }

    public Date getStartedTime() {
        return this.startedTime;
    }

    private void setStartedTimeStr() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.timeZoneID));
        this.startedTimeStr = this.startedTime == null ? "ND" : simpleDateFormat.format(this.startedTime);
    }

    public void setTimeZone(String string) {
        this.timeZoneID = string;
        this.setStartedTimeStr();
    }

    public void setDirName(String string) {
        this.dirname = string;
    }

    public void setShortName(String string) {
        this.shortname = string;
    }

    public String getDirName() {
        return this.dirname;
    }

    public void setFinishedFlag(boolean bl) {
        this.finishedFlag = bl;
    }

    public boolean getFinishedFlag() {
        return this.finishedFlag;
    }

    public void setPointData(PointData pointData) {
        this.pt = pointData;
    }

    public PointData getPointData() {
        return this.pt;
    }

    public void setPlotData(PlotData plotData) {
        this.plt = plotData;
    }

    public PlotData getPlotData() {
        return this.plt;
    }

    public void setColorName(String string) {
        this.colorname = string;
        if (this.pt != null) {
            this.pt.setColor(this.colorname);
        }
    }

    public String getColorName() {
        return this.colorname;
    }

    public String getTitle() {
        return this.getPosStr();
    }

    public void setMd(MxData mxData) {
        this.md = mxData;
    }

    public void clearLinkToMx() {
        this.md = null;
    }

    public boolean getVisible() {
        if (this.md == null) {
            return true;
        }
        return this.md.getVisible();
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public String getRemainCpuString() {
        int n;
        if (this.prog == 0.0) {
            return null;
        }
        double d = this.cpu / this.prog - this.cpu;
        if (d < 0.0) {
            d = 0.0;
        }
        int n2 = (int)(d / 3600.0);
        d -= (double)(n2 * 3600);
        if ((d -= (double)((n = (int)(d / 60.0)) * 60)) > 1.0 && ++n == 60) {
            n = 0;
            ++n2;
        }
        String string = String.valueOf(Integer.toString(n2)) + "hr " + Integer.toString(n) + "min";
        return string;
    }

    public void setBgpot(int n, double d) {
        if (this.bgpot == null) {
            this.bgpot = new Vector();
        }
        if (n > this.bgpot.size() - 1) {
            this.bgpot.setSize(n + 1);
        }
        this.bgpot.setElementAt(new Double(d), n);
    }

    public Vector getBgpot() {
        return this.bgpot;
    }

    private void resetBgpot() {
        this.bgpot = new Vector();
    }

    private void resetAreaData() {
        this.areaData = new Vector();
    }

    private void addAreaData(TDPoint tDPoint) {
        this.areaData.addElement(tDPoint);
    }

    public void getAreaData(Vector vector) {
        if (this.areaData == null || this.areaData.size() == 0) {
            this.setAreaData();
        }
        int n = 0;
        while (n < this.areaData.size()) {
            TDPoint tDPoint = (TDPoint)this.areaData.elementAt(n);
            vector.addElement(new TDPoint(tDPoint));
            ++n;
        }
    }

    private void setAreaData() {
        this.areaData = new Vector();
        if (this.tpoint != null && this.end_tpoint == null) {
            this.areaData.addElement(new TDPoint(this.tpoint));
        } else if (this.tpoint != null && this.end_tpoint != null) {
            TDPoint tDPoint = this.tpoint.subtract(this.end_tpoint);
            if (tDPoint.length() == 0.0) {
                double d = 1.5707963267948966 - this.tpoint.getDe();
                tDPoint = new TDPoint(this.tpoint.getRa(), d);
                this.setAreaPoint(this.tpoint, tDPoint, this.areaData);
                d = this.tpoint.getRa() + 1.5707963267948966;
                if (d > Math.PI * 2) {
                    d -= Math.PI * 2;
                }
                TDPoint tDPoint2 = new TDPoint(d, 0.0);
                this.setAreaPoint(this.tpoint, tDPoint2, this.areaData);
                TDPoint tDPoint3 = (TDPoint)this.areaData.elementAt(1);
                this.areaData.setElementAt(this.areaData.elementAt(2), 1);
                this.areaData.setElementAt(tDPoint3, 2);
            } else {
                this.setAreaPoint(this.tpoint, tDPoint, this.areaData);
                this.setAreaPoint(this.end_tpoint, tDPoint, this.areaData);
                TDPoint tDPoint4 = (TDPoint)this.areaData.elementAt(2);
                this.areaData.setElementAt(this.areaData.elementAt(3), 2);
                this.areaData.setElementAt(tDPoint4, 3);
            }
        }
    }

    private void setAreaPoint(TDPoint tDPoint, TDPoint tDPoint2, Vector vector) {
        double d = tDPoint.length() * Math.tan(8.726646259971648E-4);
        TDPoint tDPoint3 = tDPoint.cross(tDPoint2);
        tDPoint3.changeLength(d);
        TDPoint tDPoint4 = tDPoint3.add(tDPoint);
        tDPoint4.changeLength(1.0);
        vector.addElement(tDPoint4);
        TDPoint tDPoint5 = tDPoint2.cross(tDPoint);
        tDPoint5.changeLength(d);
        TDPoint tDPoint6 = tDPoint5.add(tDPoint);
        tDPoint6.changeLength(1.0);
        vector.addElement(tDPoint6);
    }

    public boolean getTop() {
        return this.getBgChisq() < 2.0 + 1.5 * this.getBgPower() && this.getBgChisq() <= 10.0 && this.getBgPower() > 0.0;
    }

    public void clearStateInfo() {
        this.setCpu("0.0");
        this.setProg("0.0");
        this.resetBgpot();
        this.setBsPower("0.0");
        this.setBsScore("0.0");
        this.setBgPower("0.0");
        this.setBgScore("0.0");
        this.setBgChisq("0.0");
        this.setBgTrueMean("0.0");
        this.setBgSigma("0.0");
        this.setBgBin("0.0");
        this.setBgFftInd("0.0");
        this.setBgChirpRate("0.0");
        this.setBgFftLen("0.0");
    }

    public String getDataStr() {
        String string = "";
        if (this.name != null) {
            string = String.valueOf(string) + "Name : " + this.name;
        }
        if (this.shortname != null) {
            string = String.valueOf(string) + " (@ " + this.shortname + ")";
        }
        if (this.name != null || this.shortname != null) {
            string = String.valueOf(string) + "\n";
        }
        string = String.valueOf(string) + "From : " + this.getPosStr() + "\n";
        if (this.time_recorded != null) {
            string = String.valueOf(string) + "Recorded on : " + this.time_recorded + "\n";
        }
        if (this.subband_base >= 0.0) {
            string = String.valueOf(string) + "Base Frequency : " + DoubleFormat.toString(this.subband_base / 1.0E9, 9) + " GHz\n";
        }
        if (this.bs_power != null) {
            string = String.valueOf(string) + "Strongest Peak : power " + this.bs_power;
        }
        if (this.bs_score != null) {
            string = String.valueOf(string) + ", score " + this.bs_score + "\n";
        }
        if (this.bg_power != null) {
            string = String.valueOf(string) + "Strongest Gaussian : power " + this.bg_power;
        }
        if (this.bg_chisq != null) {
            string = String.valueOf(string) + ", fit " + this.bg_chisq;
        }
        if (this.bg_score != null) {
            string = String.valueOf(string) + ", score " + this.bg_score + "\n";
        }
        if (this.prog >= 0.0) {
            string = String.valueOf(string) + "Overall : " + this.getProgString() + " Done";
        }
        if (this.cpu >= 0.0) {
            string = String.valueOf(string) + " CPU Time : " + this.getCpuString() + "\n";
        }
        if (this.cpu > 0.0 && this.prog > 0.0 && !this.finishedFlag) {
            string = String.valueOf(string) + "Estimated remaining CPU Time: " + this.getRemainCpuString() + "\n";
        }
        if (this.startedTime != null) {
            string = String.valueOf(string) + "Analysis started : " + this.startedTimeStr + " \n";
        }
        if (this.infoUpdatedTime != null) {
            string = String.valueOf(string) + "Information Updated : " + this.getUpdatedStr();
        }
        return string;
    }

    public String getFileOutStr(boolean bl) {
        String string = "";
        string = String.valueOf(string) + "name=" + this.getName() + "\r";
        string = String.valueOf(string) + "start_ra=" + DoubleFormat.toString(this.getRaHMS(), 3) + "\r";
        string = String.valueOf(string) + "start_dec=" + DoubleFormat.toString(this.getDecDeg(), 3) + "\r";
        if (this.end_tpoint != null && !this.end_tpoint.isNull()) {
            string = String.valueOf(string) + "end_ra=" + DoubleFormat.toString(this.getEndRaHMS(), 3) + "\r";
            string = String.valueOf(string) + "end_dec=" + DoubleFormat.toString(this.getEndDecDeg(), 3) + "\r";
        }
        string = String.valueOf(string) + "angle_range=" + this.angle_range + "\r";
        string = String.valueOf(string) + "subband_base=" + this.subband_base + "\r";
        string = String.valueOf(string) + "time_recorded=" + "(" + this.time_recorded + ")" + "\r";
        string = String.valueOf(string) + "bs_power=" + this.bs_power + "\r";
        string = String.valueOf(string) + "bs_score=" + this.bs_score + "\r";
        string = String.valueOf(string) + "bs_bin=" + this.bs_bin + "\r";
        string = String.valueOf(string) + "bs_fft_ind=" + this.bs_fft_ind + "\r";
        string = String.valueOf(string) + "bs_chirp_rate=" + this.bs_chirp_rate + "\r";
        string = String.valueOf(string) + "bs_fft_len=" + this.bs_fft_len + "\r";
        string = String.valueOf(string) + "bg_power=" + this.bg_power + "\r";
        string = String.valueOf(string) + "bg_chisq=" + this.bg_chisq + "\r";
        string = String.valueOf(string) + "bg_score=" + this.bg_score + "\r";
        string = String.valueOf(string) + "bg_true_mean=" + this.bg_true_mean + "\r";
        string = String.valueOf(string) + "bg_sigma=" + this.bg_sigma + "\r";
        string = String.valueOf(string) + "bg_bin=" + this.bg_bin + "\r";
        string = String.valueOf(string) + "bg_fft_ind=" + this.bg_fft_ind + "\r";
        string = String.valueOf(string) + "bg_chirp_rate=" + this.bg_chirp_rate + "\r";
        string = String.valueOf(string) + "bg_fft_len=" + this.bg_fft_len + "\r";
        string = String.valueOf(string) + "prog=" + Double.toString(this.prog) + "\r";
        string = String.valueOf(string) + "cpu=" + Double.toString(this.cpu) + "\r";
        if (bl) {
            string = String.valueOf(string) + "DataDirName=" + this.dirname + "\r";
        }
        String string2 = null;
        if (this.startedTime != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            string2 = simpleDateFormat.format(this.startedTime);
            string = String.valueOf(string) + "started_time=" + string2 + "\r";
        }
        if (this.bgpot != null) {
            int n = 0;
            while (n < this.bgpot.size()) {
                Double d = (Double)this.bgpot.elementAt(n);
                if (d != null) {
                    string = String.valueOf(string) + "bg_pot " + n + "=" + d.toString() + "\r";
                }
                ++n;
            }
        }
        return string;
    }

    public void getCSVStr(Vector vector) {
        String string = "ND";
        if (this.name != null) {
            string = this.name;
        }
        vector.addElement(string);
        double d = this.prog;
        if (d < 0.0) {
            d = 0.0;
        }
        vector.addElement(DoubleFormat.toString(d, 6));
        if (this.cpu >= 0.0) {
            vector.addElement(Double.toString(this.cpu));
            vector.addElement(this.getCpuString());
        } else {
            vector.addElement("ND");
            vector.addElement("ND");
        }
        if (this.startedTimeStr == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.startedTimeStr);
        }
        if (this.bs_power == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bs_power);
        }
        if (this.bs_score == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bs_score);
        }
        if (this.bs_chirp_rate == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bs_chirp_rate);
        }
        if (this.bg_power == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bg_power);
        }
        if (this.bg_chisq == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bg_chisq);
        }
        if (this.bg_score == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bg_score);
        }
        if (this.bg_chirp_rate == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.bg_chirp_rate);
        }
        vector.addElement(DoubleFormat.toString(this.tpoint.getRa(), 3));
        vector.addElement(DoubleFormat.toString(this.tpoint.getDe(), 3));
        if (this.end_tpoint == null) {
            vector.addElement("ND");
            vector.addElement("ND");
        } else if (this.end_tpoint.isNull()) {
            vector.addElement("ND");
            vector.addElement("ND");
        } else {
            vector.addElement(DoubleFormat.toString(this.end_tpoint.getRa(), 3));
            vector.addElement(DoubleFormat.toString(this.end_tpoint.getDe(), 3));
        }
        if (this.time_recorded_yms == null) {
            vector.addElement("ND");
        } else {
            vector.addElement(this.time_recorded_yms);
        }
        if (this.subband_base < 0.0) {
            vector.addElement("ND");
        } else {
            vector.addElement(DoubleFormat.toString(this.subband_base, 2));
        }
        if (this.angle_range < 0.0) {
            vector.addElement("ND");
        } else {
            vector.addElement(DoubleFormat.toString(this.angle_range, 3));
        }
    }

    public StrDbl getMxVal(String string) {
        if (string.equals(GLBX.TITLE[1])) {
            return new StrDbl(this.name, 0.0);
        }
        if (string.equals(GLBX.TITLE[2])) {
            double d = this.prog;
            if (d < 0.0) {
                d = 0.0;
            }
            return new StrDbl(DoubleFormat.toString(d, 6), d);
        }
        if (string.equals(GLBX.TITLE[3])) {
            return new StrDbl(ResultData.cvrToTime(this.cpu), this.cpu);
        }
        if (string.equals(GLBX.TITLE[4])) {
            if (this.startedTime == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(this.startedTimeStr, this.startedTime.getTime());
        }
        if (string.equals(GLBX.TITLE[5])) {
            return new StrDbl(this.bs_power, this.bs_power_val);
        }
        if (string.equals(GLBX.TITLE[6])) {
            return new StrDbl(this.bs_score, this.bs_score_val);
        }
        if (string.equals(GLBX.TITLE[7])) {
            return new StrDbl(this.bs_chirp_rate, this.bs_chirp_rate_val);
        }
        if (string.equals(GLBX.TITLE[8])) {
            return new StrDbl(this.bg_power, this.bg_power_val);
        }
        if (string.equals(GLBX.TITLE[9])) {
            return new StrDbl(this.bg_chisq, this.bg_chisq_val);
        }
        if (string.equals(GLBX.TITLE[10])) {
            return new StrDbl(this.bg_score, this.bg_score_val);
        }
        if (string.equals(GLBX.TITLE[11])) {
            return new StrDbl(this.bg_chirp_rate, this.bg_chirp_rate_val);
        }
        if (string.equals(GLBX.TITLE[12])) {
            return new StrDbl(DoubleFormat.toString(this.getRaHMS(), 3), this.getRaValue());
        }
        if (string.equals(GLBX.TITLE[13])) {
            return new StrDbl(DoubleFormat.toString(this.getDecDeg(), 3), this.getDecValue());
        }
        if (string.equals(GLBX.TITLE[14])) {
            if (this.end_tpoint == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(DoubleFormat.toString(this.getEndRaHMS(), 3), this.getEndRaValue());
        }
        if (string.equals(GLBX.TITLE[15])) {
            if (this.end_tpoint == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(DoubleFormat.toString(this.getEndDecDeg(), 3), this.getEndDecValue());
        }
        if (string.equals(GLBX.TITLE[16])) {
            if (this.time_recorded == null) {
                return new StrDbl("ND", 0.0);
            }
            return new StrDbl(this.time_recorded_yms, this.recordedTime.getTime());
        }
        if (string.equals(GLBX.TITLE[17])) {
            String string2 = "ND";
            if (this.subband_base >= 0.0) {
                string2 = DoubleFormat.toString(this.subband_base, 2);
            }
            return new StrDbl(string2, this.subband_base);
        }
        if (string.equals(GLBX.TITLE[18])) {
            String string3 = "ND";
            if (this.angle_range >= 0.0) {
                string3 = DoubleFormat.toString(this.angle_range, 3);
            }
            return new StrDbl(string3, this.angle_range);
        }
        return null;
    }

    public static String genHMSString(double d) {
        int n = (int)(d / 3600.0);
        int n2 = (int)((d -= (double)(n * 3600)) / 60.0);
        String string = "";
        string = String.valueOf(string) + Integer.toString(n) + " hr " + Integer.toString(n2) + " min " + Integer.toString((int)(d -= (double)(n2 * 60))) + " sec";
        return string;
    }

    public static String cvrToTime(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        int n = (int)(d / 3600.0);
        int n2 = (int)((d -= (double)(n * 3600)) / 60.0);
        d -= (double)(n2 * 60);
        String string = "";
        if (n < 10) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + Integer.toString(n) + "h:";
        if (n2 < 10) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + Integer.toString(n2) + "m:";
        if (d < 10.0) {
            string = String.valueOf(string) + "0";
        }
        string = String.valueOf(string) + Integer.toString((int)d) + "s";
        return string;
    }
}

