/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class FileAnalyzer {
    static String versionFileName = "version.sah";
    static String stateFileName = "state.txt";
    static String workFileName = "work_unit.txt";
    static String userFileName = "user_info.txt";
    static String n2_stateFileName = "state.sah";
    static String n2_workFileName = "work_unit.sah";
    static String n2_userFileName = "user_info.sah";
    static String dataDirFileName = "ss_dir_data.txt";
    static String pastDirFileName = "ss_pdir.txt";
    static String pastDataFileName = "ss_past_data.txt";
    static String currentDataFileName = "ss_current_data.txt";
    static String prefFileName = "ss_pref.txt";
    static String mxPrefFileName = "ss_mx_pref.txt";
    static String gdPrefFileName = "ss_gd_pref.txt";

    public static boolean checkPastFile() {
        return FileAnalyzer.checkFile(String.valueOf(System.getProperty("user.dir")) + pastDataFileName);
    }

    public static boolean checkFile(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static boolean checkCurrentFile() {
        return FileAnalyzer.checkFile(String.valueOf(System.getProperty("user.dir")) + currentDataFileName);
    }

    public static boolean checkStateFile(String string) {
        boolean bl = FileAnalyzer.checkVerFile(string) ? new File(string, n2_stateFileName).exists() : new File(string, stateFileName).exists();
        return bl;
    }

    public static boolean checkWorkFile(String string) {
        boolean bl = FileAnalyzer.checkVerFile(string) ? new File(string, n2_workFileName).exists() : new File(string, workFileName).exists();
        return bl;
    }

    public static boolean checkVerFile(String string) {
        boolean bl = new File(string, versionFileName).exists();
        return bl;
    }

    public static void readDirData(Vector vector) {
        File file = new File(System.getProperty("user.dir"), dataDirFileName);
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = string.substring(string2.length() + 1);
                vector.addElement(new DirData(string2, string3));
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    public static void readPastDataDir(Vector vector) {
        File file = new File(System.getProperty("user.dir"), pastDirFileName);
        if (!file.exists()) {
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = string.substring(string2.length() + string3.length() + 2);
                vector.addElement(new DirData(string2, string3, string4));
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    public static void FileoutDirData(Vector vector) {
        File file = new File(System.getProperty("user.dir"), dataDirFileName);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            int n = 0;
            while (n < vector.size()) {
                DirData dirData = (DirData)vector.elementAt(n);
                printWriter.println(String.valueOf(dirData.getShortName()) + " " + dirData.getDir());
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static void FileoutPastDataDir(Vector vector) {
        PrintWriter printWriter = null;
        File file = new File(System.getProperty("user.dir"), pastDirFileName);
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            int n = 0;
            while (n < vector.size()) {
                DirData dirData = (DirData)vector.elementAt(n);
                printWriter.println(String.valueOf(dirData.getShortName()) + " " + dirData.getColorName() + " " + dirData.getDir());
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static void readCurrentData(Vector vector, String string) {
        if (FileAnalyzer.checkVerFile(string)) {
            if (FileAnalyzer.checkWorkFile(string)) {
                FileAnalyzer.readWorkFile(vector, string, n2_workFileName);
            }
            if (FileAnalyzer.checkStateFile(string)) {
                FileAnalyzer.readStateFile(vector, string, n2_stateFileName);
            }
        } else {
            if (FileAnalyzer.checkWorkFile(string)) {
                FileAnalyzer.readWorkFile(vector, string, workFileName);
            }
            if (FileAnalyzer.checkStateFile(string)) {
                FileAnalyzer.readStateFile(vector, string, stateFileName);
            }
        }
    }

    private static void readWorkFile(Vector vector, String string, String string2) {
        String string3 = String.valueOf(string) + string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
            FileAnalyzer.analyzeDataFile(bufferedReader, vector);
            File file = new File(string3);
            Date date = new Date(file.lastModified());
            ResultData resultData = (ResultData)vector.elementAt(0);
            resultData.setStartedTime(date);
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    private static void readStateFile(Vector vector, String string, String string2) {
        String string3 = String.valueOf(string) + string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
            boolean bl = FileAnalyzer.analyzeDataFile(bufferedReader, vector);
            if (!bl && vector.size() > 0) {
                ResultData resultData = (ResultData)vector.elementAt(0);
                resultData.clearStateInfo();
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    public static void readSavedCurrentData(Vector vector) {
        File file = new File(System.getProperty("user.dir"), currentDataFileName);
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            FileAnalyzer.analyzeDataFile(bufferedReader, vector);
        }
        catch (IOException iOException) {}
    }

    public static void fileOutCurrentData(Vector vector) {
        File file = new File(System.getProperty("user.dir"), currentDataFileName);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            int n = 0;
            while (n < vector.size()) {
                ResultData resultData = ((DirData)vector.elementAt(n)).getProg();
                if (resultData != null) {
                    printWriter.println("!");
                    printWriter.println(resultData.getFileOutStr(true));
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static void readPastFile(String string, Vector vector, String string2) {
        File file = null;
        file = string.equals(pastDataFileName) ? new File(System.getProperty("user.dir"), string) : new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = bufferedReader.readLine();
            if (string3 == null) {
                System.out.println("wao error in past read file");
            } else {
                Object object;
                string3.trim();
                boolean bl = true;
                if (string3.length() > 6 && ((CSVTokenizer)(object = new CSVTokenizer(string3))).nextToken().equals("date")) {
                    bl = false;
                }
                object = new BufferedReader(new FileReader(file));
                if (bl) {
                    FileAnalyzer.analyzeDataFile((BufferedReader)object, vector);
                } else {
                    FileAnalyzer.analyzeSetiLogFile((BufferedReader)object, vector, string2);
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    private static boolean analyzeDataFile(BufferedReader bufferedReader, Vector vector) {
        boolean bl = false;
        try {
            String string;
            ResultData resultData = null;
            if (vector.size() > 0) {
                resultData = (ResultData)vector.elementAt(0);
            }
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                Object object2;
                String string2;
                String string3;
                if ((string = string.trim()).length() == 0) continue;
                bl = true;
                int n = string.indexOf("=");
                if (n == -1) {
                    string3 = string;
                    string2 = null;
                } else {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                }
                if (string3.equals("!")) {
                    resultData = new ResultData();
                    vector.addElement(resultData);
                    continue;
                }
                if (string3.equals("pos")) {
                    object2 = new StringTokenizer(string2);
                    object = new String[]{null, null, null, null, null, null};
                    int n2 = 0;
                    while (n2 < 6) {
                        object[n2] = ((StringTokenizer)object2).nextToken();
                        ++n2;
                    }
                    resultData.setPosData((String[])object);
                    continue;
                }
                if (string3.equals("end_pos")) {
                    object2 = new StringTokenizer(string2);
                    object = new String[]{null, null, null, null, null, null};
                    int n3 = 0;
                    while (n3 < 6) {
                        object[n3] = ((StringTokenizer)object2).nextToken();
                        ++n3;
                    }
                    resultData.setEndPosData((String[])object);
                    continue;
                }
                if (string3.equals("start_ra")) {
                    resultData.setRa(string2);
                    continue;
                }
                if (string3.equals("start_dec")) {
                    resultData.setDec(string2);
                    continue;
                }
                if (string3.equals("end_ra")) {
                    resultData.setEndRa(string2);
                    continue;
                }
                if (string3.equals("end_dec")) {
                    resultData.setEndDec(string2);
                    continue;
                }
                if (string3.equals("angle_range")) {
                    resultData.setAngleRange(string2);
                    continue;
                }
                if (string3.equals("subband_base")) {
                    if (resultData == null) {
                        System.out.println("Wrong fromat, rdata for band is null");
                    }
                    resultData.setBand(string2);
                    continue;
                }
                if (string3.equals("time_recorded")) {
                    if (string2.indexOf("(") == -1 || string2.indexOf(")") == -1) {
                        resultData.setTimeRecorded("ND");
                        continue;
                    }
                    object2 = string2.substring(string2.indexOf("("), string2.indexOf(")") + 1);
                    resultData.setTimeRecorded((String)object2);
                    continue;
                }
                if (string3.equals("name")) {
                    if (resultData == null) {
                        resultData = new ResultData();
                    }
                    resultData.setName(string2);
                    continue;
                }
                if (string3.equals("bs_power")) {
                    resultData.setBsPower(string2);
                    continue;
                }
                if (string3.equals("bs_score")) {
                    resultData.setBsScore(string2);
                    continue;
                }
                if (string3.equals("bs_bin")) {
                    resultData.setBsBin(string2);
                    continue;
                }
                if (string3.equals("bs_fft_ind")) {
                    resultData.setBsFftInd(string2);
                    continue;
                }
                if (string3.equals("bs_chirp_rate")) {
                    resultData.setBsChirpRate(string2);
                    continue;
                }
                if (string3.equals("bs_fft_len")) {
                    resultData.setBsFftLen(string2);
                    continue;
                }
                if (string3.equals("bg_power")) {
                    resultData.setBgPower(string2);
                    continue;
                }
                if (string3.equals("bg_score")) {
                    resultData.setBgScore(string2);
                    continue;
                }
                if (string3.equals("bg_chisq")) {
                    resultData.setBgChisq(string2);
                    continue;
                }
                if (string3.equals("bg_true_mean")) {
                    resultData.setBgTrueMean(string2);
                    continue;
                }
                if (string3.equals("bg_sigma")) {
                    resultData.setBgSigma(string2);
                    continue;
                }
                if (string3.equals("bg_bin")) {
                    resultData.setBgBin(string2);
                    continue;
                }
                if (string3.equals("bg_fft_ind")) {
                    resultData.setBgFftInd(string2);
                    continue;
                }
                if (string3.equals("bg_chirp_rate")) {
                    resultData.setBgChirpRate(string2);
                    continue;
                }
                if (string3.equals("bg_fft_len")) {
                    resultData.setBgFftLen(string2);
                    continue;
                }
                if (string3.equals("cpu")) {
                    resultData.setCpu(string2);
                    continue;
                }
                if (string3.equals("prog")) {
                    resultData.setProg(string2);
                    continue;
                }
                if (string3.equals("started_time")) {
                    object2 = new SimpleDateFormat("dd/MM/yyyy:HH:mm:ss");
                    ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("GMT"));
                    object = new ParsePosition(0);
                    Date date = ((SimpleDateFormat)object2).parse(string2, (ParsePosition)object);
                    resultData.setStartedTime(date);
                    continue;
                }
                if (string3.equals("DataDirName")) {
                    resultData.setDirName(string2);
                    continue;
                }
                if (string3.startsWith("bg_pot")) {
                    object2 = new StringTokenizer(string3);
                    object = "0";
                    try {
                        ((StringTokenizer)object2).nextToken();
                        object = ((StringTokenizer)object2).nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        object = "0";
                    }
                    int n4 = 0;
                    try {
                        n4 = Integer.valueOf((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n4 = 0;
                    }
                    double d = 0.0;
                    try {
                        d = Double.valueOf(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        d = 0.0;
                    }
                    resultData.setBgpot(n4, d);
                    continue;
                }
                if (!string3.equals("end_seti_header") && !string3.equals("num_positions")) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        return bl;
    }

    private static void analyzeSetiLogFile(BufferedReader bufferedReader, Vector vector, String string) {
        Object object;
        String[] stringArray = new String[]{"date", "name", "start_ra", "start_dec", "end_ra", "end_dec", "time_recorded", "subband_base", "cpu", "prog", "bs_power", "bs_score", "bs_bin", "bs_fft_ind", "bs_chirp_rate", "bs_fft_len", "bg_score", "bg_power", "bg_chisq", "bg_true_mean", "bg_sigma", "bg_bin", "bg_fft_ind", "bg_chirp_rate", "bg_fft_len"};
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = 0;
        while (n < stringArray.length) {
            vector2.addElement(null);
            ++n;
        }
        String string2 = null;
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string2);
        int n2 = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            object = cSVTokenizer.nextToken();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals(object)) {
                    try {
                        vector2.setElementAt(new Integer(n2), n3);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("please let Goro Otsuo know this bug");
                    }
                }
                ++n3;
            }
            ++n2;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object2;
                Enumeration enumeration;
                Object object3;
                object = new ResultData();
                vector.addElement(object);
                cSVTokenizer = new CSVTokenizer(string2);
                Vector<Object> vector3 = new Vector<Object>();
                int n4 = 0;
                while (cSVTokenizer.hasMoreTokens()) {
                    object3 = cSVTokenizer.nextToken();
                    vector3.addElement(object3);
                    ++n4;
                }
                object3 = new Vector();
                int n5 = 0;
                while (n5 < vector2.size()) {
                    enumeration = (Integer)vector2.elementAt(n5);
                    if (enumeration != null) {
                        ((Vector)object3).addElement(vector3.elementAt((Integer)((Object)enumeration)));
                    } else {
                        ((Vector)object3).addElement(null);
                    }
                    ++n5;
                }
                enumeration = ((Vector)object3).elements();
                String string3 = (String)enumeration.nextElement();
                if (string3 != null) {
                    object2 = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                    ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone(string));
                    ParsePosition parsePosition = new ParsePosition(0);
                    Date date = ((SimpleDateFormat)object2).parse(string3, parsePosition);
                    ((ResultData)object).setStartedTime(date);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setName(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setRa(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setDec(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setEndRa(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setEndDec(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    if (string3.indexOf("(") == -1 || string3.indexOf(")") == -1) {
                        ((ResultData)object).setTimeRecorded("ND");
                    } else {
                        object2 = string3.substring(string3.indexOf("("), string3.indexOf(")") + 1);
                        ((ResultData)object).setTimeRecorded((String)object2);
                    }
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBand(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setCpu(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setProg(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsPower(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsScore(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsBin(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsFftInd(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsChirpRate(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBsFftLen(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgScore(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgPower(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgChisq(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgTrueMean(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgSigma(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgBin(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgFftInd(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) != null) {
                    ((ResultData)object).setBgChirpRate(string3);
                }
                if ((string3 = (String)enumeration.nextElement()) == null) continue;
                ((ResultData)object).setBgFftLen(string3);
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
    }

    public static void addPastData(ResultData resultData) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(byteArrayOutputStream)));
            printWriter.println("!");
            printWriter.println(resultData.getFileOutStr(false));
            printWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(System.getProperty("user.dir"), pastDataFileName), "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.write(byArray);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("FileAccessError " + iOException);
        }
    }

    public static PrefValue readPrefs() {
        PrefValue prefValue = new PrefValue();
        prefValue.setUpdatePref(1);
        prefValue.setProgPref(1);
        prefValue.setDispPref(0);
        prefValue.setScrollPref(0);
        prefValue.setCLPref(1);
        prefValue.setBlinkPref(1);
        prefValue.setCurrentTimeZoneID("JST");
        prefValue.setPaintPref("Standard");
        prefValue.setAPaintPref("Circle");
        prefValue.setAmPref("Auto");
        prefValue.setSkyPref(0);
        prefValue.setCstPref(1);
        prefValue.setCstNamePref(1);
        prefValue.setGridPref(1);
        prefValue.setGpPref(1);
        prefValue.setStarBrPref(5.5);
        prefValue.setSSizePref("Standard");
        prefValue.setAcPref(10);
        prefValue.setStarTracePref(1);
        prefValue.setAutoVanglePref(0);
        prefValue.setDatatablePref(0);
        prefValue.setGsdPref(0);
        prefValue.setTopPref(1);
        prefValue.setLogDataPref(1);
        File file = new File(System.getProperty("user.dir"), prefFileName);
        if (!file.exists()) {
            return prefValue;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if ((string2 = string2.trim()).equals("updatePref")) {
                    prefValue.setUpdatePref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("progPref")) {
                    prefValue.setProgPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("dispPref")) {
                    prefValue.setDispPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("clPref")) {
                    prefValue.setCLPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("blinkPref")) {
                    prefValue.setBlinkPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("scrollPref")) {
                    prefValue.setScrollPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("tzPref")) {
                    prefValue.setCurrentTimeZoneID(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("paintPref")) {
                    prefValue.setPaintPref(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("apaintPref")) {
                    prefValue.setAPaintPref(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("boundPref")) {
                    prefValue.setBound(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("amPref")) {
                    prefValue.setAmPref(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("skyPref")) {
                    prefValue.setSkyPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("cstPref")) {
                    prefValue.setCstPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("cstNamePref")) {
                    prefValue.setCstNamePref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("gridPref")) {
                    prefValue.setGridPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("gpPref")) {
                    prefValue.setGpPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("starBrPref")) {
                    prefValue.setStarBrPref(Double.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("acPref")) {
                    prefValue.setAcPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("ssizePref")) {
                    prefValue.setSSizePref(stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("starTracePref")) {
                    prefValue.setStarTracePref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("datatablePref")) {
                    prefValue.setDatatablePref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("gsdPref")) {
                    prefValue.setGsdPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (string2.equals("topPref")) {
                    prefValue.setTopPref(Integer.valueOf(stringTokenizer.nextToken()));
                    continue;
                }
                if (!string2.equals("logDataPref")) continue;
                prefValue.setLogDataPref(Integer.valueOf(stringTokenizer.nextToken()));
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        return prefValue;
    }

    public static void fileOutPrefs(PrefValue prefValue) {
        PrintWriter printWriter = null;
        File file = new File(System.getProperty("user.dir"), prefFileName);
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("updatePref " + prefValue.getUpdatePref());
            printWriter.println("progPref " + prefValue.getProgPref());
            printWriter.println("dispPref " + prefValue.getDispPref());
            printWriter.println("scrollPref " + prefValue.getScrollPref());
            printWriter.println("clPref " + prefValue.getCLPref());
            printWriter.println("blinkPref " + prefValue.getBlinkPref());
            printWriter.println("tzPref " + prefValue.getCurrentTimeZoneID());
            printWriter.println("paintPref " + prefValue.getPaintPref());
            printWriter.println("apaintPref " + prefValue.getAPaintPref());
            printWriter.println("boundPref " + prefValue.getBoundStr());
            printWriter.println("amPref " + prefValue.getAmPref());
            printWriter.println("skyPref " + prefValue.getSkyPref());
            printWriter.println("cstPref " + prefValue.getCstPref());
            printWriter.println("cstNamePref " + prefValue.getCstNamePref());
            printWriter.println("gridPref " + prefValue.getGridPref());
            printWriter.println("gpPref " + prefValue.getGpPref());
            printWriter.println("starBrPref " + prefValue.getStarBrPref());
            printWriter.println("acPref " + prefValue.getAcPref());
            printWriter.println("ssizePref " + prefValue.getSSizePref());
            printWriter.println("starTracePref " + prefValue.getStarTracePref());
            printWriter.println("datatablePref " + prefValue.getDatatablePref());
            printWriter.println("gsdPref " + prefValue.getGsdPref());
            printWriter.println("topPref " + prefValue.getTopPref());
            printWriter.println("logDataPref " + prefValue.getLogDataPref());
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static String getUserString(String string) {
        String string2 = String.valueOf(string) + userFileName;
        File file = new File(string2);
        if (!file.exists() && !(file = new File(string2 = String.valueOf(string) + n2_userFileName)).exists()) {
            return "";
        }
        String string3 = "";
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            int n = 0;
            double d = 0.0;
            while ((string4 = bufferedReader.readLine()) != null) {
                String string5;
                String string6;
                if ((string4 = string4.trim()).length() == 0) continue;
                int n2 = string4.indexOf("=");
                if (n2 == -1) {
                    string6 = string4;
                    string5 = null;
                } else {
                    string6 = string4.substring(0, n2);
                    string5 = string4.substring(n2 + 1);
                }
                if (string6.equals("name")) {
                    string3 = String.valueOf(string3) + "Name: " + string5 + "\n";
                    continue;
                }
                if (string6.equals("nwus")) {
                    string3 = String.valueOf(string3) + "Work units sent: " + string5 + "\n";
                    continue;
                }
                if (string6.equals("nresults")) {
                    string3 = String.valueOf(string3) + "Results received: " + string5 + "\n";
                    n = Integer.valueOf(string5);
                    continue;
                }
                if (!string6.equals("total_cpu")) continue;
                d = Double.valueOf(string5);
                string3 = String.valueOf(string3) + "Total CPU time: " + ResultData.genHMSString(d);
                if (d >= 3196800.0) {
                    String string7 = DoubleFormat.toString(d / 3.1536E7, 2);
                    string3 = String.valueOf(string3) + " (" + string7 + " years )";
                }
                string3 = String.valueOf(string3) + "\n";
            }
            if (n != 0 && d != 0.0) {
                string3 = String.valueOf(string3) + "Average CPU time per work unit: " + ResultData.genHMSString(d / (double)n) + "\n";
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        return string3;
    }

    static void exportCSVFile(String string, Vector vector, int n) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            String string2 = "";
            if (n == 0) {
                string2 = ",";
            } else if (n == 1) {
                string2 = "\t";
            } else if (n == 2) {
                string2 = "</TD><TD>";
                printWriter.println("<HTML>");
                printWriter.println("<HEAD>");
                printWriter.println("<TITLE>SETI@home data</TITLE>");
                printWriter.println("<BODY>");
                printWriter.println("<TABLE BORDER=1>");
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n2);
                if (n == 2) {
                    if (n2 == 0) {
                        printWriter.print("<TR><TH>");
                    } else {
                        printWriter.print("<TR><TD>");
                    }
                }
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n3);
                    if (n3 == vector2.size() - 1) {
                        printWriter.print(string3);
                    } else if (n2 == 0 && n == 2) {
                        printWriter.print(String.valueOf(string3) + "</TH><TH>");
                    } else {
                        printWriter.print(String.valueOf(string3) + string2);
                    }
                    ++n3;
                }
                if (n == 2) {
                    if (n2 == 0) {
                        printWriter.println("</TH></TR>");
                    } else {
                        printWriter.println("</TD></TR>");
                    }
                } else {
                    printWriter.println();
                }
                ++n2;
            }
            if (n == 2) {
                printWriter.println("</TABLE>");
                printWriter.println("</BODY>");
                printWriter.println("</HTML>");
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static MxPrefValue readMxPrefs() {
        MxPrefValue mxPrefValue = new MxPrefValue();
        mxPrefValue.setSortTitle("No");
        mxPrefValue.setSortMode(0);
        mxPrefValue.setBound(new Rectangle(50, 50, 600, 400));
        mxPrefValue.addTitle("No");
        int n = 0;
        while (n < GLBX.TITLE.length) {
            mxPrefValue.addTitle(GLBX.TITLE[n]);
            ++n;
        }
        File file = new File(System.getProperty("user.dir"), mxPrefFileName);
        if (!file.exists()) {
            return mxPrefValue;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                if ((string = string.trim()).length() == 0) continue;
                int n2 = string.indexOf("=");
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                if (string2.equals("sortTitle")) {
                    mxPrefValue.setSortTitle(string3);
                    continue;
                }
                if (string2.equals("sortmode")) {
                    mxPrefValue.setSortMode(Integer.valueOf(string3));
                    continue;
                }
                if (string2.equals("boundPref")) {
                    stringTokenizer = new StringTokenizer(string3);
                    mxPrefValue.setBound(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("title")) {
                    mxPrefValue.clearTitle();
                    stringTokenizer = new StringTokenizer(string3, "$");
                    while (stringTokenizer.hasMoreTokens()) {
                        mxPrefValue.addTitle(stringTokenizer.nextToken());
                    }
                    continue;
                }
                if (!string2.equals("cutcond")) continue;
                mxPrefValue.addCutCondStr(string3);
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        return mxPrefValue;
    }

    public static void fileOutMxPrefs(MxPrefValue mxPrefValue) {
        File file = new File(System.getProperty("user.dir"), mxPrefFileName);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("sortTitle=" + mxPrefValue.getSortTitle());
            printWriter.println("sortmode=" + mxPrefValue.getSortMode());
            printWriter.println("boundPref=" + mxPrefValue.getBoundStr());
            printWriter.println("title=" + mxPrefValue.getTitleStr());
            Vector vector = mxPrefValue.getCondVect();
            int n = 0;
            while (n < vector.size()) {
                printWriter.println("cutcond=" + (String)vector.elementAt(n));
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }

    public static GDPrefValue readGDPrefs() {
        GDPrefValue gDPrefValue = new GDPrefValue();
        gDPrefValue.setBound(new Rectangle(50, 50, 400, 400));
        gDPrefValue.setClPref(1);
        gDPrefValue.setArPref(1);
        gDPrefValue.setHiCurPref(1);
        gDPrefValue.setBlinkPref(0);
        gDPrefValue.setSnowPref(0);
        File file = new File(System.getProperty("user.dir"), gdPrefFileName);
        if (!file.exists()) {
            return gDPrefValue;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0) continue;
                int n = string.indexOf("=");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2.equals("boundPref")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    gDPrefValue.setBound(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                    continue;
                }
                if (string2.equals("clPref")) {
                    gDPrefValue.setClPref(Integer.valueOf(string3));
                    continue;
                }
                if (string2.equals("arPref")) {
                    gDPrefValue.setArPref(Integer.valueOf(string3));
                    continue;
                }
                if (string2.equals("hiCurPref")) {
                    gDPrefValue.setHiCurPref(Integer.valueOf(string3));
                    continue;
                }
                if (string2.equals("blinkPref")) {
                    gDPrefValue.setBlinkPref(Integer.valueOf(string3));
                    continue;
                }
                if (!string2.equals("snowPref")) continue;
                gDPrefValue.setSnowPref(Integer.valueOf(string3));
            }
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        return gDPrefValue;
    }

    public static void fileOutGDPrefs(GDPrefValue gDPrefValue) {
        File file = new File(System.getProperty("user.dir"), gdPrefFileName);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("boundPref=" + gDPrefValue.getBoundStr());
            printWriter.println("clPref=" + gDPrefValue.getClPref());
            printWriter.println("arPref=" + gDPrefValue.getArPref());
            printWriter.println("hiCurPref=" + gDPrefValue.getHiCurPref());
            printWriter.println("blinkPref=" + gDPrefValue.getBlinkPref());
            printWriter.println("snowPref=" + gDPrefValue.getSnowPref());
        }
        catch (IOException iOException) {
            System.out.println("File error:" + iOException);
        }
        printWriter.close();
    }
}

